/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.IMeasureProcesser;
import com.kingdee.eas.ma.mbg.common.IViewListNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import java.math.BigDecimal;
import java.util.Map;
import java.util.WeakHashMap;

public class ViewListMeasureProcesser
implements IMeasureProcesser {
    IViewListNumberCellDisplayHelper helper = null;
    protected Map formulaMap = new WeakHashMap();
    private Map<String, BgElementInfo> elementObjMap = null;

    public ViewListMeasureProcesser(IViewListNumberCellDisplayHelper helper) {
        this.helper = helper;
        if (helper != null && helper.getFormulaMap() != null) {
            this.formulaMap = helper.getFormulaMap();
        }
    }

    protected IViewListNumberCellDisplayHelper getHelper() {
        return this.helper;
    }

    @Override
    public BigDecimal getCoefficient(String _text, Cell _cell) {
        if (!(BgNFSHelper.checkHasPercentage(_cell) || BgNFSHelper.checkHasTextOfCell(_cell) || MBGViewListFormCommonHelper.checkElementRateOrPrice(_cell, this.getElementObjMap(), this.formulaMap))) {
            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                return this.updateMeasureUnitValue(_text, _cell);
            }
            if (ViewListHelper.getCalculatorDataStyle(_cell) != null) {
                ViewListCalculatorDataStyleInfo calcDataStyle = ViewListHelper.getCalculatorDataStyle(_cell);
                return new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit(calcDataStyle.getMeasureUnit()));
            }
            if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                return this.updateMeasureUnitValue(_text, _cell);
            }
        }
        return null;
    }

    public Map<String, BgElementInfo> getElementObjMap() {
        if (this.elementObjMap == null) {
            try {
                this.elementObjMap = BgElementHelper.getElementoObjMap();
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return this.elementObjMap;
    }

    protected BigDecimal updateMeasureUnitValue(String _text, Cell _cell) {
        BigDecimal _value = null;
        if (!this.getHelper().getMeasureUnitMap().isEmpty()) {
            _value = this.updateBgMeasureUnitValue(_text, _cell);
        }
        return _value;
    }

    protected BigDecimal updateBgMeasureUnitValue(String _text, Cell _cell) {
        String _bgAccountNumber = null;
        String _tmpStr = null;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        _tmpStr = _text.trim().replaceAll(",", "");
        try {
            _value = new BigDecimal(_tmpStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null && _cell != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && _cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
            _bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue());
            _coefficient = this.getCoef(_bgAccountNumber, _coefficient, _cell);
        }
        return _coefficient;
    }

    protected BigDecimal getCoef(String _bgAccountNumber, BigDecimal defaultValue, Cell cell) {
        if (this.getHelper() == null || this.getHelper().getMeasureUnitMap() == null || this.getHelper().getAccountDataTypeMap() == null || !this.getHelper().getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
            return defaultValue;
        }
        if (this.getHelper().getTemplateStyle() == null || this.getHelper().getTemplateStyle() != null && this.getHelper().getTemplateStyle().isDataTYpe()) {
            if (this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber) != null && this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber) instanceof Integer) {
                if (10 == (Integer)this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getHelper().getMeasureUnitMap().get("currency"));
                }
                if (20 == (Integer)this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getHelper().getMeasureUnitMap().get("noCurrency"));
                }
                if (30 == (Integer)this.getHelper().getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getHelper().getMeasureUnitMap().get("rate"));
                }
            }
        } else {
            String eleNumber;
            if (MBGViewListFormClientHelper.checkRateElement((Cell)cell, this.getElementObjMap(), (Map)this.formulaMap)) {
                return defaultValue;
            }
            if (this.getHelper().getTemplateStyle() != null && !this.getHelper().getTemplateStyle().isDataTYpe() && (eleNumber = MBGViewListFormClientHelper.getCellElement((Cell)cell, this.getElementObjMap(), (Map)this.formulaMap)) != null && this.getHelper().getTemplateStyle().getEleMap().containsKey(eleNumber)) {
                Object[] object = this.getHelper().getTemplateStyle().getEleMap().get(eleNumber);
                if ((Integer)object[3] == 0) {
                    return this.getHelper().getTemplateStyle().getCof();
                }
                return new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit((Integer)object[3] - 1));
            }
        }
        return defaultValue;
    }
}

