/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadCellTextRender;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kds.core.RenderUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.mbg.client.utils.IActionHide;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.ExpandMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListMemberRender
implements IBasicRender {
    public static Logger logger = Logger.getLogger((String)ViewListMemberRender.class.getName());
    private static final int TABSIZE = 8;
    private static final int ICONSIZE = 10;
    private static final int margin = 2;
    private Cell cell = null;
    private SpreadCellTextRender textRender = new SpreadCellTextRender();

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (this.cell == null) {
            return;
        }
        if (ViewListHelper.getHeadCellValue(this.cell) instanceof ExpandMember) {
            ExpandMember member = (ExpandMember)ViewListHelper.getHeadCellValue(this.cell);
            if (member.isNeedShowLevel) {
                int x = clip.getBounds().x + member.getLevel() * 10;
                if (!member.isLeaf()) {
                    Color c = graphics.getColor();
                    graphics.setColor(cellStyle.getFontColor());
                    int y = clip.getBounds().y + clip.getBounds().height / 2 - 5;
                    if (member.isExpanded) {
                        this.drawExpanded(graphics, x, y);
                    } else {
                        this.drawCollapsed(graphics, x, y);
                    }
                    graphics.setColor(c);
                }
                Rectangle rect = new Rectangle(clip.getBounds());
                rect.x = x + 10 + 2;
                if (object instanceof String) {
                    object = ((String)object).trim();
                }
                this.textRender.draw(graphics, (Shape)rect, object, cellStyle, (Object)RenderUtil.PaintCell_Clip);
            } else {
                this.textRender.draw(graphics, (Shape)clip.getBounds(), object, cellStyle, (Object)RenderUtil.PaintCell_Clip);
            }
        }
    }

    protected void drawExpanded(Graphics g, int x, int y) {
        g.drawRect(x, y, 10, 10);
        int lineSize = 6;
        g.drawLine(x + 2, y + 5, x + 2 + lineSize, y + 5);
    }

    protected void drawCollapsed(Graphics g, int x, int y) {
        g.drawRect(x, y, 10, 10);
        int lineSize = 6;
        g.drawLine(x + 2, y + 5, x + 2 + lineSize, y + 5);
        g.drawLine(x + 5, y + 2, x + 5, y + 2 + lineSize);
    }

    public static boolean checkHasMember(Cell cell) {
        return ViewListHelper.getHeadCellValue(cell) instanceof ExpandMember;
    }

    public static Object createExpaneMember(Object object) {
        if (!(object instanceof MbgViewListDimensionMember)) {
            return object;
        }
        MbgViewListDimensionMember member = (MbgViewListDimensionMember)object;
        ExpandMember expandMember = new ExpandMember(member);
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(member.getType())) {
            expandMember.isNeedShowLevel = false;
        }
        return expandMember;
    }

    public static Object createExpaneMember(Object object, boolean isColumn) {
        if (!(object instanceof MbgViewListDimensionMember)) {
            return object;
        }
        MbgViewListDimensionMember member = (MbgViewListDimensionMember)object;
        ExpandMember expandMember = new ExpandMember(member);
        if (isColumn) {
            expandMember.isNeedShowLevel = false;
        }
        return expandMember;
    }

    public static void cell_mouseClicked(CoreUIObject ownerUi, MouseEvent e, Sheet sheet) {
        ExpandMember expandMember;
        int c;
        Point p = e.getPoint();
        int r = SheetBaseMath.rowAtPoint((Sheet)sheet, (Point2D)p);
        CellBlock block = ViewListHelper.getCellBlock(sheet, r, c = SheetBaseMath.colAtPoint((Sheet)sheet, (Point2D)p));
        Cell cell = ViewListHelper.getFirstCell(sheet, block);
        Object object = ViewListHelper.getHeadCellValue(cell);
        if (object instanceof ExpandMember && !(expandMember = (ExpandMember)object).isLeaf() && ViewListMemberRender.isInRange(cell, p, expandMember)) {
            boolean isExpand;
            expandMember.isExpanded = isExpand = !expandMember.isExpanded;
            RowColObejctProcessor processor = null;
            processor = ViewListHelper.getDimension(sheet.getRow(r, false)) != null ? new RowObjectProcessor(sheet) : new ColObjectProcessor(sheet);
            processor.expand(block, expandMember, isExpand, -1);
            if (isExpand && ownerUi instanceof IActionHide) {
                try {
                    ((IActionHide)ownerUi).doHide();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void doExpand(Sheet sheet, CellBlock block, boolean isExpand, int level) {
        ExpandMember expandMember;
        Cell cell = ViewListHelper.getFirstCell(sheet, block);
        Object object = ViewListHelper.getHeadCellValue(cell);
        if (cell != null && cell.isHidden() && isExpand) {
            return;
        }
        if (object instanceof ExpandMember && !(expandMember = (ExpandMember)object).isLeaf()) {
            expandMember.isExpanded = isExpand;
            RowColObejctProcessor processor = null;
            processor = ViewListHelper.getDimension(sheet.getRow(cell.getRow(), false)) != null ? new RowObjectProcessor(sheet) : new ColObjectProcessor(sheet);
            processor.expand(block, expandMember, isExpand, level);
        }
    }

    public static int getMemberLevel(ExpandMember baseMember, ExpandMember expandMember) {
        if (String.valueOf(expandMember.member.getSortValue()).startsWith(baseMember.member.getSortValue() + "!")) {
            String endStr = String.valueOf(expandMember.member.getSortValue()).substring((baseMember.member.getSortValue() + "!").length(), String.valueOf(expandMember.member.getSortValue()).length());
            if (endStr.indexOf("!") <= 0) {
                return 1;
            }
            return endStr.split("!").length;
        }
        return -1;
    }

    private static boolean isInRange(Cell cell, Point p, ExpandMember expandMember) {
        Rectangle cellRect = SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)false);
        int minX = cellRect.x + expandMember.getLevel() * 10;
        int maxX = minX + 10;
        int minY = cellRect.y + cellRect.height / 2 - 5;
        int maxY = minY + 10;
        return p.x >= minX && p.x <= maxX && p.y >= minY && p.y <= maxY;
    }

    private static class RowObjectProcessor
    extends RowColObejctProcessor {
        public RowObjectProcessor(Sheet sheet) {
            super(sheet);
        }

        @Override
        public boolean isRow() {
            return true;
        }

        @Override
        protected CellBlock getNextBlock(CellBlock block) {
            IMbgViewListObject objectNext;
            if (block == null) {
                return null;
            }
            if (block.getRow2() >= this.getSheet().getMaxRowIndex()) {
                return null;
            }
            IMbgViewListObject object = ViewListHelper.getDimension(this.getSheet().getRow(block.getRow2(), false));
            if (object != (objectNext = ViewListHelper.getDimension(this.getSheet().getRow(block.getRow2() + 1, false)))) {
                return null;
            }
            return ViewListHelper.getCellBlock(this.getSheet(), block.getRow2() + 1, block.getCol());
        }

        @Override
        protected Range getRange(CellBlock block) {
            return this.getSheet().getRowRange(block.getRow(), block.getRow2());
        }
    }

    private static class ColObjectProcessor
    extends RowColObejctProcessor {
        public ColObjectProcessor(Sheet sheet) {
            super(sheet);
        }

        @Override
        public boolean isRow() {
            return false;
        }

        @Override
        protected CellBlock getNextBlock(CellBlock block) {
            if (block == null) {
                return null;
            }
            if (block.getCol2() >= this.getSheet().getMaxColIndex()) {
                return null;
            }
            return ViewListHelper.getCellBlock(this.getSheet(), block.getRow(), block.getCol2() + 1);
        }

        @Override
        protected Range getRange(CellBlock block) {
            return this.getSheet().getColRange(block.getCol(), block.getCol2());
        }
    }

    private static abstract class RowColObejctProcessor {
        private Sheet sheet = null;
        private static Map<String, Set<String>> periodChildMap = null;

        public RowColObejctProcessor(Sheet sheet) {
            this.sheet = sheet;
        }

        public Sheet getSheet() {
            return this.sheet;
        }

        public abstract boolean isRow();

        public void expand(CellBlock block, ExpandMember expandMember, boolean isExpand, int level) {
            Range range = this.getExpandRange(block, expandMember, null, isExpand, null, level);
            if (range != null) {
                range.setIgnoreProtected(true);
                range.setHidden(!isExpand, this.isRow());
            }
        }

        protected boolean checkPeriodIsChild(String parent, String child) {
            if (periodChildMap == null) {
                periodChildMap = new HashMap<String, Set<String>>();
                try {
                    BgPeriodDispCollection col = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection("select longNumber");
                    String[] lns = null;
                    for (int i = 0; i < col.size(); ++i) {
                        lns = col.get(i).getLongNumber().split("!");
                        for (int l = 0; l < lns.length - 1; ++l) {
                            if (!periodChildMap.containsKey(lns[l])) {
                                periodChildMap.put(lns[l], new HashSet());
                            }
                            periodChildMap.get(lns[l]).add(lns[lns.length - 1]);
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return periodChildMap.get(parent).contains(child);
        }

        protected Range getExpandRange(CellBlock block, ExpandMember baseMember, ExpandMember parentMember, boolean isExpand, Range range, int level) {
            Cell cellBase = ViewListHelper.getFirstCell(this.getSheet(), block);
            if ((block = this.getNextBlock(block)) == null) {
                return range;
            }
            Cell cell = ViewListHelper.getFirstCell(this.getSheet(), block);
            Object object = ViewListHelper.getHeadCellValue(cell);
            if (!this.isMultiSubjectSupExpand(cell, cellBase, baseMember)) {
                return range;
            }
            if (object instanceof ExpandMember) {
                ExpandMember expandMember = (ExpandMember)object;
                boolean isChild = false;
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(expandMember.member.getType())) {
                    isChild = this.checkPeriodIsChild(baseMember.member.getNumber(), expandMember.member.getNumber());
                } else {
                    boolean bl = isChild = expandMember.member.getSortValue() != null && ((String)((Object)expandMember.member.getSortValue())).startsWith(baseMember.member.getSortValue() + "!");
                }
                if (isChild) {
                    if (level > 0 && ViewListMemberRender.getMemberLevel(baseMember, expandMember) > 0 && ViewListMemberRender.getMemberLevel(baseMember, expandMember) > level) {
                        if (parentMember != null && !String.valueOf(isExpand).equals(String.valueOf(expandMember.isExpanded))) {
                            parentMember.isExpanded = !isExpand;
                        }
                        return this.getExpandRange(block, baseMember, expandMember, isExpand, range, level);
                    }
                    expandMember.isExpanded = isExpand;
                    if (range == null) {
                        range = this.getRange(block);
                    } else {
                        range.addAll((SortedCellBlockArray)this.getRange(block));
                    }
                    return this.getExpandRange(block, baseMember, expandMember, isExpand, range, level);
                }
                return range;
            }
            return range;
        }

        protected boolean isMultiSubjectSupExpand(Cell cell, Cell cellBase, ExpandMember baseMember) {
            boolean result = true;
            Object userObjectValueBase = this.getSheet().getRow(cellBase.getRow(), false).getUserObjectValue("dimensino.member");
            Object userObjectValue = this.getSheet().getRow(cell.getRow(), false).getUserObjectValue("dimensino.member");
            if (userObjectValue != null && userObjectValue instanceof BgDimensionMember[]) {
                BgDimensionMember[] mbgViewListDimensionMember = (BgDimensionMember[])userObjectValue;
                BgDimensionMember[] mbgViewListDimensionMemberBase = (BgDimensionMember[])userObjectValueBase;
                if (mbgViewListDimensionMember.length != mbgViewListDimensionMemberBase.length) {
                    return false;
                }
                int indexFlag = -1;
                for (int i = 0; i < mbgViewListDimensionMember.length && !mbgViewListDimensionMember[i].getSrcNumber().equals(baseMember.getMember().getSrcNumber()); ++i) {
                    if (mbgViewListDimensionMember[i].getNumber().equals(mbgViewListDimensionMemberBase[i].getNumber())) continue;
                    return false;
                }
            }
            return result;
        }

        protected abstract CellBlock getNextBlock(CellBlock var1);

        protected abstract Range getRange(CellBlock var1);
    }
}

