/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common.calcRow;

import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.util.StringUtils;
import java.util.Stack;

public class CalcRowParser2RPN {
    private String formulaStr = null;
    private int point = 0;
    private int length = 0;
    private char look;
    private Stack<String> tokens = new Stack();
    private static final char STACK_OPERATOR = '\u0000';
    private static final char[] OPERATIONS = IExpr.OPERATIONS;

    public CalcRowParser2RPN(String formulaStr) {
        this.formulaStr = formulaStr.trim();
        this.point = 0;
        this.length = this.formulaStr.length();
    }

    public Stack<String> getTokens() {
        return this.tokens;
    }

    public void parse() {
        this.init();
        while (this.look != '\u0000') {
            if (CalcRowParser2RPN.isOperation(this.look) || this.look == '(' || this.look == ')') {
                this.readOperation(this.look);
                this.getChar();
                continue;
            }
            if (CalcRowParser2RPN.isSpaceWhite(this.look)) {
                this.readSpaceWhite();
                continue;
            }
            this.readFunction();
        }
    }

    private void init() {
        this.getChar();
    }

    private void getChar() {
        if (this.point == this.length) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaStr.charAt(this.point++);
    }

    private void readOperation(char c) {
        this.tokens.push(String.valueOf(c));
    }

    private void readSpaceWhite() {
        StringBuffer sw = new StringBuffer();
        while (CalcRowParser2RPN.isSpaceWhite(this.look) && this.look != '\u0000') {
            sw.append(this.look);
            this.getChar();
        }
    }

    private void readFunction() {
        String function = this.getFunction();
        if (!StringUtils.isEmpty((String)function)) {
            String noWhiteFunction = function.trim();
            int index = function.indexOf(noWhiteFunction);
            if (index > 0) {
                this.tokens.push(function.substring(0, index));
            }
            this.tokens.push(noWhiteFunction);
            index = function.lastIndexOf(noWhiteFunction);
            if (index >= 0 && index + noWhiteFunction.length() < function.length()) {
                this.tokens.push(function.substring(index + noWhiteFunction.length()));
            }
        } else {
            this.getChar();
        }
    }

    private String getFunction() {
        int count = 0;
        int sqCount = 0;
        String function = "";
        while (!(sqCount == 0 && CalcRowParser2RPN.isOperation(this.look) || this.look == '\u0000')) {
            if (this.look == '(') {
                ++count;
            }
            if (this.look == ')') {
                --count;
            }
            if (count < 0) break;
            if (this.look == '[') {
                ++sqCount;
            }
            if (this.look == ']') {
                --sqCount;
            }
            if (sqCount < 0) break;
            function = function + this.look;
            this.getChar();
        }
        return function;
    }

    public static boolean isLeftBracket(char c) {
        return c == '(';
    }

    public static boolean isOperation(char c) {
        for (char tmpChar : OPERATIONS) {
            if (tmpChar != c) continue;
            return true;
        }
        return false;
    }

    public static boolean isRightBracket(char c) {
        return c == ')';
    }

    public static boolean isSpaceWhite(char c) {
        return c == ' ';
    }

    public static void main(String[] args) {
        String formula = "R:1 +  ((GVF:[BGF(\"AAA\", \"BBB\")] * 0.8) / R:2)";
        CalcRowParser2RPN parser2 = new CalcRowParser2RPN(formula);
        parser2.parse();
        System.out.println(parser2.getTokens());
    }
}

