/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.convertexcel.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.convertexcel.IConvertExcelProvider;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class BgCslFormFixelConvertExcelProvider
implements IConvertExcelProvider {
    @Override
    public Book convert(Context ctx, IDimDataQuery info) throws Exception {
        info = BgCslFormFactory.getLocalInstance((Context)ctx).getBgCslFormInfo((IObjectPK)new ObjectUuidPK(info.getId()), BgCslFormHelper.getSelector());
        Book book = ((BgCslFormInfo)info).getBook();
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
        BgSchemeDimensionHelper schemehelper = new BgSchemeDimensionHelper(ctx, info.getBizBgScheme().getId().toString());
        BgCslDimensionMemberCheckHelper checkHelper = BgCslDimensionMemberCheckHelper.getLocalIntance((Context)ctx, (DimensionCacheHelper)cacheHelper, (String)info.getBizOrgUnit().getId().toString(), (String)info.getBizBgScheme().getOrgUnit().getId().toString(), null, (BgSchemeDimensionHelper)schemehelper, (IMbgViewManager)BgCslFormHelper.getFormView((Context)ctx, (BgCslFormInfo)((BgCslFormInfo)info), (BgSchemeDimensionHelper)schemehelper));
        Sheet sheet = null;
        Cell cell = null;
        String formula = null;
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell(cell);
                    if (!BgNFSHelper.checkHasExpression(cell) || StringUtils.isEmpty((CharSequence)formula) || checkHelper.canSave(formula, null, null)) continue;
                    BgNFSHelper.setExpression(cell, null);
                }
            }
        }
        BgNFSHelper.enableCal(book);
        BgNFSHelper.enableUndo(book);
        return this.exportFixExcelFile(ctx, (BgCslFormInfo)info, book);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return null;
    }

    @Override
    public void setOwner(CoreUIObject owner) {
    }

    protected Book exportFixExcelFile(Context ctx, BgCslFormInfo _bgFormInfo, Book book) throws Exception {
        Book _book = null;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        BigDecimal _coefficient = null;
        BigDecimal bigDecimal = _coefficient = _bgFormInfo.getMeasureUnit() != null ? _bgFormInfo.getMeasureUnit().getCoefficient() : null;
        if (_bgFormInfo.getCslFormMeasureUnit() != null) {
            for (Object next : _bgFormInfo.getCslFormMeasureUnit()) {
                BgCslAdjFormMeasureUnitInfo _muInfo;
                if (next instanceof BgCslAdjFormMeasureUnitInfo) {
                    _muInfo = (BgCslAdjFormMeasureUnitInfo)next;
                    _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
                    continue;
                }
                if (!(next instanceof BgCslFormMeasureUnitInfo)) continue;
                _muInfo = (BgCslFormMeasureUnitInfo)next;
                _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
            }
        }
        BgSchemeDimensionHelper schemehelper = new BgSchemeDimensionHelper(ctx, _bgFormInfo.getBizBgScheme().getId().toString());
        Map _dataMap = BgCslFormFactory.getLocalInstance((Context)ctx).getBgDataInfo(_bgFormInfo, (IMbgViewBase)BgCslFormHelper.getFormView((Context)ctx, (BgCslFormInfo)_bgFormInfo, (BgSchemeDimensionHelper)schemehelper));
        _book = _bgFormInfo.getBook();
        if (_book == null) {
            _book = Book.Manager.getNewBook();
        }
        _book.getProtection().deleteOperations();
        book = _book;
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        this.refillFixBook(_book, _dataMap, _bgFormInfo);
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", book);
        _tmpMap.put("EXPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgFormInfo.getBgCslTemplate().getFormType()) && !_bgFormInfo.getBgSpecialItems().isEmpty() && !StringUtils.isEmpty((CharSequence)_bgFormInfo.getBgSpecialItems().get(0).getDimensionNumber())) {
            _tmpMap.put("bgSpecialItems", _bgFormInfo.getBgSpecialItems());
        }
        return BgNFSHelper.exportExcel2007(ctx, _tmpMap);
    }

    private void refillFixBook(Book book, Map dataMap, BgCslFormInfo bgFormInfo) throws EASBizException, BOSException {
        Sheet _sheet = null;
        Cell _cell = null;
        String formula = null;
        BgNDataInfo bgData = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell(_cell);
                    if (StringUtils.isEmpty((CharSequence)formula) || (bgData = (BgNDataInfo)dataMap.get(formula + "_" + bgFormInfo.getBgVersion().getNumber())) == null) continue;
                    BgNFSHelper.setValue(_cell, bgData.getBudgetValue());
                }
            }
        }
    }
}

