/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.face.ICubeManager;
import com.kingdee.eas.ma.mbg.cube.impl.CubeManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCubeUtils {
    private static Logger logger = Logger.getLogger((String)BgCubeUtils.class.getName());
    private static Set<String> checkedDataBases = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBgDataTableNameByFormId(Context ctx, String id) throws SQLException {
        if (ctx == null || StringUtils.isEmpty((String)id)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        String tableName = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FREFCUBE FROM T_MBG_BGSCHEME WHERE FID=(SELECT FBGSCHEMEID FROM T_MBG_BGFORM WHERE FID=?)");
            pmst.setString(1, id);
            rs = pmst.executeQuery();
            if (rs.next()) {
                tableName = rs.getString("FREFCUBE");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pmst, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return tableName;
    }

    public static List<String> getRefDims(Context ctx, BgSchemeInfo bgSchemeInfo, boolean hasCslDim) throws BOSException {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add(DimensionConstants.DEF_BGINDEX_FIELD);
        if (ctx == null || bgSchemeInfo == null || bgSchemeInfo.getBgDimSettings() == null) {
            return dims;
        }
        MbgDimCollection colls = DimUtils.getDimensionColls(ctx);
        return BgCubeUtils.getRefDims(bgSchemeInfo, colls, hasCslDim);
    }

    public static List<String> getRefDims(BgSchemeInfo bgSchemeInfo, MbgDimCollection mbgDims, boolean hasCslDim) throws BOSException {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add(DimensionConstants.DEF_BGINDEX_FIELD);
        if (bgSchemeInfo == null || bgSchemeInfo.getBgDimSettings() == null || mbgDims == null) {
            return dims;
        }
        ArrayList<MbgDimInfo> _mbgDims = new ArrayList<MbgDimInfo>();
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            _mbgDims.add(mbgDims.get(i));
        }
        return BgCubeUtils.getRefDims(bgSchemeInfo, _mbgDims, hasCslDim);
    }

    public static List<String> getRefDims(BgSchemeInfo bgSchemeInfo, Collection<MbgDimInfo> mbgDims, boolean hasCslDim) throws BOSException {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add(DimensionConstants.DEF_BGINDEX_FIELD);
        if (bgSchemeInfo == null || bgSchemeInfo.getBgDimSettings() == null) {
            return dims;
        }
        HashSet<String> dimsSet = new HashSet<String>(dims);
        HashMap<String, MbgDimInfo> dimMap = new HashMap<String, MbgDimInfo>();
        for (MbgDimInfo mbgDim : mbgDims) {
            if (DimUtils.checkBaseDimension(mbgDim.getNumber())) continue;
            dimMap.put(mbgDim.getNumber(), mbgDim);
        }
        MbgDimInfo mbgDim = null;
        int in = bgSchemeInfo.getBgDimSettings().size();
        for (int i = 0; i < in; ++i) {
            String dimNum = bgSchemeInfo.getBgDimSettings().get(i).getDimNumber();
            if (!hasCslDim && DimensionConstants.DEF_CSL_NUMBER.equals(dimNum) || !dimMap.containsKey(dimNum) || dimsSet.contains((mbgDim = (MbgDimInfo)dimMap.get(dimNum)).getRefField())) continue;
            dimsSet.add(mbgDim.getRefField());
            dims.add(mbgDim.getRefField());
        }
        DimUtils.sortFields(dims);
        return dims;
    }

    public static String getBudgetEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_BUDGET_ENTRY);
        }
        return null;
    }

    public static String getActualCubeName(String tableName) {
        return tableName;
    }

    public static String getActualCubeName1(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL);
        }
        return null;
    }

    public static String getActualEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL_ENTRY);
        }
        return null;
    }

    public static String getDailyActualCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL_DAILY);
        }
        return null;
    }

    public static String getDailyActualEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL_DAILY_ENTRY);
        }
        return null;
    }

    public static String getControlCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_CONTROL);
        }
        return null;
    }

    public static String getCFSCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_CFS);
        }
        return null;
    }

    public static String getCFSAdjustCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_CFS_ADJUST);
        }
        return null;
    }

    public static String getDecomposeCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_DECOMPOSE);
        }
        return null;
    }

    public static String getDecomposeSendDownCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_DECOMPOSE_SENDDOWN);
        }
        return null;
    }

    public static String getDecomposeGatherCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_DECOMPOSE_GATHER);
        }
        return null;
    }

    public static String getCFSEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_CFS_ENTRY);
        }
        return null;
    }

    public static String getCFSAdjustEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_CFS_ADJUST_ENTRY);
        }
        return null;
    }

    public static String getDecomposeEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_DECOMPOSE_ENTRY);
        }
        return null;
    }

    public static String getDecomposeSendDownEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_DECOMPOSE_SENDDOWN_ENTRY);
        }
        return null;
    }

    public static String getDecomposeGatherEntryCubeName(String tableName) {
        if (tableName != null) {
            return tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_DECOMPOSE_GATHER_ENTRY);
        }
        return null;
    }

    public static SelectorItemCollection getRefDimSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("number");
        sic.add("useAccInt");
        sic.add("name");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("period");
        sic.add("refCube");
        sic.add("isEnableAnalyse");
        sic.add("bgDimSettings.*");
        sic.add("bgDimSettings.members.*");
        sic.add("refProp.*");
        sic.add("refProp.bgPropertySort.*");
        return sic;
    }

    public static String getCubeName(String cubeName, int valueType) {
        if (StringUtils.isEmpty((String)cubeName)) {
            return cubeName;
        }
        String _cubeName = cubeName;
        if (valueType == 1 || valueType == 2 || valueType == 8) {
            _cubeName = cubeName;
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            _cubeName = BgCubeUtils.getDailyActualCubeName(cubeName);
        } else if (valueType == 4) {
            _cubeName = BgCubeUtils.getActualCubeName(cubeName);
        } else if (valueType == 64) {
            _cubeName = BgCubeUtils.getCFSCubeName(cubeName);
        } else if (valueType == 128) {
            _cubeName = BgCubeUtils.getCFSAdjustCubeName(cubeName);
        } else if (valueType == 256) {
            _cubeName = BgCubeUtils.getDecomposeCubeName(cubeName);
        } else if (valueType == 512) {
            _cubeName = BgCubeUtils.getDecomposeSendDownCubeName(cubeName);
        } else if (valueType == 1024) {
            _cubeName = BgCubeUtils.getDecomposeGatherCubeName(cubeName);
        }
        return _cubeName;
    }

    public static String getCubeEntryName(String cubeName, int valueType) {
        if (StringUtils.isEmpty((String)cubeName)) {
            return cubeName;
        }
        String _entryName = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        if (valueType == 1 || valueType == 2) {
            _entryName = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        } else if (valueType == 16 || valueType == 32 || valueType == 2048) {
            _entryName = BgCubeUtils.getDailyActualEntryCubeName(cubeName);
        } else if (valueType == 4) {
            _entryName = BgCubeUtils.getActualEntryCubeName(cubeName);
        } else if (valueType == 64) {
            _entryName = BgCubeUtils.getCFSEntryCubeName(cubeName);
        } else if (valueType == 128) {
            _entryName = BgCubeUtils.getCFSAdjustEntryCubeName(cubeName);
        } else if (valueType == 256) {
            _entryName = BgCubeUtils.getDecomposeEntryCubeName(cubeName);
        } else if (valueType == 512) {
            _entryName = BgCubeUtils.getDecomposeSendDownEntryCubeName(cubeName);
        } else if (valueType == 1024) {
            _entryName = BgCubeUtils.getDecomposeGatherEntryCubeName(cubeName);
        }
        return _entryName;
    }

    public static String getCubeName(String cubeName, BgProcessEnum processType) {
        if (processType == null) {
            return cubeName;
        }
        if (processType.equals((Object)BgProcessEnum.C02)) {
            return BgCubeUtils.getDecomposeCubeName(cubeName);
        }
        if (processType.equals((Object)BgProcessEnum.C03)) {
            return BgCubeUtils.getDecomposeSendDownCubeName(cubeName);
        }
        if (processType.equals((Object)BgProcessEnum.C04)) {
            return BgCubeUtils.getDecomposeGatherCubeName(cubeName);
        }
        return cubeName;
    }

    public static String getEntryCubeName(String cubeName, BgProcessEnum processType) {
        if (processType == null) {
            return BgCubeUtils.getBudgetEntryCubeName(cubeName);
        }
        if (processType.equals((Object)BgProcessEnum.C02)) {
            return BgCubeUtils.getDecomposeEntryCubeName(cubeName);
        }
        if (processType.equals((Object)BgProcessEnum.C03)) {
            return BgCubeUtils.getDecomposeSendDownEntryCubeName(cubeName);
        }
        if (processType.equals((Object)BgProcessEnum.C04)) {
            return BgCubeUtils.getDecomposeGatherEntryCubeName(cubeName);
        }
        return BgCubeUtils.getBudgetEntryCubeName(cubeName);
    }

    public static void checkTable(Context ctx) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            BgCubeUtils.checkTable(conn);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkTable(Connection conn) throws BOSException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ICubeManager cubeManager = CubeManager.getInstance();
        HashMap<String, Integer> refCubes = new HashMap<String, Integer>();
        String dataBase = null;
        try {
            dataBase = conn.getMetaData().getURL() + "$$" + conn.getMetaData().getUserName();
            if (checkedDataBases.contains(dataBase)) {
                return;
            }
            checkedDataBases.add(dataBase);
            BgCubeUtils.checkFormulaLength(conn, "T_MBG_BgPastData");
            BgCubeUtils.checkFormulaLength(conn, "T_MBG_BGTMPDATA");
            pstmt = conn.prepareStatement("Select FRefCube, FUseAccInt FROM T_MBG_BgScheme Where FRefCube IS NOT NULL Order By FCreateTime ASC");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                refCubes.put(rst.getString("FRefCube"), rst.getInt("FUseAccInt"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (refCubes.isEmpty()) {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                return;
            }
            boolean isAddTable = true;
            if (!isAddTable) {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                return;
            }
            HashMap refDims = new HashMap();
            String cubeName = null;
            String refField = null;
            String dimNumber = null;
            if (isAddTable) {
                pstmt = conn.prepareStatement("Select bgScheme.FRefCube, dimSet.FDimNumber, mbgDim.FRefField FROM T_MBG_BgScheme bgScheme INNER JOIN T_MBG_BgDimSettings dimSet ON bgScheme.FID = dimSet.FBgSchemeId LEFT JOIN T_MBG_MbgDim mbgDim ON mbgDim.FNumber = dimSet.FDimNumber Order By bgScheme.FRefCube, FRefField");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    cubeName = rst.getString("FRefCube");
                    dimNumber = rst.getString("FDimNumber");
                    refField = rst.getString("FRefField");
                    if (!refDims.containsKey(cubeName)) {
                        refDims.put(cubeName, new ArrayList());
                    }
                    if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber)) {
                        refField = DimensionConstants.DEF_BGINDEX_FIELD;
                    }
                    if (StringUtils.isEmpty((String)refField) || DimensionConstants.DEF_CSL_FIELD.equals(refField)) continue;
                    ((List)refDims.get(cubeName)).add(refField);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            String tableName = null;
            String[] sqls = null;
            HashMap<String, Object> sqlMap = new HashMap<String, Object>();
            HashSet<String> subCubes = new HashSet<String>();
            HashMap<String, String> splitMap = new HashMap<String, String>();
            for (String refCube : refCubes.keySet()) {
                subCubes.clear();
                splitMap.clear();
                if ((Integer)refCubes.get(refCube) > 0) {
                    BgSchemeConvertToAccIntUtils.querySplit(conn, refCube, splitMap);
                    subCubes.addAll(splitMap.values());
                } else {
                    subCubes.add(refCube);
                }
                BgCubeUtils.checkReportOrgUnitField(conn, refCube, subCubes);
                BgCubeUtils.checkFDetailField(conn, refCube, subCubes);
                BgCubeUtils.checkAudFormField(conn, refCube, subCubes);
                BgCubeUtils.checkDataSourceField(conn, refCube, subCubes);
                BgCubeUtils.checkIsomerField(conn, refCube);
                for (int dataType : DimensionConstants.ALL_DATA_TYPES) {
                    tableName = BgCubeUtils.getCubeName(refCube, dataType);
                    if (dataType == 1) {
                        for (String subCube : subCubes) {
                            BgCubeUtils.checkFormulaLength(conn, subCube);
                        }
                    } else {
                        BgCubeUtils.checkFormulaLength(conn, tableName);
                    }
                    sqlMap.put(CubeConstants.CUBE_NAME, refCube);
                    sqlMap.put(CubeConstants.CUBE_TYPE, dataType);
                    if (!DimensionCommonHelper.isDecompose(dataType)) continue;
                    if (BgDBUtils.existTable((Connection)conn, (String)BgCubeUtils.getCubeName(refCube, dataType)) != BgDBUtils.YES) {
                        sqls = cubeManager.getCubeFacade().getSqlStrategy().getCubeSql(conn, sqlMap, (List)refDims.get(refCube));
                        BgDBUtils.executeUpdate((Connection)conn, (String[])sqls);
                        sqls = cubeManager.getCubeFacade().getSqlStrategy().getCubeIndex(conn, sqlMap, (List)refDims.get(refCube));
                        BgDBUtils.executeUpdate((Connection)conn, (String[])sqls);
                        continue;
                    }
                    if (BgDBUtils.existColumn((Connection)conn, (String)tableName, (String)"FAudFormId") == BgDBUtils.NO) {
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + tableName + " add FAudFormId VARCHAR(44)"));
                    }
                    if (BgDBUtils.existColumn((Connection)conn, (String)tableName, (String)"FDataSource") != BgDBUtils.NO) continue;
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + tableName + " add FDataSource NUMERIC(21,8)"));
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return;
        }
        catch (SQLException e) {
            logger.error((Object)"Check Table Error", (Throwable)e);
            if (dataBase == null) throw new BOSException((Throwable)e);
            checkedDataBases.remove(dataBase);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
    }

    private static void checkDataSourceField(Connection conn, String cubeName, Set<String> subCubes) throws SQLException {
        String actCube;
        String cfsAdjCube;
        if (conn == null || cubeName == null || subCubes == null) {
            return;
        }
        for (String subCube : subCubes) {
            if (subCube.indexOf(CubeConstants.BASE_REPLACE_KEY) <= 0 || BgDBUtils.existColumn((Connection)conn, (String)subCube, (String)"FDataSource") != BgDBUtils.NO) continue;
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + subCube + " add FDataSource NUMERIC(21,8)"));
        }
        String cfsCube = BgCubeUtils.getCFSCubeName(cubeName);
        if (BgDBUtils.existTable((Connection)conn, (String)cfsCube) == BgDBUtils.YES && BgDBUtils.existColumn((Connection)conn, (String)cfsCube, (String)"FDataSource") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + cfsCube + " add FDataSource NUMERIC(21,8)"));
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(cfsAdjCube = BgCubeUtils.getCFSAdjustCubeName(cubeName))) == BgDBUtils.YES && BgDBUtils.existColumn((Connection)conn, (String)cfsAdjCube, (String)"FDataSource") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + cfsAdjCube + " add FDataSource NUMERIC(21,8)"));
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(actCube = BgCubeUtils.getDailyActualCubeName(cubeName))) == BgDBUtils.YES && BgDBUtils.existColumn((Connection)conn, (String)actCube, (String)"FDataSource") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + actCube + " add FDataSource NUMERIC(21,8)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFormulaLength(Connection conn, String tableName) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("SELECT KSQL_COL_LENGTH from KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = ? and KSQL_COL_TABNAME = ?");
            pstmt.setString(1, "FFormula");
            pstmt.setString(2, tableName);
            rst = pstmt.executeQuery();
            int length = -1;
            if (rst.next()) {
                length = rst.getInt(1);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (length > 0 && (BgDBUtils.isMSSQL((Connection)conn) || BgDBUtils.isOracle((Connection)conn))) {
                length /= 2;
            }
            if (length > 0 && length < 300) {
                pstmt = conn.prepareStatement("Alter Table " + tableName + " Alter Column FFormula NVarchar(" + 300 + ")");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    public static void checkReportOrgUnitField(Connection conn, String cubeName, Set<String> subCubes) throws SQLException {
        String cfsCube;
        if (conn == null || cubeName == null) {
            return;
        }
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        if (subCubes != null) {
            for (String subRefCube : subCubes) {
                if (BgDBUtils.existColumn((Connection)conn, (String)subRefCube, (String)"FReportOrgUnitID") != BgDBUtils.NO) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)("Alter Table " + subRefCube + " add FReportOrgUnitID VARCHAR(44)"));
                String index4 = "IX_MBG_BR" + codeNumber;
                if (!subRefCube.equals(cubeName)) {
                    index4 = "IX_MBG_BR" + BgSchemeConvertToAccIntUtils.getSplitString(subRefCube) + codeNumber;
                }
                if (BgDBUtils.existIndex((Connection)conn, (String)subRefCube, (String)index4) != BgDBUtils.NO) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE INDEX " + index4 + " ON " + subRefCube + " (FReportOrgUnitID ASC)"));
            }
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(cfsCube = BgCubeUtils.getCFSCubeName(cubeName))) == BgDBUtils.YES && BgDBUtils.existColumn((Connection)conn, (String)cfsCube, (String)"FReportOrgUnitID") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter Table " + cfsCube + " add FReportOrgUnitID VARCHAR(44)"));
            String index4 = "IX_MBG_CR" + codeNumber;
            if (BgDBUtils.existIndex((Connection)conn, (String)cfsCube, (String)index4) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("CREATE INDEX " + index4 + " ON " + cfsCube + " (FReportOrgUnitID ASC)"));
            }
        }
    }

    private static void checkFDetailField(Connection conn, String cubeName, Set<String> subCubes) throws SQLException {
        if (conn == null || cubeName == null || subCubes == null) {
            return;
        }
        for (String subCube : subCubes) {
            if (subCube.indexOf(CubeConstants.BASE_REPLACE_KEY) <= 0 || BgDBUtils.existColumn((Connection)conn, (String)subCube, (String)"FDetail") != BgDBUtils.NO) continue;
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter Table " + subCube + " add FDetail INT DEFAULT 0 NOT NULL"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + subCube + " Set FDetail = 1 where FState > 1 and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + 0 + ")"));
        }
    }

    public static void checkAudFormField(Connection conn, String cubeName, Set<String> subCubes) throws SQLException {
        String actCube;
        if (conn == null || cubeName == null || subCubes == null) {
            return;
        }
        for (String subCube : subCubes) {
            if (subCube.indexOf(CubeConstants.BASE_REPLACE_KEY) <= 0 || BgDBUtils.existColumn((Connection)conn, (String)subCube, (String)"FAudFormId") != BgDBUtils.NO) continue;
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + subCube + " add FAudFormId VARCHAR(44)"));
        }
        String cfsCube = BgCubeUtils.getCFSCubeName(cubeName);
        if (BgDBUtils.existTable((Connection)conn, (String)cfsCube) == BgDBUtils.YES && BgDBUtils.existColumn((Connection)conn, (String)cfsCube, (String)"FAudFormId") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + cfsCube + " add FAudFormId VARCHAR(44)"));
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(actCube = BgCubeUtils.getDailyActualCubeName(cubeName))) == BgDBUtils.YES && BgDBUtils.existColumn((Connection)conn, (String)actCube, (String)"FAudFormId") == BgDBUtils.NO) {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + actCube + " add FAudFormId VARCHAR(44)"));
        }
    }

    public static void checkIsomerField(Connection conn, String cubeName) throws SQLException {
        if (conn == null || cubeName == null) {
            return;
        }
        String controlCube = BgCubeUtils.getControlCubeName(cubeName);
        if (BgDBUtils.existTable((Connection)conn, (String)controlCube) == BgDBUtils.YES) {
            if (BgDBUtils.existColumn((Connection)conn, (String)controlCube, (String)"FConnectionID") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + controlCube + " add FConnectionID VARCHAR(44)"));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)controlCube, (String)"FIsomerID") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + controlCube + " add FIsomerID VARCHAR(44)"));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)controlCube, (String)"FBillEntryID") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + controlCube + " add FBillEntryID VARCHAR(44)"));
            }
            if (BgDBUtils.existColumn((Connection)conn, (String)controlCube, (String)"FAssistRecordID") == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Alter table " + controlCube + " add FAssistRecordID VARCHAR(44)"));
            }
        }
    }

    public static String getBgDataHint(String cubeName, String tableAlias, boolean isUseInt) {
        return BgCubeUtils.getBgDataHint(cubeName, tableAlias, "IX_MBG_BQ", isUseInt);
    }

    public static String getBgDataHint(String cubeName, String tableAlias, String hintName, boolean isUseInt) {
        return "/*+index(" + (tableAlias != null ? tableAlias : cubeName) + " " + hintName + cubeName.substring(cubeName.length() - (isUseInt ? 9 : 8)) + ")*/";
    }
}

