/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.logger.MbgLoggerUtils;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.data.MbgDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.app.olap.face.IOlapService;
import com.kingdee.eas.ma.mbg.app.olap.impl.BizCalcStrategy;
import com.kingdee.eas.ma.mbg.app.olap.impl.OlapService;
import com.kingdee.eas.ma.mbg.app.olap.utils.CubeUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.BizCalcOrgObject;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimDataUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.OptimizeUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class MbgDataMultiQuery
extends MultiThreadQuery {
    private static Logger logger = Logger.getLogger(MbgDataMultiQuery.class);
    private Map<String, List<String>> usingTmpTable = Collections.synchronizedMap(new HashMap());
    private Map<String, List<String>> unUseTmpTable = Collections.synchronizedMap(new HashMap());
    private TempTablePool pool = null;

    public MbgDataMultiQuery(Context ctx) {
        super(ctx);
    }

    public TempTablePool getPool() {
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.getCtx());
        }
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map doQuery(Collection<String> orgUnitIds, IDimensionParameter parameter, String engine) throws Exception {
        try {
            Map map = super.doQuery(orgUnitIds, parameter, engine);
            return map;
        }
        finally {
            ArrayList<String> tmpTables = new ArrayList<String>();
            for (List<String> ones : this.usingTmpTable.values()) {
                tmpTables.addAll(ones);
            }
            for (List<String> ones : this.unUseTmpTable.values()) {
                tmpTables.addAll(ones);
            }
            if (!tmpTables.isEmpty()) {
                BgDBUtils.releaseTmpTable((TempTablePool)this.getPool(), tmpTables);
            }
        }
    }

    @Override
    protected void optimizeParam(Connection conn, IDimensionParameter parameter) throws Exception {
        int in;
        if (this.getCtx() == null || conn == null || parameter == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        parameter.getDataManager().setOptimizeParams(params);
        MbgLoggerUtils.logger((String)"start getBgSchemeCubeInfo");
        BgSchemeInfo bgScheme = null;
        if (parameter.getDataManager().getBgScheme() == null) {
            bgScheme = BgViewServerHelper.getBgSchemeCubeInfo(this.getCtx(), parameter.getBgSchemeId());
            parameter.getDataManager().setBgScheme(bgScheme);
        } else {
            bgScheme = parameter.getDataManager().getBgScheme();
        }
        if (bgScheme == null) {
            return;
        }
        parameter.setUseAccInt(BgSchemeConvertToAccIntUtils.isUseAccInt(this.getCtx(), parameter.getDataManager().getBgScheme().getId().toString()));
        if (parameter.isUseAccInt()) {
            BgSchemeConvertToAccIntUtils.queryDimInt(conn, parameter);
            BgSchemeConvertToAccIntUtils.querySplit(conn, parameter.getDataManager().getBgScheme().getRefCube(), parameter.getDataManager().getSplitMap());
        }
        MbgDimCollection colls = null;
        MbgDimInfo mbgDim = null;
        MbgLoggerUtils.logger((String)"start getDimensionColls");
        if (parameter.getDataManager().getDimensions() == null || parameter.getDataManager().getDimensions().isEmpty()) {
            colls = DimUtils.getDimensionColls(conn, this.getCtx().getLocale());
            parameter.getDataManager().setDimensions(colls);
        } else {
            colls = parameter.getDataManager().getDimensions();
        }
        Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        Map<String, String> fieldSrcMap = parameter.getDataManager().getFieldSrcMap();
        Map<String, MbgDimInfo> mbgDims = parameter.getDataManager().getMbgDims();
        int in2 = colls.size();
        for (int i = 0; i < in2; ++i) {
            mbgDim = colls.get(i);
            mbgDims.put(mbgDim.getRefField(), mbgDim);
            srcFieldMap.put(mbgDim.getSrcNumber(), mbgDim.getRefField());
            fieldSrcMap.put(mbgDim.getRefField(), mbgDim.getSrcNumber());
        }
        srcFieldMap.put(DimensionConstants.DEF_PROCESS_SRCNUMBER, DimensionConstants.DEF_PROCESS_FIELD);
        fieldSrcMap.put(DimensionConstants.DEF_PROCESS_FIELD, DimensionConstants.DEF_PROCESS_SRCNUMBER);
        if (parameter.getDataManager().getBgScenarioMap().isEmpty()) {
            parameter.getDataManager().getBgScenarioMap().putAll(BgDimCacheUtils.getScenarioCache((Context)this.getCtx()));
        }
        MbgLoggerUtils.logger((String)"start transScenarioAndVersion");
        DimUtils.transScenarioAndVersion(this.getCtx(), conn, parameter, params);
        Set<String> standbyDim = bgScheme.getStandbyDim(conn);
        HashSet<String> cantCalcByDim = new HashSet<String>();
        MbgLoggerUtils.logger((String)"start transScenarioAndVersion");
        HashMap<String, String> rootMemberMap = new HashMap<String, String>();
        if (parameter.getDims() != null && !parameter.getDims().isEmpty()) {
            bgScheme.getExtRootMember(conn);
        }
        Set<String> cslDimSet = null;
        Set<String> sumDimSet = null;
        Set<String> sumCslDimSet = null;
        if (parameter.getUnionId() != null) {
            cslDimSet = bgScheme.getCslDim(conn);
            sumCslDimSet = bgScheme.getCslSumDim(conn);
        }
        MbgLoggerUtils.logger((String)"start getRootDim");
        sumDimSet = OptimizeUtils.getRootDim(parameter, standbyDim, cslDimSet, sumCslDimSet, rootMemberMap);
        OptimizeUtils.filterBySumDim(sumDimSet, parameter);
        if (sumDimSet != null && !sumDimSet.isEmpty()) {
            standbyDim.addAll(sumDimSet);
        }
        if (parameter.getAllPeriodMap() == null) {
            parameter.setAllPeriodMap(BizPtoUtils.queryBgPeriodInfo((Connection)conn));
        }
        MbgLoggerUtils.logger((String)"start queryCalc");
        BizCalcStrategy calcStrategy = new BizCalcStrategy();
        calcStrategy = parameter.getDataManager().getCalcStrategy() != null && parameter.getDataManager().getCalcStrategy().getBizCalcTraceResult() != null ? parameter.getDataManager().getCalcStrategy() : new BizCalcStrategy();
        calcStrategy.setStandbyDim(sumDimSet);
        calcStrategy.queryCalc(this.getCtx(), parameter);
        MbgLoggerUtils.logger((String)"start fillPeriodMemberByPeriodAlgorithm");
        if (!parameter.getControlManager().isFiscalYear()) {
            if (!BgParamNHelper.isPeriodAlgorithm((Context)this.getCtx())) {
                DimUtils.fillPeriodMemberByPeriodAlgorithm(this.getCtx(), parameter);
            } else {
                DimUtils.fillPeriodMemberToPeriodAlgorithm(this.getCtx(), parameter);
            }
        }
        parameter.getDataManager().setCalcStrategy(calcStrategy);
        MbgLoggerUtils.logger((String)"start filterExpress");
        OptimizeUtils.filterExpress(conn, calcStrategy.getMembers(), MbgDataHelper.mergeMbgMember(parameter), srcFieldMap, parameter, params);
        MbgLoggerUtils.logger((String)"start getRefMemberByExpress");
        Map<String, Set<String>> refDimMap = OptimizeUtils.getRefMemberByExpress(calcStrategy, parameter);
        if (parameter.isOrgLongNumber()) {
            com.kingdee.eas.ma.mbg.dimension.face.IDimension orgDim = parameter.getDimensionMap().get(DimensionConstants.DEF_ORGUNIT_NUMBER);
            if (orgDim == null && parameter.getDataManager().getMbgDims().containsKey(DimensionConstants.DEF_ORGUNIT_FIELD)) {
                MbgDimInfo mbgDimen = parameter.getDataManager().getMbgDims().get(DimensionConstants.DEF_ORGUNIT_FIELD);
                orgDim = new DimensionObject();
                orgDim.setNumber(mbgDimen.getNumber());
                orgDim.setField(mbgDimen.getRefField());
                orgDim.setSrcNumber(mbgDimen.getSrcNumber());
            }
            if (orgDim != null) {
                if (DimUtils.getDimension(parameter.getColDims(), DimensionConstants.DEF_ORGUNIT_NUMBER) == null && DimUtils.getDimension(parameter.getRowDims(), DimensionConstants.DEF_ORGUNIT_NUMBER) == null && DimUtils.getDimension(parameter.getPageDims(), DimensionConstants.DEF_ORGUNIT_NUMBER) == null) {
                    parameter.getColDims().add(orgDim);
                    if (parameter.getDimensionMap().get(DimensionConstants.DEF_ORGUNIT_NUMBER) == null) {
                        parameter.getDimensionMap().put(DimensionConstants.DEF_ORGUNIT_NUMBER, orgDim);
                    }
                }
                if (parameter.getQuerys() != null && !parameter.getQuerys().isEmpty()) {
                    for (IQueryData iQueryData : parameter.getQuerys()) {
                        if (iQueryData.getMbgDimMap().containsKey(DimensionConstants.DEF_ORGUNIT_FIELD)) continue;
                        iQueryData.getMbgDimMap().put(DimensionConstants.DEF_ORGUNIT_FIELD, orgDim.toMbgDim(this.getCtx(), parameter));
                    }
                }
            }
        }
        if (parameter.getOrgCalcMap() != null && !parameter.getOrgCalcMap().isEmpty()) {
            BizMemberQuery query = BizMemberQuery.getInstance((Context)this.getCtx(), (String)parameter.getBgSchemeId().toString());
            query.setSchemeInfo(bgScheme);
            query.setMbgColls(DimUtils.getDimensionColls(this.getCtx()));
            query.initMbgDimInfo(conn);
            for (Set set : parameter.getOrgCalcMap().values()) {
                BizCalcOrgObject[] objs;
                for (BizCalcOrgObject obj : objs = set.toArray(new BizCalcOrgObject[0])) {
                    if (!obj.isFunction) continue;
                    List members = query.queryFcuntion(conn, DimensionConstants.DEF_ORGUNIT_FIELD, (FunctionExpr)MbgExprParseHelper.parse((String)obj.orgNumber));
                    set.remove(obj);
                    for (IMember member : members) {
                        set.add(new BizCalcOrgObject(obj.processType, member.getNumber()));
                    }
                }
            }
        }
        boolean bizExitCsl = false;
        if (refDimMap.keySet().contains(DimensionBaseConstants.DEF_CSL_Consolidation)) {
            bizExitCsl = true;
        }
        standbyDim.removeAll(refDimMap.keySet());
        OptimizeUtils.filterExpressFormulaCalc(this.getCtx(), calcStrategy.getMembers(), parameter, refDimMap, srcFieldMap, calcStrategy.getBizCalcQuery().getRelyObjMap());
        MbgLoggerUtils.logger((String)"start getRelationData");
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        if (relationData != null && !relationData.isEmpty()) {
            for (String _field : relationData.get(0)) {
                if (!mbgDims.containsKey(_field)) continue;
                standbyDim.remove(mbgDims.get(_field).getNumber());
            }
        }
        if (parameter.getQuerys() != null) {
            for (IQueryData queryData3 : parameter.getQuerys()) {
                if (queryData3.getFilters() == null) continue;
                List<String[]> filter = queryData3.getRowFilter();
                if (filter != null && !filter.isEmpty()) {
                    for (String _field : filter.get(0)) {
                        if (!mbgDims.containsKey(_field)) continue;
                        standbyDim.remove(mbgDims.get(_field).getNumber());
                    }
                }
                if ((filter = queryData3.getColFilter()) == null || filter.isEmpty()) continue;
                for (String _field : filter.get(0)) {
                    if (!mbgDims.containsKey(_field)) continue;
                    standbyDim.remove(mbgDims.get(_field).getNumber());
                }
            }
        }
        if (cslDimSet != null) {
            cslDimSet.addAll(refDimMap.keySet());
        }
        for (String mbgNumber : bgScheme.getExtDimNums()) {
            if (refDimMap.containsKey(mbgNumber)) continue;
            cantCalcByDim.add(mbgNumber);
        }
        MbgLoggerUtils.logger((String)"start filterBizMember");
        OptimizeUtils.filterBizMember(parameter.getDataManager().getCalcStrategy().getMembers(), parameter, standbyDim);
        MbgLoggerUtils.logger((String)"start OptimizeDimension");
        CubeUtils.queryNotAggEle(conn, parameter);
        OptimizeUtils.OptimizeDimension(conn, parameter, params, refDimMap, standbyDim);
        if (bizExitCsl) {
            standbyDim.remove(DimensionBaseConstants.DEF_CSL_Consolidation);
        }
        Object var20_31 = null;
        if (parameter.getUnionId() != null && cslDimSet != null && !cslDimSet.isEmpty()) {
            OptimizeUtils.filterRootDimension(parameter.getDims(), cslDimSet, rootMemberMap);
            int in3 = parameter.getQuerys().size();
            for (int i = 0; i < in3; ++i) {
                IQueryData iQueryData = parameter.getQuerys().get(i);
                OptimizeUtils.filterRootQuery(iQueryData.getDims(), cslDimSet, rootMemberMap);
                OptimizeUtils.filterRootQuery(iQueryData.getMbgDimMap(), cslDimSet, rootMemberMap);
            }
        }
        MbgLoggerUtils.logger((String)"start filterStandbyDimension");
        OptimizeUtils.filterStandbyExpress(standbyDim, parameter);
        OptimizeUtils.filterStandbyDimension(parameter.getRowDims(), standbyDim, parameter);
        OptimizeUtils.filterStandbyDimension(parameter.getColDims(), standbyDim, parameter);
        OptimizeUtils.filterStandbyDimension(parameter.getPageDims(), standbyDim, parameter);
        OptimizeUtils.filterStandbyDimension(parameter.getDimensionMap(), standbyDim, parameter);
        int in4 = parameter.getQuerys().size();
        for (int i = 0; i < in4; ++i) {
            IQueryData iQueryData = parameter.getQuerys().get(i);
            OptimizeUtils.filterStandbyDimension(iQueryData.getRows(), standbyDim, parameter, iQueryData);
            OptimizeUtils.filterStandbyDimension(iQueryData.getCols(), standbyDim, parameter, iQueryData);
            OptimizeUtils.filterStandbyDimension(iQueryData.getViews(), standbyDim, parameter, iQueryData);
            OptimizeUtils.filterStandbyDimension(iQueryData.getMbgDimMap(), standbyDim, parameter, iQueryData);
        }
        MbgLoggerUtils.logger((String)"start filterMbgMemberByOrg");
        OptimizeUtils.filterMbgMemberByOrg(this.getCtx(), conn, cslDimSet, cantCalcByDim, parameter, params, refDimMap);
        if (standbyDim != null && !standbyDim.isEmpty()) {
            params.put(DimensionConstants.MEMBER_FILTER, DimensionConstants.MEMBER_FILTER);
        }
        MbgLoggerUtils.logger((String)"start OptimizeBgIndex");
        OptimizeUtils.OptimizeBgIndex(this.getCtx(), conn, parameter, params);
        MbgLoggerUtils.logger((String)"end OptimizeBgIndex");
        StringBuffer numbers = new StringBuffer();
        List<String> memberNums = this.getBaseMemberNums(parameter, refDimMap, DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        if (memberNums != null && !memberNums.isEmpty()) {
            in = memberNums.size();
            for (int i = 0; i < in; ++i) {
                numbers.append("'" + memberNums.get(i) + "',");
            }
            numbers.delete(numbers.length() - 1, numbers.length());
            params.put(DimensionConstants.ELEMENT_NUMBERS, numbers.toString());
        }
        if ((memberNums = this.getBaseMemberNums(parameter, refDimMap, DimensionBaseConstants.DEF_CURRENCY_NUMBER)) != null && !memberNums.isEmpty()) {
            numbers.setLength(0);
            in = memberNums.size();
            for (int i = 0; i < in; ++i) {
                numbers.append("'" + memberNums.get(i) + "',");
            }
            numbers.delete(numbers.length() - 1, numbers.length());
            params.put(DimensionConstants.CURRENCY_NUMBERS, numbers.toString());
        }
        if ((memberNums = this.getBaseMemberNums(parameter, refDimMap, DimensionBaseConstants.DEF_SCENARIO_NUMBER)) != null && !memberNums.isEmpty()) {
            numbers.setLength(0);
            in = memberNums.size();
            for (int i = 0; i < in; ++i) {
                numbers.append("'" + memberNums.get(i) + "',");
            }
            numbers.delete(numbers.length() - 1, numbers.length());
            params.put(DimensionConstants.SCENARIO_NUMBERS, numbers.toString());
        }
        if ((memberNums = this.getBaseMemberNums(parameter, refDimMap, DimensionBaseConstants.DEF_VERSION_NUMBER)) != null && !memberNums.isEmpty()) {
            numbers.setLength(0);
            in = memberNums.size();
            for (int i = 0; i < in; ++i) {
                numbers.append("'" + memberNums.get(i) + "',");
            }
            numbers.delete(numbers.length() - 1, numbers.length());
            params.put(DimensionConstants.VERSION_NUMBERS, numbers.toString());
        }
        MbgLoggerUtils.logger((String)"start queryNotAggEle");
        MbgLoggerUtils.logger((String)"start \u5904\u7406\u9884\u7b97\u9879\u76ee\u7ec4\u5408\u4e8b\u5b9e\u8868\u6570\u636e\u53ca\u7ef4\u5ea6\u8303\u56f4");
        String refFieldStr = "";
        String factStr = "";
        String closureStr = "";
        String refField = null;
        String closureTable = null;
        String factTable = null;
        String dimTable = null;
        BOSUuid viewId = null;
        ArrayList<String> fields = new ArrayList<String>();
        CubeUtils.getRefDimensionInfo(parameter.getDims(), fields);
        CubeUtils.getRefDimensionInfo(parameter.getDimensionMap(), fields);
        DimUtils.sortFields(fields);
        dimTable = bgScheme.getRefCube();
        if (!(DimDataUtils.hasType(parameter.getValueType(), 1) || DimDataUtils.hasType(parameter.getValueType(), 2) || DimDataUtils.hasType(parameter.getValueType(), 8) || DimDataUtils.hasType(parameter.getValueType(), 4))) {
            if (DimDataUtils.hasType(parameter.getValueType(), 16) || DimDataUtils.hasType(parameter.getValueType(), 32) || DimDataUtils.hasType(parameter.getValueType(), 2048)) {
                dimTable = BgCubeUtils.getDailyActualCubeName(dimTable);
            } else if (DimDataUtils.hasType(parameter.getValueType(), 64)) {
                dimTable = BgCubeUtils.getCFSCubeName(dimTable);
            } else if (DimDataUtils.hasType(parameter.getValueType(), 128)) {
                dimTable = BgCubeUtils.getCFSAdjustCubeName(dimTable);
            } else if (DimDataUtils.hasType(parameter.getValueType(), 256)) {
                dimTable = BgCubeUtils.getDecomposeCubeName(dimTable);
            } else if (DimDataUtils.hasType(parameter.getValueType(), 512)) {
                dimTable = BgCubeUtils.getDecomposeSendDownCubeName(dimTable);
            } else if (DimDataUtils.hasType(parameter.getValueType(), 1024)) {
                dimTable = BgCubeUtils.getDecomposeGatherCubeName(dimTable);
            }
        }
        params.put(DimensionConstants.TABLE_CUBE, bgScheme.getRefCube());
        params.put(DimensionConstants.TABLE_NAME, dimTable);
        int in5 = fields.size();
        for (int i = 0; i < in5; ++i) {
            refField = (String)fields.get(i);
            mbgDim = parameter.getDataManager().getMbgDims().get(refField);
            if (standbyDim != null && standbyDim.contains(mbgDim.getNumber())) continue;
            viewId = bgScheme.getViewId(mbgDim.getNumber());
            if (viewId == null) {
                throw new DimensionException(DimensionException.DIMENSIONREFFIELDERROR);
            }
            factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId);
            if (StringUtils.isEmpty((String)factTable)) {
                throw new DimensionException(DimensionException.NOFACTTABLE);
            }
            closureTable = MbgVirtualView.getClosureTable((String)factTable);
            if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(mbgDim.getNumber())) {
                params.put(DimensionConstants.BGINDEX_FACT_TABLE, factTable);
                params.put(DimensionConstants.BGINDEX_CLOSURE_TABLE, closureTable);
            }
            refFieldStr = refFieldStr + refField + ";";
            factStr = factStr + factTable + ";";
            closureStr = closureStr + closureTable + ";";
            if (parameter == null || mbgDim == null || parameter.getUnionId() == null || cslDimSet == null || cslDimSet.contains(mbgDim.getNumber()) || rootMemberMap == null || !rootMemberMap.containsKey(refField)) continue;
            params.put(refField + "_" + DimensionConstants.MEMBER_ROOT, DimensionConstants.MEMBER_ROOT);
            params.put(refField + "_" + DimensionConstants.MEMBER_ROOT_NUMBER, (String)rootMemberMap.get(refField));
        }
        params.put(DimensionConstants.BGITEM_DIM_REFFIELD, refFieldStr);
        params.put(DimensionConstants.BGITEM_DIM_FACT, factStr);
        params.put(DimensionConstants.BGITEM_DIM_CLOSURE, closureStr);
        parameter.getControlManager().setMultiProcessType(DimUtils.isMultiProcessType(params));
        MbgLoggerUtils.logger((String)"end \u5904\u7406\u9884\u7b97\u9879\u76ee\u7ec4\u5408\u4e8b\u5b9e\u8868\u6570\u636e\u53ca\u7ef4\u5ea6\u8303\u56f4");
    }

    protected List<String> getBaseMemberNums(IDimensionParameter parameter, Map<String, Set<String>> refDimMap, String dimNumber) {
        List<String> memberNums = new ArrayList<String>();
        if (parameter.getDimensionMap().containsKey(dimNumber) && !parameter.getDimensionMap().get(dimNumber).getDimensionMember().isEmpty()) {
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : parameter.getDimensionMap().get(dimNumber).getDimensionMember()) {
                if (memberNums.contains(member.getNumber())) continue;
                memberNums.add(member.getNumber());
            }
        }
        if (parameter.getQuerys() != null && !parameter.getQuerys().isEmpty()) {
            IQueryData queryData = null;
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                queryData = parameter.getQuerys().get(i);
                if (queryData.getMbgDimMap().isEmpty()) continue;
                String field2 = null;
                IDimension dimension = null;
                for (String field2 : queryData.getMbgDimMap().keySet()) {
                    dimension = queryData.getMbgDimMap().get(field2);
                    if (!dimNumber.equals(dimension.getNumber()) || dimension.getMembers().isEmpty()) continue;
                    for (IMember member : dimension.getMembers()) {
                        if (memberNums.contains(member.getNumber())) continue;
                        memberNums.add(member.getNumber());
                    }
                }
            }
        }
        if (refDimMap != null && !refDimMap.isEmpty() && refDimMap.containsKey(dimNumber) && !refDimMap.get(dimNumber).isEmpty()) {
            for (String str : refDimMap.get(dimNumber)) {
                if (memberNums.contains(str)) continue;
                memberNums.add(str);
            }
        }
        if (memberNums.isEmpty()) {
            memberNums = parameter.getDataManager().getBgScheme().getMemberNumber(dimNumber);
        }
        return memberNums;
    }

    @Override
    protected Callable<Map> getQueryThread(Context ctx, Connection conn, List<OrgUnitInfo> orgUnitInfos, List<OrgUnitInfo> decompOrgUnitInfos, IDimensionParameter parameter, String engine) throws BOSException, EASBizException {
        if (ctx == null || orgUnitInfos == null || orgUnitInfos.isEmpty() || parameter == null || StringUtils.isEmpty((String)engine)) {
            return null;
        }
        MbgDataBaseThread call = null;
        call = parameter.getUnionId() != null && parameter.getBillId() != null && "9E7BD5E2".equals(parameter.getBillId().getType().toString()) ? new MbgWorkPaperDataThread(ctx, conn, orgUnitInfos, decompOrgUnitInfos, parameter, engine) : new MbgDataBaseThread(ctx, conn, orgUnitInfos, decompOrgUnitInfos, parameter, engine);
        return call;
    }

    protected void fillOldValue(Map<String, Map<String, IBgNData>> bgDataMap) {
        if (bgDataMap == null || bgDataMap.isEmpty()) {
            return;
        }
        Object var2_2 = null;
        Map<String, IBgNData> _bgDataMap22 = null;
        for (Map<String, IBgNData> _bgDataMap22 : bgDataMap.values()) {
            if (_bgDataMap22 == null) continue;
            for (BgNDataInfo bgNDataInfo : _bgDataMap22.values()) {
                if (bgNDataInfo.getOldValue() != null || bgNDataInfo.getBudgetValueNoDef() == null) continue;
                bgNDataInfo.setOldValue(bgNDataInfo.getBudgetValueNoDef());
            }
        }
    }

    private void releaseTmpTable(Map<String, String> tmpTables) {
        if (tmpTables == null || tmpTables.isEmpty()) {
            return;
        }
        String tmpTable = null;
        for (String dimNumber : tmpTables.keySet()) {
            tmpTable = tmpTables.get(dimNumber);
            if (tmpTable == null) continue;
            this.usingTmpTable.get(dimNumber).remove(tmpTable);
            this.unUseTmpTable.get(dimNumber).add(tmpTable);
        }
    }

    public String getTmpTable(Connection conn, String dimNumber, String createSql) throws EASBizException, BOSException, SQLException {
        String tmpTable = null;
        if (!this.unUseTmpTable.containsKey(dimNumber)) {
            this.unUseTmpTable.put(dimNumber, new ArrayList());
        }
        if (!this.usingTmpTable.containsKey(dimNumber)) {
            this.usingTmpTable.put(dimNumber, new ArrayList());
        }
        tmpTable = !this.unUseTmpTable.get(dimNumber).isEmpty() ? this.unUseTmpTable.get(dimNumber).remove(0) : BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)createSql);
        this.usingTmpTable.get(dimNumber).add(tmpTable);
        BgDBUtils.executeUpdate((Connection)conn, (String)("Delete FROM " + tmpTable));
        return tmpTable;
    }

    @Override
    protected boolean checkCUBAException(Exception e) {
        return false;
    }

    class MbgWorkPaperDataThread
    extends MbgDataBaseThread {
        public MbgWorkPaperDataThread(Context ctx, Connection conn, List<OrgUnitInfo> orgUnitInfos, List<OrgUnitInfo> decompOrgUnitInfos, IDimensionParameter parameter, String engine) {
            super(ctx, conn, orgUnitInfos, decompOrgUnitInfos, parameter, engine);
        }

        @Override
        protected void synchParameter(List<OrgUnitInfo> orgUnitInfos, List<OrgUnitInfo> decompOrgUnitInfos, IDimensionParameter parameter) throws Exception {
            super.synchParameter(orgUnitInfos, decompOrgUnitInfos, parameter);
            if (parameter != null && parameter.getDataManager().getDimDataQuery() != null && !parameter.getOrgUnitId().equals((Object)parameter.getDataManager().getDimDataQuery().getBizOrgUnit().getId())) {
                int i;
                parameter.getControlManager().setHasQueryDataState(false);
                IQueryData query = null;
                IDimension mbgCsl = null;
                Member mbgMember = null;
                MemberObject member = null;
                com.kingdee.eas.ma.mbg.dimension.face.IDimension cslDim = parameter.getDimension(DimensionBaseConstants.DEF_CSL_FIELD);
                HashSet<String> cslNums = new HashSet<String>();
                int in = cslDim.getDimensionMember().size();
                for (i = 0; i < in; ++i) {
                    cslNums.add(cslDim.getDimensionMember().get(i).getNumber());
                }
                cslDim.getDimensionMember().clear();
                if (cslNums.contains("CSL-01")) {
                    member = new MemberObject();
                    member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    member.setNumber("CSL-01");
                    cslDim.getDimensionMember().add(member);
                }
                if (cslNums.contains("CSL-02")) {
                    member = new MemberObject();
                    member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    member.setNumber("CSL-02");
                    cslDim.getDimensionMember().add(member);
                }
                if (cslNums.contains("CSL-03")) {
                    member = new MemberObject();
                    member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    member.setNumber("CSL-03");
                    cslDim.getDimensionMember().add(member);
                }
                in = parameter.getQuerys().size();
                for (i = 0; i < in; ++i) {
                    query = parameter.getQuerys().get(i);
                    mbgCsl = query.getMbgDimMap().get(DimensionBaseConstants.DEF_CSL_FIELD);
                    if (mbgCsl == null) continue;
                    cslNums.clear();
                    int jn = mbgCsl.getMembers().size();
                    for (int j = 0; j < jn; ++j) {
                        cslNums.add(mbgCsl.getMembers().get(j).getNumber());
                    }
                    mbgCsl.getMembers().clear();
                    if (cslNums.contains("CSL-01")) {
                        mbgMember = new Member();
                        mbgMember.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                        mbgMember.setNumber("CSL-01");
                        mbgCsl.getMembers().add(mbgMember);
                    }
                    if (cslNums.contains("CSL-02")) {
                        mbgMember = new Member();
                        mbgMember.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                        mbgMember.setNumber("CSL-02");
                        mbgCsl.getMembers().add(mbgMember);
                    }
                    if (!cslNums.contains("CSL-03")) continue;
                    mbgMember = new Member();
                    mbgMember.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
                    mbgMember.setNumber("CSL-03");
                    mbgCsl.getMembers().add(mbgMember);
                }
            }
        }

        @Override
        protected void setBgDataState(Connection conn, Map bgDataMap, IDimensionParameter parameter) throws BOSException, EASBizException {
            super.setBgDataState(conn, bgDataMap, parameter);
        }
    }

    class MbgDataBaseThread
    extends Thread
    implements Callable<Map> {
        private Context ctx = null;
        private Connection pConn = null;
        private List<OrgUnitInfo> orgUnitInfos = null;
        private List<OrgUnitInfo> decompOrgUnitInfos = null;
        private IDimensionParameter parameter = null;
        private String engine = null;
        private Connection conn = null;

        public MbgDataBaseThread(Context ctx, Connection conn, List<OrgUnitInfo> orgUnitInfos, List<OrgUnitInfo> decompOrgUnitInfos, IDimensionParameter parameter, String engine) {
            this.ctx = ctx;
            this.pConn = conn;
            this.orgUnitInfos = orgUnitInfos;
            this.decompOrgUnitInfos = decompOrgUnitInfos;
            this.parameter = parameter;
            this.engine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map call() throws Exception {
            HashMap<String, Object> bgDataMap = new HashMap<String, Object>();
            if (this.ctx == null || this.orgUnitInfos == null || this.orgUnitInfos.isEmpty() || this.parameter == null || StringUtils.isEmpty((String)this.engine)) {
                return bgDataMap;
            }
            try {
                this.conn = BgDBUtils.getConnection((Context)this.ctx);
                MbgLoggerUtils.logger((String)"start synchParameter.");
                this.synchParameter(this.orgUnitInfos, this.decompOrgUnitInfos, this.parameter);
                IOlapService service = OlapService.getImpl(this.engine);
                if (service != null) {
                    MbgLoggerUtils.logger((String)"start olapQuery.");
                    Map<String, Object> tmpDataMap = null;
                    tmpDataMap = this.parameter.getControlManager().isControlData() ? service.olapQuery(this.ctx, this.pConn, this.parameter) : service.olapQuery(this.ctx, BgDBUtils.isDM((Connection)this.conn) ? this.conn : this.pConn, this.parameter);
                    MbgLoggerUtils.logger((String)"end olapQuery.");
                    if (tmpDataMap != null) {
                        if (!this.parameter.getControlManager().isControlData()) {
                            this.setBgDataState(this.conn, tmpDataMap, this.parameter);
                            if (this.parameter.getOrgUnitId() == null || this.parameter.getControlManager().isMultiProcessType() && this.parameter.getControlManager().isSaveMultiData()) {
                                MultiThreadQuery.mergeData(bgDataMap, tmpDataMap);
                            } else {
                                bgDataMap.put(this.parameter.getOrgUnitId().toString(), tmpDataMap);
                            }
                        } else {
                            bgDataMap.putAll(tmpDataMap);
                        }
                    }
                }
            }
            finally {
                SQLUtils.cleanup((Connection)this.conn);
            }
            return bgDataMap;
        }

        protected void synchParameter(List<OrgUnitInfo> orgUnitInfos, List<OrgUnitInfo> decompOrgUnitInfos, IDimensionParameter parameter) throws Exception {
            if (orgUnitInfos == null || orgUnitInfos.isEmpty() || parameter == null) {
                return;
            }
            if (orgUnitInfos.size() == 1 && !parameter.isOrgLongNumber()) {
                parameter.setOrgUnitId(orgUnitInfos.get(0).getId());
                parameter.getDataManager().setOrgUnit(orgUnitInfos.get(0));
                parameter.setLocalOrgNum(orgUnitInfos.get(0).getNumber());
                parameter.getDataManager().setBgOrgUnit(MbgDataHelper.getBgOrgUnitInfo(this.conn, this.ctx.getLocale(), parameter.getBgOrgViewId(), orgUnitInfos.get(0).getId()));
                CubeUtils.deleteOrgDimension(parameter);
            } else {
                com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension;
                parameter.setOrgUnitId(null);
                HashSet<String> orgNumbers = new HashSet<String>();
                HashSet<String> orgIds = new HashSet<String>();
                for (OrgUnitInfo o : orgUnitInfos) {
                    orgNumbers.add(o.getNumber());
                    orgIds.add(o.getId().toString());
                    parameter.getDataManager().getOrgUnitMap().put(o.getNumber(), o);
                }
                parameter.setQeryOrgIds(orgIds);
                com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
                if (parameter.getDimension(DimensionConstants.DEF_ORGUNIT_FIELD) == null) {
                    dimension = new DimensionObject();
                    ((DimensionObject)dimension).setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
                    ((DimensionObject)dimension).setField(DimensionConstants.DEF_ORGUNIT_FIELD);
                    ((DimensionObject)dimension).setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                    parameter.getDimensionMap().put(((DimensionObject)dimension).getNumber(), dimension);
                    parameter.getRowDims().add(dimension);
                }
                dimension = parameter.getDimension(DimensionConstants.DEF_ORGUNIT_FIELD);
                dimension.clearMember();
                for (OrgUnitInfo o : orgUnitInfos) {
                    MemberObject _member = new MemberObject();
                    _member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                    _member.setNumber(o.getNumber());
                    dimension.addMember(_member);
                }
                if (parameter.getQuerys() != null) {
                    for (IQueryData queryData : parameter.getQuerys()) {
                        IDimension orgDim = queryData.getMbgDimMap().get(DimensionConstants.DEF_ORGUNIT_FIELD);
                        if (orgDim == null) continue;
                        for (OrgUnitInfo o : orgUnitInfos) {
                            MemberObject _member = new MemberObject();
                            _member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                            _member.setNumber(o.getNumber());
                            orgDim.addMember(_member.toMember(true));
                        }
                    }
                }
                Iterator<com.kingdee.eas.ma.mbg.dimension.face.IMember> it = parameter.getDimension(DimensionConstants.DEF_ORGUNIT_FIELD).getDimensionMember().iterator();
                while (it.hasNext()) {
                    member = it.next();
                    if (!orgNumbers.contains(member.getNumber())) {
                        it.remove();
                        continue;
                    }
                    if (parameter.isOrgLongNumber()) {
                        member.setMdxNumber(member.getNumber());
                        continue;
                    }
                    member.setMdxNumber(member.getNumber());
                }
                if (parameter.getQuerys() != null && !parameter.getQuerys().isEmpty()) {
                    for (IQueryData query : parameter.getQuerys()) {
                        if (!query.getMbgDimMap().containsKey(DimensionConstants.DEF_ORGUNIT_FIELD)) continue;
                        Iterator<IMember> it2 = query.getMbgDimMap().get(DimensionConstants.DEF_ORGUNIT_FIELD).getMembers().iterator();
                        while (it2.hasNext()) {
                            IMember m = it2.next();
                            m.setMdxNumber(m.getNumber());
                            m.setLongNumber(m.getNumber());
                            if (!orgNumbers.contains(m.getNumber())) {
                                it2.remove();
                                continue;
                            }
                            if (parameter.isOrgLongNumber()) continue;
                        }
                    }
                }
            }
            if (decompOrgUnitInfos != null && !decompOrgUnitInfos.isEmpty()) {
                parameter.setQueryOrgDecompIds(new HashSet<String>());
                for (OrgUnitInfo org : decompOrgUnitInfos) {
                    parameter.getQueryOrgDecompIds().add(org.getId().toString());
                }
            }
        }

        protected void setBgDataState(Connection conn, Map bgDataMap2, IDimensionParameter parameter) throws BOSException, EASBizException {
            boolean isUseAccInt;
            boolean isAdjust;
            if (MbgDataMultiQuery.this.getCtx() == null || parameter == null || bgDataMap2 == null || bgDataMap2.isEmpty()) {
                return;
            }
            String operState = (String)MbgDataMultiQuery.this.getCtx().get((Object)"OPEN_STATE");
            boolean bl = isAdjust = parameter.getDataManager().getDimDataQuery() != null && parameter.getControlManager().isAdjust();
            if (("VIEW".equals(operState) || !parameter.getControlManager().hasQueryDataState() || parameter.getControlManager().isControlData() || parameter.getDataManager().getDimDataQuery() == null) && !isAdjust) {
                return;
            }
            long ct = System.currentTimeMillis();
            logger.info((Object)"start setBgDataState");
            BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
            if (bgScheme == null) {
                return;
            }
            IBgNData data = null;
            Map<String, Map<String, IBgNData>> _bgDataMap = new HashMap<String, Map>();
            HashSet orgUnitIds = new HashSet();
            if (parameter.getOrgUnitId() != null) {
                _bgDataMap.put(parameter.getOrgUnitId().toString(), bgDataMap2);
            } else {
                _bgDataMap = bgDataMap2;
            }
            orgUnitIds.addAll(_bgDataMap.keySet());
            String cubeName = bgScheme.getRefCube();
            if (parameter.getValueType() == 16 || parameter.getValueType() == 32 || parameter.getValueType() == 2048) {
                cubeName = BgCubeUtils.getDailyActualCubeName(bgScheme.getRefCube());
            } else if (parameter.getValueType() == 64) {
                cubeName = BgCubeUtils.getCFSCubeName(bgScheme.getRefCube());
            } else if (parameter.getValueType() == 128) {
                cubeName = BgCubeUtils.getCFSAdjustCubeName(bgScheme.getRefCube());
            } else if (DimensionCommonHelper.isDecompose(parameter.getValueType())) {
                cubeName = BgCubeUtils.getCubeName(bgScheme.getRefCube(), parameter.getValueType());
            }
            boolean bl2 = isUseAccInt = BgSchemeConvertToAccIntUtils.isUseAccInt(this.ctx, bgScheme.getId().toString()) && cubeName.equals(bgScheme.getRefCube());
            if (!isUseAccInt && parameter.getOrgUnitId() != null && orgUnitIds.size() == 1 && !MbgDataUtils.checkHasDataByOrgUnit(MbgDataMultiQuery.this.getCtx(), isUseAccInt, cubeName, null, parameter.getOrgUnitId().toString(), parameter.getBgOrgViewId().toString())) {
                logger.info((Object)("end setBgDataState: not data or orgunit is not leaf! no accint" + parameter.getOrgUnitId().toString()));
                return;
            }
            HashSet<String> bgPeriodNums = new HashSet<String>();
            HashSet<String> bgElementNums = new HashSet<String>();
            HashSet<String> currencyNums = new HashSet<String>();
            HashSet<String> bgScenarioNums = new HashSet<String>();
            HashSet<String> mbgMemSet = null;
            HashMap<String, HashSet<String>> dimMemMap = new HashMap<String, HashSet<String>>();
            HashMap<String, String> tmpTables = new HashMap<String, String>();
            ArrayList<String> tmpNums = new ArrayList<String>();
            int versionId = 0;
            String dimKey2 = null;
            String formulaStr = null;
            String versionNum = null;
            String dimNumber2 = null;
            String srcNumber = null;
            String field = null;
            String orgUnitId = null;
            String tmpPeriod = null;
            String tmpElement = null;
            String tmpCurrency = null;
            String tmpScenario = null;
            String[] tmpStrs = null;
            String[] params = null;
            BigDecimal value = null;
            StringBuffer sql = new StringBuffer();
            HashSet<String> accNumbers = new HashSet<String>();
            Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
            Map<String, String> verInnNumMap = parameter.getDataManager().getInnNumMap().get(DimensionConstants.DEF_VERSION_FIELD);
            for (Map bgDataMap2 : _bgDataMap.values()) {
                for (String dimKey2 : bgDataMap2.keySet()) {
                    tmpStrs = dimKey2.split("_");
                    formulaStr = tmpStrs[0];
                    versionNum = tmpStrs[1];
                    params = BgNFSHelper.parseFormulaPara(formulaStr);
                    for (String dimNumber2 : params[0].split(",")) {
                        srcNumber = DimUtils.getSrcNumber(dimNumber2);
                        field = srcFieldMap.get(srcNumber);
                        if (isUseAccInt && srcNumber.equals(DimensionConstants.DEF_INDEX_SRCNUMBER)) {
                            accNumbers.add(DimUtils.getNumber(dimNumber2));
                        }
                        if ((mbgMemSet = (HashSet<String>)dimMemMap.get(field)) == null) {
                            mbgMemSet = new HashSet<String>();
                            dimMemMap.put(field, mbgMemSet);
                        }
                        mbgMemSet.add(dimNumber2);
                    }
                    bgPeriodNums.add(params[1]);
                    bgElementNums.add(params[2]);
                    currencyNums.add(params[5]);
                    bgScenarioNums.add(params[3]);
                }
            }
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                Map<String, String> splitMap = null;
                if (isUseAccInt) {
                    splitMap = BgSchemeConvertToAccIntUtils.querySplit(conn, cubeName);
                }
                if (parameter.getOrgUnitId() != null && orgUnitIds.size() == 1 && !MbgDataUtils.checkHasDataByOrgUnit(MbgDataMultiQuery.this.getCtx(), isUseAccInt, cubeName, BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, cubeName, accNumbers, splitMap), parameter.getOrgUnitId().toString(), parameter.getBgOrgViewId().toString())) {
                    logger.info((Object)("end setBgDataState: not data or orgunit is not leaf accint!" + parameter.getOrgUnitId()));
                    return;
                }
                tmpNums.clear();
                tmpNums.addAll(bgPeriodNums);
                tmpPeriod = MbgDataMultiQuery.this.getTmpTable(conn, DimensionConstants.DEF_PERIOD_NUMBER, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                tmpTables.put(DimensionConstants.DEF_PERIOD_NUMBER, tmpPeriod);
                logger.debug((Object)"end insert data state period");
                tmpElement = MbgDataMultiQuery.this.getTmpTable(conn, DimensionConstants.DEF_ELEMENT_NUMBER, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                tmpTables.put(DimensionConstants.DEF_ELEMENT_NUMBER, tmpElement);
                tmpNums.clear();
                tmpNums.addAll(bgElementNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                logger.debug((Object)"end insert data state element");
                tmpCurrency = MbgDataMultiQuery.this.getTmpTable(conn, DimensionConstants.DEF_CURRENCY_NUMBER, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                tmpTables.put(DimensionConstants.DEF_CURRENCY_NUMBER, tmpCurrency);
                tmpNums.clear();
                tmpNums.addAll(currencyNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                logger.debug((Object)"end insert data state currency");
                tmpScenario = MbgDataMultiQuery.this.getTmpTable(conn, DimensionConstants.DEF_SCENARIO_NUMBER, "CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                tmpTables.put(DimensionConstants.DEF_SCENARIO_NUMBER, tmpScenario);
                tmpNums.clear();
                tmpNums.addAll(bgScenarioNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                logger.debug((Object)"end insert data state scenario");
                sql.append("select FOrgUnitId, FFormula, FVersion, FValue, FState from " + cubeName + " where FOrgUnitId IN(");
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                sql.append(" and F2 IN(");
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                if (isUseAccInt) {
                    sql.append(" and exists (select tmpP.FID from " + tmpPeriod + " tmpP, T_MBG_BgPeriod tPer where tmpP.FID = tPer.FID AND tPer.FIntID = " + cubeName + ".FBgPeriodID)  and exists (select tmpE.FID from " + tmpElement + " tmpE, T_MBG_BgElement tEle where tmpE.FID = tEle.FID AND tEle.FIntID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ?");
                } else {
                    sql.append(" and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and FVersion = ?");
                }
                List orgBatch = MbgSqlHelper.getBatchParams(null, (Object[])orgUnitIds.toArray(), (int)50);
                HashMap<String, List> splitF2Batch = new HashMap<String, List>();
                List f2Batch = MbgSqlHelper.getBatchParams(null, (Object[])((Set)dimMemMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)).toArray(), (int)50);
                if (!isUseAccInt) {
                    splitF2Batch.put(cubeName, f2Batch);
                } else {
                    Map<String, Set<Integer>> splitAcct = BgSchemeConvertToAccIntUtils.splitAcct((Set)dimMemMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), splitMap, parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_BGINDEX_FIELD));
                    for (String refCube : splitAcct.keySet()) {
                        splitF2Batch.put(refCube, MbgSqlHelper.replaceSharpToInt((List)MbgSqlHelper.getBatchParams(null, (Object[])splitAcct.get(refCube).toArray(), (int)50)));
                    }
                }
                for (String refCube : splitF2Batch.keySet()) {
                    pstmt = conn.prepareStatement(sql.toString().replace(cubeName, refCube));
                    f2Batch = (List)splitF2Batch.get(refCube);
                    for (int o = 0; o < orgBatch.size(); ++o) {
                        for (int f2 = 0; f2 < f2Batch.size(); ++f2) {
                            if (isUseAccInt) {
                                Object[] orgInts = new Object[((Object[])orgBatch.get(o)).length];
                                for (int oi = 0; oi < orgInts.length; ++oi) {
                                    String orgId = (String)((Object[])orgBatch.get(o))[oi];
                                    orgInts[oi] = parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_ORGUNIT_FIELD).get(orgId) != null ? parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_ORGUNIT_FIELD).get(orgId) : Integer.valueOf(Integer.MIN_VALUE);
                                }
                                MbgSqlHelper.setParams((PreparedStatement)pstmt, (int)1, (Object[])orgInts);
                            } else {
                                MbgSqlHelper.setParams((PreparedStatement)pstmt, (int)1, (Object[])((Object[])orgBatch.get(o)));
                            }
                            MbgSqlHelper.setParams((PreparedStatement)pstmt, (int)51, (Object[])((Object[])f2Batch.get(f2)));
                            pstmt.setInt(101, parameter.getDataManager().getDimDataQuery().getBizVersion().getVersionId());
                            rst = pstmt.executeQuery();
                            logger.debug((Object)"end excutequery data state");
                            while (rst.next()) {
                                formulaStr = rst.getString("FFormula");
                                versionId = rst.getInt("FVersion");
                                value = rst.getBigDecimal("FValue");
                                versionNum = verInnNumMap.get(String.valueOf(versionId));
                                orgUnitId = rst.getString("FOrgUnitId");
                                dimKey2 = DimUtils.getDimDataKey(formulaStr, versionNum);
                                data = _bgDataMap.get(orgUnitId) != null ? _bgDataMap.get(orgUnitId).get(dimKey2) : null;
                                if (data == null) continue;
                                ((BgNDataInfo)data).setOldValue(value);
                                data.setState(rst.getInt("FState"));
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                }
                logger.debug((Object)"end read data state");
                MbgDataMultiQuery.this.fillOldValue(_bgDataMap);
                MbgDataMultiQuery.this.releaseTmpTable(tmpTables);
            }
            catch (SQLException ex) {
                logger.error((Object)"query DataState Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                MbgDataMultiQuery.this.releaseTmpTable(tmpTables);
                SQLUtils.cleanup(rst, pstmt);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            logger.info((Object)("end setBgDataState:" + (System.currentTimeMillis() - ct) + "ms"));
        }
    }
}

