/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.AnalyseDataFacade;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.olap.algo.KDAlgoDataMultiQuery;
import com.kingdee.eas.ma.mbg.app.olap.algo.KDAlgoServiceImpl;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapServiceImpl;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgDataQuery;
import com.kingdee.eas.ma.mbg.cube.MbgDataMultiQuery;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.roll.olap.KDOlapRollService;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseIntegUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MbgDataQueryAgent
extends AbstractBOSObject
implements IMbgDataQuery {
    private static Logger logger = Logger.getLogger(MbgDataQueryAgent.class);
    private static final String KDOLAP_ENGINE = KDOlapServiceImpl.class.getName();
    private static final String KDALGO_ENGINE = KDAlgoServiceImpl.class.getName();
    public static final String MBGDATAQUERY_SERVER_LOCATION = "MbgDataQuery";

    public MbgDataQueryAgent() {
        this.registerInterface(IMbgDataQuery.class, this);
    }

    public MbgDataQueryAgent(Context ctx) {
        super(ctx);
        this.registerInterface(IMbgDataQuery.class, this);
    }

    @Override
    public Object dimensionQuery(IDimensionParameter queryParameter) throws BOSException, EASBizException {
        if (this.getContext() == null || queryParameter == null || !this.checkParameter(this.getContext(), queryParameter)) {
            return null;
        }
        boolean isUseAlgo = MBGFormFacadeFactory.getLocalInstance(this.getContext()).isUseAlgo();
        String engine = this.getEngine(isUseAlgo);
        logger.error((Object)("dimensionQuery engine:" + engine));
        long startTime = System.currentTimeMillis();
        logger.error((Object)"invoke begin Dimension Calculate!");
        MultiThreadQuery query = null;
        Map bgDataMap = null;
        try {
            BgCubeUtils.checkTable(this.getContext());
            Map bgActDataMap = null;
            if (queryParameter.isIgnoreActualState() && queryParameter.getDimension(DimensionConstants.DEF_SCENARIO_FIELD) != null) {
                IDimensionParameter actParameter = queryParameter.getClone(this.getContext());
                if (actParameter.getDataManager().getCustomState() != null && !actParameter.getDataManager().getCustomState().isEmpty()) {
                    actParameter.getDataManager().getCustomState().clear();
                }
                Set actScenarios = BgScenarioHelper.getAcScenarioNumbers((Context)this.getContext());
                boolean hasAct = false;
                IDimension scenario = actParameter.getDimension(DimensionConstants.DEF_SCENARIO_FIELD);
                IMember member = null;
                if (scenario != null) {
                    Iterator<IMember> itM = scenario.getDimensionMember().iterator();
                    while (itM.hasNext()) {
                        member = itM.next();
                        if (actScenarios.contains(member.getNumber())) {
                            hasAct = true;
                            continue;
                        }
                        itM.remove();
                    }
                    if (hasAct && queryParameter.getUnionId() == null) {
                        actParameter.setValueType(1);
                        bgActDataMap = this.getQueryIntance(this.getContext(), isUseAlgo).doQuery(actParameter.getQueryOrgIds(), actParameter, engine);
                    }
                }
            }
            query = this.getQueryIntance(this.getContext(), isUseAlgo);
            bgDataMap = query.doQuery(queryParameter.getQueryOrgIds(), queryParameter, engine);
            if (bgActDataMap != null && !bgActDataMap.isEmpty()) {
                MultiThreadQuery.mergeData(bgDataMap, bgActDataMap);
            }
        }
        catch (DimensionException ex) {
            logger.error((Object)"dimension olapQuery Error!", (Throwable)((Object)ex));
            if (ex.getCode().equals(DimensionException.PERIODTYPEERROR.getCode())) {
                throw ex;
            }
        }
        catch (StackOverflowError ex) {
            logger.error((Object)"dimension olapQuery Error!", (Throwable)ex);
            throw new DimensionException(DimensionException.BIZCALCITERDEPENDS);
        }
        catch (BOSException ex) {
            logger.error((Object)"dimension olapQuery Error!", (Throwable)ex);
            if (ex.getCause() instanceof StackOverflowError || ex.getCause() != null && ex.getCause().getCause() instanceof StackOverflowError) {
                throw new DimensionException(DimensionException.BIZCALCITERDEPENDS);
            }
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"dimension olapQuery Error!", (Throwable)ex);
            if (ex.getClass().getName().endsWith("CUBAException") || ex.getClass().getName().endsWith("OlapException")) {
                this.checkExceptionMessage(ex);
            }
            throw new BOSException((Throwable)ex);
        }
        finally {
            queryParameter.getTempTableManager(this.getContext()).releaseTables();
        }
        logger.error((Object)("invoke end Dimension Calculate! invoke interface process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
        startTime = System.currentTimeMillis();
        KDOlapRollService.newInstance(this.getContext(), queryParameter).removeRollDatas(bgDataMap);
        try {
            if (queryParameter.getBillId() != null && queryParameter.isQingAnalyse()) {
                AnalyseDataFacade webFacade = new AnalyseDataFacade(this.getContext(), queryParameter, bgDataMap);
                webFacade.start();
            }
            if (!(BgDBUtils.existTable((Context)this.getContext(), (String)"T_MBG_MbgQingAnalyseInteg") != BgDBUtils.YES || !queryParameter.isQingAnalyse() || queryParameter.getControlManager().isControlData() || queryParameter.getBillId() != null && "2DC6EFE2".equals(BOSUuid.getBOSObjectType((String)queryParameter.getBillId().toString(), (boolean)false).toString()))) {
                MbgQingAnalyseIntegUtils utils = new MbgQingAnalyseIntegUtils(this.getContext(), queryParameter, bgDataMap);
                utils.start();
            }
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        logger.error((Object)("invoke end AnalyseDataFacade cache! invoke interface process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
        return bgDataMap;
    }

    protected String getEngine(boolean isUseAlgo) {
        if (isUseAlgo) {
            return KDALGO_ENGINE;
        }
        return KDOLAP_ENGINE;
    }

    protected MultiThreadQuery getQueryIntance(Context ctx, boolean isUseAlgo) {
        if (isUseAlgo) {
            return new KDAlgoDataMultiQuery(ctx);
        }
        return new MbgDataMultiQuery(ctx);
    }

    protected void checkExceptionMessage(Exception ex) throws EASBizException {
        if (ex == null) {
            return;
        }
        String message = ex.getMessage();
        if (message.indexOf("can't find") >= 0 && message.indexOf("period") >= 0) {
            ArrayList<String> text = new ArrayList<String>();
            Pattern p = Pattern.compile("`[.\\w]+`");
            Matcher m = p.matcher(message);
            while (m.find()) {
                text.add(m.group());
            }
            Object[] objs = text.toArray();
            if (objs != null && objs.length > 1) {
                String member = (String)objs[objs.length - 1];
                if (member != null) {
                    member = member.substring(1, member.length() - 1);
                }
                logger.error((Object)"dimension olapQuery Error!", (Throwable)ex);
                throw new DimensionException(DimensionException.PERIODMEMBERNOFOUND, new Object[]{member});
            }
        }
        logger.error((Object)"dimension olapQuery Error!", (Throwable)ex);
        if (ex.getClass().getName().endsWith("TooManyMemberException")) {
            throw new DimensionException(DimensionException.MEMBEROOMUCHRECORDS, new String[]{ex.getMessage()});
        }
        throw new DimensionException(DimensionException.MEMBERNOTFIND, new String[]{ex.getMessage()});
    }

    private boolean checkParameter(Context ctx, IDimensionParameter parameter) {
        if (ctx == null || parameter == null) {
            return false;
        }
        ArrayList<IDimension> dims = new ArrayList<IDimension>();
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        Set<Integer> state = parameter.getDataManager().getCustomState();
        if (!state.isEmpty() && !DimensionCommonHelper.isDecompose(parameter.getValueType())) {
            if (state.contains(1) && state.contains(3) && state.contains(9)) {
                parameter.setValueType(1);
            }
            if (state.contains(9) && state.size() == 1) {
                parameter.setValueType(2);
            }
        }
        return true;
    }

    public BOSObjectType getType() {
        return null;
    }
}

