/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.cube.BizCalcOrgObject;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.roll.olap.KDOlapRollService;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MdxResultImpl;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public abstract class MultiThreadQuery {
    private static Logger logger = Logger.getLogger(MultiThreadQuery.class);
    private static final int availableProcessors = Runtime.getRuntime().availableProcessors() / 2;
    private static long maxCellSize = 1000000000L;
    private static int maxAxisSize = 3000;
    private Context ctx = null;

    public MultiThreadQuery(Context ctx) {
        this.setCtx(ctx);
    }

    public static void setMaxCellSize(long maxCellSize) {
        MultiThreadQuery.maxCellSize = maxCellSize;
    }

    public static long getMaxCellSize() {
        return maxCellSize;
    }

    public static void setMaxAxisSize(int maxAxisSize) {
        MultiThreadQuery.maxAxisSize = maxAxisSize;
    }

    public static int getMaxAxisSize() {
        return maxAxisSize;
    }

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public static void loadMdxSize(Context ctx) throws BOSException {
        IRowSet rst;
        Connection conn;
        block9: {
            conn = null;
            rst = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{"MAX_CELL_SIZE"});
                if (rst.next()) {
                    try {
                        long _maxCellSize = Long.parseLong(rst.getString("FVALUE"));
                        MultiThreadQuery.setMaxCellSize(_maxCellSize);
                        MdxResultImpl.setMaxCelLSize(_maxCellSize);
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)"poolSize param value trans error:", (Throwable)ex);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{"MAX_AXIS_SIZE"});
                if (!rst.next()) break block9;
                try {
                    int _maxAxisSize = Integer.parseInt(rst.getString("FVALUE"));
                    MultiThreadQuery.setMaxAxisSize(_maxAxisSize);
                    MdxResultImpl.setMaxAxisSize(_maxAxisSize);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"poolSize param value trans error:", (Throwable)ex);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Connection)conn);
    }

    public static int getPoolSize(Connection conn) throws EASBizException {
        IRowSet rst;
        int poolSize;
        block9: {
            poolSize = availableProcessors;
            if (conn == null) {
                return poolSize;
            }
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{"POOL_SIZE"});
                if (!rst.next()) break block9;
                try {
                    int _poolSize = Integer.parseInt(rst.getString("FVALUE"));
                    if (poolSize > _poolSize) {
                        poolSize = _poolSize;
                    }
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"poolSize param value trans error:", (Throwable)ex);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (poolSize == 0) {
            poolSize = 1;
        }
        return poolSize;
    }

    public Map doQuery(Collection<String> orgUnitIds, IDimensionParameter parameter, String engine) throws Exception {
        HashMap mbgDataMap = new HashMap();
        if (parameter == null || StringUtils.isEmpty((String)engine)) {
            return mbgDataMap;
        }
        MultiThreadQuery.loadMdxSize(this.getCtx());
        parameter.getControlManager().setMaxAxisSize(MultiThreadQuery.getMaxAxisSize());
        parameter.getControlManager().setMaxCellSize(MultiThreadQuery.getMaxCellSize());
        long begin = System.currentTimeMillis();
        logger.debug((Object)("begin multi data query." + parameter.getBillId()));
        Callable<Map> call = null;
        Future result = null;
        ArrayList<Future<Map>> results = new ArrayList<Future<Map>>();
        Comparator<IMember> memberComparator = new Comparator<IMember>(){

            @Override
            public int compare(IMember o1, IMember o2) {
                if (o1.getMdxNumber() != null && o2.getMdxNumber() != null) {
                    return o2.getMdxNumber().compareTo(o1.getMdxNumber());
                }
                return 0;
            }
        };
        for (IDimension dim : parameter.getDims()) {
            Collections.sort(dim.getDimensionMember(), memberComparator);
        }
        Connection conn = null;
        try {
            Map<String, OrgUnitInfo> map;
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            int poolSize = MultiThreadQuery.getPoolSize(conn);
            logger.debug((Object)String.valueOf(parameter));
            logger.debug((Object)("multi data query poolSize = " + poolSize));
            Map<String, OrgUnitInfo> orgUnitMap = this.getOrgUnitMap(conn, this.getCtx().getLocale(), orgUnitIds, parameter);
            this.optimizeParam(conn, parameter);
            KDOlapRollService kdOlapRollService = KDOlapRollService.newInstance(this.ctx, parameter);
            kdOlapRollService.handle();
            parameter.setFilterDimDataKeys(kdOlapRollService.acquireFilterDimDataKeys());
            HashMap<String, OrgUnitInfo> orgNumberMap = new HashMap<String, OrgUnitInfo>();
            OrgUnitCollection col = new OrgUnitCollection();
            for (OrgUnitInfo orgUnitInfo : orgUnitMap.values()) {
                orgNumberMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
                col.add(orgUnitInfo);
            }
            col.sort("longNumber");
            HashSet<String> orgNumberSet = new HashSet<String>();
            if (parameter.getOrgCalcMap() != null) {
                for (Set<BizCalcOrgObject> set : parameter.getOrgCalcMap().values()) {
                    for (BizCalcOrgObject number : set) {
                        if (orgNumberMap.containsKey(number.orgNumber)) continue;
                        orgNumberSet.add(number.orgNumber);
                    }
                }
            }
            for (String string : parameter.getOrgBooleanMember()) {
                orgNumberSet.add(string);
            }
            if (!orgNumberSet.isEmpty() && (map = MbgDataHelper.getOrgUnitByNumber(conn, this.ctx.getLocale(), orgNumberSet)) != null) {
                orgNumberMap.putAll(map);
            }
            orgNumberSet.clear();
            long l = 1000L;
            long MAX_DATA_SIZE = MultiThreadQuery.getMaxCellSize();
            long oneOrgDataSize = this.calOneOrgDataSize(parameter);
            long maxOrgCount = MAX_DATA_SIZE / oneOrgDataSize + 1L;
            if (maxOrgCount > 1000L) {
                maxOrgCount = 1000L;
            }
            String processType = DimensionCommonHelper.getProcessEnum(parameter.getValueType()).getName();
            ArrayList<ArrayList<OrgUnitInfo>> batchList = new ArrayList<ArrayList<OrgUnitInfo>>();
            ArrayList<ArrayList<OrgUnitInfo>> batchDecompList = new ArrayList<ArrayList<OrgUnitInfo>>();
            List<Object> subList = null;
            List<Object> subDecompList = null;
            ArrayList<OrgUnitInfo> oneSubList = null;
            ArrayList<OrgUnitInfo> oneSubDecompList = null;
            HashSet<BizCalcOrgObject> hasCalcs = new HashSet<BizCalcOrgObject>();
            for (int i = 0; i < col.size(); ++i) {
                if (orgNumberSet.contains(col.get(i).getNumber())) continue;
                if (subList == null) {
                    subList = new ArrayList<OrgUnitInfo>();
                    batchList.add((ArrayList<OrgUnitInfo>)subList);
                    subDecompList = new ArrayList<OrgUnitInfo>();
                    batchDecompList.add((ArrayList<OrgUnitInfo>)subDecompList);
                }
                if (col.get(i).isIsLeaf()) {
                    subList.add(col.get(i));
                    hasCalcs.clear();
                    this.addCalcOrg(processType, new BizCalcOrgObject(processType, col.get(i).getNumber()), subList, subDecompList, orgNumberSet, hasCalcs, parameter.getOrgCalcMap(), orgNumberMap);
                    if ((long)subList.size() < maxOrgCount) continue;
                    subList = null;
                    continue;
                }
                oneSubList = new ArrayList<OrgUnitInfo>();
                oneSubList.add(col.get(i));
                batchList.add(oneSubList);
                oneSubDecompList = new ArrayList<OrgUnitInfo>();
                batchDecompList.add(oneSubDecompList);
                hasCalcs.clear();
                this.addCalcOrg(processType, new BizCalcOrgObject(processType, col.get(i).getNumber()), oneSubList, oneSubDecompList, orgNumberSet, hasCalcs, parameter.getOrgCalcMap(), orgNumberMap);
            }
            int batchCount = MbgSqlHelper.getBatchCount((int)batchList.size(), (int)50);
            logger.debug((Object)String.valueOf(parameter));
            logger.debug((Object)("start ExecutorService total count:" + batchCount));
            int index = 0;
            for (int b = 0; b < batchCount; ++b) {
                int i;
                logger.debug((Object)String.valueOf(parameter));
                logger.debug((Object)"start ExecutorService newFixedThreadPool");
                ExecutorService service = Executors.newFixedThreadPool(poolSize);
                logger.debug((Object)String.valueOf(parameter));
                logger.debug((Object)"end ExecutorService newFixedThreadPool");
                for (i = 0; i < 50 && (index = i + b * 50) < batchList.size(); ++i) {
                    subList = (List)batchList.get(index);
                    subDecompList = (List)batchDecompList.get(index);
                    call = this.getQueryThread(this.getCtx(), conn, subList, subDecompList, this.getClone(this.getCtx(), parameter), engine);
                    if (call == null) continue;
                    results.add(service.submit(call));
                }
                logger.debug((Object)String.valueOf(parameter));
                logger.debug((Object)"start ExecutorService shutdown");
                service.shutdown();
                logger.debug((Object)String.valueOf(parameter));
                logger.debug((Object)"end ExecutorService shutdown");
                int in = results.size();
                for (i = 0; i < in; ++i) {
                    result = (Future)results.get(i);
                    MultiThreadQuery.mergeData(mbgDataMap, (Map)result.get());
                }
            }
            logger.debug((Object)String.valueOf(parameter));
            logger.debug((Object)"end ExecutorService all");
        }
        catch (SQLDataException ex) {
            logger.error((Object)"query error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        catch (InterruptedException ex) {
            logger.error((Object)"query error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            logger.error((Object)"query error:", (Throwable)ex);
            if (ex.getCause() instanceof BOSException) {
                throw (BOSException)ex.getCause();
            }
            if (ex.getCause() instanceof EASBizException) {
                throw (EASBizException)ex.getCause();
            }
            if (this.checkCUBAException(ex)) {
                throw (Exception)ex.getCause();
            }
            if (ex.getCause().getMessage() != null && ex.getCause().getMessage().indexOf("can't find") >= 0 && ex.getCause().getMessage().indexOf("in cube BudgetCube") >= 0) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{ex.getCause().getMessage()});
            }
            throw new BOSException((Throwable)ex);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("end multi data query. use = " + (System.currentTimeMillis() - begin) + " ms."));
        return mbgDataMap;
    }

    private void addCalcOrg(String currprocessType, BizCalcOrgObject orgInfo, List<OrgUnitInfo> subList, List<OrgUnitInfo> subDecompList, Set<String> orgNumberSet, Set<BizCalcOrgObject> hasCalcs, Map<BizCalcOrgObject, Set<BizCalcOrgObject>> orgCalcMap, Map<String, OrgUnitInfo> orgNumberMap) {
        if (orgCalcMap == null) {
            return;
        }
        Set<BizCalcOrgObject> subSet = orgCalcMap.get(new BizCalcOrgObject(null, null));
        this.addCalcOrgSub(currprocessType, orgInfo, subList, subDecompList, orgNumberSet, hasCalcs, orgCalcMap, orgNumberMap, subSet);
        subSet = orgCalcMap.get(new BizCalcOrgObject(null, orgInfo.orgNumber));
        this.addCalcOrgSub(currprocessType, orgInfo, subList, subDecompList, orgNumberSet, hasCalcs, orgCalcMap, orgNumberMap, subSet);
        subSet = orgCalcMap.get(orgInfo);
        this.addCalcOrgSub(currprocessType, orgInfo, subList, subDecompList, orgNumberSet, hasCalcs, orgCalcMap, orgNumberMap, subSet);
    }

    protected void addCalcOrgSub(String currprocessType, BizCalcOrgObject orgInfo, List<OrgUnitInfo> subList, List<OrgUnitInfo> subDecompList, Set<String> orgNumberSet, Set<BizCalcOrgObject> hasCalcs, Map<BizCalcOrgObject, Set<BizCalcOrgObject>> orgCalcMap, Map<String, OrgUnitInfo> orgNumberMap, Set<BizCalcOrgObject> subSet) {
        if (subSet != null) {
            for (BizCalcOrgObject obj : subSet) {
                OrgUnitInfo orgUnit;
                if (hasCalcs.contains(obj)) continue;
                hasCalcs.add(obj);
                if (obj.orgNumber == null) {
                    if (currprocessType.equals(BgProcessEnum.C01.getName()) && obj.processType != null && !obj.processType.equals(BgProcessEnum.C01.getName()) && !subDecompList.contains(orgUnit = orgNumberMap.get(orgInfo.orgNumber))) {
                        subDecompList.add(orgUnit);
                    }
                    this.addCalcOrg(currprocessType, new BizCalcOrgObject(obj.processType, orgInfo.orgNumber), subList, subDecompList, orgNumberSet, hasCalcs, orgCalcMap, orgNumberMap);
                    continue;
                }
                if (!orgNumberMap.containsKey(obj.orgNumber)) continue;
                orgUnit = orgNumberMap.get(obj.orgNumber);
                if (currprocessType.equals(BgProcessEnum.C01.getName()) && obj.processType != null && !obj.processType.equals(BgProcessEnum.C01.getName())) {
                    if (!subDecompList.contains(orgUnit)) {
                        subDecompList.add(orgUnit);
                    }
                } else {
                    orgNumberSet.add(obj.orgNumber);
                    if (!subList.contains(orgUnit)) {
                        subList.add(orgUnit);
                    }
                }
                this.addCalcOrg(currprocessType, obj, subList, subDecompList, orgNumberSet, hasCalcs, orgCalcMap, orgNumberMap);
            }
        }
    }

    protected abstract boolean checkCUBAException(Exception var1);

    private long calOneOrgDataSize(IDimensionParameter parameter) {
        long dataSize = 1L;
        for (IDimension dim : parameter.getDims()) {
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber()) || dim.getDimensionMember() == null || dim.getDimensionMember().isEmpty()) continue;
            dataSize *= (long)dim.getDimensionMember().size();
        }
        if (dataSize > Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return (int)dataSize;
    }

    protected Map<String, OrgUnitInfo> getOrgUnitMap(Connection conn, Locale locale, Collection<String> orgUnitIds, IDimensionParameter parameter) throws Exception {
        String ccOrgUnitId;
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (orgUnitIds == null) {
            orgUnitIds = new HashSet<String>();
        }
        if (orgUnitIds.isEmpty() && parameter.getOrgUnitId() != null) {
            orgUnitIds.add(parameter.getOrgUnitId().toString());
        }
        if (conn == null || locale == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return orgUnitMap;
        }
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            List<OrgUnitInfo> orgUnits = null;
            if (parameter.getBgOrgViewId() != null && parameter.getUnionId() == null) {
                List<BgOrgUnitInfo> list = MbgDataHelper.getBgOrgUnits(this.ctx, parameter.getBgOrgViewId(), new ArrayList<String>(orgUnitIds));
                orgUnits = new ArrayList<OrgUnitInfo>();
                if (list != null) {
                    for (BgOrgUnitInfo o : list) {
                        orgUnits.add((OrgUnitInfo)o.castToFullOrgUnitInfo());
                    }
                }
            } else {
                orgUnits = MbgDataHelper.getOrgUnits(this.getCtx(), conn, orgUnitIds);
            }
            if (orgUnits != null) {
                for (OrgUnitInfo orgUnit : orgUnits) {
                    orgUnitMap.put(orgUnit.getId().toString(), orgUnit);
                }
            }
        }
        if (parameter.getDataManager().getOrgUnit() != null && !orgUnitMap.containsKey(ccOrgUnitId = parameter.getOrgUnitId().toString())) {
            orgUnitMap.put(ccOrgUnitId, parameter.getDataManager().getOrgUnit());
        }
        return orgUnitMap;
    }

    protected abstract void optimizeParam(Connection var1, IDimensionParameter var2) throws Exception;

    protected IDimensionParameter getClone(Context ctx, IDimensionParameter parameter) throws Exception {
        if (ctx == null || parameter == null) {
            return null;
        }
        IDimensionParameter clone = parameter.getClone(ctx);
        if (clone.getDimensionMap().isEmpty() && !parameter.getDimensionMap().isEmpty()) {
            clone.getDimensionMap().putAll(parameter.getDimensionMap());
        }
        return clone;
    }

    protected abstract Callable<Map> getQueryThread(Context var1, Connection var2, List<OrgUnitInfo> var3, List<OrgUnitInfo> var4, IDimensionParameter var5, String var6) throws BOSException, EASBizException;

    public static void mergeData(Map mbgDataMap, Map queryDataMap) {
        if (mbgDataMap == null || queryDataMap == null) {
            return;
        }
        Object obj = null;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : queryDataMap.entrySet()) {
            obj = mbgDataMap.get(entry2.getKey());
            if (obj == null) {
                mbgDataMap.put(entry2.getKey(), entry2.getValue());
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map tmpMap = obj;
            if (!(entry2.getValue() instanceof Map)) continue;
            tmpMap.putAll((Map)entry2.getValue());
        }
    }
}

