/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.dimension;

import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IMemberBase;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Dimension
implements IDimension,
Serializable {
    private static final long serialVersionUID = -2273548192250022682L;
    private String number = null;
    private String srcNumber = null;
    private String field = null;
    private List<IMember> members = new ArrayList<IMember>();
    private Set<String> numberSet = new HashSet<String>();
    private int memberType = DimensionConstants.MEMBER_TYPE_ALL;

    @Override
    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public void setSrcNumber(String srcNumber) {
        this.srcNumber = srcNumber;
    }

    @Override
    public String getSrcNumber() {
        return this.srcNumber;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public List<IMember> getMembers() {
        return this.members;
    }

    @Override
    public List<? extends IMemberBase> getDimensionMember() {
        return this.members;
    }

    private void initCheck() {
        this.numberSet.clear();
        int in = this.getMembers().size();
        for (int i = 0; i < in; ++i) {
            this.numberSet.add(this.getMembers().get(i).getNumber());
        }
    }

    @Override
    public void addMember(IMember member) {
        if (member == null) {
            return;
        }
        this.initCheck();
        if (!this.numberSet.contains(member.getNumber())) {
            this.getMembers().add(member);
        }
    }

    @Override
    public void addAllMember(List<IMember> members) {
        if (members == null || members.isEmpty()) {
            return;
        }
        this.initCheck();
        for (IMember member : members) {
            if (this.numberSet.contains(member.getNumber())) continue;
            this.numberSet.add(member.getNumber());
            this.getMembers().add(member);
        }
    }

    @Override
    public IDimension clone() {
        Dimension _clone = new Dimension();
        _clone.setNumber(this.getNumber());
        _clone.setSrcNumber(this.getSrcNumber());
        _clone.setField(this.getField());
        for (IMember member : this.getMembers()) {
            _clone.getMembers().add(member.clone());
        }
        return _clone;
    }

    @Override
    public com.kingdee.eas.ma.mbg.dimension.face.IDimension toMbgDim() {
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(this.getNumber());
        dimension.setField(this.getField());
        dimension.setSrcNumber(this.getSrcNumber());
        dimension.setMemberType(this.getMemberType());
        if (!this.getMembers().isEmpty()) {
            IMember member = null;
            int in = this.getMembers().size();
            for (int i = 0; i < in; ++i) {
                member = this.getMembers().get(i);
                dimension.getDimensionMember().add(member.toMember());
            }
        }
        return dimension;
    }

    public static IDimension parse(BgDimensionInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return null;
        }
        Dimension dimension = new Dimension();
        dimension.setNumber(dimensionInfo.getNumber());
        dimension.setField(DimUtils.getDimensionField(dimensionInfo));
        boolean baseDim = DimUtils.checkBaseDimensionByField(dimension.getField());
        List memList = dimensionInfo.getMember();
        if (memList != null && !memList.isEmpty()) {
            BgDimensionMember dimensionMember = null;
            Member member = null;
            int jn = memList.size();
            for (int j = 0; j < jn; ++j) {
                dimensionMember = (BgDimensionMember)memList.get(j);
                member = new Member();
                member.setName(dimensionMember.getName());
                member.setNumber(dimensionMember.getNumber());
                if (!baseDim) {
                    member.setSrcNumber(dimensionMember.getSrcNumber());
                }
                dimension.addMember(member);
                if (dimension.getSrcNumber() != null) continue;
                dimension.setSrcNumber(dimensionMember.getSrcNumber());
            }
        }
        return dimension;
    }

    public static IDimension parse(MbgViewListDimensionInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return null;
        }
        Dimension dimension = new Dimension();
        dimension.setNumber(dimensionInfo.getNumber());
        dimension.setField(DimUtils.getDimensionField(dimensionInfo));
        boolean baseDim = DimUtils.checkBaseDimensionByField(dimension.getField());
        List memList = dimensionInfo.getMember();
        if (memList != null && !memList.isEmpty()) {
            BgDimensionMember dimensionMember = null;
            Member member = null;
            int jn = memList.size();
            for (int j = 0; j < jn; ++j) {
                dimensionMember = (BgDimensionMember)memList.get(j);
                member = new Member();
                member.setName(dimensionMember.getName());
                member.setNumber(dimensionMember.getNumber());
                if (!baseDim) {
                    member.setSrcNumber(dimensionMember.getSrcNumber());
                }
                dimension.addMember(member);
                if (dimension.getSrcNumber() != null) continue;
                dimension.setSrcNumber(dimensionMember.getSrcNumber());
            }
        }
        return dimension;
    }

    @Override
    public void setMemberType(int memberType) {
        this.memberType = memberType;
    }

    @Override
    public int getMemberType() {
        return this.memberType;
    }
}

