/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.impl;

import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.face.ICubeSqlStrategy;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class CubeSqlStrategy
implements ICubeSqlStrategy {
    public static final String BASE_NAME = "T_MBG_BGDATA";
    private boolean isInt = false;
    private static final int MAX_INDEX_SIZE = 8;

    @Override
    public String getCubeName(Connection conn) {
        if (conn == null) {
            return null;
        }
        String tableName = BASE_NAME;
        String randomStr = null;
        String code = "";
        for (int i = 0; i < CubeConstants.CODE_LENGTH; ++i) {
            code = code + "0";
        }
        SecureRandom random = new SecureRandom();
        DecimalFormat df = new DecimalFormat(code);
        boolean isExist = true;
        while (isExist) {
            randomStr = df.format(random.nextInt(99999999));
            tableName = BASE_NAME + randomStr;
            isExist = BgDBUtils.existTable((Connection)conn, (String)tableName) == BgDBUtils.YES;
        }
        return tableName.toUpperCase();
    }

    @Override
    public String[] getCubeSql(Connection conn, Map<String, Object> sqlMap, List<String> refDims) {
        if (sqlMap == null || refDims == null) {
            return null;
        }
        String cubeName = (String)sqlMap.get(CubeConstants.CUBE_NAME);
        Integer valueType = (Integer)sqlMap.get(CubeConstants.CUBE_TYPE);
        if (StringUtils.isEmpty((String)cubeName)) {
            return null;
        }
        if (valueType != null && valueType == Integer.MAX_VALUE) {
            return this.getActual1Sql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 1) {
            return this.getBudgetSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 4) {
            return this.getActualSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 16) {
            return this.getDailyActualSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 64) {
            return this.getCFSSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 256) {
            return this.getDecomposeSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 512) {
            return this.getDecomposeSendDownSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 1024) {
            return this.getDecomposeGatherSql(conn, cubeName, refDims);
        }
        return this.getControlSql(conn, cubeName);
    }

    @Override
    public String[] getCubeIndex(Connection conn, Map<String, Object> sqlMap, List<String> refDims) {
        if (sqlMap == null || refDims == null) {
            return null;
        }
        String cubeName = (String)sqlMap.get(CubeConstants.CUBE_NAME);
        Integer valueType = (Integer)sqlMap.get(CubeConstants.CUBE_TYPE);
        if (StringUtils.isEmpty((String)cubeName)) {
            return null;
        }
        if (valueType != null && valueType == Integer.MAX_VALUE) {
            return this.getActualIndex1Sql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 1) {
            return this.getBudgetIndexSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 4) {
            return this.getActualIndexSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 16) {
            return this.getDailyActualIndexSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 64) {
            return this.getCFSIndexSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 256) {
            return this.getDecomposeIndexSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 512) {
            return this.getDecomposeSendDownIndexSql(conn, cubeName, refDims);
        }
        if (valueType != null && valueType == 1024) {
            return this.getDecomposeGatherIndexSql(conn, cubeName, refDims);
        }
        return this.getControlIndexSql(conn, cubeName);
    }

    @Override
    public String getModifyCubeSql(String tableName, String column) {
        if (tableName == null || column == null) {
            return null;
        }
        String sql = "ALTER TABLE {0} ADD {1} NVARCHAR(84)";
        return MessageFormat.format(sql, tableName, column);
    }

    @Override
    public String getDropColumnCubeSql(String cubeName, String columnName) {
        if (cubeName == null || columnName == null) {
            return null;
        }
        String sql = "ALTER TABLE {0} DROP COLUMN {1}";
        return MessageFormat.format(sql, cubeName, columnName);
    }

    @Override
    public String getDropCubeSql(String tableName) {
        if (tableName == null) {
            return null;
        }
        return "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tableName + "') DROP TABLE " + tableName;
    }

    private String[] getDecomposeSql(Connection conn, String tableName, List<String> refDims) {
        String entryName;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[2];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        String decName = BgCubeUtils.getDecomposeCubeName(tableName);
        if (BgDBUtils.existTable((Connection)conn, (String)decName) == BgDBUtils.NO) {
            String pk = "PK_MBG_DCC" + codeNumber;
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + decName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44), FDetail INT DEFAULT 0 NOT NULL,FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getDecomposeEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            String pkName = "PK_MBG_DCE" + codeNumber;
            tmpStrs[1] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        return tmpStrs;
    }

    private String[] getDecomposeSendDownSql(Connection conn, String tableName, List<String> refDims) {
        String entryName;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[2];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        String decName = BgCubeUtils.getDecomposeSendDownCubeName(tableName);
        if (BgDBUtils.existTable((Connection)conn, (String)decName) == BgDBUtils.NO) {
            String pk = "PK_MBG_SDC" + codeNumber;
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + decName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44), FDetail INT DEFAULT 0 NOT NULL,FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getDecomposeSendDownEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            String pkName = "PK_MBG_SDE" + codeNumber;
            tmpStrs[1] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        return tmpStrs;
    }

    private String[] getDecomposeGatherSql(Connection conn, String tableName, List<String> refDims) {
        String entryName;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[2];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        String decName = BgCubeUtils.getDecomposeGatherCubeName(tableName);
        if (BgDBUtils.existTable((Connection)conn, (String)decName) == BgDBUtils.NO) {
            String pk = "PK_MBG_GTC" + codeNumber;
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + decName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44), FDetail INT DEFAULT 0 NOT NULL,FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getDecomposeGatherEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            String pkName = "PK_MBG_GTE" + codeNumber;
            tmpStrs[1] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        return tmpStrs;
    }

    public void setInt(boolean isInt) {
        this.isInt = isInt;
    }

    private String[] getBudgetSql(Connection conn, String tableName, List<String> refDims) {
        String entryName;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[2];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        if (BgDBUtils.existTable((Connection)conn, (String)tableName) == BgDBUtils.NO) {
            String pk = "PK_MBG_BC" + codeNumber;
            if (this.isInt) {
                pk = "PK_MBG_BC" + tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH - 1, tableName.length() - CubeConstants.CODE_LENGTH) + codeNumber;
            }
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + tableName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID " + (this.isInt ? "INT" : "VARCHAR(44) DEFAULT ''") + " NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                if (this.isInt) {
                    str.append(tmpStr + " INT NOT NULL, ");
                    continue;
                }
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID " + (this.isInt ? "INT" : "VARCHAR(44) DEFAULT ''") + " NOT NULL, FBgElementID " + (this.isInt ? "INT" : "VARCHAR(44) DEFAULT ''") + " NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44), FDetail INT DEFAULT 0 NOT NULL, FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44), FIntegrationId Varchar(44)");
            if (!tableName.endsWith("Tmp")) {
                str.append(", CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            } else {
                str.append(")");
            }
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getBudgetEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            String pkName = "PK_MBG_BE" + codeNumber;
            tmpStrs[1] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        return tmpStrs;
    }

    private String[] getActualSql(Connection conn, String tableName, List<String> refDims) {
        return null;
    }

    private String[] getActual1Sql(Connection conn, String tableName, List<String> refDims) {
        String entryName;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[2];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        String actualName = tableName.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL);
        if (BgDBUtils.existTable((Connection)conn, (String)actualName) == BgDBUtils.NO) {
            String pk = "PK_MBG_AC" + codeNumber;
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + actualName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0, ");
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getActualEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            String pkName = "PK_MBG_AE" + codeNumber;
            tmpStrs[1] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        return tmpStrs;
    }

    private String[] getDailyActualSql(Connection conn, String tableName, List<String> refDims) {
        String dailyActualEntry;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[2];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        String dailyActual = BgCubeUtils.getDailyActualCubeName(tableName);
        if (BgDBUtils.existTable((Connection)conn, (String)dailyActual) == BgDBUtils.NO) {
            String pk = "PK_MBG_DAC" + codeNumber;
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + dailyActual + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0, ");
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FAudUserID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(dailyActualEntry = BgCubeUtils.getDailyActualEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            String pkName = "PK_MBG_DAE" + codeNumber;
            tmpStrs[1] = entrySql = "Create Table " + dailyActualEntry + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        return tmpStrs;
    }

    private String[] getControlSql(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String[] tmpStrs = new String[1];
        String lastStr = tableName.substring(12, tableName.length());
        String controlName = BgCubeUtils.getControlCubeName(tableName);
        if (BgDBUtils.existTable((Connection)conn, (String)controlName) == BgDBUtils.NO) {
            String pk = "PK_MBG_CR" + lastStr;
            StringBuffer str = new StringBuffer();
            str.append("Create Table " + controlName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FBillID VARCHAR(44) DEFAULT '' NOT NULL, FBillNumber NVARCHAR(80) DEFAULT '' NOT NULL, FBillType VARCHAR(10) DEFAULT '' NOT NULL, FActaulAmount NUMERIC(21,8) DEFAULT 0 NOT NULL, FBizDate DateTime NOT NULL, FActualID VARCHAR(44) DEFAULT '' NOT NULL, FBizOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FReqOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FControlType INT DEFAULT 0 NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FBgIndexNum NVARCHAR(80) DEFAULT '' NOT NULL, FItemExtNumber NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FBgSettingID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        return tmpStrs;
    }

    private String[] getCFSSql(Connection conn, String tableName, List<String> refDims) {
        String pkName;
        String entryName;
        int i;
        int in;
        StringBuffer str;
        String pk;
        if (conn == null || StringUtils.isEmpty((String)tableName) || refDims == null) {
            return null;
        }
        String tmpStr = null;
        String[] tmpStrs = new String[4];
        String codeNumber = tableName.substring(tableName.length() - CubeConstants.CODE_LENGTH, tableName.length());
        String cfsName = BgCubeUtils.getCFSCubeName(tableName);
        if (BgDBUtils.existTable((Connection)conn, (String)cfsName) == BgDBUtils.NO) {
            pk = "PK_MBG_CF" + codeNumber;
            str = new StringBuffer();
            str.append("Create Table " + cfsName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FUnionID VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            in = refDims.size();
            for (i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44), FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[0] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(cfsName = BgCubeUtils.getCFSAdjustCubeName(tableName))) == BgDBUtils.NO) {
            pk = "PK_MBG_CA" + codeNumber;
            str = new StringBuffer();
            str.append("Create Table " + cfsName + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FUnionID VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(" + 300 + ") DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            in = refDims.size();
            for (i = 0; i < in; ++i) {
                tmpStr = refDims.get(i);
                str.append(tmpStr + " NVARCHAR(84), ");
            }
            str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44),FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44), CONSTRAINT " + pk + " PRIMARY KEY (FID))");
            tmpStrs[1] = str.toString();
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getCFSEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            pkName = "PK_MBG_CE" + codeNumber;
            tmpStrs[2] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        if (BgDBUtils.existTable((Connection)conn, (String)(entryName = BgCubeUtils.getCFSAdjustEntryCubeName(tableName))) == BgDBUtils.NO) {
            String entrySql;
            pkName = "PK_MBG_CJ" + codeNumber;
            tmpStrs[3] = entrySql = "Create Table " + entryName + " (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FFormID, FDataID))";
        }
        try {
            BgCubeUtils.checkReportOrgUnitField(conn, tableName, null);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tmpStrs;
    }

    private String[] getCFSIndexSql(Connection conn, String cubeName, List<String> refDims) {
        String index5;
        String index3;
        String index2;
        String index1;
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return null;
        }
        String[] tmpStrs = new String[5];
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        String cfsName = BgCubeUtils.getCFSCubeName(cubeName);
        String entryName = BgCubeUtils.getCFSEntryCubeName(cubeName);
        String field = null;
        String ixQuery = "IX_MBG_CQ" + codeNumber;
        if (BgDBUtils.existIndex((Connection)conn, (String)cfsName, (String)ixQuery) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + ixQuery + " ON " + cfsName + " (FUnionID, FOrgUnitID, ";
            if (refDims.size() > 6) {
                for (int i = 0; i < 6; ++i) {
                    field = refDims.get(i);
                    if (DimensionConstants.DEF_CSL_FIELD.equals(field)) continue;
                    tmpStrs[0] = tmpStrs[0] + field + ", ";
                }
            } else {
                for (String _field : refDims) {
                    if (DimensionConstants.DEF_CSL_FIELD.equals(_field)) continue;
                    tmpStrs[0] = tmpStrs[0] + _field + ", ";
                }
            }
            tmpStrs[0] = tmpStrs[0] + DimensionConstants.DEF_CSL_FIELD + ", FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cfsName, (String)(index1 = "IX_MBG_CO" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE UNIQUE INDEX " + index1 + " ON " + cfsName + " (FUnionID ASC, FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cfsName, (String)(index2 = "IX_MBG_CI" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index2 + " ON " + cfsName + " (FBgItemCombination ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cfsName, (String)(index3 = "IX_MBG_CR" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index3 + " ON " + cfsName + " (FReportOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)entryName, (String)(index5 = "IX_MBG_CD" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[4] = "CREATE INDEX " + index5 + " ON " + entryName + " (FDataID)";
        }
        return tmpStrs;
    }

    private String[] getBudgetIndexSql(Connection conn, String cubeName, List<String> refDims) {
        String index6;
        String index5;
        String index4;
        String index3;
        String index2;
        String index1;
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return null;
        }
        String[] tmpStrs = new String[7];
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        String entryName = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        String ixQuery = "IX_MBG_BQ" + codeNumber;
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)ixQuery) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + ixQuery + " ON " + cubeName + " (FOrgUnitID, ";
            if (refDims.size() > 8) {
                for (int i = 0; i < 8; ++i) {
                    tmpStrs[0] = tmpStrs[0] + refDims.get(i) + ", ";
                }
            } else {
                for (String field : refDims) {
                    tmpStrs[0] = tmpStrs[0] + field + ", ";
                }
            }
            tmpStrs[0] = tmpStrs[0] + "FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index1 = "IX_MBG_BO" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE UNIQUE INDEX " + index1 + " ON " + cubeName + " (FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index2 = "IX_MBG_BI" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index2 + " ON " + cubeName + " (FBgItemCombination ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index3 = "IX_MBG_BA" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index3 + " ON " + cubeName + " (FAudOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index4 = "IX_MBG_BR" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[4] = "CREATE INDEX " + index4 + " ON " + cubeName + " (FReportOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)entryName, (String)(index5 = "IX_MBG_BD" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[5] = "CREATE INDEX " + index5 + " ON " + entryName + " (FDataID)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index6 = "IX_MBG_BgDataOS" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[6] = "CREATE INDEX " + index6 + " ON " + cubeName + " (FORGUNITID,FSCENARIO ASC)";
        }
        return tmpStrs;
    }

    private String[] getDecomposeIndexSql(Connection conn, String cubeName, List<String> refDims) {
        String index5;
        String index4;
        String index3;
        String index2;
        String index1;
        String ixQuery;
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return null;
        }
        String[] tmpStrs = new String[6];
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        String entryName = BgCubeUtils.getDecomposeEntryCubeName(cubeName);
        if (BgDBUtils.existIndex((Connection)conn, (String)(cubeName = BgCubeUtils.getDecomposeCubeName(cubeName)), (String)(ixQuery = "IX_MBG_DCQ" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + ixQuery + " ON " + cubeName + " (FOrgUnitID, ";
            if (refDims.size() > 8) {
                for (int i = 0; i < 8; ++i) {
                    tmpStrs[0] = tmpStrs[0] + refDims.get(i) + ", ";
                }
            } else {
                for (String field : refDims) {
                    tmpStrs[0] = tmpStrs[0] + field + ", ";
                }
            }
            tmpStrs[0] = tmpStrs[0] + "FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index1 = "IX_MBG_DCO" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE UNIQUE INDEX " + index1 + " ON " + cubeName + " (FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index2 = "IX_MBG_DCI" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index2 + " ON " + cubeName + " (FBgItemCombination ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index3 = "IX_MBG_DCA" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index3 + " ON " + cubeName + " (FAudOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index4 = "IX_MBG_DCR" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[4] = "CREATE INDEX " + index4 + " ON " + cubeName + " (FReportOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)entryName, (String)(index5 = "IX_MBG_DCD" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[5] = "CREATE INDEX " + index5 + " ON " + entryName + " (FDataID)";
        }
        return tmpStrs;
    }

    private String[] getDecomposeSendDownIndexSql(Connection conn, String cubeName, List<String> refDims) {
        String index5;
        String index4;
        String index3;
        String index2;
        String index1;
        String ixQuery;
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return null;
        }
        String[] tmpStrs = new String[6];
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        String entryName = BgCubeUtils.getDecomposeSendDownEntryCubeName(cubeName);
        if (BgDBUtils.existIndex((Connection)conn, (String)(cubeName = BgCubeUtils.getDecomposeSendDownCubeName(cubeName)), (String)(ixQuery = "IX_MBG_SDQ" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + ixQuery + " ON " + cubeName + " (FOrgUnitID, ";
            if (refDims.size() > 8) {
                for (int i = 0; i < 8; ++i) {
                    tmpStrs[0] = tmpStrs[0] + refDims.get(i) + ", ";
                }
            } else {
                for (String field : refDims) {
                    tmpStrs[0] = tmpStrs[0] + field + ", ";
                }
            }
            tmpStrs[0] = tmpStrs[0] + "FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index1 = "IX_MBG_SDO" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE UNIQUE INDEX " + index1 + " ON " + cubeName + " (FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index2 = "IX_MBG_SDI" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index2 + " ON " + cubeName + " (FBgItemCombination ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index3 = "IX_MBG_SDA" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index3 + " ON " + cubeName + " (FAudOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index4 = "IX_MBG_SDR" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[4] = "CREATE INDEX " + index4 + " ON " + cubeName + " (FReportOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)entryName, (String)(index5 = "IX_MBG_SDD" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[5] = "CREATE INDEX " + index5 + " ON " + entryName + " (FDataID)";
        }
        return tmpStrs;
    }

    private String[] getDecomposeGatherIndexSql(Connection conn, String cubeName, List<String> refDims) {
        String index5;
        String index4;
        String index3;
        String index2;
        String index1;
        String ixQuery;
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return null;
        }
        String[] tmpStrs = new String[6];
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        String entryName = BgCubeUtils.getDecomposeGatherEntryCubeName(cubeName);
        if (BgDBUtils.existIndex((Connection)conn, (String)(cubeName = BgCubeUtils.getDecomposeGatherCubeName(cubeName)), (String)(ixQuery = "IX_MBG_GTQ" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + ixQuery + " ON " + cubeName + " (FOrgUnitID, ";
            if (refDims.size() > 8) {
                for (int i = 0; i < 8; ++i) {
                    tmpStrs[0] = tmpStrs[0] + refDims.get(i) + ", ";
                }
            } else {
                for (String field : refDims) {
                    tmpStrs[0] = tmpStrs[0] + field + ", ";
                }
            }
            tmpStrs[0] = tmpStrs[0] + "FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index1 = "IX_MBG_GTO" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE UNIQUE INDEX " + index1 + " ON " + cubeName + " (FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index2 = "IX_MBG_GTI" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index2 + " ON " + cubeName + " (FBgItemCombination ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index3 = "IX_MBG_GTA" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index3 + " ON " + cubeName + " (FAudOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)cubeName, (String)(index4 = "IX_MBG_GTR" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[4] = "CREATE INDEX " + index4 + " ON " + cubeName + " (FReportOrgUnitID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)entryName, (String)(index5 = "IX_MBG_GTD" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[5] = "CREATE INDEX " + index5 + " ON " + entryName + " (FDataID)";
        }
        return tmpStrs;
    }

    private String[] getActualIndexSql(Connection conn, String cubeName, List<String> refDims) {
        return null;
    }

    private String[] getActualIndex1Sql(Connection conn, String cubeName, List<String> refDims) {
        return null;
    }

    private String[] getDailyActualIndexSql(Connection conn, String cubeName, List<String> refDims) {
        String index4;
        String index3;
        String index1;
        if (conn == null || StringUtils.isEmpty((String)cubeName) || refDims == null) {
            return null;
        }
        String[] tmpStrs = new String[4];
        String codeNumber = cubeName.substring(cubeName.length() - CubeConstants.CODE_LENGTH, cubeName.length());
        String dailyActual = BgCubeUtils.getDailyActualCubeName(cubeName);
        String entryName = BgCubeUtils.getDailyActualEntryCubeName(cubeName);
        String ixQuery = "IX_MBG_DAQ" + codeNumber;
        if (BgDBUtils.existIndex((Connection)conn, (String)dailyActual, (String)ixQuery) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + ixQuery + " ON " + dailyActual + " (FOrgUnitID, ";
            if (refDims.size() > 8) {
                for (int i = 0; i < 8; ++i) {
                    tmpStrs[0] = tmpStrs[0] + refDims.get(i) + ", ";
                }
            } else {
                for (String field : refDims) {
                    tmpStrs[0] = tmpStrs[0] + field + ", ";
                }
            }
            tmpStrs[0] = tmpStrs[0] + "FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, FState, FValue)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)dailyActual, (String)(index1 = "IX_MBG_DAO" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE UNIQUE INDEX " + index1 + " ON " + dailyActual + " (FOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)dailyActual, (String)(index3 = "IX_MBG_DAI" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index3 + " ON " + dailyActual + " (FBgItemCombination ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)entryName, (String)(index4 = "IX_MBG_DAD" + codeNumber)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index4 + " ON " + entryName + " (FDataID)";
        }
        return tmpStrs;
    }

    public String[] getControlIndexSql(Connection conn, String cubeName) {
        String index5;
        String index4;
        String index3;
        String index2;
        String index1;
        if (conn == null || StringUtils.isEmpty((String)cubeName)) {
            return null;
        }
        String[] tmpStrs = new String[5];
        String lastStr = cubeName.substring(12, cubeName.length());
        String controlName = BgCubeUtils.getControlCubeName(cubeName);
        if (BgDBUtils.existIndex((Connection)conn, (String)controlName, (String)(index1 = "IX_MBG_CRB" + lastStr)) == BgDBUtils.NO) {
            tmpStrs[0] = "CREATE INDEX " + index1 + " ON " + controlName + " (FBillID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)controlName, (String)(index2 = "IX_MBG_CRA" + lastStr)) == BgDBUtils.NO) {
            tmpStrs[1] = "CREATE INDEX " + index2 + " ON " + controlName + " (FActualID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)controlName, (String)(index3 = "IX_MBG_CRD" + lastStr)) == BgDBUtils.NO) {
            tmpStrs[2] = "CREATE INDEX " + index3 + " ON " + controlName + " (FBizOrgUnitID ASC, FFormula ASC, FVersion ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)controlName, (String)(index4 = "IX_MBG_CRS" + lastStr)) == BgDBUtils.NO) {
            tmpStrs[3] = "CREATE INDEX " + index4 + " ON " + controlName + " (FBgSettingID ASC)";
        }
        if (BgDBUtils.existIndex((Connection)conn, (String)controlName, (String)(index5 = "IX_MBG_CRG" + lastStr)) == BgDBUtils.NO) {
            tmpStrs[4] = "CREATE INDEX " + index5 + " ON " + controlName + " (FBizOrgUnitID ASC)";
        }
        return tmpStrs;
    }
}

