/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.query;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.query.IControlManager;
import com.kingdee.eas.ma.mbg.cube.query.IDataManager;
import com.kingdee.eas.ma.mbg.cube.query.IOlapService;
import com.kingdee.eas.ma.mbg.cube.query.IQuery;
import com.kingdee.eas.ma.mbg.cube.query.IQueryParameter;
import com.kingdee.eas.ma.mbg.cube.query.ISchemeCube;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OlapService
implements IOlapService {
    private static Logger logger = Logger.getLogger(OlapService.class);
    private IControlManager controlManager = null;
    private IDataManager dataManager = null;
    private IQuery queryStrategy = null;
    private ISchemeCube schemeCube = null;

    public IControlManager getControlManager() {
        return this.controlManager;
    }

    protected abstract IControlManager createControlManager();

    public IDataManager getDataManager() {
        return this.dataManager;
    }

    protected abstract IDataManager createDataManager();

    protected IQuery getQueryStrategy() {
        return this.queryStrategy;
    }

    protected abstract IQuery createQueryStrategy(IDataManager var1, IControlManager var2);

    public ISchemeCube getSchemeCube() {
        return this.schemeCube;
    }

    protected abstract ISchemeCube createSchemeCube(IDataManager var1, IControlManager var2);

    public static IOlapService getImpl(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        Object _obj = null;
        Class<?> _class = null;
        try {
            _class = Class.forName(className);
            if (IOlapService.class.isAssignableFrom(_class)) {
                _obj = Class.forName(className).newInstance();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Create OlapService Impl Error:", (Throwable)ex);
        }
        return _obj;
    }

    public OlapService() {
        this.createControlManager();
        this.createDataManager();
        this.createQueryStrategy(this.getDataManager(), this.getControlManager());
        this.createSchemeCube(this.getDataManager(), this.getControlManager());
    }

    @Override
    public Map<String, IMbgData> olapQuery(Context ctx, IQueryParameter parameter) throws Exception {
        Map<String, IMbgData> mbgDataMap = new HashMap<String, IMbgData>();
        if (ctx == null || parameter == null) {
            return mbgDataMap;
        }
        if (parameter.getQuerys().isEmpty() && parameter.getBizCalcIds().isEmpty()) {
            return mbgDataMap;
        }
        this.verify(parameter);
        Map<String, Object> olapParams = null;
        try {
            olapParams = this.beforeQuery(ctx, parameter);
            mbgDataMap = this.getQueryStrategy().executeMdxQuery(parameter, olapParams);
        }
        catch (Exception ex) {
            logger.error((Object)"olapQuery Error:", (Throwable)ex);
            throw ex;
        }
        finally {
            this.afterQuery(ctx, olapParams);
        }
        return mbgDataMap;
    }

    protected void verify(IQueryParameter parameter) throws Exception {
        if (parameter.getBgSchemeId() == null || parameter.getBgOrgViewId() == null) {
            throw new DimensionException(DimensionException.PARAMETERORGUNITORSCHEMEERROR);
        }
    }

    protected Map<String, Object> beforeQuery(Context ctx, IQueryParameter parameter) throws Exception {
        if (ctx == null || parameter == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        this.getDataManager().setConnection(BgDBUtils.getConnection((Context)ctx));
        this.getDataManager().setTempTablePool(TempTablePool.getInstance((Context)ctx));
        HashMap<String, Object> olapParams = new HashMap<String, Object>();
        Map<String, String> cubeParams = this.getSchemeCube().getSchemeCube(ctx, parameter);
        olapParams.put(CubeConstants.OLAP_SCHEME, cubeParams);
        return olapParams;
    }

    protected void afterQuery(Context ctx, Map<String, Object> olapParams) throws Exception {
        if (olapParams == null) {
            return;
        }
        BgDBUtils.releaseTmpTable((TempTablePool)this.getDataManager().getTempTablePool(), this.getDataManager().getTempTable());
        SQLUtils.cleanup((Connection)this.getDataManager().getConnection());
    }
}

