/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.query;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.query.IControlManager;
import com.kingdee.eas.ma.mbg.cube.query.IDataManager;
import com.kingdee.eas.ma.mbg.cube.query.IQueryParameter;
import com.kingdee.eas.ma.mbg.cube.query.ISchemeCube;
import com.kingdee.eas.ma.mbg.cube.utils.CubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SchemeCube
implements ISchemeCube {
    private static Logger logger = Logger.getLogger(SchemeCube.class);
    private IDataManager dataManager = null;
    private IControlManager controlManager = null;

    protected void setDataManager(IDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected IDataManager getDataManager() {
        return this.dataManager;
    }

    protected void setControlManager(IControlManager controlManager) {
        this.controlManager = controlManager;
    }

    protected IControlManager getControlManager() {
        return this.controlManager;
    }

    public SchemeCube(IDataManager dataManager, IControlManager controlManager) {
        this.setDataManager(dataManager);
        this.setControlManager(controlManager);
    }

    @Override
    public Map<String, String> getSchemeCube(Context ctx, IQueryParameter parameter) throws Exception {
        if (ctx == null || parameter == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            List<IMember> members;
            if (this.getDataManager().getBgScheme() == null) {
                BgSchemeInfo bgScheme = BgViewServerHelper.getBgSchemeInfo(ctx.getLocale(), this.getDataManager().getConnection(), parameter.getBgSchemeId());
                this.getDataManager().setBgScheme(bgScheme);
            }
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)this.getDataManager().getConnection(), (BOSUuid)parameter.getBgOrgViewId());
            String mbgOrgFact = MbgVirtualView.getBgOrgFactTable((String)mbgSnapVar);
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            params.put(CubeConstants.ORGUNIT_FACT_TABLE, mbgOrgFact);
            params.put(CubeConstants.ORGUNIT_CLOSURE_TABLE, mbgOrgClosure);
            MbgDimInfo mbgDim = null;
            MbgDimCollection colls = DimUtils.getDimensionColls(this.getDataManager().getConnection(), ctx.getLocale());
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                this.getDataManager().getMbgDims().put(mbgDim.getRefField(), mbgDim);
                this.getDataManager().getSrcFieldMap().put(mbgDim.getSrcNumber(), mbgDim.getRefField());
                this.getDataManager().getFieldSrcMap().put(mbgDim.getRefField(), mbgDim.getSrcNumber());
            }
            this.getDataManager().getFields().addAll(this.getDataManager().getBgScheme().getRefFields(this.getDataManager().getConnection(), parameter.getValueType()));
            HashMap<String, String> innNumMap = new HashMap<String, String>();
            HashMap<String, String> numInnMap = new HashMap<String, String>();
            this.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, innNumMap);
            this.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, numInnMap);
            if (this.getDataManager().getBgScenarioMap().isEmpty()) {
                this.getDataManager().getBgScenarioMap().putAll(BgDimCacheUtils.getScenarioCache((Context)ctx));
            }
            Object var11_14 = null;
            for (BgScenarioInfo bgScenarioInfo : this.getDataManager().getBgScenarioMap().values()) {
                innNumMap.put(String.valueOf(bgScenarioInfo.getScenarioId()), bgScenarioInfo.getNumber());
                numInnMap.put(bgScenarioInfo.getNumber(), String.valueOf(bgScenarioInfo.getScenarioId()));
            }
            innNumMap = new HashMap();
            numInnMap = new HashMap();
            this.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, innNumMap);
            this.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, numInnMap);
            if (this.getDataManager().getBgVersionMap().isEmpty()) {
                this.getDataManager().getBgVersionMap().putAll(BgDimCacheUtils.getVersionCache((Context)ctx));
            }
            Object var12_18 = null;
            for (BgVersionInfo bgVersionInfo : this.getDataManager().getBgVersionMap().values()) {
                innNumMap.put(String.valueOf(bgVersionInfo.getVersionId()), bgVersionInfo.getNumber());
                numInnMap.put(bgVersionInfo.getNumber(), String.valueOf(bgVersionInfo.getVersionId()));
            }
            if (!params.containsKey(CubeConstants.CUBE_TABLE)) {
                String cubeTable = this.getDataManager().getBgScheme().getRefCube();
                if (this.getControlManager().isDailyActual()) {
                    cubeTable = BgCubeUtils.getDailyActualCubeName(cubeTable);
                }
                params.put(CubeConstants.CUBE_TABLE, cubeTable);
            }
            if (!params.containsKey(CubeConstants.FIELD_REFFIELDS)) {
                String factTable = null;
                String closureTable = null;
                String fields = "";
                BOSUuid viewId = null;
                for (String field : this.getDataManager().getFields()) {
                    mbgDim = this.getDataManager().getMbgDims().get(field);
                    viewId = this.getDataManager().getBgScheme().getViewId(mbgDim.getNumber());
                    if (viewId == null) {
                        throw new DimensionException(DimensionException.DIMENSIONREFFIELDERROR);
                    }
                    fields = fields + field + CubeConstants.SEMICOLON;
                    factTable = MbgVirtualView.getFactTable((Connection)this.getDataManager().getConnection(), (BOSUuid)viewId);
                    if (StringUtils.isEmpty((String)factTable)) {
                        throw new DimensionException(DimensionException.NOFACTTABLE);
                    }
                    closureTable = MbgVirtualView.getClosureTable((String)factTable);
                    params.put(field + CubeConstants.FIELD_FACT_TABLE, factTable);
                    params.put(field + CubeConstants.FIELD_CLOSURE_TABLE, closureTable);
                }
                params.put(CubeConstants.FIELD_REFFIELDS, fields);
            }
            List<String> orgUnitIds = CubeUtils.getOrgOfChildren(this.getDataManager().getConnection(), parameter.getBgOrgViewId(), this.getDataManager().getBgOrgUnit(), mbgOrgFact, mbgOrgClosure);
            params.put(CubeConstants.DATA_SQL_GROUP, Boolean.FALSE.toString());
            StringBuffer sql = new StringBuffer();
            if (orgUnitIds.isEmpty()) {
                sql.append("select * from " + CubeConstants.DATA_SQL_CUBE + " where FOrgUnitID  = '" + parameter.getOrgUnitId() + "'");
            } else if (orgUnitIds.size() == 1) {
                sql.append("select * from " + CubeConstants.DATA_SQL_CUBE + " where FOrgUnitID  = '" + orgUnitIds.get(0) + "'");
            } else {
                String orgTmpTable = CubeUtils.getOrgTmpTable(ctx, this.getDataManager().getTempTablePool(), this.getDataManager().getConnection(), orgUnitIds);
                this.getDataManager().getTempTable().add(orgTmpTable);
                sql.append("select * from " + CubeConstants.DATA_SQL_CUBE + " where FOrgUnitID IN (select FID from " + orgTmpTable + ")");
                params.put(CubeConstants.DATA_SQL_GROUP, Boolean.TRUE.toString());
            }
            if (this.getControlManager().isControl() && !(members = CubeUtils.getBgIndexMember(parameter.getQuerys())).isEmpty()) {
                sql.append(" and F2 IN (select FDimNumber from " + (String)params.get(DimensionBaseConstants.DEF_BGINDEX_FIELD + CubeConstants.FIELD_FACT_TABLE) + " where (");
                for (IMember member : members) {
                    sql.append("(FDimNumber = '" + member.getDimNumber() + "' OR FDimLongNumber LIKE '" + member.transLongNumber(member.getLongNumber()) + "!%') OR ");
                }
                if (sql.length() > 0) {
                    sql.delete(sql.length() - 4, sql.length());
                }
                sql.append("))");
            }
            params.put(CubeConstants.DATA_SQL, sql.toString());
        }
        catch (Exception ex) {
            logger.error((Object)"prep olap properties error:", (Throwable)ex);
            throw ex;
        }
        return params;
    }
}

