/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class CubeUtils {
    private static Logger logger = Logger.getLogger(CubeUtils.class);

    public static List<String> getOrgOfChildren(Connection conn, BOSUuid bgOrgViewId, BgOrgUnitInfo bgOrgUnit, String orgFactTable, String orgClosureTable) throws EASBizException {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (conn == null || bgOrgViewId == null || bgOrgUnit == null) {
            return orgUnitIds;
        }
        String orgViewId = bgOrgViewId.toString();
        String orgUnitId = bgOrgUnit.getOrgUnitID();
        String orgUnitLongNum = bgOrgUnit.getLongNumber();
        HashSet<String> tmpOrgSet = new HashSet<String>();
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FChildID from " + orgClosureTable + " t where t.FID = ?"), (Object[])new Object[]{orgUnitId});
            while (rst.next()) {
                tmpOrgSet.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID from " + orgClosureTable + " where FID in (select FOrgunitID from T_MBG_BgOrgUnit where FViewID = ? and  FPolAlgorithm = " + 3 + " and FOrgunitID in (select FOrgunitID from T_MBG_BgOrgUnit where FViewID  = ? and (FLongNumber = ? or FLongNumber like ?)))"), (Object[])new Object[]{orgViewId, orgViewId, orgUnitLongNum, orgUnitLongNum + "%"});
            while (rst.next()) {
                tmpOrgSet.remove(rst.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getOrgOfChildren error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        orgUnitIds.addAll(tmpOrgSet);
        return orgUnitIds;
    }

    public static String getOrgTmpTable(Context ctx, TempTablePool pool, Connection conn, List<String> orgUnitIds) throws BOSException, EASBizException {
        if (ctx == null || pool == null || conn == null || orgUnitIds == null) {
            return null;
        }
        int batchIndex = 0;
        String tableName = null;
        PreparedStatement pstmt = null;
        try {
            tableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            pstmt = conn.prepareStatement("Insert Into " + tableName + " (FID) values (?)");
            int in = orgUnitIds.size();
            for (int i = 0; i < in; ++i) {
                pstmt.setString(1, orgUnitIds.get(i));
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getOrgTmpTable error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        return tableName;
    }

    public static List<IMember> getBgIndexMember(List<IQueryData> querys) {
        ArrayList<IMember> members = new ArrayList<IMember>();
        return members;
    }
}

