/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.cube.utils;

import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.util.List;

public class MbgMdxUtils {
    public static final String LEFT_BRACE = "{";
    public static final String RIGHT_BRACE = "}";
    public static final String LEFT_SEP_BRACKET = ".[";
    public static final String RIGHT_SEP_BRACKET = "].";
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String LEFT_PARENTHESIS = "(";
    public static final String RIGHT_PARENTHESIS = ")";
    public static final String SEP_COMMA = ",";
    public static final String SEP_COLON = ":";
    public static final String SEP_EXCLAMATION_MARKS = "!";
    public static final String SEP_DECIMAL_POINT = ".";
    public static final String SEP_DECIMAL_POINT_SPLIT = "\\.";
    public static final String HEAD_ORGUNIT_NUMBER = "orgUnit";
    public static final String HEAD_PERIOD_NUMBER = "period";
    public static final String HEAD_ELEMENT_NUMBER = "element";
    public static final String HEAD_CURRENCY_NUMBER = "currency";
    public static final String HEAD_SCENARIO_NUMBER = "scenario";
    public static final String HEAD_VERSION_NUMBER = "version";
    public static final String HEAD_MEASURES_NUMBER = "measures";
    public static final String HEAD_STATE_NUMBER = "state";
    public static final String HEAD_DIMENSION_NUMBER = "DIM";
    public static final String HEAD_PROCESSTYPE_NUMBER = "processType";

    public static String transMdx(String calcMdx, List<IDimension> rows, List<IDimension> cols, List<IDimension> views) {
        if (rows == null || cols == null) {
            return null;
        }
        StringBuffer mdx = new StringBuffer();
        if (!StringUtils.isEmpty((String)calcMdx)) {
            mdx.append(calcMdx);
        }
        mdx.append(" SELECT NON EMPTY ");
        MbgMdxUtils.appendSetOfDimension(mdx, cols);
        mdx.append(" * ");
        MbgMdxUtils.appendMeasures(mdx);
        mdx.append(" ON COLUMNS ");
        mdx.append(", NON EMPTY ");
        MbgMdxUtils.appendSetOfDimension(mdx, rows);
        mdx.append(" ON ROWS ");
        mdx.append(" from BudgetCube");
        if (views != null && !views.isEmpty()) {
            mdx.append(" where ");
            MbgMdxUtils.appendTupleOfDimension(mdx, views);
        }
        return mdx.toString();
    }

    public static void appendSetOfDimension(StringBuffer mdx, List<IDimension> mbgDims) {
        if (mdx == null || mbgDims == null || mbgDims.isEmpty()) {
            return;
        }
        IDimension mbgDim = null;
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            if (mbgDim.getMembers().isEmpty()) continue;
            MbgMdxUtils.appendSetOfDimension(mdx, mbgDim);
            mdx.append(" * ");
        }
        if (mdx.length() > 0 && " * ".equals(mdx.substring(mdx.length() - 3, mdx.length()))) {
            mdx.setLength(mdx.length() - 3);
        }
    }

    public static void appendSetOfDimension(StringBuffer mdx, IDimension mbgDim) {
        if (mdx == null || mbgDim == null || mbgDim.getMembers().isEmpty()) {
            return;
        }
        IMember member = null;
        String dimHeadStr = DimUtils.getDimensionNumber(mbgDim);
        mdx.append(LEFT_BRACE);
        int in = mbgDim.getMembers().size();
        for (int i = 0; i < in; ++i) {
            member = mbgDim.getMembers().get(i);
            MbgMdxUtils.appendMember(mdx, dimHeadStr, member);
            mdx.append(SEP_COMMA);
        }
        if (mdx.length() > 0) {
            mdx.setLength(mdx.length() - 1);
        }
        mdx.append(RIGHT_BRACE);
    }

    public static void appendTupleOfDimension(StringBuffer mdx, List<IDimension> mbgDims) {
        if (mdx == null || mbgDims == null || mbgDims.isEmpty()) {
            return;
        }
        IDimension mbgDim = null;
        IMember member = null;
        String dimHeadStr = null;
        mdx.append(LEFT_PARENTHESIS);
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = mbgDims.get(i);
            if (mbgDim.getMembers().isEmpty()) continue;
            member = mbgDim.getMembers().get(0);
            dimHeadStr = DimUtils.getDimensionNumber(mbgDim);
            MbgMdxUtils.appendMember(mdx, dimHeadStr, member);
            mdx.append(SEP_COMMA);
        }
        if (mdx.length() > 0) {
            mdx.setLength(mdx.length() - 1);
        }
        mdx.append(RIGHT_PARENTHESIS);
    }

    public static void appendMember(StringBuffer mdx, String dimHeadStr, IMember member) {
        if (mdx == null || member == null) {
            return;
        }
        if (member.getMdxNumber() == null) {
            member.transMdxNumber();
        }
        if (member.getMdxNumber() != null) {
            if (member.getMdxNumber().startsWith(LEFT_BRACKET)) {
                mdx.append(dimHeadStr).append(SEP_DECIMAL_POINT + member.getMdxNumber());
            } else {
                mdx.append(dimHeadStr).append(LEFT_SEP_BRACKET + member.getMdxNumber() + RIGHT_BRACKET);
            }
        } else {
            mdx.append(dimHeadStr).append(LEFT_SEP_BRACKET + member.getDimNumber() + RIGHT_BRACKET);
        }
    }

    public static void appendMeasures(StringBuffer mdx) {
        if (mdx == null) {
            return;
        }
        mdx.append("{[measures].[" + DimensionConstants.VALUE + "]}");
    }
}

