/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.parse;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2Cond;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.expr.IBizExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizConditionExpr;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgScopeCollection;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.parse.BgExamineExpr;
import com.kingdee.eas.ma.mbg.parse.BgExamineExprChecker;
import com.kingdee.eas.ma.mbg.parse.BgExamineExprParser;
import com.kingdee.eas.ma.mbg.parse.BgExamineParseDimMemHelper;
import com.kingdee.eas.ma.mbg.parse.BgExamineParseExceptionHandler;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class BgExamineFormulaVerifyHelper {
    private LinkedHashMap<String, LinkedHashMap<String, String>> bgExamineFormulaMap = null;
    private Map<String, Map<String, Set<String>>> bgScopeSrcMap = null;
    private Map<String, Map<String, BgScopeCollection>> bgScopeMap = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean showBizNameInException = false;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private Set<String> scopeSrc = null;
    private Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap = new LinkedHashMap<String, Map<String, Map<Integer, List<IBizExpr>>>>();
    private Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = new LinkedHashMap<String, Map<String, Map<Integer, List<Exception>>>>();
    private Map<String, String> bizBgVariateMap = new HashMap<String, String>();
    private int currLine = 1;
    private int currPos = 0;
    private char currChar = '\u0000';
    private char lastNotBlankChar = '\u0000';
    private final char SEMICOLON = (char)59;
    private final char STACK_OPERATOR = '\u0000';

    public BgExamineFormulaVerifyHelper(LinkedHashMap<String, LinkedHashMap<String, String>> bgExamineFormulaMap, Map<String, Map<String, Set<String>>> bgScopeSrcMap, Map<String, Map<String, BgScopeCollection>> bgScopeMap, BgSchemeDimensionHelper schemeHelper, boolean showBizNameInException) {
        this.bgExamineFormulaMap = bgExamineFormulaMap;
        this.bgScopeSrcMap = bgScopeSrcMap;
        this.bgScopeMap = bgScopeMap;
        this.schemeHelper = schemeHelper;
        this.showBizNameInException = showBizNameInException;
    }

    public void batchParse() throws EASBizException, BOSException {
        if (this.bgExamineFormulaMap == null || this.bgScopeSrcMap == null || this.schemeHelper == null) {
            return;
        }
        HashSet<String> parsedSet = new HashSet<String>();
        Iterator<String> iterator = this.bgExamineFormulaMap.keySet().iterator();
        while (iterator.hasNext()) {
            String bizName;
            this.bizName = bizName = iterator.next();
            Map subset = this.bgExamineFormulaMap.get(bizName);
            if (this.exprMap.get(bizName) == null) {
                this.exprMap.put(bizName, new LinkedHashMap());
            }
            if (this.allExceptions.get(bizName) == null) {
                this.allExceptions.put(bizName, new LinkedHashMap());
            }
            for (String subsetName : subset.keySet()) {
                this.scopeSrc = this.bgScopeSrcMap.get(bizName) != null ? this.bgScopeSrcMap.get(bizName).get(subsetName) : null;
                this.subsetName = subsetName;
                this.text = (String)subset.get(subsetName);
                if (this.exprMap.get(bizName).get(subsetName) == null) {
                    this.exprMap.get(bizName).put(subsetName, new LinkedHashMap());
                }
                if (this.allExceptions.get(bizName).get(subsetName) == null) {
                    this.allExceptions.get(bizName).put(subsetName, new LinkedHashMap());
                }
                this.parse();
            }
            BgExamineParseDimMemHelper dimMemHelper = new BgExamineParseDimMemHelper(this.exprMap, this.bizBgVariateMap, this.schemeHelper, this.bgScopeSrcMap, this.bgScopeMap, this.allExceptions);
            dimMemHelper.setParsedSet(parsedSet);
            dimMemHelper.verifyMemberIsExist();
            parsedSet.add(bizName);
        }
    }

    private void parse() throws EASBizException, BOSException {
        if (this.text == null) {
            this.recordException(BgExamineParseException.ERROR_FORMULA_NULL, null);
            return;
        }
        this.init();
        this.getChar();
        while (this.currChar != '\u0000') {
            String script = this.readScript();
            if (this.isLikeIF(script)) {
                this.recordException(BgExamineParseException.ERROR_IF_LEFT, script.contains("*/") ? script.substring(script.indexOf("*/") + 2, script.length()) : script);
                continue;
            }
            if (StringUtils.isEmpty((String)script) || script.trim().equals(String.valueOf(';')) || BizParseHelper.isAnnotation((String)org.apache.commons.lang.StringUtils.strip((String)script, (String)String.valueOf(';')))) {
                this.currLine += org.apache.commons.lang.StringUtils.countMatches((String)script, (String)String.valueOf('\n'));
                this.getChar();
                continue;
            }
            if (!StringUtils.isEmpty((String)script) && !script.endsWith(String.valueOf(';'))) {
                this.currLine += org.apache.commons.lang.StringUtils.countMatches((String)script, (String)String.valueOf('\n'));
                this.recordException(BgExamineParseException.EXPR_NO_END, script.contains("*/") ? script.substring(script.indexOf("*/") + 2, script.length()) : script);
                continue;
            }
            BgExamineExprParser parser2 = new BgExamineExprParser(this.createParam(script));
            if (parser2.parse()) {
                this.currLine = parser2.getCurrLine();
                Stack exprStack = parser2.getExprStack();
                BgExamineExprChecker exprCheck = new BgExamineExprChecker(this.createParam(script));
                if (exprCheck.check(exprStack)) {
                    if (exprStack.size() == 3 && exprStack.get(2) instanceof Operand && BizParseHelper.isIf((String)((Operand)exprStack.get(2)).getOperand())) {
                        Parse2Cond condParser = new Parse2Cond(((Operand)exprStack.get(2)).getOperand());
                        try {
                            condParser.parse();
                            ConditionExpr _expr = (ConditionExpr)condParser.getExpr();
                            for (IExpress result : _expr.getAllExpresss()) {
                                Operand _operand = new Operand(result.getOriginalExpr().trim());
                                Stack _stack = new Stack();
                                _stack.push(exprStack.get(0));
                                _stack.push(exprStack.get(1));
                                _stack.push(_operand);
                                BizConditionExpr _condExpr = new BizConditionExpr(_stack, null);
                                BgExamineExprParser _parser = new BgExamineExprParser(this.createParam(_condExpr.toString()));
                                _parser.parse();
                                _condExpr = new BizConditionExpr(_parser.getExprStack(), _condExpr.toString().replaceAll("\r", "").replaceAll("\n", ""));
                                if (_expr.conditions.contains(result)) {
                                    _condExpr.setCondition(true);
                                }
                                this.recordExpr((IBizExpr)_condExpr);
                            }
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    } else {
                        BgExamineExpr expr = new BgExamineExpr(exprStack);
                        this.recordExpr(expr);
                    }
                }
            } else {
                this.currLine = parser2.getCurrLine();
            }
            this.getChar();
        }
    }

    private void parseBgVariate() throws EASBizException, BOSException {
    }

    private void recordExpr(IBizExpr expr) {
        List<IBizExpr> lineList = this.exprMap.get(this.bizName).get(this.subsetName).get(this.currLine);
        if (lineList == null) {
            lineList = new ArrayList<IBizExpr>();
            this.exprMap.get(this.bizName).get(this.subsetName).put(this.currLine, lineList);
        }
        lineList.add(expr);
    }

    private String readScript() {
        StringBuffer script = new StringBuffer();
        int count = 0;
        boolean isAcct = false;
        int index = 0;
        StringBuffer convertScript = new StringBuffer();
        while ((!this.isSemicolon(this.currChar) || count != 0 || isAcct) && this.currChar != '\u0000' && count >= 0) {
            if (this.currChar == '/' && this.preViewNextChar() == '*') {
                script.append(this.readAnnotation());
                this.getChar();
                continue;
            }
            if (this.currChar == '{') {
                ++count;
            }
            if (this.currChar == '}') {
                --count;
            }
            script.append(this.currChar);
            convertScript.append(this.currChar);
            if (convertScript.toString().contains("Acct")) {
                isAcct = true;
                char quo = '\"';
                if (quo == this.currChar) {
                    ++index;
                }
                if (index > 1) {
                    isAcct = false;
                    index = 0;
                    convertScript = new StringBuffer();
                }
            }
            this.getChar();
        }
        if (this.isSemicolon(this.currChar)) {
            script.append(this.currChar);
        }
        return script.toString();
    }

    private String readAnnotation() {
        StringBuffer annoStr = new StringBuffer();
        while (this.currChar != '\u0000') {
            if (this.currChar == '/' && annoStr.length() > 1 && annoStr.charAt(annoStr.length() - 1) == '*') {
                annoStr.append(this.currChar);
                break;
            }
            annoStr.append(this.currChar);
            this.getChar();
        }
        return annoStr.toString();
    }

    private void init() {
        this.currLine = 1;
        this.currPos = 0;
        this.currChar = '\u0000';
    }

    private void getChar() {
        if (this.currPos == this.text.length()) {
            this.currChar = '\u0000';
            return;
        }
        this.currChar = this.text.charAt(this.currPos++);
    }

    private char preViewNextChar() {
        if (this.currPos == this.text.length()) {
            return '\u0000';
        }
        return this.text.charAt(this.currPos);
    }

    private boolean isSemicolon(char c) {
        return ';' == c;
    }

    private boolean isLikeIF(String script) {
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (BizParseHelper.isBlank((char)c)) continue;
            if (c == '/' && i + 1 < script.length() && script.charAt(i + 1) == '*') {
                if ((i = script.indexOf("*/", i) + 1) > 0) continue;
                return false;
            }
            if (c == 'I') {
                return script.charAt(i + 1) == 'F';
            }
            return false;
        }
        return false;
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BgExamineParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(""));
    }

    private BizParseParam createParam(String text) {
        BizParseParam param = new BizParseParam();
        param.setCurrLine(Integer.valueOf(this.currLine));
        param.setBizName(this.bizName);
        param.setSubsetName(this.subsetName);
        param.setText(text);
        param.setExprMap(this.exprMap);
        param.setAllExceptions(this.allExceptions);
        return param;
    }

    public Map<String, Map<String, Map<Integer, List<Exception>>>> getAllExceptions() {
        return this.allExceptions;
    }

    public String getErrorMsg() {
        StringBuffer errorMsg = new StringBuffer();
        if (this.allExceptions.size() > 0) {
            for (String bizName : this.allExceptions.keySet()) {
                Map<String, Map<Integer, List<Exception>>> subsetException = this.allExceptions.get(bizName);
                for (String subsetName : subsetException.keySet()) {
                    Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                    ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        List<Exception> Exceptions = lineException.get(line);
                        for (Exception exception : Exceptions) {
                            if (this.showBizNameInException) {
                                errorMsg.append(new BgExamineParseException(BgExamineParseException.ERROR_SHOWBIZNAME, new Object[]{bizName, exception.getMessage()}).getMessage()).append("\r\n");
                                continue;
                            }
                            errorMsg.append(exception.getMessage()).append("\r\n");
                        }
                    }
                }
            }
            return errorMsg.toString();
        }
        return null;
    }

    public static void buildParseParam(Collection<BgExamineInfo> bgExamineList, LinkedHashMap<String, LinkedHashMap<String, String>> bgExamineFormulaMap, Map<String, Map<String, Set<String>>> bgScopeSrcMap, Map<String, Map<String, BgScopeCollection>> bgScopeMap, BgSchemeDimensionHelper schemeHelper) {
        BgExamineSubsetInfo subSetInfo = null;
        BgExamineInfo bgExamineInfo2 = null;
        String bgExamineNumber = null;
        for (BgExamineInfo bgExamineInfo2 : bgExamineList) {
            bgExamineNumber = bgExamineInfo2.getNumber();
            if (!bgScopeMap.containsKey(bgExamineNumber)) {
                bgScopeMap.put(bgExamineNumber, new HashMap());
            }
            Iterator it1 = bgExamineInfo2.getBgExamineSubset().iterator();
            while (it1.hasNext()) {
                subSetInfo = (BgExamineSubsetInfo)it1.next();
                if (!bgExamineFormulaMap.containsKey(bgExamineNumber)) {
                    bgExamineFormulaMap.put(bgExamineNumber, new LinkedHashMap());
                }
                bgExamineFormulaMap.get(bgExamineNumber).put(subSetInfo.getName(), subSetInfo.getBizFormula());
                if (subSetInfo.getBgScope().isEmpty()) continue;
                if (!bgScopeSrcMap.containsKey(bgExamineNumber)) {
                    bgScopeSrcMap.put(bgExamineNumber, new HashMap());
                }
                bgScopeSrcMap.get(bgExamineNumber).put(subSetInfo.getName(), BgExamineFormulaVerifyHelper.processScope(subSetInfo.getBgScope(), schemeHelper));
                bgScopeMap.get(bgExamineNumber).put(subSetInfo.getName(), subSetInfo.getBgScope());
            }
        }
    }

    public static Set<String> processScope(BgScopeCollection scopes, BgSchemeDimensionHelper schemeHelper) {
        HashSet<String> scopeSrc = new HashSet<String>();
        for (int i = 0; i < scopes.size(); ++i) {
            BgScopeInfo scope = scopes.get(i);
            if (!StringUtils.isEmpty((String)scope.getRefField())) {
                if (scope.getRefField().equals(BgProcessHelper.DEF_PROCESS_FIELD)) {
                    scopeSrc.add(BgProcessHelper.DEF_PROCESS_SRC);
                    continue;
                }
                scopeSrc.add(schemeHelper.getSrcNumberByRefField(scope.getRefField()));
                continue;
            }
            String[] memNum = scope.getBgMemberNum().split("\"");
            if (memNum.length > 1) {
                scopeSrc.add(memNum[1].split(":")[0]);
                continue;
            }
            scopeSrc.add(scope.getBgMemberNum().split(":")[0]);
        }
        return scopeSrc;
    }
}

