/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.parse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MemberProxy;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.BizExprParser;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.expr.IBizExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizAssignmentExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizConditionExpr;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgScopeCollection;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.BgVariateCollection;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.IBgVariate;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.parse.BgExamineExpr;
import com.kingdee.eas.ma.mbg.parse.BgExamineExprChecker;
import com.kingdee.eas.ma.mbg.parse.BgExamineParseExceptionHandler;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class BgExamineParseDimMemHelper {
    private Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap = null;
    private Map<String, String> bizBgVariateMap = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, Map<String, Set<String>>> bizScopeSrcMap = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Map<String, BgScopeCollection>> bizScopeMap = null;
    private Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = null;
    public static final String DEFAULT_BG_SCHMEM = "default_bgScheme";
    private Set<String> parsedSet = null;
    private String bizName = null;
    private String subsetName = null;
    private Integer line = null;

    public Set<String> getParsedSet() {
        return this.parsedSet;
    }

    public void setParsedSet(Set<String> parsedSet) {
        this.parsedSet = parsedSet;
    }

    public BgExamineParseDimMemHelper(Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap, Map<String, String> bizBgVariateMap, BgSchemeDimensionHelper schemeHelper, Map<String, Map<String, Set<String>>> bizScopeSrcMap, Map<String, Map<String, BgScopeCollection>> bizScopeMap, Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions) {
        this.exprMap = exprMap;
        this.bizBgVariateMap = bizBgVariateMap;
        this.schemeHelper = schemeHelper;
        this.bizScopeSrcMap = bizScopeSrcMap;
        this.bizScopeMap = bizScopeMap;
        this.allExceptions = allExceptions;
    }

    public void verifyMemberIsExist() throws EASBizException, BOSException {
        this.parseScopeVariate();
        this.parseExprVariate();
        this.queryBgVariate();
        HashMap<String, Map<String, Map<Integer, Map<String, Set<String>>>>> bizMemberMap = new HashMap<String, Map<String, Map<Integer, Map<String, Set<String>>>>>();
        HashMap<String, Map<String, Set<String>>> dimMemMap = new HashMap<String, Map<String, Set<String>>>();
        Map<String, Map<String, String>> dimNumberMap = null;
        dimNumberMap = this.processBgDimensionMember();
        this.parseExprMem(bizMemberMap, dimMemMap, dimNumberMap);
        this.parseScopeMem(dimMemMap);
        this.queryDimMember(bizMemberMap, dimMemMap, dimNumberMap);
    }

    private void queryDimMember(Map<String, Map<String, Map<Integer, Map<String, Set<String>>>>> bizMemberMap, Map<String, Map<String, Set<String>>> dimMemMap, Map<String, Map<String, String>> dimNumberMap) throws EASBizException, BOSException {
        Map<String, BgDimensionInfo> ref_dim = this.schemeHelper.getDimensionByRefField();
        ref_dim.put(BgProcessHelper.DEF_PROCESS_FIELD, BgProcessHelper.getDimension());
        BgScopeInfo scope = null;
        String orgTreeId = null;
        if (this.schemeHelper.getClass().getName().equalsIgnoreCase(DimensionConstants.CSLSCHEME_HELPER) && this.schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() != null) {
            orgTreeId = this.schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        }
        Map existMemMap = null;
        existMemMap = this.schemeHelper.getContext() == null ? BgExamineFactory.getRemoteInstance().queryDimMember(dimMemMap, this.schemeHelper.getBgSchemeId(), true, orgTreeId) : BgExamineFactory.getLocalInstance(this.schemeHelper.getContext()).queryDimMember(dimMemMap, this.schemeHelper.getBgSchemeId(), true, orgTreeId);
        if (existMemMap != null) {
            for (String bizName : bizMemberMap.keySet()) {
                if (this.parsedSet != null && this.parsedSet.contains(bizName)) continue;
                Map<String, Map<Integer, Map<String, Set<String>>>> subsetMemberMap = bizMemberMap.get(bizName);
                for (String subsetName : subsetMemberMap.keySet()) {
                    BgScopeCollection scopes;
                    Map<Integer, Map<String, Set<String>>> lineMemberMap = subsetMemberMap.get(subsetName);
                    Map<String, Set<String>> bgSchemeMap = null;
                    for (Integer line : lineMemberMap.keySet()) {
                        bgSchemeMap = lineMemberMap.get(line);
                        for (Map.Entry<String, Set<String>> entry : bgSchemeMap.entrySet()) {
                            String dimNum;
                            String number;
                            String src;
                            String[] member;
                            Set<String> srcMemSet;
                            if (entry.getValue().isEmpty()) continue;
                            String bgScheme = entry.getKey();
                            if (!existMemMap.containsKey(bgScheme) && dimNumberMap != null && dimNumberMap.keySet().contains(bgScheme)) {
                                this.recordException(BgExamineParseException.ERROR_BGSCHEME, bgScheme, bizName, subsetName, line);
                                continue;
                            }
                            if (bgScheme.equals(DEFAULT_BG_SCHMEM)) {
                                srcMemSet = bgSchemeMap.get(bgScheme);
                                for (String srcMem : srcMemSet) {
                                    if (srcMem.equals("BgP") || BizParseHelper.isNum((String)srcMem)) continue;
                                    member = srcMem.split(":");
                                    src = member[0];
                                    number = this.getMemberNumber(member);
                                    dimNum = null;
                                    if (this.schemeHelper.getDimensionBySrcNumber() != null && this.schemeHelper.getDimensionBySrcNumber().get(src) != null) {
                                        dimNum = this.schemeHelper.getDimensionBySrcNumber().get(src).getNumber();
                                    } else if (BgProcessHelper.DEF_PROCESS_SRC.equals(src)) {
                                        dimNum = BgProcessHelper.DEF_PROCESS_NUMBER;
                                    } else if ("BgP1".equals(src)) {
                                        dimNum = "BG_Period1";
                                    } else if ("BgP2".equals(src)) {
                                        dimNum = "BG_Period2";
                                    }
                                    if ((DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimNum) || "BG_Period1".equals(dimNum) || "BG_Period2".equals(dimNum)) && BgPeriodNVariableHelper.checkCanConvert((String)number) || this.checkHasMember(existMemMap, dimNum, number, bgScheme)) continue;
                                    this.recordException(BgExamineParseException.ERROR_MEMBER, this.getSrcMemberNumber(member), bizName, subsetName, line);
                                }
                                continue;
                            }
                            srcMemSet = bgSchemeMap.get(bgScheme);
                            for (String srcMem : srcMemSet) {
                                member = srcMem.split(":");
                                src = member[0];
                                number = this.getMemberNumber(member);
                                dimNum = null;
                                if (dimNumberMap != null && !dimNumberMap.isEmpty()) {
                                    if (dimNumberMap.get(bgScheme) != null) {
                                        dimNum = dimNumberMap.get(bgScheme).get(src);
                                    }
                                    if (dimNum == null) {
                                        dimNum = BgProcessHelper.DEF_PROCESS_SRC.equals(src) ? BgProcessHelper.DEF_PROCESS_NUMBER : ("BgP1".equals(src) ? "BG_Period1" : ("BgP2".equals(src) ? "BG_Period2" : this.getDimNumberBySrc(src)));
                                    }
                                }
                                if ((DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimNum) || "BG_Period1".equals(dimNum) || "BG_Period2".equals(dimNum)) && BgPeriodNVariableHelper.checkCanConvert((String)number) || DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(src) && (number.indexOf("!Y") == -1 || number.indexOf("!HY") == -1 || number.indexOf("!M") == -1) || this.checkHasMember(existMemMap, dimNum, number, bgScheme) || dimNumberMap.isEmpty()) continue;
                                this.recordException(BgExamineParseException.ERROR_MEMBER, this.getSrcMemberNumber(member), bizName, subsetName, line);
                            }
                        }
                    }
                    if (this.bizScopeMap == null || !this.bizScopeMap.containsKey(bizName) || !this.bizScopeMap.get(bizName).containsKey(subsetName) || (scopes = this.bizScopeMap.get(bizName).get(subsetName)) == null || scopes.isEmpty()) continue;
                    for (int i = 0; i < scopes.size(); ++i) {
                        scope = scopes.get(i);
                        if (scope.getRefField() == null) continue;
                        if (!ref_dim.containsKey(scope.getRefField())) {
                            this.recordException(BgExamineParseException.ERROR_SCOPE_NO_REFFIELD, new Object[]{subsetName, scope.getRefField()}, bizName, subsetName, (Integer)-1);
                            continue;
                        }
                        if (BgMemberSelectTypeEnum.Member.equals((Object)scope.getBizDataType())) {
                            if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(scope.getRefField()) && BgPeriodNVariableHelper.checkCanConvert((String)scope.getBgMemberNum()) || this.checkHasMember(existMemMap, ref_dim.get(scope.getRefField()).getNumber(), this.getMemberNumber(scope.getBgMemberNum().split(":")), DEFAULT_BG_SCHMEM)) continue;
                            this.recordException(BgExamineParseException.ERROR_SCOPE_NO_MEMBER, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                            continue;
                        }
                        if (BgMemberSelectTypeEnum.Variate.equals((Object)scope.getBizDataType())) {
                            String number = this.bizBgVariateMap.get(scope.getBgMemberNum());
                            if (this.checkHasMember(existMemMap, ref_dim.get(scope.getRefField()).getNumber(), this.getMemberNumber(number.split(":")), DEFAULT_BG_SCHMEM)) continue;
                            this.recordException(BgExamineParseException.ERROR_SCOPE_NO_MEMBER, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                            continue;
                        }
                        if (!BgMemberSelectTypeEnum.Function.equals((Object)scope.getBizDataType())) continue;
                        Set<String> numbers = MbgFunctionHelper.getMemNumByScopeMemFunction(scope.getBgMemberNum());
                        for (String number : numbers) {
                            if (number.indexOf(":") > 0) {
                                if (BgPeriodNVariableHelper.checkCanConvert((String)number) || this.checkHasMember(existMemMap, ref_dim.get(scope.getRefField()).getNumber(), this.getMemberNumber(number.split(":")), DEFAULT_BG_SCHMEM)) continue;
                                this.recordException(BgExamineParseException.ERROR_SCOPE_NO_FUNCTION, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                                continue;
                            }
                            String memberNumber = this.bizBgVariateMap.get(number);
                            if (this.checkHasMember(existMemMap, ref_dim.get(scope.getRefField()).getNumber(), this.getMemberNumber(memberNumber.split(":")), DEFAULT_BG_SCHMEM)) continue;
                            this.recordException(BgExamineParseException.ERROR_SCOPE_NO_FUNCTION, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                        }
                    }
                }
            }
        }
    }

    private boolean checkHasMember(Map<String, Map<String, Set<String>>> existMemMap, String dimNumber, String number, String bgScheme) {
        return existMemMap != null && !existMemMap.isEmpty() && existMemMap.get(bgScheme) != null && existMemMap.get(bgScheme).get(dimNumber) != null && existMemMap.get(bgScheme).get(dimNumber).contains(number);
    }

    private boolean checkVarHasSameSrc(List<String> memberList) {
        if (memberList == null) {
            return false;
        }
        String baseSrc = null;
        for (String member : memberList) {
            String src = member.split(":")[0];
            if (baseSrc == null) {
                baseSrc = src;
                continue;
            }
            if (baseSrc.equals(src)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Map<String, String>> processBgDimensionMember() throws EASBizException, BOSException {
        List<Map<String, Set<String>>> lineMembers = null;
        Object dimMembers = null;
        ArrayList<String> bgSchemes = new ArrayList<String>();
        Map dimNumberMap = null;
        Iterator<String> iterator = this.exprMap.keySet().iterator();
        while (iterator.hasNext()) {
            String bizName;
            this.bizName = bizName = iterator.next();
            Map<String, Set<String>> subSetScopeSrc = this.bizScopeSrcMap.get(bizName);
            Map<String, Map<Integer, List<IBizExpr>>> subsetMap = this.exprMap.get(bizName);
            Iterator<String> iterator2 = subsetMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String subsetName;
                this.subsetName = subsetName = iterator2.next();
                Map<Integer, List<IBizExpr>> lineMap = subsetMap.get(subsetName);
                Iterator<Integer> iterator3 = lineMap.keySet().iterator();
                while (iterator3.hasNext()) {
                    Integer line;
                    this.line = line = iterator3.next();
                    List<IBizExpr> exprList = lineMap.get(line);
                    for (IBizExpr expr : exprList) {
                        if (!(expr instanceof BgExamineExpr) && !(expr instanceof BizConditionExpr)) continue;
                        lineMembers = this.parseLogicalExpr(expr, null, false, null);
                        for (int i = 0; i < lineMembers.size(); ++i) {
                            Map<String, Set<String>> map = lineMembers.get(i);
                            for (String bgSchemeNumber : map.keySet()) {
                                if (bgSchemeNumber.equals(DEFAULT_BG_SCHMEM)) continue;
                                bgSchemes.add(bgSchemeNumber);
                            }
                        }
                    }
                }
            }
        }
        if (!bgSchemes.isEmpty()) {
            dimNumberMap = this.schemeHelper.getContext() == null ? BgExamineFactory.getRemoteInstance().queryAllDimMember(bgSchemes) : BgExamineFactory.getLocalInstance(this.schemeHelper.getContext()).queryAllDimMember(bgSchemes);
        }
        return dimNumberMap;
    }

    private void parseExprMem(Map<String, Map<String, Map<Integer, Map<String, Set<String>>>>> bizMemberMap, Map<String, Map<String, Set<String>>> dimMemMap, Map<String, Map<String, String>> dimNumberMap) {
        List<Map<String, Set<String>>> lineMembers = null;
        Set<String> dimMembers = null;
        Iterator<String> iterator = this.exprMap.keySet().iterator();
        while (iterator.hasNext()) {
            String bizName;
            this.bizName = bizName = iterator.next();
            if (this.parsedSet != null && this.parsedSet.contains(bizName)) continue;
            Map<String, Set<String>> subSetScopeSrc = this.bizScopeSrcMap.get(bizName);
            Map<String, Map<Integer, List<IBizExpr>>> subsetMap = this.exprMap.get(bizName);
            Map<String, Map<Integer, Map<String, Set<String>>>> subsetMemberMap = bizMemberMap.get(bizName);
            if (subsetMemberMap == null) {
                subsetMemberMap = new HashMap<String, Map<Integer, Map<String, Set<String>>>>();
                bizMemberMap.put(bizName, subsetMemberMap);
            }
            Iterator<String> iterator2 = subsetMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String subsetName;
                this.subsetName = subsetName = iterator2.next();
                Map<Integer, List<IBizExpr>> lineMap = subsetMap.get(subsetName);
                Set<String> scopeSrc = subSetScopeSrc != null ? subSetScopeSrc.get(subsetName) : null;
                Map<Integer, Map<String, Set<String>>> lineMemberMap = subsetMemberMap.get(subsetName);
                if (lineMemberMap == null) {
                    lineMemberMap = new HashMap<Integer, Map<String, Set<String>>>();
                    subsetMemberMap.put(subsetName, lineMemberMap);
                }
                Iterator<Integer> iterator3 = lineMap.keySet().iterator();
                while (iterator3.hasNext()) {
                    Integer line;
                    this.line = line = iterator3.next();
                    List<IBizExpr> exprList = lineMap.get(line);
                    for (IBizExpr expr : exprList) {
                        if (!(expr instanceof BizAssignmentExpr) && (expr instanceof BgExamineExpr || expr instanceof BizConditionExpr)) {
                            lineMembers = this.parseLogicalExpr(expr, scopeSrc, true, dimNumberMap);
                        }
                        HashMap<String, Set<String>> members = new HashMap<String, Set<String>>();
                        if (lineMembers == null) continue;
                        for (int i = 0; i < lineMembers.size(); ++i) {
                            Map<String, Set<String>> map = lineMembers.get(i);
                            for (Map.Entry<String, Set<String>> memEntry : map.entrySet()) {
                                String key = memEntry.getKey();
                                Set<String> memSet = memEntry.getValue();
                                if (!members.containsKey(key)) {
                                    members.put(key, memSet);
                                    continue;
                                }
                                ((Set)members.get(key)).addAll(memSet);
                            }
                        }
                        Map<String, Set<String>> lineMember = lineMemberMap.get(line);
                        if (lineMember == null) {
                            lineMember = new HashMap<String, Set<String>>();
                            lineMemberMap.put(line, lineMember);
                        }
                        lineMember.putAll(members);
                        for (Map.Entry<String, Set<String>> entry : lineMember.entrySet()) {
                            String key = entry.getKey();
                            Set<String> memSet = entry.getValue();
                            for (String dimMem : memSet) {
                                Map<String, Set<String>> tmpMap;
                                String dimNum;
                                String[] member = dimMem.split(":");
                                String src = member[0];
                                String number = this.getMemberNumber(member);
                                if (key.equals(DEFAULT_BG_SCHMEM)) {
                                    if (!BgProcessHelper.DEF_PROCESS_SRC.equals(src) && this.schemeHelper.getDimensionBySrcNumber() == null) continue;
                                    dimNum = null;
                                    tmpMap = null;
                                    if (BgProcessHelper.DEF_PROCESS_SRC.equals(src)) {
                                        dimNum = BgProcessHelper.DEF_PROCESS_NUMBER;
                                    } else if (this.schemeHelper.getDimensionBySrcNumber() != null && this.schemeHelper.getDimensionBySrcNumber().get(src) != null) {
                                        dimNum = this.schemeHelper.getDimensionBySrcNumber().get(src).getNumber();
                                    } else if ("BgP1".equals(src)) {
                                        dimNum = "BG_Period1";
                                    } else if ("BgP2".equals(src)) {
                                        dimNum = "BG_Period2";
                                    }
                                    if (StringUtils.isEmpty((String)dimNum)) continue;
                                    tmpMap = dimMemMap.get(key);
                                    if (tmpMap == null) {
                                        tmpMap = new HashMap<String, Set<String>>();
                                        dimMemMap.put(key, tmpMap);
                                    }
                                    if ((dimMembers = tmpMap.get(dimNum)) == null) {
                                        dimMembers = new HashSet<String>();
                                        tmpMap.put(dimNum, dimMembers);
                                    }
                                    dimMembers.add(number);
                                    continue;
                                }
                                if (dimNumberMap == null || dimNumberMap.isEmpty()) continue;
                                dimNum = null;
                                if (dimNumberMap.get(key) != null) {
                                    dimNum = dimNumberMap.get(key).get(src);
                                }
                                if (dimNum == null) {
                                    dimNum = BgProcessHelper.DEF_PROCESS_SRC.equals(src) ? BgProcessHelper.DEF_PROCESS_NUMBER : this.getDimNumberBySrc(src);
                                    if ("BgP1".equals(src)) {
                                        dimNum = "BG_Period1";
                                    } else if ("BgP2".equals(src)) {
                                        dimNum = "BG_Period2";
                                    }
                                }
                                tmpMap = null;
                                tmpMap = dimMemMap.get(key);
                                if (tmpMap == null) {
                                    tmpMap = new HashMap<String, Set<String>>();
                                    dimMemMap.put(key, tmpMap);
                                }
                                if ((dimMembers = tmpMap.get(dimNum)) == null) {
                                    dimMembers = new HashSet<String>();
                                    tmpMap.put(dimNum, dimMembers);
                                }
                                dimMembers.add(number);
                            }
                        }
                    }
                }
            }
        }
    }

    private String getDimNumberBySrc(String srcNumber) {
        if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_ORGUNIT_NUMBER;
        }
        if (DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_ELEMENT_NUMBER;
        }
        if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_PERIOD_NUMBER;
        }
        if (DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_SCENARIO_NUMBER;
        }
        if (DimensionConstants.DEF_VERSION_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_VERSION_NUMBER;
        }
        if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_ACCOUNT_NUMBER;
        }
        if (DimensionConstants.DEF_CURRENCY_SRCNUMBER.equals(srcNumber)) {
            return DimensionConstants.DEF_CURRENCY_NUMBER;
        }
        return null;
    }

    private void parseScopeMem(Map<String, Map<String, Set<String>>> dimMemMap) {
        HashMap scopeMap = new HashMap();
        Map<String, BgDimensionInfo> ref_dim = this.schemeHelper.getDimensionByRefField();
        ref_dim.put(BgProcessHelper.DEF_PROCESS_FIELD, BgProcessHelper.getDimension());
        BgScopeInfo scope = null;
        if (this.bizScopeMap != null && !this.bizScopeMap.isEmpty()) {
            String dimNumber = null;
            String memberNumber = null;
            if (!dimMemMap.containsKey(DEFAULT_BG_SCHMEM)) {
                dimMemMap.put(DEFAULT_BG_SCHMEM, scopeMap);
            }
            for (Map<String, BgScopeCollection> subSetScope : this.bizScopeMap.values()) {
                if (subSetScope == null) continue;
                for (BgScopeCollection scopes : subSetScope.values()) {
                    if (scopes == null) continue;
                    for (int i = 0; i < scopes.size(); ++i) {
                        scope = scopes.get(i);
                        if (!ref_dim.containsKey(scope.getRefField())) continue;
                        dimNumber = ref_dim.get(scope.getRefField()).getNumber();
                        if (!dimMemMap.get(DEFAULT_BG_SCHMEM).containsKey(dimNumber)) {
                            scopeMap.put(dimNumber, new HashSet());
                            dimMemMap.get(DEFAULT_BG_SCHMEM).putAll(scopeMap);
                        }
                        if (BgMemberSelectTypeEnum.Member.equals((Object)scope.getBizDataType())) {
                            memberNumber = dimNumber.equals(BgProcessHelper.DEF_PROCESS_NUMBER) ? scope.getBgMemberNum() : this.splitScopeBgMemberNum(dimNumber, scope.getBgMemberNum());
                            dimMemMap.get(DEFAULT_BG_SCHMEM).get(dimNumber).add(memberNumber);
                            continue;
                        }
                        if (BgMemberSelectTypeEnum.Variate.equals((Object)scope.getBizDataType())) {
                            memberNumber = this.bizBgVariateMap.get(scope.getBgMemberNum());
                            if (this.schemeHelper.getDimensionBySrcNumber().get(memberNumber.split(":")[0]) == null) continue;
                            dimMemMap.get(DEFAULT_BG_SCHMEM).get(dimNumber).add(memberNumber.split(":")[1]);
                            continue;
                        }
                        if (!BgMemberSelectTypeEnum.Function.equals((Object)scope.getBizDataType())) continue;
                        Set<String> numbers = MbgFunctionHelper.getMemNumByScopeMemFunction(scope.getBgMemberNum());
                        for (String number : numbers) {
                            if (number.indexOf(":") > 0) {
                                if (BgPeriodNVariableHelper.checkCanConvert((String)number)) continue;
                                dimMemMap.get(DEFAULT_BG_SCHMEM).get(dimNumber).add(this.getMemberNumber(number.split(":")));
                                continue;
                            }
                            memberNumber = this.bizBgVariateMap.get(number);
                            dimMemMap.get(DEFAULT_BG_SCHMEM).get(dimNumber).add(memberNumber);
                        }
                    }
                }
            }
        }
    }

    private String splitScopeBgMemberNum(String dimNumber, String bgMemberNum) {
        if (!(dimNumber.equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimNumber.equals(DimensionConstants.DEF_SCENARIO_NUMBER) || dimNumber.equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimNumber.equals(DimensionConstants.DEF_VERSION_NUMBER) || dimNumber.equals(DimensionConstants.DEF_CURRENCY_NUMBER) || dimNumber.equals(DimensionConstants.DEF_ELEMENT_NUMBER))) {
            return bgMemberNum.split(":")[1];
        }
        return bgMemberNum;
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Set<String>>> parseLogicalExpr(IBizExpr expr, Set<String> scopeSrc, boolean isRemember, Map<String, Map<String, String>> dimNumberMap) {
        ArrayList<Map<String, Set<String>>> lineMembers = new ArrayList<Map<String, Set<String>>>();
        Stack exprStack = expr.getExpr();
        boolean left = true;
        Object leftOper = null;
        ArrayList<Operand> leftOperList = new ArrayList<Operand>();
        ArrayList<Operand> rightOperList = new ArrayList<Operand>();
        for (Object obj : exprStack) {
            if (obj instanceof AbstractOper) {
                if (!BgExamineExprChecker.LEGAL_OPER.contains(((AbstractOper)obj).getOper())) continue;
                left = false;
                continue;
            }
            if (left) {
                leftOperList.add((Operand)obj);
                continue;
            }
            rightOperList.add((Operand)obj);
        }
        List<Map<String, Set<String>>> leftMemberList = this.getDimMemberList(leftOperList, false);
        List<Map<String, Set<String>>> rightMemberList = this.getDimMemberList(rightOperList, false);
        lineMembers.addAll(leftMemberList);
        if (rightMemberList != null && !rightMemberList.isEmpty()) {
            lineMembers.addAll(rightMemberList);
        }
        if (leftMemberList == null || leftMemberList.size() == 0 && rightMemberList == null || rightMemberList.size() == 0) {
            return lineMembers;
        }
        boolean isExistDim = false;
        if (!leftMemberList.isEmpty()) {
            Map<String, Set<String>> leftFistMemberMap = leftMemberList.get(0);
            HashSet<String> leftFirstMemberSet = new HashSet<String>();
            Set<String> leftTmpMemberSet = null;
            for (Map.Entry<String, Set<String>> entry : leftFistMemberMap.entrySet()) {
                leftTmpMemberSet = entry.getValue();
                for (String string : leftTmpMemberSet) {
                    leftFirstMemberSet.add(string.split(":")[0]);
                }
            }
            if (leftMemberList.size() > 1) {
                for (int j = 1; j < leftMemberList.size(); ++j) {
                    Map<String, Set<String>> leftMemberMap = leftMemberList.get(j);
                    for (Map.Entry entry : leftMemberMap.entrySet()) {
                        Set leftMemberSet = (Set)entry.getValue();
                        for (String leftMember : leftMemberSet) {
                            String dimSrc = leftMember.split(":")[0];
                            if (!leftFirstMemberSet.contains(dimSrc)) continue;
                            isExistDim = true;
                        }
                    }
                    if (isExistDim || !isRemember) continue;
                    this.recordException(BgExamineParseException.ERROR_NOT_EQUAL_IN_LEFT, ((Operand)leftOperList.get(j)).getOperand());
                }
            }
        }
        int constantsCount = 0;
        for (int j = 0; j < leftMemberList.size(); ++j) {
            Map<String, Set<String>> leftMemberMap = leftMemberList.get(j);
            for (Map.Entry<String, Set<String>> entry : leftMemberMap.entrySet()) {
                String bgScheme = entry.getKey();
                Set<String> set = entry.getValue();
                for (String leftMember : set) {
                    Map<String, Set<String>> rightMemberMap;
                    String dimSrc = leftMember.split(":")[0];
                    String beginPeriodStr = "";
                    String endPeriodStr = "";
                    for (int i = 0; i < rightMemberList.size() && (rightMemberMap = rightMemberList.get(i)) != null; ++i) {
                        HashSet<String> tempSet = new HashSet<String>();
                        for (Map.Entry<String, Set<String>> memberEntry : rightMemberMap.entrySet()) {
                            String bgSchemeRight = memberEntry.getKey();
                            Set<String> rightMemberSet = memberEntry.getValue();
                            if (rightMemberSet.size() == 1) {
                                Object member = null;
                                for (String o : rightMemberSet) {
                                    member = o;
                                }
                                if (BizParseHelper.isNum(member)) {
                                    ++constantsCount;
                                    rightMemberSet.remove(member);
                                    lineMembers.remove(memberEntry);
                                }
                            }
                            for (String string : rightMemberSet) {
                                String[] member = string.split(":");
                                String src = member[0];
                                String number = this.getMemberNumber(member);
                                tempSet.add(src + ":" + number);
                                if (src.equals("BgP1")) {
                                    beginPeriodStr = number;
                                    continue;
                                }
                                if (!src.equals("BgP2")) continue;
                                endPeriodStr = number;
                            }
                            if (((Operand)leftOperList.get(0)).toString().indexOf("Lead") == -1 && set.size() == rightMemberSet.size() && tempSet.containsAll(set) && bgScheme.equals(bgSchemeRight) && isRemember && ((Operand)rightOperList.get(i)).toString().indexOf("Lead") == -1) {
                                this.recordException(BgExamineParseException.ERROR_EXPR_SAME, ((Operand)rightOperList.get(i)).getOperand());
                            }
                            boolean hasDim = false;
                            if (bgSchemeRight.equals(bgScheme)) {
                                if (rightMemberSet == null || rightMemberSet.size() <= 0) continue;
                                for (String rightMember : rightMemberSet) {
                                    if (rightMember.startsWith(dimSrc)) {
                                        hasDim = true;
                                        continue;
                                    }
                                    if (!dimSrc.equals("BgP1") && !dimSrc.equals("BgP2") || !rightMember.startsWith("BgP1") && !rightMember.startsWith("BgP2") && !rightMember.startsWith(DimensionConstants.DEF_PERIOD_SRCNUMBER)) continue;
                                    hasDim = true;
                                }
                                if (hasDim || !isRemember) continue;
                                this.recordException(BgExamineParseException.ERROR_EXPR_LESS, ((Operand)rightOperList.get(i)).getOperand());
                                continue;
                            }
                            HashSet<String> hashSet = new HashSet<String>();
                            Set<Object> keySetRight = new HashSet();
                            HashMap<String, String> srcMap = new HashMap<String, String>();
                            DimUtils.putCommSrcField(srcMap);
                            if (dimNumberMap != null && !srcMap.containsKey(dimSrc)) {
                                void var34_48;
                                List<String> dimNumber;
                                if (dimNumberMap.isEmpty()) {
                                    if (bgScheme.equals(DEFAULT_BG_SCHMEM)) {
                                        dimNumber = this.schemeHelper.getAccAndOtherDim(true);
                                        for (String number : dimNumber) {
                                            hashSet.add(this.schemeHelper.getSrcNumber(number));
                                        }
                                    }
                                    if (bgSchemeRight.equals(DEFAULT_BG_SCHMEM)) {
                                        dimNumber = this.schemeHelper.getAccAndOtherDim(true);
                                        for (String number : dimNumber) {
                                            keySetRight.add(this.schemeHelper.getSrcNumber(number));
                                        }
                                    }
                                } else {
                                    if (bgScheme.equals(DEFAULT_BG_SCHMEM)) {
                                        dimNumber = this.schemeHelper.getAccAndOtherDim(true);
                                        for (String number : dimNumber) {
                                            hashSet.add(this.schemeHelper.getSrcNumber(number));
                                        }
                                    } else if (dimNumberMap.get(bgScheme) != null) {
                                        Set<String> set2 = dimNumberMap.get(bgScheme).keySet();
                                    }
                                    if (bgSchemeRight.equals(DEFAULT_BG_SCHMEM)) {
                                        dimNumber = this.schemeHelper.getAccAndOtherDim(true);
                                        for (String number : dimNumber) {
                                            keySetRight.add(this.schemeHelper.getSrcNumber(number));
                                        }
                                    } else if (dimNumberMap.get(bgSchemeRight) != null) {
                                        keySetRight = dimNumberMap.get(bgSchemeRight).keySet();
                                    }
                                }
                                if (!var34_48.contains(dimSrc) || !keySetRight.contains(dimSrc) || rightMemberSet == null || rightMemberSet.size() <= 0) continue;
                                for (String rightMember : rightMemberSet) {
                                    if (!rightMember.startsWith(dimSrc)) continue;
                                    hasDim = true;
                                }
                                if (hasDim || !isRemember) continue;
                                this.recordException(BgExamineParseException.ERROR_EXPR_LESS, ((Operand)rightOperList.get(i)).getOperand());
                                continue;
                            }
                            if (rightMemberSet == null || rightMemberSet.size() <= 0) continue;
                            for (String rightMember : rightMemberSet) {
                                if (!rightMember.startsWith(dimSrc)) continue;
                                hasDim = true;
                            }
                            if (hasDim || !isRemember) continue;
                            this.recordException(BgExamineParseException.ERROR_EXPR_LESS, ((Operand)rightOperList.get(i)).getOperand());
                        }
                        if (!BizPtoUtils.checkBeginAndEndPeriodType((String)beginPeriodStr, (String)endPeriodStr)) {
                            this.recordException(BgExamineParseException.ERROR_PERIODTYPENOTEQUAL, ((Operand)rightOperList.get(i)).getOperand());
                        }
                        if (BizPtoUtils.checkBeginPeriodBeforeEndPeriod((String)beginPeriodStr, (String)endPeriodStr)) continue;
                        this.recordException(BgExamineParseException.ERROR_PERIODCOMPARE, ((Operand)rightOperList.get(i)).getOperand());
                    }
                    if (scopeSrc == null || !scopeSrc.contains(dimSrc)) continue;
                    this.recordException(BgExamineParseException.ERROR_SCOPE, ((Operand)leftOperList.get(j)).getOperand());
                }
            }
        }
        return lineMembers;
    }

    public void queryBgVariate() throws EASBizException, BOSException {
        if (!this.bizBgVariateMap.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("dimNumber");
            evi.getSelector().add("memberNumber");
            evi.getSelector().add("bgVariateClass");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.schemeHelper.getBgSchemeId(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(this.bizBgVariateMap.keySet()), CompareType.INCLUDE));
            IBgVariate iVar = null;
            iVar = this.schemeHelper.getContext() == null ? BgVariateFactory.getRemoteInstance() : BgVariateFactory.getLocalInstance(this.schemeHelper.getContext());
            BgVariateCollection col = iVar.getBgVariateCollection(evi);
            BgVariateInfo variate = null;
            Object srcNumber = null;
            Object sourceNumber = null;
            for (int i = 0; i < col.size(); ++i) {
                variate = col.get(i);
                String value = null;
                value = variate.getBgVariateClass().getValue() == 0 ? this.schemeHelper.getSrcNumber(variate.getDimNumber()) + ":" + variate.getMemberNumber() : variate.getMemberNumber();
                this.bizBgVariateMap.put(variate.getNumber(), value);
            }
            this.bizBgVariateMap.put("NULL", "0");
        }
    }

    private void parseScopeVariate() {
        if (this.bizScopeMap == null) {
            return;
        }
        for (String bizName : this.bizScopeMap.keySet()) {
            if (this.parsedSet != null && this.parsedSet.contains(bizName)) continue;
            Map<String, BgScopeCollection> subsetScope = this.bizScopeMap.get(bizName);
            if (subsetScope == null) {
                return;
            }
            for (String subsetName : subsetScope.keySet()) {
                BgScopeCollection scopes = subsetScope.get(subsetName);
                if (scopes == null || scopes.isEmpty()) {
                    return;
                }
                BgScopeInfo scope = null;
                String src = null;
                for (int i = 0; i < scopes.size(); ++i) {
                    scope = scopes.get(i);
                    src = this.schemeHelper.getSrcNumberByRefField(scope.getRefField());
                    if (BgMemberSelectTypeEnum.Variate.equals((Object)scope.getBizDataType())) {
                        this.addToVirateMap(scope.getBgMemberNum(), src);
                        continue;
                    }
                    if (!BgMemberSelectTypeEnum.Function.equals((Object)scope.getBizDataType())) continue;
                    Set<String> numbers = MbgFunctionHelper.getMemNumByScopeMemFunction(scope.getBgMemberNum());
                    for (String number : numbers) {
                        if (number.indexOf(":") >= 0) continue;
                        this.addToVirateMap(number, src);
                    }
                }
            }
        }
    }

    private void parseExprVariate() {
        for (String bizName : this.exprMap.keySet()) {
            Map<String, Map<Integer, List<IBizExpr>>> subsetMap;
            if (this.parsedSet != null && this.parsedSet.contains(bizName) || (subsetMap = this.exprMap.get(bizName)) == null) continue;
            for (String subsetName : subsetMap.keySet()) {
                Map<Integer, List<IBizExpr>> lineMap = subsetMap.get(subsetName);
                if (lineMap == null) continue;
                for (Integer line : lineMap.keySet()) {
                    List<IBizExpr> exprList = lineMap.get(line);
                    if (exprList == null) continue;
                    for (IBizExpr expr : exprList) {
                        Stack exprStack = expr.getExpr();
                        for (Object obj : exprStack) {
                            Stack absStack;
                            String subFormula;
                            if (!(obj instanceof Operand)) continue;
                            Operand operand = (Operand)obj;
                            String formula = operand.getOperand();
                            if (BizParseHelper.isVAR((String)formula)) {
                                String member = formula.substring(formula.indexOf("\"") + 1, formula.lastIndexOf("\""));
                                this.addToVirateMap(member, "");
                                continue;
                            }
                            if (!BizParseHelper.isMathFX((String)formula) && !BizParseHelper.isBoolFX((String)formula)) continue;
                            String formulaName = BizCalcCommonHelper.getFunctionName((String)formula);
                            if (formulaName.equals("@MAX") || formulaName.equals("@MIN") || formulaName.equals("@AVG") || formulaName.equals("@IsMember")) {
                                subFormula = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
                                if (!subFormula.startsWith("VAR:")) continue;
                                String[] members = formula.substring(formula.indexOf("\"") + 1, formula.lastIndexOf("\"")).split(",");
                                for (int i = 0; i < members.length; ++i) {
                                    this.addToVirateMap(members[i], null);
                                }
                                continue;
                            }
                            subFormula = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
                            BizParseParam param = new BizParseParam();
                            param.setText(subFormula);
                            BizExprParser parser2 = new BizExprParser(param);
                            parser2.setRecordExc(false);
                            if (!parser2.parse() || (absStack = parser2.getExprStack()) == null) continue;
                            for (Object absOper : absStack) {
                                if (!(absOper instanceof Operand) || !BizParseHelper.isVAR((String)((Operand)absOper).getOperand())) continue;
                                String member = formula.substring(formula.indexOf("\"") + 1, formula.lastIndexOf("\""));
                                this.addToVirateMap(member, "");
                            }
                        }
                    }
                }
            }
        }
    }

    private String getMemberNumber(String[] member) {
        if (member.length == 1) {
            return member[0];
        }
        String number = member[1];
        if (member.length == 3 && "VAR".equals(number)) {
            number = this.bizBgVariateMap.get(member[2]);
        }
        return number;
    }

    private String getSrcMemberNumber(String[] member) {
        if (member.length == 1) {
            return member[0];
        }
        String src = member[0];
        String number = member[1];
        if ("VAR".equals(src)) {
            return number;
        }
        return src + ":" + number;
    }

    public List<String> replaceVAR2MBR(List<String> members, boolean isRecordVar) {
        ArrayList<String> mbrList = new ArrayList<String>();
        for (int i = 0; i < members.size(); ++i) {
            String number = members.get(i);
            mbrList.add(this.bizBgVariateMap.get(number));
        }
        return mbrList;
    }

    public void addToVirateMap(String number, String src) {
        this.bizBgVariateMap.put(number, "VAR:" + number);
    }

    public List<Map<String, Set<String>>> getDimMemberList(List<Operand> rightOperList, boolean isRecordVar) {
        ArrayList<Map<String, Set<String>>> memberList = new ArrayList<Map<String, Set<String>>>();
        HashMap<String, Set<String>> dimMemberMap = null;
        Object memberSet = null;
        if (rightOperList != null) {
            Iterator<Operand> iterator = rightOperList.iterator();
            while (iterator.hasNext()) {
                Operand obj;
                Operand leftOper = obj = iterator.next();
                dimMemberMap = new HashMap<String, Set<String>>();
                this.getDimMemberSet(leftOper, false, isRecordVar, dimMemberMap);
                if (dimMemberMap == null || dimMemberMap.size() == 0) continue;
                memberList.add(dimMemberMap);
            }
        }
        return memberList;
    }

    protected Map<String, Set<String>> processLead(Operand leftOper, boolean multiMem, boolean isRecordVar, Map<String, Set<String>> dimMemberMap) {
        HashSet<String> funMemberSet = new HashSet<String>();
        String bgScheme = null;
        boolean hasBgScheme = false;
        String tempMember = leftOper.getOperand().substring(leftOper.getOperand().indexOf("[") + 1, leftOper.getOperand().length() - 1);
        String[] tmpStrs = MemberProxy.splitMemberString((String)tempMember);
        String dimMem = null;
        int length = tmpStrs.length;
        for (int i = 0; i < length; ++i) {
            if (tmpStrs[i] == null) continue;
            int len = tmpStrs[i].length();
            dimMem = tmpStrs[i].substring(1, len - 1);
            if (dimMem.indexOf("Sch") != -1) {
                bgScheme = dimMem.split(":")[1];
                if (dimMemberMap.containsKey(bgScheme)) {
                    dimMemberMap.get(bgScheme).addAll(funMemberSet);
                } else {
                    dimMemberMap.put(bgScheme, funMemberSet);
                }
                hasBgScheme = true;
                continue;
            }
            if (dimMem.indexOf("FX:[") == -1) {
                funMemberSet.add(dimMem);
                continue;
            }
            if (dimMem.indexOf("BgP") == -1) continue;
            dimMem = dimMem.split(",")[1].substring(1, dimMem.split(",")[1].length() - 3);
            funMemberSet.add(dimMem);
        }
        if (!hasBgScheme) {
            if (dimMemberMap.containsKey(DEFAULT_BG_SCHMEM)) {
                dimMemberMap.get(DEFAULT_BG_SCHMEM).addAll(funMemberSet);
            } else {
                dimMemberMap.put(DEFAULT_BG_SCHMEM, funMemberSet);
            }
        }
        return dimMemberMap;
    }

    protected Map<String, Set<String>> processParent(Operand leftOper, boolean multiMem, boolean isRecordVar, Map<String, Set<String>> dimMemberMap) {
        HashSet<String> funMemberSet = new HashSet<String>();
        String bgScheme = null;
        boolean hasBgScheme = false;
        String tempMember = leftOper.getOperand().substring(leftOper.getOperand().indexOf("[") + 1, leftOper.getOperand().length() - 1);
        String[] tmpStrs = MemberProxy.splitMemberString((String)tempMember);
        String dimMem = null;
        int length = tmpStrs.length;
        for (int i = 0; i < length; ++i) {
            if (tmpStrs[i] == null) continue;
            int len = tmpStrs[i].length();
            dimMem = tmpStrs[i].substring(1, len - 1);
            if (dimMem.indexOf("Sch") != -1) {
                bgScheme = dimMem.split(":")[1];
                if (dimMemberMap.containsKey(bgScheme)) {
                    dimMemberMap.get(bgScheme).addAll(funMemberSet);
                } else {
                    dimMemberMap.put(bgScheme, funMemberSet);
                }
                hasBgScheme = true;
                continue;
            }
            if (dimMem.indexOf("FX:[") == -1) {
                funMemberSet.add(dimMem);
                continue;
            }
            if (dimMem.indexOf("Cos") == -1) continue;
            dimMem = dimMem.split(",")[1].substring(1, dimMem.split(",")[1].length() - 3);
            funMemberSet.add(dimMem);
        }
        if (!hasBgScheme) {
            if (dimMemberMap.containsKey(DEFAULT_BG_SCHMEM)) {
                dimMemberMap.get(DEFAULT_BG_SCHMEM).addAll(funMemberSet);
            } else {
                dimMemberMap.put(DEFAULT_BG_SCHMEM, funMemberSet);
            }
        }
        return dimMemberMap;
    }

    public Map<String, Set<String>> getDimMemberSet(Operand leftOper, boolean multiMem, boolean isRecordVar, Map<String, Set<String>> dimMemberMap) {
        HashSet<Object> memberSet = new HashSet();
        String bgScheme = null;
        if (leftOper != null && (leftOper.getOperand().startsWith("MBR") || leftOper.getOperand().startsWith("PTO"))) {
            if (leftOper.getOperand().indexOf("Lead") != -1) {
                dimMemberMap = this.processLead(leftOper, multiMem, isRecordVar, dimMemberMap);
            } else if (leftOper.getOperand().indexOf("Parent") != -1) {
                dimMemberMap = this.processParent(leftOper, multiMem, isRecordVar, dimMemberMap);
            } else if (!multiMem) {
                String[] members = leftOper.getOperand().split("\\[")[1].split("\\]")[0].split(",");
                memberSet = new HashSet<String>(BgExamineParseDimMemHelper.trimQuotation(members));
                if (leftOper.getOperand().indexOf("Sch:") != -1) {
                    String bgSchemeStr = members[0].split("\"")[1];
                    bgScheme = bgSchemeStr.split(":")[1];
                    memberSet.remove(bgSchemeStr);
                    if (dimMemberMap.containsKey(bgScheme)) {
                        dimMemberMap.get(bgScheme).addAll(memberSet);
                    } else {
                        dimMemberMap.put(bgScheme, memberSet);
                    }
                } else if (dimMemberMap.containsKey(DEFAULT_BG_SCHMEM)) {
                    dimMemberMap.get(DEFAULT_BG_SCHMEM).addAll(memberSet);
                } else {
                    dimMemberMap.put(DEFAULT_BG_SCHMEM, memberSet);
                }
            } else {
                memberSet = new HashSet<String>(BgExamineParseDimMemHelper.processMultiMem(leftOper.getOperand().split("\"")[1].split("\"")[0]));
            }
        } else if (leftOper != null && leftOper.getOperand().startsWith("VAR")) {
            if (!multiMem) {
                String operand = leftOper.getOperand();
                String[] members = operand.substring(operand.indexOf("\"") + 1, operand.lastIndexOf("\"")).split(",");
                List<String> memberList = this.replaceVAR2MBR(Arrays.asList(members), isRecordVar);
                memberSet = new HashSet<String>(memberList);
            } else {
                String operand = leftOper.getOperand();
                String[] members = operand.substring(operand.indexOf("\"") + 1, operand.lastIndexOf("\"")).split(",");
                List<String> memberList = this.replaceVAR2MBR(Arrays.asList(members), isRecordVar);
                if (!this.checkVarHasSameSrc(memberList)) {
                    this.recordException(BgExamineParseException.ERROR_EXPR_SAMESRC, leftOper.getOperand());
                }
                memberSet = new HashSet<String>(memberList);
            }
            dimMemberMap.put(DEFAULT_BG_SCHMEM, memberSet);
        } else if (BizParseHelper.isNum((String)leftOper.getOperand())) {
            // empty if block
        }
        return dimMemberMap;
    }

    public static List<String> trimQuotation(String[] members) {
        ArrayList<String> mbrList = new ArrayList<String>();
        for (int i = 0; i < members.length; ++i) {
            String member;
            if ("\"\"".equals(members[i]) || !(member = members[i].split("\"")[1]).contains(":")) continue;
            mbrList.add(member);
        }
        return mbrList;
    }

    public static List<String> processMultiMem(String multiMemStr) {
        ArrayList<String> mbrList = new ArrayList<String>();
        String[] srcMembers = multiMemStr.split(":");
        String srcNum = srcMembers[0];
        String[] membersNum = srcMembers[1].split(",");
        for (int i = 0; i < membersNum.length; ++i) {
            mbrList.add(srcNum + ":" + membersNum[i]);
        }
        return mbrList;
    }

    protected static boolean isFX(String currExpr) {
        return BizParseHelper.isFX((String)currExpr);
    }

    protected static boolean isBoolFX(String currExpr) {
        return BizParseHelper.isBoolFX((String)currExpr);
    }

    protected static boolean isMathFX(String currExpr) {
        return BizParseHelper.isMathFX((String)currExpr);
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BgExamineParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(this.bizName, this.subsetName, this.line));
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq, String bizName, String subsetName, Integer currLine) {
        BgExamineParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(bizName, subsetName, currLine));
    }

    private void recordException(NumericExceptionSubItem excSubItem, Object[] exceptionParam, String bizName, String subsetName, Integer currLine) {
        BgExamineParseExceptionHandler.recordException(excSubItem, exceptionParam, this.createParam(bizName, subsetName, currLine));
    }

    private BizParseParam createParam(String bizName, String subsetName, Integer currLine) {
        BizParseParam param = new BizParseParam();
        param.setCurrLine(currLine);
        param.setBizName(bizName);
        param.setSubsetName(subsetName);
        param.setAllExceptions(this.allExceptions);
        return param;
    }
}

