/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.expr.oper.OperationType;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.mbg.BizFunctionType;
import com.kingdee.eas.ma.mbg.function.define.MbgFunctionSourceFactory;
import com.kingdee.eas.ma.mbg.parse.BgExamineParseHelper;
import com.kingdee.util.NumericExceptionSubItem;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Parse2RPN {
    String subsetName = null;
    private int line;
    private Stack expr = null;
    private Stack operators = new Stack();
    private Stack operand = new Stack();
    private Stack rpnTypeExpr = new Stack();
    private Object token = null;
    private Map<String, List<String>> fnMap = null;
    private List<String> memberFn = null;
    private List<String> mathFn = null;
    private List<String> boolFn = null;
    private List<String> aggFn = null;
    private final char SPACE = (char)32;
    private final char TAB = (char)9;
    private final char ENTER = (char)13;
    private final char LINE_FEED = (char)10;
    private static final Set<Integer> LOGIC_OPER = new HashSet<Integer>();
    private static final Set<Integer> MATH_OPER = new HashSet<Integer>();
    private static final Set<Integer> COMPARE_OPER = new HashSet<Integer>();

    public Parse2RPN(String subsetName, int line, Stack expr) {
        this.subsetName = subsetName;
        this.line = line;
        this.expr = new Stack();
        while (expr != null && !expr.isEmpty()) {
            this.expr.push(expr.pop());
        }
    }

    private void readToken() {
        this.token = this.expr.pop();
    }

    public void parse() throws BizCalcParseException {
        this.init();
        try {
            while (!this.expr.isEmpty()) {
                this.readToken();
                if (this.token instanceof Operand) {
                    this.operand.push(this.token);
                    continue;
                }
                AbstractOper oper = (AbstractOper)this.token;
                Object top = null;
                if (oper.getOper().equals("(")) {
                    this.operators.push(oper);
                    continue;
                }
                if (oper.getOper().equals(")")) {
                    this.pushUntilLeftParen();
                    continue;
                }
                if (this.operators.isEmpty() || ((AbstractOper)this.operators.peek()).getSID() == 1 || OperationType.comparePRI((int)oper.getSID(), (int)((AbstractOper)this.operators.peek()).getSID()) > 0) {
                    this.operators.push(oper);
                    continue;
                }
                this.pushUntilPRIChangeOrLeftParen(oper);
            }
            while (!this.operators.isEmpty()) {
                this.operand.push(this.operators.pop());
            }
        }
        catch (Exception e) {
            this.throwException(BizCalcParseException.ERROR_EXPR);
        }
    }

    private void pushUntilLeftParen() {
        AbstractOper top = null;
        while (!this.operators.isEmpty() && 1 != (top = (AbstractOper)this.operators.pop()).getSID()) {
            this.operand.push(top);
        }
    }

    private void pushUntilPRIChangeOrLeftParen(AbstractOper oper) {
        AbstractOper top = null;
        while (!this.operators.isEmpty()) {
            top = (AbstractOper)this.operators.peek();
            if (1 == top.getSID() || OperationType.comparePRI((int)oper.getSID(), (int)top.getSID()) > 0) {
                this.operators.push(oper);
                return;
            }
            AbstractOper pop = (AbstractOper)this.operators.pop();
            if (1 == pop.getSID()) continue;
            this.operand.push(top);
        }
        this.operators.push(oper);
    }

    public Stack getExprStack() {
        return this.operators;
    }

    public String getExprReturnType() throws BizCalcParseException {
        this.preocessOperand();
        Stack<String> tmpStack = new Stack<String>();
        Object obj = null;
        try {
            while (!this.rpnTypeExpr.isEmpty()) {
                obj = this.rpnTypeExpr.pop();
                if (obj instanceof String) {
                    tmpStack.push(obj);
                    continue;
                }
                this.calcReturnType(tmpStack, obj);
            }
        }
        catch (Exception e) {
            this.throwException(BizCalcParseException.ERROR_EXPR, (Object)obj);
        }
        if (tmpStack.size() != 1) {
            this.throwException(BizCalcParseException.ERROR_EXPR, (Object)obj);
        }
        return (String)tmpStack.pop();
    }

    private void preocessOperand() {
        Object obj = null;
        while (!this.operand.isEmpty()) {
            obj = this.operand.pop();
            if (obj instanceof AbstractOper) {
                this.rpnTypeExpr.push(obj);
                continue;
            }
            this.rpnTypeExpr.push(this.getOperandReturnType((Operand)obj));
        }
    }

    private void calcReturnType(Stack<String> tmpOperandStack, AbstractOper oper) throws BizCalcParseException {
        int operNum = this.getOperNum(oper);
        if (operNum == 1 && oper.getSID() == 21) {
            String operand = tmpOperandStack.pop();
            if (operand.equals("boolean")) {
                tmpOperandStack.push("boolean");
            } else {
                this.throwException(BizCalcParseException.ERROR_EXPR, oper);
            }
        } else {
            int SID = oper.getSID();
            String operand1 = tmpOperandStack.pop();
            String operand2 = tmpOperandStack.pop();
            if (oper.getSID() == 20) {
                if (operand1.equals("numeric") && operand2.equals("numeric")) {
                    tmpOperandStack.push("other");
                } else {
                    this.throwException(BizCalcParseException.ERROR_EXPR, oper);
                }
            } else if (LOGIC_OPER.contains(SID)) {
                if (operand1.equals("boolean") && operand2.equals("boolean")) {
                    tmpOperandStack.push("boolean");
                } else {
                    this.throwException(BizCalcParseException.ERROR_EXPR, oper);
                }
            } else if (MATH_OPER.contains(SID)) {
                if (operand1.equals("numeric") && operand2.equals("numeric")) {
                    tmpOperandStack.push("numeric");
                } else {
                    this.throwException(BizCalcParseException.ERROR_EXPR, oper);
                }
            } else if (COMPARE_OPER.contains(SID)) {
                if (operand1.equals("numeric") && operand2.equals("numeric")) {
                    tmpOperandStack.push("boolean");
                } else {
                    this.throwException(BizCalcParseException.ERROR_EXPR, oper);
                }
            } else {
                this.throwException(BizCalcParseException.ERROR_EXPR, oper);
            }
        }
    }

    protected Object getOperandReturnType(Operand token) {
        if (BgExamineParseHelper.isMBR(token.getOperand()) || BizParseHelper.isVAR((String)token.getOperand()) || BizParseHelper.isGVF((String)token.getOperand()) || BizParseHelper.isIf((String)token.getOperand()) || BizParseHelper.isPTO((String)token.getOperand())) {
            return "numeric";
        }
        if (BizParseHelper.isFX((String)token.getOperand())) {
            String fnName = BizCalcCommonHelper.getFunctionName((String)token.getOperand());
            if (this.memberFn != null && this.memberFn.contains(fnName) || this.mathFn != null && this.mathFn.contains(fnName)) {
                return "numeric";
            }
            if (this.boolFn != null && this.boolFn.contains(fnName)) {
                return "boolean";
            }
            return "other";
        }
        if (token.getOperand().matches("-?([\\d]+\\.?)*[\\d]+\\%?")) {
            return "numeric";
        }
        return "other";
    }

    private int getOperNum(AbstractOper oper) {
        return oper.getSID() == 21 ? 1 : 2;
    }

    private void throwException(NumericExceptionSubItem excSubItem, Object[] parmas) throws BizCalcParseException {
        throw new BizCalcParseException(excSubItem, parmas);
    }

    private void throwException(NumericExceptionSubItem excSubItem, Object charSeq) throws BizCalcParseException {
        throw new BizCalcParseException(excSubItem, new Object[]{this.subsetName, this.line, charSeq});
    }

    private void throwException(NumericExceptionSubItem excSubItem) throws BizCalcParseException {
        throw new BizCalcParseException(excSubItem, new Object[]{this.subsetName, this.line, this.token});
    }

    private void init() {
        this.fnMap = MbgFunctionSourceFactory.getInstance().getFunctionNameMap();
        this.memberFn = this.fnMap.get(BizFunctionType.MEMBER.getName());
        this.mathFn = this.fnMap.get(BizFunctionType.MATH.getName());
        this.boolFn = this.fnMap.get(BizFunctionType.BOOLEAN.getName());
        this.aggFn = this.fnMap.get(BizFunctionType.AGG.getName());
    }

    private boolean isBlank(char currChar) {
        return currChar == '\t' || currChar == '\r' || currChar == '\n' || currChar == ' ';
    }

    static {
        Collections.addAll(LOGIC_OPER, (Object[])new Integer[]{21, 22, 23});
        Collections.addAll(MATH_OPER, (Object[])new Integer[]{7, 8, 9, 10, 11, 12});
        Collections.addAll(COMPARE_OPER, (Object[])new Integer[]{13, 14, 15, 16, 17, 18});
    }
}

