/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.progress;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.progress.IProgressMonitor;
import com.kingdee.eas.ma.mbg.progress.IRunnableWithProgress;
import com.kingdee.eas.ma.mbg.progress.ProgressDialogHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ProgressDialog
extends KDDialog {
    private static final Logger logger = CoreUIObject.getLogger(ProgressDialog.class);
    private KDLabel labelTaskName;
    private KDLabel labelIcon;
    private KDProgressBar progressBar;
    private KDLabel subTaskName;
    private KDLabel labelTimer;
    private KDButton btnCancel;
    private IProgressMonitor monitor;
    private Actions actions = new Actions();
    private static final String COMMAND_CANCEL = "CANCEL";
    private boolean cancelable;
    private Timer timer;

    public ProgressDialog() {
        this.initUI();
    }

    public ProgressDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initUI();
    }

    public ProgressDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.initUI();
    }

    private void initUI() {
        this.labelTaskName = new KDLabel();
        this.progressBar = new KDProgressBar();
        this.subTaskName = new KDLabel();
        this.btnCancel = new KDButton();
        this.labelIcon = new KDLabel();
        this.labelTimer = new KDLabel();
        this.labelTaskName.setName("calculating");
        this.progressBar.setName("calcProgress");
        this.labelIcon.setIcon(EASResource.getIcon((String)"imgTbtn_help"));
        this.initUIContentLayout();
        this.monitor = new ProgressMonitor();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!ProgressDialog.this.cancelable) {
                    ProgressDialog.this.monitor.setCanceled(true);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (ProgressDialog.this.timer != null) {
                    ProgressDialog.this.timer.stop();
                }
            }
        });
    }

    private void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 350, 163));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.labelIcon.setBounds(new Rectangle(10, 8, 20, 20));
        this.getContentPane().add((Component)this.labelIcon, null);
        this.labelTaskName.setBounds(new Rectangle(30, 10, 250, 19));
        this.getContentPane().add((Component)this.labelTaskName, null);
        this.progressBar.setBounds(new Rectangle(10, 35, 329, 19));
        this.getContentPane().add((Component)this.progressBar, null);
        this.subTaskName.setBounds(new Rectangle(10, 62, 329, 19));
        this.getContentPane().add((Component)this.subTaskName, null);
        this.labelTimer.setBounds(new Rectangle(10, 85, 329, 19));
        this.getContentPane().add((Component)this.labelTimer, null);
        this.btnCancel.setBounds(new Rectangle(263, 109, 75, 19));
        this.btnCancel.setAction((Action)this.actions);
        this.btnCancel.setActionCommand(COMMAND_CANCEL);
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"37_ProgressDialog"));
        this.btnCancel.setMnemonic('C');
        this.getContentPane().add((Component)this.btnCancel, null);
    }

    public static ProgressDialog createProgressDialog(Component owner, boolean model) {
        Window ance = null;
        if (owner != null) {
            ance = SwingUtilities.getWindowAncestor(owner);
        }
        ProgressDialog dialog = null;
        if (ance == null) {
            dialog = new ProgressDialog();
        } else if (ance instanceof Dialog) {
            dialog = new ProgressDialog((Dialog)ance, model);
        } else if (ance instanceof Frame) {
            dialog = new ProgressDialog((Frame)ance, model);
        }
        return dialog;
    }

    public void setIcon(Icon icon) {
        this.labelIcon.setIcon(icon);
    }

    public void run(boolean cancelable, IRunnableWithProgress runable) {
        this.run(cancelable, false, runable);
    }

    public void run(boolean cancelable, boolean enableTimer, final IRunnableWithProgress runable) {
        this.cancelable = cancelable;
        if (!this.isDisplayable()) {
            if (!cancelable) {
                this.setUndecorated(true);
            } else {
                this.setUndecorated(false);
            }
        }
        this.btnCancel.setEnabled(cancelable);
        if (enableTimer) {
            this.labelTimer.setVisible(true);
            this.startTimer();
        } else {
            this.labelTimer.setVisible(false);
        }
        ProgressDialogHelper.setToScreenCenter((Window)((Object)this));
        Thread runner = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    runable.exec(ProgressDialog.this.monitor);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        });
        runner.start();
        this.show();
    }

    public void run4New(boolean cancelable, boolean enableTimer, final IRunnableWithProgress runable) {
        this.cancelable = cancelable;
        if (!cancelable) {
            WindowListener[] ls = this.getWindowListeners();
            for (int i = 0; i < ls.length; ++i) {
                this.removeWindowListener(ls[i]);
            }
        }
        this.btnCancel.setEnabled(cancelable);
        if (enableTimer) {
            this.labelTimer.setVisible(true);
            this.startTimer();
        } else {
            this.labelTimer.setVisible(false);
        }
        ProgressDialogHelper.setToScreenCenter((Window)((Object)this));
        Thread runner = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                try {
                    runable.exec(ProgressDialog.this.monitor);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        });
        runner.start();
        this.show();
    }

    protected void cancelPressed(ActionEvent e) {
        this.btnCancel.setEnabled(false);
        this.monitor.setCanceled(true);
    }

    private void startTimer() {
        this.labelTimer.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.passTime"));
        this.timer = new Timer(1000, new ActionListener(){
            long start = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                long end = System.currentTimeMillis();
                ProgressDialog.this.labelTimer.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.passTimeing") + ProgressDialogHelper.formatTime(end - this.start));
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    private class Actions
    extends AbstractAction {
        private Actions() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProgressDialog.COMMAND_CANCEL.equals(e.getActionCommand())) {
                ProgressDialog.this.cancelPressed(e);
            }
        }
    }

    class ProgressMonitor
    implements IProgressMonitor {
        private boolean isCancel = false;
        private int totalWork;

        ProgressMonitor() {
        }

        @Override
        public void beginTask(final String name, final int totalWork) {
            this.totalWork = totalWork;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.setTitle(name);
                    ProgressDialog.this.labelTaskName.setText(name);
                    if (totalWork < 0) {
                        ProgressDialog.this.progressBar.setIndeterminate(true);
                    }
                    ProgressDialog.this.progressBar.setMaximum(totalWork);
                    ProgressDialog.this.progressBar.setMinimum(0);
                }
            });
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProgressMonitor.this.totalWork < 0) {
                        ProgressDialog.this.progressBar.setIndeterminate(false);
                    }
                    if (ProgressDialog.this.timer != null) {
                        ProgressDialog.this.timer.stop();
                    }
                    ProgressDialog.this.dispose();
                }
            });
        }

        @Override
        public boolean isCanceled() {
            return this.isCancel;
        }

        @Override
        public void setCanceled(boolean value) {
            this.isCancel = value;
        }

        @Override
        public void setTaskName(String name) {
            ProgressDialog.this.labelTaskName.setText(name);
        }

        @Override
        public void subTaskBegin(String name) {
            ProgressDialog.this.subTaskName.setText(name);
        }

        @Override
        public void worked(int work) {
            if (this.totalWork >= 0) {
                ProgressDialog.this.progressBar.setValue(ProgressDialog.this.progressBar.getValue() + work);
            }
        }
    }
}

