/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.progress;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.client.utils.MbgCHelper;
import com.kingdee.eas.ma.mbg.progress.IProgressMonitor;
import com.kingdee.eas.ma.mbg.progress.IRunnableWithProgress;
import com.kingdee.eas.ma.mbg.progress.ProgressDialogNew;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ProgressDialogHelper {
    private static final Logger logger = CoreUIObject.getLogger(ProgressDialogHelper.class);
    private static Set<MonitorInfo> monitors = new HashSet<MonitorInfo>();

    public static ProgressDialogNew createProgressDialogNew(CoreUI owner, boolean model) {
        Window ance = null;
        if (owner != null) {
            ance = SwingUtilities.getWindowAncestor((Component)owner);
        }
        ProgressDialogNew dialog = null;
        if (ance == null) {
            dialog = new ProgressDialogNew();
        } else if (ance instanceof Dialog) {
            dialog = new ProgressDialogNew((Dialog)ance, model);
        } else if (ance instanceof Frame) {
            dialog = new ProgressDialogNew((Frame)ance, model);
        }
        if (dialog != null) {
            dialog.owner = owner;
        }
        return dialog;
    }

    public static void run(final IRunnableWithProgress runable, ProgressDialogNew dialogNew, final IProgressMonitor monitor, boolean canBackRun, boolean refreshUI) {
        if (!canBackRun) {
            Thread runner = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        runable.exec(monitor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            runner.start();
            dialogNew.show();
        } else {
            ProgressDialogHelper.runBack(runable, dialogNew, monitor, refreshUI);
        }
    }

    private static void runBack(final IRunnableWithProgress runable, final ProgressDialogNew dialogNew, final IProgressMonitor monitor, final boolean refreshUI) {
        final MonitorInfo info = new MonitorInfo(dialogNew.getWindowMsgTitle() + ": " + dialogNew.getUiTitle(), null, (Object)dialogNew, false);
        final SwingWorker worker = new SwingWorker(){
            private boolean stop = false;

            public Object construct() {
                while (dialogNew.isLoading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!refreshUI) continue;
                    MbgCHelper.getIntance().asyncRefreshListUI(dialogNew.owner);
                }
                return null;
            }

            public void finished() {
            }

            public void finishedLater() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
                if (dialogNew.isShowing()) {
                    dialogNew.dispose();
                }
            }
        };
        SwingWorker dataWorker = new SwingWorker(){
            Object result = null;

            public Object construct() {
                dialogNew.isLoading = true;
                try {
                    this.result = runable.exec(monitor);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
                dialogNew.isLoading = false;
                return this.result;
            }

            public void finished() {
                if (dialogNew.isShowing()) {
                    dialogNew.dispose();
                }
                if (this.result != null) {
                    try {
                        Thread.sleep(500L);
                        runable.afterExec(this.result);
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }
        };
        dataWorker.start();
        SwingWorker processBarWorker = new SwingWorker(){

            public Object construct() {
                if (monitor instanceof ProgressDialogNew.ProgressMonitor && ((ProgressDialogNew.ProgressMonitor)monitor).isEnd()) {
                    return null;
                }
                if (ProgressDialogHelper.show(dialogNew)) {
                    ProgressDialogHelper.hideWindow(dialogNew, true);
                    info.setWorker(worker);
                    ThreadPool.addActionThread((MonitorInfo)info);
                }
                return null;
            }
        };
        processBarWorker.start();
    }

    public static boolean isMonitorEnd(ProgressDialogNew progressDialogNew) {
        return progressDialogNew != null && progressDialogNew.getMonitor() != null && ((ProgressDialogNew.ProgressMonitor)progressDialogNew.getMonitor()).isEnd();
    }

    public static boolean addMonitor(MonitorInfo m) {
        return monitors.add(m);
    }

    public static boolean removeMonitor(MonitorInfo m) {
        return monitors.remove(m);
    }

    public static void destroyMonitorFromThreadPool(MonitorInfo m) {
        ThreadPool.destroyMonitor((MonitorInfo)m);
    }

    public static void destroyAllMonitorFromThreadPool() {
        if (monitors.size() > 0) {
            Iterator<MonitorInfo> it = monitors.iterator();
            while (it.hasNext()) {
                ProgressDialogHelper.destroyMonitorFromThreadPool(it.next());
            }
            monitors.clear();
        }
    }

    private static boolean show(ProgressDialogNew dialogNew) {
        if (dialogNew != null) {
            dialogNew.show();
            return dialogNew.goBackRunning();
        }
        return false;
    }

    private static void hideWindow(ProgressDialogNew dialogNew, boolean hide) {
        if (hide) {
            dialogNew.owner.getUIWindow().hide();
        } else {
            dialogNew.owner.getUIWindow().show();
            dialogNew.owner.requestFocus();
        }
    }

    public static void setToScreenCenter(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static String formatTime(long time) {
        StringBuffer sb = new StringBuffer();
        sb.append(ProgressDialogHelper.formatNumber((time /= 1000L) / 60L / 60L % 60L)).append(':').append(ProgressDialogHelper.formatNumber(time / 60L % 60L)).append(':').append(ProgressDialogHelper.formatNumber(time % 60L));
        return sb.toString();
    }

    private static String formatNumber(long t) {
        return t > 9L ? "" + t : "0" + t;
    }
}

