/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgGatherInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.common.AbstractBookParseHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.CalculateContext;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.IProviderUI;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public abstract class AbstractProvider<T extends IMbgViewBase, E extends IMbgSheetBase>
implements IProvider,
IGetSchemeHelper {
    private static final Logger logger = Logger.getLogger((String)AbstractProvider.class.getName());
    private Map<String, T> bgViewManagerForMulOrg = new HashMap<String, T>();
    protected T curMbgViewManager = null;
    protected E curMbgSheetManager = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private DimensionMemberCheckFactory checkFactory = null;
    protected IObjectValue model = null;
    protected Map<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
    private FullOrgUnitInfo orgUnitInfo = null;
    private CoreUIObject owner = null;
    private DimensionMemberFilterInfo memberFilter = new DimensionMemberFilterInfo();
    protected boolean isPreview = false;
    private String orgViewId = null;
    private Map formulaMap = null;
    private Context ctx = null;
    public String unionID = null;
    private List<BgGatherInfo> gatherInfos = new ArrayList<BgGatherInfo>();

    public Map<String, FullOrgUnitInfo> getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map getFormulaMap() {
        if (this.formulaMap == null) {
            this.formulaMap = this.getOwner() instanceof IBgNumberCellDisplayHelper ? ((IBgNumberCellDisplayHelper)this.getOwner()).getFormulaMap() : new WeakHashMap();
        }
        return this.formulaMap;
    }

    public final void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public final Context getCtx() {
        return this.ctx;
    }

    @Override
    public DimensionMemberCheckFactory getCheckFactory() {
        if (this.checkFactory == null) {
            try {
                this.checkFactory = this.createCheckFactory();
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                SysUtil.abort();
            }
        }
        return this.checkFactory;
    }

    public boolean isDecompose() {
        if (this.getEditValue() instanceof BgFormInfo) {
            return ((BgFormInfo)this.getEditValue()).isDecompose();
        }
        return false;
    }

    protected IBookDimensionParse getBookDimensionParse() {
        if (this.getOwner() instanceof IProviderUI) {
            return ((IProviderUI)this.getOwner()).getBookDimensionParse();
        }
        return null;
    }

    protected DimensionMemberCheckFactory createCheckFactory() throws EASBizException, BOSException {
        DimensionMemberCheckFactory checkFactory = null;
        try {
            checkFactory = new DimensionMemberCheckFactory(this.getCtx(), null, this.getSchemeHelper(), this.isDecompose());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return checkFactory;
    }

    @Override
    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = this.createSchemeHelper();
        }
        return this.schemeHelper;
    }

    protected BgSchemeDimensionHelper createSchemeHelper() throws EASBizException, BOSException {
        return new BgSchemeDimensionHelper(this.getCtx(), this.getBgSchemeId());
    }

    public final T getCurMbgViewManager() {
        return this.curMbgViewManager;
    }

    protected abstract IObjectValue getQueryDataInfo();

    public final void refreshCurMbgViewManager(FullOrgUnitInfo orgUnitInfo, T mbgViewManager) {
        this.curMbgViewManager = mbgViewManager;
        this.getBookParseHelper().refreshCurMbgViewManager(orgUnitInfo, (IMbgViewBase)mbgViewManager);
    }

    public final Map<String, T> getBgViewManagerForMulOrg() {
        return this.bgViewManagerForMulOrg;
    }

    public final E getCurMbgSheetManager() {
        return this.curMbgSheetManager;
    }

    @Override
    public final void setCurMbgSheetManager(int sheetIndex) {
        if (this.getCurMbgViewManager().getSheetManagers().size() > sheetIndex) {
            this.setCurMbgSheetManager(this.getCurMbgViewManager().getSheetManagers().get(sheetIndex));
        }
    }

    public final void setCurMbgSheetManager(E curMbgSheetManager) {
        this.curMbgSheetManager = curMbgSheetManager;
    }

    public abstract AbstractBookParseHelper getBookParseHelper();

    public final String getBgSchemeId() {
        BgSchemeInfo bgScheme = this.getBgSchemeInfo();
        if (bgScheme != null) {
            return bgScheme.getId().toString();
        }
        return null;
    }

    protected abstract BgScenarioType getEditScenType();

    protected abstract String getVersionNumber();

    public boolean isCheckFull() {
        return true;
    }

    public String getUnionID() {
        return this.unionID;
    }

    public void setUnionID(String unionID) {
        this.unionID = unionID;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public void setPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    @Override
    public String getBillId() {
        if (this.model != null) {
            return this.model.getString(this.model.getPKField());
        }
        return null;
    }

    @Override
    public String getOrgUnitId() {
        if (this.orgUnitInfo != null) {
            return this.orgUnitInfo.getId().toString();
        }
        return null;
    }

    @Override
    public String getOrgViewId() {
        if (this.orgViewId == null) {
            try {
                BgSchemeDimensionHelper schemeHelper = this.getSchemeHelper();
                if (schemeHelper != null) {
                    return schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return this.orgViewId;
    }

    @Override
    public BOSUuid getBgOrgViewId() {
        return this.getOrgViewId() != null ? BOSUuid.read((String)this.getOrgViewId()) : null;
    }

    @Override
    public void setOrgViewId(String orgViewId) {
        this.orgViewId = orgViewId;
    }

    @Override
    public FullOrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public CoreUIObject getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(CoreUIObject owner) {
        this.owner = owner;
    }

    @Override
    public void setEditValue(IObjectValue model) {
        this.model = model;
    }

    @Override
    public IObjectValue getEditValue() {
        return this.model;
    }

    protected abstract void initQueryData(Sheet var1) throws Exception;

    protected String getItemCombine(List<BgDimensionMember> _rowObj) {
        if (_rowObj == null || _rowObj.isEmpty()) {
            return null;
        }
        HashMap<Integer, String> _item = new HashMap<Integer, String>();
        int in = _rowObj.size();
        for (int i = 0; i < in; ++i) {
            BgDimensionMember member = _rowObj.get(i);
            if (member.getType() == null || MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType()) || member == null || member.getNumber() == null || member.getAttribute() == null || member.getSrcNumber() == null) continue;
            _item.put(DimensionCommonHelper.getField(member.getAttribute().toUpperCase()), member.getSrcNumber() + ":" + member.getNumber());
        }
        if (_item.isEmpty()) {
            return null;
        }
        StringBuffer f = new StringBuffer();
        Object[] reffields = _item.keySet().toArray();
        Arrays.sort(reffields);
        for (int i = 0; i < reffields.length; ++i) {
            if (i != 0) {
                f.append(",");
            }
            f.append(_item.get(reffields[i]));
        }
        return f.toString();
    }

    @Override
    public IObjectValue queryEditValue(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue(pk, this.getSelectors());
    }

    @Override
    public DimensionMemberFilterInfo getMemberFilter() {
        return this.memberFilter;
    }

    public void reset() {
        this.getBgViewManagerForMulOrg().clear();
        this.getCheckFactory().clear();
        this.orgUnitMap.clear();
    }

    @Override
    public String getOrgPermission() {
        if (this.getOwner() instanceof IProviderUI) {
            return ((IProviderUI)this.getOwner()).getOrgPermission();
        }
        return null;
    }

    @Override
    public Book pageChangeLoadBook() throws Exception {
        return null;
    }

    @Override
    public void save(CoreBaseInfo model) throws Exception {
    }

    protected void getOrgNumsForCurBook(Book book, Set<String> orgNums) {
        if (book == null || orgNums == null) {
            return;
        }
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            this.getOrgNumsForCurSheet(sheetIndex, orgNums);
        }
    }

    @Override
    public List<BgGatherInfo> getGatherInfos() {
        return this.gatherInfos;
    }

    public void calcBook(Book _book, IReportPropertyAdapter _adapter) throws Exception {
        CalculateContext ctx = new CalculateContext(_book, _adapter);
        ctx.setServerContext(this.getCtx());
        FormulaDefinition.registerFormulaToBook((Book)_book, (ICalculateContextProvider)ctx);
        boolean oldstate = _book.isAutoCalculate();
        _book.setCalculate(true);
        _book.calc();
        _book.setCalculate(oldstate);
    }

    protected boolean checkOwnerIsDim() {
        return this.getOwner().getUIContext().get("FROMUI") != null && (this.getOwner().getUIContext().get("FROMUI").getClass().getName().equals("com.kingdee.eas.ma.mbg.client.BgDimCellUI") || this.getOwner().getUIContext().get("FROMUI").getClass().getName().equals("com.kingdee.eas.ma.bgcsl.client.BgCslDimCellUI"));
    }
}

