/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteCollection;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ViewListTemplateProvider
extends ViewListProvider {
    private Map<Integer, String> editNotes = new HashMap<Integer, String>();

    public Map<Integer, String> getEditNotes() {
        return this.editNotes;
    }

    @Override
    public Object load() throws Exception {
        this.loadViewManager();
        Book book = this.getBookParseHelper().getBook(this.getOwner(), this, this.getCheckFactory(), this.getOrgPermission());
        MbgPermissionHelper.setSheetHide(null, RptSrcTypeEnum.PT_BUDGET_REPORT, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), this.getBgTemplateId().toString(), this.getBgSchemeId(), book);
        return book;
    }

    @Override
    protected IReportPropertyAdapter getReportAdapter() {
        return null;
    }

    private void loadViewManager() throws Exception, BOSException, EASBizException {
        BgTemplateInfo tempInfo = null;
        if (this.getEditValue() instanceof BgTemplateInfo) {
            tempInfo = this.getEditValue();
            this.setOrgUnitInfo(tempInfo.getOrgUnit());
            if (tempInfo.getStyleSet() != null && tempInfo.getStyleSet().getData() != null) {
                this.setTemplateStyle(MbgViewListXMLParser.parseStyle(tempInfo.getStyleSet().getData()));
            }
            Map templateData = null;
            templateData = tempInfo.getId() != null && !this.isPreview() ? ViewListFacadeFactory.getRemoteInstance().initTemplateData(tempInfo, this.getTemplateStyle(), tempInfo.getOrgUnit().getId().toString(), false) : ViewListFacadeFactory.getRemoteInstance().initTemplateData(tempInfo, this.getTemplateStyle(), (MbgViewListManager)this.getOwner().getUIContext().get("dimension.object"), tempInfo.getOrgUnit().getId().toString(), false);
            this.setEditOrgUnit((String)templateData.get("edit.orgunit"));
            this.setEditPeriod((String)templateData.get("edit.period"));
            this.setPropMaps((Map)templateData.get("dimension.property"));
            this.curMbgViewManager = (MbgViewListManager)templateData.get("dimensino.member");
        }
        this.addOtherOrgViewData(this.getOrgUnitInfo(), (MbgViewListManager)this.curMbgViewManager);
    }

    @Override
    public void fillData(Book book) throws Exception {
        String editNote = null;
        Sheet sheet = null;
        Cell cell = null;
        Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> descMap = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            editNote = this.queryEditNote(s);
            descMap = this.queryDescMap(book.getSheet(s));
            int maxCol = sheet.getMaxColIndex();
            int maxRow = sheet.getMaxRowIndex();
            for (int i = 0; i <= maxRow; ++i) {
                for (int j = 0; j <= maxCol; ++j) {
                    cell = sheet.getCell(i, j, false);
                    this.fillEditNote(cell, editNote);
                    this.fillDescriptions(cell, descMap);
                }
            }
        }
    }

    protected String queryEditNote(int sheetIndex) throws BOSException {
        String editNote = null;
        MbgViewListEditNoteCollection colls = MbgViewListEditNoteFactory.getRemoteInstance().getMbgViewListEditNoteCollection("select value where bgTemplateId = '" + this.getEditValue().getId().toString() + "' and sheetIndex = " + sheetIndex);
        if (colls != null && !colls.isEmpty()) {
            editNote = colls.get(0).getValue();
        }
        return editNote;
    }

    private void fillEditNote(Cell cell, String editNote) {
        if (ViewListHelper.checkIsEditNoteCell(cell)) {
            BgNFSHelper.setValue(cell, editNote);
            BgNFSHelper.setUserObject(cell, "oldValue", editNote);
        }
    }

    @Override
    protected String getSheetTitle() {
        if (this.getEditValue() != null) {
            return this.getEditValue().getName();
        }
        return null;
    }

    @Override
    public ViewListBookParseHelper getBookParseHelper() {
        ViewListBookParseHelper bookParseHelper = super.getBookParseHelper();
        bookParseHelper.setViewF7Enable(false);
        bookParseHelper.setPageF7Enable(false);
        bookParseHelper.setShowDefaultMember(true);
        return bookParseHelper;
    }

    @Override
    public boolean isCheckFull() {
        return false;
    }

    @Override
    public void reloadBook(Book book) throws Exception {
        this.loadViewManager();
        this.getBookParseHelper().refreshCurMbgViewManager(this.getOrgUnitInfo(), this.curMbgViewManager);
        this.getBookParseHelper().getBook(this.getOwner(), this, book, this.getCheckFactory(), this.getOrgPermission());
    }

    @Override
    protected void initQueryData(Sheet sheet) throws Exception {
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getTemplateSelectors();
        sic.add("styleSet.id");
        sic.add("styleSet.number");
        sic.add("styleSet.name");
        sic.add("styleSet.data");
        return sic;
    }

    @Override
    public void save(CoreBaseInfo model) throws Exception {
    }

    @Override
    protected BgScenarioType getEditScenType() {
        return BgScenarioType.BudgetData;
    }

    @Override
    protected String getVersionNumber() {
        return null;
    }

    @Override
    public BgSchemeInfo getBgSchemeInfo() {
        return this.getEditValue().getBgScheme();
    }

    public BgTemplateInfo getEditValue() {
        return (BgTemplateInfo)super.getEditValue();
    }

    @Override
    protected BOSUuid getBgPeriodId() {
        return BOSUuid.read((String)"000000000000000000000000000=");
    }

    @Override
    protected BOSUuid getBgTemplateId() {
        return this.getEditValue().getId();
    }

    @Override
    protected BOSUuid getBgVersionId() {
        return BOSUuid.read((String)"000000000000000000000000000=");
    }

    @Override
    protected BOSUuid getCurrencyId() {
        return BOSUuid.read((String)"000000000000000000000000000=");
    }

    @Override
    public void store(Book book) throws Exception {
        if (book == null) {
            return;
        }
        Sheet sheet = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            this.store(sheet);
        }
    }

    @Override
    public void store(Sheet sheet) throws Exception {
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        MbgViewListDesCellCollection desCellCol = this.getBgDescriptionColls(sheet.getSheetIndex());
        desCellCol.clear();
        Cell cell = null;
        for (int r = 0; r <= maxRow; ++r) {
            for (int c = 0; c <= maxCol; ++c) {
                cell = sheet.getCell(r, c, false);
                if (ViewListHelper.checkIsEditNoteCell(cell)) {
                    String value = null;
                    if (cell != null && BgNFSHelper.getValue(cell) != null && (value = String.valueOf(BgNFSHelper.getValue(cell))).length() > 1999) {
                        int isComfirm = MsgBox.showConfirm2((Component)this.getOwner(), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"editNoteLong"));
                        if (MsgBox.isYes((int)isComfirm)) {
                            value = value.substring(0, 2000);
                            BgNFSHelper.setValue(cell, value);
                        } else {
                            SysUtil.abort();
                        }
                    }
                    if (value == null) {
                        this.getEditNotes().remove(cell.getSheet().getSheetIndex());
                    } else {
                        this.getEditNotes().put(cell.getSheet().getSheetIndex(), value);
                    }
                    BgNFSHelper.setUserObject(cell, "oldValue", value);
                }
                this.storeDesCellValue(cell, desCellCol, true);
            }
        }
    }

    @Override
    public void store(Object obj) throws Exception {
    }

    @Override
    public String getOrgNumsForCurSheet(int sheetIndex, Set<String> orgNums) {
        return null;
    }

    @Override
    protected IObjectValue getQueryDataInfo() {
        return null;
    }

    @Override
    public Map<String, Integer> getAccountDataTypeMap() {
        return null;
    }
}

