/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgDataAssistFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgDataAssist;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgPeriodDecomposeUtils;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.MBGProvider;
import com.kingdee.eas.ma.mbg.utils.BgCommentCommonHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgBudgetDataQueryHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class MBGBaseFormProvider
extends MBGProvider {
    private static final Logger logger = Logger.getLogger((String)MBGBaseFormProvider.class.getName());
    private MbgBudgetDataQueryHelper queryDataHelper = null;
    protected Map<String, Map<String, BgNViewDataInfo>> bgDataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
    protected Map<String, Map<String, String>> bgDescriptionMap = new HashMap<String, Map<String, String>>();

    protected MbgBudgetDataQueryHelper getQueryDataHelper() {
        if (this.queryDataHelper == null) {
            this.queryDataHelper = new MbgBudgetDataQueryHelper((Component)this.getOwner(), this.getCtx());
        }
        this.queryDataHelper.setViewStates((Set)this.getOwner().getUIContext().get("BGFROM_DATA_STATE"));
        return this.queryDataHelper;
    }

    public boolean isModifyData(Sheet sheet) throws EASBizException, BOSException {
        boolean isModify = false;
        if (sheet == null) {
            return isModify;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String cellOrgNum = null;
        BgNViewDataInfo dataValue = null;
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = null;
        IMbgViewManager view = null;
        for (int rowIndex = 0; rowIndex <= maxRow; ++rowIndex) {
            Row row = sheet.getRow(rowIndex, false);
            if (row == null) continue;
            for (int colIndex = 0; colIndex <= maxCol; ++colIndex) {
                cell = row.getCell(colIndex, false);
                formula = BgNFSHelper.getItemFormula(cell);
                if (formula == null) continue;
                String version = formula.getExt("Version");
                cellOrgId = formula.getExt("ORGUNITID");
                cellOrgNum = formula.getExt("ORGUNIT");
                dataValue = this.getData(this.getBgDataMap(), cellOrgId, formula.getFormula(), version, false);
                view = (IMbgViewManager)this.getBgViewManagerForMulOrg().get(cellOrgNum);
                helper = factory.getHelper(cellOrgId, view);
                if (!(dataValue instanceof BgNViewDataInfo) || !this.isCanEditBgData(cell, formula.getFormula(), dataValue, view, helper, sheet.getSheetIndex(), version)) continue;
                boolean bl = isModify = this.isModify(dataValue) || BgPeriodDecomposeUtils.checkHasBgDecomposeData(this.getOwner());
                if (!isModify) continue;
                return isModify;
            }
        }
        return isModify;
    }

    public Map<String, Map<String, BgNViewDataInfo>> getBgDataMap() {
        return this.bgDataMap;
    }

    public Map<String, Map<String, String>> getBgDescriptionMap() {
        return this.bgDescriptionMap;
    }

    protected abstract boolean isModify(BgNViewDataInfo var1);

    @Override
    public void store(Book book) throws Exception {
        for (int s = 0; s < book.getSheetCount(); ++s) {
            this.store(book.getSheet(s));
        }
    }

    @Override
    public void store(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = null;
        IMbgViewManager view = null;
        for (int r = 0; r <= maxRow; ++r) {
            for (int c = 0; c <= maxCol; ++c) {
                String orgId;
                Cell cell = sheet.getCell(r, c, false);
                ItemFormula formula = BgNFSHelper.getItemFormula(cell);
                if (formula != null) {
                    String version = formula.getExt("Version");
                    if (this.checkVersion(version)) continue;
                    orgId = formula.getExt("ORGUNITID");
                    view = (IMbgViewManager)this.getBgViewManagerForMulOrg().get(formula.getExt("ORGUNIT"));
                    helper = factory.getHelper(orgId, view);
                    BigDecimal value = BgViewHelper.getNumeric(cell, null);
                    if (value != null) {
                        BgNViewDataInfo data = this.getData(this.getBgDataMap(), orgId, formula.getFormula(), version, true);
                        this.storeDataValue(value, data);
                        if (data != null) {
                            data.setCanSave(this.isCanEditBgData(cell, formula.getFormula(), data, view, helper, sheet.getSheetIndex(), version));
                        }
                    } else if (this.isCanEditBgData(cell, formula.getFormula(), null, view, helper, sheet.getSheetIndex(), version)) {
                        this.createNullData(this.getBgDataMap(), orgId, formula.getFormula(), version);
                    }
                }
                if (!DimensionDescriptionHelper.checkHashDescriptionFormula(cell)) continue;
                orgId = DimensionDescriptionHelper.getDescriptionOrgUnitId(cell);
                String descFormula = DimensionDescriptionHelper.getDescriptionFormula(cell);
                String value = null;
                if (!Variant.isNull((Variant)cell.getValue()) && cell.getValue() != null && (value = String.valueOf(cell.getValue().getValue())).length() > 1999) {
                    throw new BgNFormException(BgNFormException.DESCRIPTIONLONG, new String[]{cell.getName(false, false)});
                }
                this.addDescription(this.getBgDescriptionMap(), orgId, descFormula, value);
            }
        }
    }

    protected boolean checkVersion(String versionNum) {
        return versionNum == null || this.getBgFormInfo() == null || !versionNum.equals(this.getBgFormInfo().getBgVersion().getNumber());
    }

    protected void addDescription(Map<String, Map<String, String>> descriptionMap, String orgId, String descFormula, String value) {
        Map subMap;
        if (orgId == null) {
            orgId = this.getOrgUnitId();
        }
        if ((subMap = BgViewHelper.getSubMap(descriptionMap, orgId, true)) != null) {
            subMap.put(descFormula, value);
        }
    }

    protected String getDescription(Map descriptionMap, String orgId, String formula) {
        Map subMap;
        if (orgId == null) {
            orgId = this.getOrgUnitId();
        }
        if ((subMap = BgViewHelper.getSubMap(descriptionMap, orgId, false)) != null) {
            return (String)subMap.get(formula);
        }
        return null;
    }

    protected void setDescription(Map descriptionMap, String orgId, String formula, String value) {
        Map subMap = BgViewHelper.getSubMap(descriptionMap, orgId, true);
        if (subMap != null) {
            subMap.put(formula, value);
        }
    }

    protected BgNViewDataInfo getData(Map bgDataMap, String orgId, String formula, String versionNumber, boolean isCreate) {
        if (bgDataMap == null) {
            return null;
        }
        HashMap<String, BgNViewDataInfo> subMap = null;
        if (bgDataMap.containsKey(orgId)) {
            subMap = (HashMap<String, BgNViewDataInfo>)bgDataMap.get(orgId);
        } else if (isCreate) {
            subMap = new HashMap<String, BgNViewDataInfo>();
            bgDataMap.put(orgId, subMap);
        }
        if (subMap == null) {
            return null;
        }
        BgNViewDataInfo data = null;
        String key = formula + "_" + versionNumber;
        if (subMap.containsKey(key)) {
            data = (BgNViewDataInfo)subMap.get(key);
        } else if (isCreate) {
            data = new BgNViewDataInfo();
            data.setFormula(formula);
            data.setBgVersion(versionNumber);
            data.splitFormula();
            subMap.put(key, data);
        }
        if (data == null && isCreate) {
            data = new BgNViewDataInfo();
            data.setFormula(formula);
            data.setBgVersion(versionNumber);
            data.splitFormula();
            subMap.put(key, data);
        }
        return data;
    }

    protected void createNullData(Map bgDataMap, String orgId, String formula, String versionNumber) {
        MBGViewListFormCommonHelper.createNullData(bgDataMap, orgId, formula, versionNumber);
    }

    protected abstract void storeDataValue(BigDecimal var1, BgNViewDataInfo var2);

    @Override
    protected void initQueryData(Sheet sheet) throws Exception {
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new HashMap<String, List<IBgDimensionManagerBase>>();
        if (sheet != null) {
            this.collectDimesionManagersForQuery(sheet.getSheetIndex(), dimensionManagers);
            this.getQueryDataHelper().startQueryData(this.getQueryDataInfo(), dimensionManagers, this.getDataType(), this.getBgOrgViewId(), false);
        }
    }

    protected Map<String, Map<String, BgNViewDataInfo>> queryData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers) throws BOSException, EASBizException {
        return this.queryDimData(dimensionManagers, false);
    }

    protected Map<String, Map<String, BgNViewDataInfo>> queryData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers, boolean isSynch) throws BOSException, EASBizException {
        return this.queryDimData(dimensionManagers, isSynch);
    }

    private Map<String, Map<String, BgNViewDataInfo>> queryDimData(Map<String, List<IBgDimensionManagerBase>> dimensionManagers, boolean isSynch) throws BOSException, EASBizException {
        Map<String, Map<String, BgNViewDataInfo>> dataMap;
        block2: {
            dataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
            try {
                dataMap = this.getQueryDataHelper().queryData(this.getQueryDataInfo(), dimensionManagers, this.getDataType(), isSynch, this.getBgOrgViewId());
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof BgPeriodException)) break block2;
                MsgBox.showDetailAndOK((Component)this.getOwner(), (String)e.getCause().getMessage(), (String)e.getCause().getCause().getMessage(), (int)0);
                SysUtil.abort();
            }
        }
        return dataMap;
    }

    protected abstract int getDataType();

    @Override
    public void fillData(Book book) throws Exception {
        this.fillDimData(book, false);
    }

    @Override
    public void fillData(Book book, boolean isSynch) throws Exception {
        this.fillDimData(book, isSynch);
    }

    private void fillDimData(Book book, boolean isSynch) throws Exception {
        this.fillDataClear(book);
        super.fillData(book, isSynch);
        if (book != null) {
            Boolean isBookHasFormula = BgNFSHelper.checkBookHasFormula(book);
            Map<String, Map<String, BgNViewDataInfo>> dataMap = isBookHasFormula != false ? this.getDimData(book, isSynch, null) : null;
            Map<String, Map<String, String>> descMap = this.queryDescMap(book);
            for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
                this.fillBgDataValue(book.getSheet(sheetIndex), dataMap, null, descMap);
            }
            if (isBookHasFormula.booleanValue()) {
                BgCommentCommonHelper.fillBgComments(this.getCtx(), book, this.getBgFormInfo(), this.getOrgViewId(), this.getCurMbgViewManager());
            }
        }
        BgNFSHelper.enableUndo(book);
    }

    public Map<String, Map<String, BgNViewDataInfo>> getDimData(Book book, boolean isSynch, String[] sheetNames) throws Exception {
        this.fillDataClear(book);
        Map<String, Map<String, BgNViewDataInfo>> dataMap = null;
        if (book != null) {
            Map<String, List<IBgDimensionManagerBase>> dimensionManager = this.getDimensionManagerForQuery(book, sheetNames);
            dataMap = this.queryData(dimensionManager, isSynch);
        }
        return dataMap;
    }

    private void fillDataClear(Book book) {
        this.getBgDataMap().clear();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
    }

    private Map<String, List<IBgDimensionManagerBase>> getDimensionManagerForQuery(Book book, String[] sheetNames) {
        if (book == null) {
            return null;
        }
        List sheetList = BgNFSHelper.toList(sheetNames);
        Sheet _sheet = null;
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManager = new HashMap<String, List<IBgDimensionManagerBase>>();
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (!sheetList.isEmpty() && !sheetList.contains(_sheet.getSheetName())) continue;
            this.collectDimesionManagersForQuery(sheetIndex, dimensionManager);
        }
        return dimensionManager;
    }

    @Override
    public void fillData(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> tmpData) throws Exception {
        super.fillData(sheet, null);
        HashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new HashMap<String, List<IBgDimensionManagerBase>>();
        this.collectDimesionManagersForQuery(sheet.getSheetIndex(), dimensionManagers);
        sheet.setUserObject("dimensionManagers", dimensionManagers);
        long ct = System.currentTimeMillis();
        Map<String, Map<String, BgNViewDataInfo>> dataMap = this.queryData(dimensionManagers);
        Map<String, Map<String, String>> descMap = this.queryDescMap(sheet);
        this.fillBgDataValue(sheet, dataMap, tmpData, descMap);
        BgCommentCommonHelper.fillBgComments(this.getCtx(), sheet.getBook(), this.getBgFormInfo(), this.getOrgViewId(), this.getCurMbgViewManager());
    }

    private Map<String, Map<String, String>> queryDescMap(Sheet sheet) throws EASBizException, BOSException {
        Map queryMap = DimensionDescriptionHelper.getQueryMap(sheet);
        String bgSchemeId = null;
        if (this.getEditValue() instanceof BgFormInfo) {
            bgSchemeId = ((BgFormInfo)this.getEditValue()).getBgScheme().getId().toString();
        } else if (this.getEditValue() instanceof BgActualRecordInfo) {
            bgSchemeId = ((BgActualRecordInfo)this.getEditValue()).getBgForm().getBgScheme().getId().toString();
        }
        IBgDataAssist biz = null;
        biz = this.getCtx() == null ? BgDataAssistFactory.getRemoteInstance() : BgDataAssistFactory.getLocalInstance(this.getCtx());
        return biz.queryAssist(bgSchemeId, queryMap);
    }

    protected Map<String, Map<String, String>> queryDescMap(Book book) throws EASBizException, BOSException {
        Map queryMap = DimensionDescriptionHelper.getQueryMap(book);
        IBgDataAssist biz = null;
        biz = this.getCtx() == null ? BgDataAssistFactory.getRemoteInstance() : BgDataAssistFactory.getLocalInstance(this.getCtx());
        return biz.queryAssist(this.getBgFormInfo().getBgScheme().getId().toString(), queryMap);
    }

    public abstract BgFormInfo getBgFormInfo();

    @Override
    public BgSchemeInfo getBgSchemeInfo() {
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo != null) {
            return bgFormInfo.getBgScheme();
        }
        return null;
    }

    protected void fillBgDataValue(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> dataMap, Map<String, Map<String, BgNViewDataInfo>> tmpDataMap, Map<String, Map<String, String>> descMap) throws Exception {
        long ct = System.currentTimeMillis();
        logger.info((Object)("start fillBgDataValue:" + ct));
        if (sheet == null) {
            return;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        BgNViewDataInfo dataValue = null;
        BgSheetRange lockRange = new BgSheetRange(sheet);
        BgSheetRange unLockRange = new BgSheetRange(sheet);
        BgNFSHelper.disableUndo(sheet.getBook());
        BgNFSHelper.disableCal(sheet.getBook());
        int maxCap = sheet.getMaxColIndex() + sheet.getMaxRowIndex() / 10;
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = null;
        IMbgViewManager view = null;
        String selFormulaStr = null;
        int selRowIndex = 0;
        int selColIndex = 0;
        List linkFormulas = null;
        if (this.getOwner() != null && this.getOwner().getUIContext() != null) {
            selFormulaStr = (String)this.getOwner().getUIContext().get("FORMULA");
            linkFormulas = (List)this.getOwner().getUIContext().get("LINK_FORMULA");
        }
        boolean isBgDim = this.checkOwnerIsDim();
        HashSet<Cell> set = new HashSet<Cell>();
        for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula(cell);
                if (formula != null) {
                    String version = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    dataValue = this.getData(tmpDataMap, cellOrgId, formula.getFormula(), version, false);
                    if (dataValue == null) {
                        dataValue = this.getData(dataMap, cellOrgId, formula.getFormula(), version, false);
                    }
                    view = (IMbgViewManager)this.getBgViewManagerForMulOrg().get(formula.getExt("ORGUNIT"));
                    helper = factory.getHelper(cellOrgId, view);
                    this.getEditBgScenario(cell, helper, sheet.getSheetIndex());
                    if (dataValue != null) {
                        this.setDataValueToCell(cell, dataValue, dataMap, cellOrgId, helper);
                        this.addToMap(cellOrgId, formula.getFormula(), version, dataValue, this.getBgDataMap());
                    } else {
                        this.setDataValueToCell(cell, null, helper);
                    }
                    if (!this.isCanEditBgData(cell, formula.getFormula(), dataValue, view, helper, sheet.getSheetIndex(), version)) {
                        if (!cell.isLocked()) {
                            lockRange.addCell(rowIndex, colIndex);
                        }
                    } else if (cell.isLocked()) {
                        unLockRange.addCell(rowIndex, colIndex);
                    }
                    if (!isBgDim) {
                        if (selFormulaStr != null && formula.getFormula().equals(selFormulaStr) && this.getOwner().getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo && ((OrgUnitInfo)this.getOwner().getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString().equals(cellOrgId)) {
                            selRowIndex = rowIndex;
                            selColIndex = colIndex;
                            set.add(cell);
                        }
                        if (linkFormulas == null || !linkFormulas.contains(formula.getFormula()) || !(this.getOwner().getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo) || !((OrgUnitInfo)this.getOwner().getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString().equals(cellOrgId)) continue;
                        set.add(cell);
                        continue;
                    }
                    if (!isBgDim || !this.getOwner().getUIContext().get("Version").equals(version) || !this.getOwner().getUIContext().get("ORGUNITID").equals(cellOrgId) || selFormulaStr == null || !formula.getFormula().equals(selFormulaStr)) continue;
                    selRowIndex = rowIndex;
                    selColIndex = colIndex;
                    continue;
                }
                if (!DimensionDescriptionHelper.checkHashDescriptionFormula(cell)) continue;
                String descFormula = DimensionDescriptionHelper.getDescriptionFormula(cell);
                String orgId = DimensionDescriptionHelper.getDescriptionOrgUnitId(cell);
                BgNFSHelper.setValue(cell, BgViewHelper.getSubMap(descMap, orgId, true).get(descFormula));
            }
        }
        this.setLocked(lockRange);
        BgViewHelper.setLocked(false, unLockRange.getRange());
        BgNFSHelper.enableUndo(sheet.getBook());
        for (Cell rescell : set) {
            BgNFSHelper.setBackGroup(rescell, Color.RED);
        }
        if (selFormulaStr != null && selRowIndex > 0 && selColIndex > 0) {
            sheet.getRange(selRowIndex, selColIndex).select();
            if (isBgDim) {
                BgNFSHelper.setBackGroup(sheet.getCell(selRowIndex, selColIndex, false), Color.RED);
            }
        }
        logger.info((Object)("fillBgDataValue: " + (System.currentTimeMillis() - ct) + "ms"));
    }

    protected void getEditBgScenario(Cell cell, DimensionMemberCheckHelper helper, int sheetIndex) throws EASBizException, BOSException {
    }

    protected String rollbackItemFormula(Cell cell) {
        return BgNFSHelper.getItemFormula(cell).getFormula();
    }

    protected void setDataValueToCell(Cell cell, BgNViewDataInfo dataValue, Map<String, Map<String, BgNViewDataInfo>> dataMap, String cellOrgId, DimensionMemberCheckHelper helper) {
        this.setDataValueToCell(cell, dataValue, helper);
    }

    protected void updateItemFormula(Cell cell) {
    }

    protected void setLocked(BgSheetRange lockRange) {
        BgViewHelper.setLockedAndBackgroud(true, lockRange.getRange());
    }

    public void fillBgDataValue(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> dataMap, KDProgressBar progressBar) throws EASBizException, BOSException {
        long ct = System.currentTimeMillis();
        logger.info((Object)("start fillBgDataValue:" + ct));
        if (sheet == null) {
            return;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        BgNViewDataInfo dataValue = null;
        BgSheetRange lockRange = new BgSheetRange(sheet);
        BgSheetRange unLockRange = new BgSheetRange(sheet);
        BgNFSHelper.disableUndo(sheet.getBook());
        BgNFSHelper.disableCal(sheet.getBook());
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = null;
        IMbgViewManager view = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula(cell);
                if (formula == null) continue;
                String version = formula.getExt("Version");
                cellOrgId = formula.getExt("ORGUNITID");
                dataValue = this.getData(dataMap, cellOrgId, formula.getFormula(), version, false);
                view = (IMbgViewManager)this.getBgViewManagerForMulOrg().get(formula.getExt("ORGUNIT"));
                helper = factory.getHelper(cellOrgId, view);
                if (dataValue != null) {
                    this.setDataValueToCell(cell, dataValue, helper);
                    this.addToMap(cellOrgId, formula.getFormula(), version, dataValue, this.getBgDataMap());
                    if (progressBar != null) {
                        progressBar.setValue(progressBar.getValue() + 1);
                    }
                } else {
                    this.setDataValueToCell(cell, null, helper);
                }
                if (!this.isCanEditBgData(cell, formula.getFormula(), dataValue, view, helper, sheet.getSheetIndex(), version)) {
                    if (cell.isLocked()) continue;
                    lockRange.addCell(rowIndex, colIndex);
                    continue;
                }
                if (!cell.isLocked()) continue;
                unLockRange.addCell(rowIndex, colIndex);
            }
        }
        this.setLocked(lockRange);
        BgViewHelper.setLocked(false, unLockRange.getRange());
        BgNFSHelper.enableUndo(sheet.getBook());
        logger.info((Object)("fillBgDataValue: " + (System.currentTimeMillis() - ct) + "ms"));
    }

    protected abstract boolean isCanEditBgData(Cell var1, String var2, BgNViewDataInfo var3, IMbgViewManager var4, DimensionMemberCheckHelper var5, int var6, String var7) throws EASBizException, BOSException;

    protected void setDataValueToCell(Cell cell, BgNViewDataInfo dataValue, DimensionMemberCheckHelper helper) {
        if (dataValue == null) {
            BgNFSHelper.setValue(cell, null);
            return;
        }
        String[] params = BgNFSHelper.parseFormulaPara(dataValue.getFormula());
        DimensionCacheHelper cachehelper = this.getCheckFactory().getCacheHelper();
        try {
            if (cachehelper.getBudgetScens().contains(params[3])) {
                this.setBudgetValue(cell, dataValue);
            } else if (cachehelper.getActualScens().contains(params[3])) {
                this.setActualValue(cell, dataValue);
            }
        }
        catch (Exception ex) {
            BgNFSHelper.setValue(cell, null);
        }
    }

    protected void setBudgetValue(Cell cell, BgNViewDataInfo dataValue) {
        BgNFSHelper.setValue(cell, dataValue == null ? null : dataValue.getBudgetValueNoDef());
    }

    protected void setActualValue(Cell cell, BgNViewDataInfo dataValue) {
        BgNFSHelper.setValue(cell, dataValue == null ? null : dataValue.getBizActualNoDef());
    }

    public void addToMap(String orgId, String formula, String version, BgNViewDataInfo dataInfo, Map<String, Map<String, BgNViewDataInfo>> dataMap) {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || dataInfo == null || dataMap == null) {
            return;
        }
        if (!dataMap.containsKey(orgId)) {
            dataMap.put(orgId, new HashMap());
        }
        dataMap.get(orgId).put(formula + "_" + version, dataInfo);
    }

    @Override
    protected Map<String, Map<String, BgNViewDataInfo>> divideSheetDataFromDataCache(Sheet sheet) throws Exception {
        if (sheet == null) {
            return null;
        }
        HashMap<String, Map<String, BgNViewDataInfo>> tmpData = new HashMap<String, Map<String, BgNViewDataInfo>>();
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String version = null;
        BgNViewDataInfo dataValue = null;
        this.store(sheet);
        for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula(cell);
                if (formula == null) continue;
                version = formula.getExt("Version");
                cellOrgId = formula.getExt("ORGUNITID");
                dataValue = this.getData(this.getBgDataMap(), cellOrgId, formula.getFormula(), version, false);
                if (dataValue == null) continue;
                this.removeFromMap(cellOrgId, formula.getFormula(), version, this.getBgDataMap());
                if (!this.isModify(dataValue)) continue;
                this.addToMap(cellOrgId, formula.getFormula(), version, dataValue, tmpData);
            }
        }
        return tmpData;
    }

    public void removeFromMap(String orgId, String formula, String version, Map<String, Map<String, BgNViewDataInfo>> dataMap) {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || dataMap == null) {
            return;
        }
        if (dataMap.containsKey(orgId)) {
            dataMap.get(orgId).remove(formula + "_" + version);
        }
    }

    protected void collectDimesionManagersForQuery(int sheetIndex, Map<String, List<IBgDimensionManagerBase>> dimensionManagers) {
        if (sheetIndex == -1) {
            return;
        }
        HashSet<String> orgNums = new HashSet<String>();
        this.getOrgNumsForCurSheet(sheetIndex, orgNums);
        IBgDimensionManager clone = null;
        if (orgNums.size() > 0) {
            IBgDimensionManager dimensionManager = null;
            for (String orgNum : orgNums) {
                if (!this.orgUnitMap.containsKey(orgNum)) continue;
                if (!dimensionManagers.containsKey(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())) {
                    dimensionManagers.put(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString(), new ArrayList());
                }
                if (!this.getBgViewManagerForMulOrg().containsKey(orgNum)) continue;
                dimensionManager = ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex).getDimensionManager();
                clone = ((IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheetIndex).getDimensionManager().deepclone();
                clone.clearStyle();
                this.synDisplayStyle(dimensionManager.getPageDisplayDimension(), clone.getDimension(), clone.getPageDisplayDimension());
                this.synDisplayStyle(dimensionManager.getViewDisplayDimension(), clone.getDimension(), clone.getViewDisplayDimension());
                this.synDisplayStyle(dimensionManager.getRowDisplayDimension(), clone.getDimension(), clone.getRowDisplayDimension());
                this.synDisplayStyle(dimensionManager.getColDisplayDimension(), clone.getDimension(), clone.getColDisplayDimension());
                dimensionManager = clone;
                this.dealPageMembers(this.getViewF7List(sheetIndex), this.getPageF7List(sheetIndex), dimensionManager, ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex).getDimensionManager(), this.getOrgUnitInfo().getNumber());
                this.synHideDimension(((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex), dimensionManager);
                dimensionManagers.get(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString()).add(dimensionManager);
            }
        }
        this.proMutilOrgDimesionManagersForQuery(sheetIndex, dimensionManagers);
    }

    private void synDisplayStyle(List sourceDisplayDims, List dimensions, List targetDisplayDim) {
        if (sourceDisplayDims == null || sourceDisplayDims.isEmpty()) {
            return;
        }
        BgDimensionInfo dim = null;
        for (int i = 0; i < sourceDisplayDims.size(); ++i) {
            dim = (BgDimensionInfo)sourceDisplayDims.get(i);
            targetDisplayDim.add(DimensionCommonHelper.searchDimension(dim.getNumber(), dimensions));
        }
    }

    protected void proMutilOrgDimesionManagersForQuery(int sheetIndex, Map<String, List<IBgDimensionManagerBase>> dimensionManagers) {
        block15: {
            boolean isorgOnPageOrView;
            block14: {
                int i;
                if (sheetIndex == -1 || dimensionManagers.isEmpty()) {
                    return;
                }
                HashSet<String> orgNums = new HashSet<String>();
                String currentOrgNum = this.getOrgNumsForCurSheet(sheetIndex, orgNums);
                if (StringUtils.isEmpty((String)currentOrgNum) && orgNums.isEmpty()) {
                    this.getInitOrgNums(orgNums, sheetIndex);
                    currentOrgNum = this.getOrgUnitInfo().getNumber();
                }
                isorgOnPageOrView = true;
                if (this.getCurMbgViewManager() != null) {
                    isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex).getDimensionManager());
                } else if (this.curMbgViewManager != null) {
                    isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((IMbgViewManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex).getDimensionManager());
                }
                if (orgNums.size() <= 1 || dimensionManagers.isEmpty() || StringUtils.isEmpty((String)currentOrgNum) || isorgOnPageOrView) break block14;
                String curOrgId = ((FullOrgUnitInfo)this.orgUnitMap.get(currentOrgNum)).getId().toString();
                IBgDimensionManager curDimManager = (IBgDimensionManager)dimensionManagers.get(curOrgId).get(0);
                HashMap<String, List> mapMembers = new HashMap<String, List>();
                BgDimensionInfo dimInfo = null;
                for (i = 0; i < curDimManager.getRowDisplayDimension().size(); ++i) {
                    if (!(curDimManager.getDimension().get(i) instanceof BgDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionInfo)curDimManager.getDimension().get(i)).getNumber())) continue;
                    mapMembers.put(dimInfo.getNumber(), dimInfo.getMember());
                }
                for (i = 0; i < curDimManager.getColDisplayDimension().size(); ++i) {
                    if (!(curDimManager.getDimension().get(i) instanceof BgDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionInfo)curDimManager.getDimension().get(i)).getNumber())) continue;
                    mapMembers.put(dimInfo.getNumber(), dimInfo.getMember());
                }
                for (String orgId : dimensionManagers.keySet()) {
                    if (curOrgId.equals(orgId)) continue;
                    IBgDimensionManager dimManager = (IBgDimensionManager)dimensionManagers.get(orgId).get(0);
                    for (int i2 = 0; i2 < dimManager.getDimension().size(); ++i2) {
                        dimInfo = (BgDimensionInfo)dimManager.getDimension().get(i2);
                        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber()) || !mapMembers.containsKey(dimInfo.getNumber())) continue;
                        List mLst = dimInfo.getMember();
                        mLst.addAll((Collection)mapMembers.get(dimInfo.getNumber()));
                        HashSet mSet = new HashSet(mLst);
                        dimInfo.getMember().clear();
                        dimInfo.getMember().addAll(new ArrayList(mSet));
                    }
                }
                break block15;
            }
            if (!isorgOnPageOrView || dimensionManagers.size() != 1) break block15;
            for (String orgId : dimensionManagers.keySet()) {
                IBgDimensionManager dimManager = (IBgDimensionManager)dimensionManagers.get(orgId).get(0);
                HashMap<String, List> mapMembers = new HashMap<String, List>();
                BgDimensionInfo dimInfo = null;
                Map BgViewManagers = this.getBgViewManagerForMulOrg();
                for (String orgUnitId : BgViewManagers.keySet()) {
                    int i;
                    if (orgUnitId.equals(orgId)) continue;
                    IMbgViewManager cView = (IMbgViewManager)BgViewManagers.get(orgUnitId);
                    IBgDimensionManager cdimManager = cView.getSheetManagers().get(sheetIndex).getDimensionManager();
                    for (i = 0; i < cdimManager.getRowDisplayDimension().size(); ++i) {
                        if (!(cdimManager.getDimension().get(i) instanceof BgDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionInfo)cdimManager.getDimension().get(i)).getNumber())) continue;
                        mapMembers.put(dimInfo.getNumber(), dimInfo.getMember());
                    }
                    for (i = 0; i < cdimManager.getColDisplayDimension().size(); ++i) {
                        if (!(cdimManager.getDimension().get(i) instanceof BgDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (BgDimensionInfo)cdimManager.getDimension().get(i)).getNumber())) continue;
                        mapMembers.put(dimInfo.getNumber(), dimInfo.getMember());
                    }
                }
                ArrayList rowColDims = new ArrayList();
                rowColDims.addAll(dimManager.getRowDisplayDimension());
                rowColDims.addAll(dimManager.getColDisplayDimension());
                for (int i = 0; i < rowColDims.size(); ++i) {
                    dimInfo = (BgDimensionInfo)rowColDims.get(i);
                    if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber()) || !mapMembers.containsKey(dimInfo.getNumber())) continue;
                    List mLst = dimInfo.getMember();
                    mLst.addAll((Collection)mapMembers.get(dimInfo.getNumber()));
                    HashSet mSet = new HashSet(mLst);
                    dimInfo.getMember().clear();
                    dimInfo.getMember().addAll(new ArrayList(mSet));
                }
            }
        }
    }

    private void synHideDimension(IMbgSheetManager sheetManager, IBgDimensionManager dimensionManager) {
        if (sheetManager == null || dimensionManager == null) {
            return;
        }
        HashMap<String, BgDimensionInfo> baseHide = new HashMap<String, BgDimensionInfo>();
        for (int d = 0; d < sheetManager.getDimensionManager().getHideDisplayDimension().size(); ++d) {
            BgDimensionInfo bgDimension = (BgDimensionInfo)sheetManager.getDimensionManager().getHideDisplayDimension().get(d);
            baseHide.put(bgDimension.getNumber(), bgDimension);
        }
        this.moveToHide(dimensionManager.getPageDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToHide(dimensionManager.getViewDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToHide(dimensionManager.getRowDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToHide(dimensionManager.getColDimension(), dimensionManager.getHideDisplayDimension(), baseHide);
        this.moveToNoHide(dimensionManager, baseHide);
    }

    private void moveToNoHide(IBgDimensionManager dimensionManager, Map<String, BgDimensionInfo> baseHide) {
        if (dimensionManager == null || dimensionManager.getHideDisplayDimension() == null) {
            return;
        }
        Iterator it = dimensionManager.getHideDisplayDimension().iterator();
        while (it.hasNext()) {
            BgDimensionInfo bgDimension = (BgDimensionInfo)it.next();
            if (baseHide.containsKey(bgDimension.getNumber())) continue;
            dimensionManager.getRowDisplayDimension().add(bgDimension);
            it.remove();
        }
    }

    private void moveToHide(List displayDimens, List hideDimensions, Map<String, BgDimensionInfo> baseHide) {
        if (displayDimens == null || hideDimensions == null) {
            return;
        }
        Iterator it = displayDimens.iterator();
        while (it.hasNext()) {
            BgDimensionInfo bgDimension = (BgDimensionInfo)it.next();
            if (!baseHide.containsKey(bgDimension.getNumber()) || hideDimensions.contains(bgDimension)) continue;
            hideDimensions.add(bgDimension);
            it.remove();
        }
    }

    private void dealPageMembers(List<KDPromptBox> viewF7List, List<KDPromptBox> pageF7List, IBgDimensionManager dimensionManager, IBgDimensionManager dimensionManagerForStyle, String currOrgNumber) {
        List members;
        List dimensions;
        if (dimensionManager == null) {
            return;
        }
        ArrayList pageViewDimens = new ArrayList();
        ArrayList pageViewMembers = new ArrayList();
        if (viewF7List != null && !viewF7List.isEmpty()) {
            dimensions = MBgTemplateHelper.getDimensions(dimensionManager, MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getViewDisplayDimension()));
            members = BgViewHelper.getCurrPageMember(viewF7List, dimensions);
            pageViewDimens.addAll(dimensions);
            pageViewMembers.addAll(members);
        }
        if (pageF7List != null && !pageF7List.isEmpty()) {
            dimensions = MBgTemplateHelper.getDimensions(dimensionManager, MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getPageDisplayDimension()));
            members = BgViewHelper.getCurrPageMember(pageF7List, dimensions);
            pageViewDimens.addAll(dimensions);
            pageViewMembers.addAll(members);
        }
        for (int dimensionIndex = 0; dimensionIndex < pageViewDimens.size(); ++dimensionIndex) {
            int m;
            BgDimensionInfo dim = (BgDimensionInfo)pageViewDimens.get(dimensionIndex);
            BgDimensionMember member = null;
            for (m = 0; m < pageViewMembers.size(); ++m) {
                if (((BgDimensionMember)pageViewMembers.get(m)).getType() == null || !((BgDimensionMember)pageViewMembers.get(m)).getType().equals(dim.getNumber())) continue;
                member = (BgDimensionMember)pageViewMembers.get(m);
                break;
            }
            if (member == null && !dim.getMember().isEmpty()) {
                member = (BgDimensionMember)dim.getMember().get(0);
                if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    for (m = 0; m < dim.getMember().size(); ++m) {
                        if (!currOrgNumber.equals(((BgDimensionMember)dim.getMember().get(m)).getNumber())) continue;
                        member = (BgDimensionMember)dim.getMember().get(m);
                        break;
                    }
                }
                dim.getMember().clear();
                dim.getMember().add(member);
            }
            dim.getMember().clear();
            if (member == null) continue;
            dim.getMember().add(member);
        }
    }

    public void getInitOrgNums(Set<String> orgNums, int sheetIndex) {
        IBgDimensionManager dimManager = ((IMbgViewManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex).getDimensionManager();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(dimManager);
        if (isorgOnPageOrView) {
            orgNums.add(this.getOrgUnitInfo().getNumber());
        } else {
            ArrayList dimens = new ArrayList();
            dimens.addAll(dimManager.getRowDisplayDimension());
            dimens.addAll(dimManager.getColDisplayDimension());
            for (int i = 0; i < dimens.size(); ++i) {
                if (!((BgDimensionInfo)dimens.get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                for (int m = 0; m < ((BgDimensionInfo)dimens.get(i)).getMember().size(); ++m) {
                    orgNums.add(((BgDimensionMember)((BgDimensionInfo)dimens.get(i)).getMember().get(m)).getNumber());
                }
                break;
            }
        }
    }

    public void getInitOrgNums(Set<String> orgNums) {
        this.getInitOrgNums(orgNums, 0);
    }

    protected void loadMultiOrg() throws Exception {
        HashSet<String> orgNums = new HashSet<String>();
        this.getOrgNumsForCurViewManager((IMbgViewManager)this.curMbgViewManager, orgNums);
        if (orgNums != null && orgNums.size() > 1) {
            this.addBgViewManagerForMultiOrg(orgNums);
        }
    }

    protected Map<String, List<IBgDimensionManagerBase>> getInitDimensionManagers() {
        LinkedHashMap<String, List<IBgDimensionManagerBase>> dimensionManagers = new LinkedHashMap<String, List<IBgDimensionManagerBase>>();
        String currOrgNumber = this.getOrgUnitInfo().getNumber();
        LinkedHashSet<String> orgNums = new LinkedHashSet<String>();
        for (int sheetIndex = 0; sheetIndex < ((IMbgViewManager)this.curMbgViewManager).getSheetManagers().size(); ++sheetIndex) {
            orgNums.clear();
            this.getInitOrgNums(orgNums, sheetIndex);
            if (orgNums.size() > 0) {
                IBgDimensionManager dimensionManager = null;
                for (String orgNum : orgNums) {
                    if (!this.orgUnitMap.containsKey(orgNum)) continue;
                    if (!dimensionManagers.containsKey(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())) {
                        dimensionManagers.put(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString(), new ArrayList());
                    }
                    if (!this.getBgViewManagerForMulOrg().containsKey(orgNum)) continue;
                    dimensionManager = ((IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgNum)).getSheetManagers().get(sheetIndex).getDimensionManager().deepclone();
                    ArrayList pageViewDims = new ArrayList();
                    pageViewDims.addAll(((IMbgViewManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex).getDimensionManager().getPageDisplayDimension());
                    pageViewDims.addAll(((IMbgViewManager)this.curMbgViewManager).getSheetManagers().get(sheetIndex).getDimensionManager().getViewDisplayDimension());
                    if (!pageViewDims.isEmpty()) {
                        List dimensions = MBgTemplateHelper.getDimensions(dimensionManager, MBgTemplateHelper.getDimensionsNum(pageViewDims));
                        for (int dimensionIndex = 0; dimensionIndex < dimensions.size(); ++dimensionIndex) {
                            BgDimensionInfo dim = (BgDimensionInfo)dimensions.get(dimensionIndex);
                            if (dim.getMember().isEmpty()) continue;
                            Object member = dim.getMember().get(0);
                            String currNumber = null;
                            if (dim.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                                currNumber = currOrgNumber;
                            } else if (dim.getNumber().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                                BgDimensionMember defScen = BgDimensionParseCommonHelper.getDefaultMember((IUIObject)this.getOwner(), dim, this.getEditScenType(), this.getCheckFactory().getCacheHelper());
                                if (defScen != null) {
                                    currNumber = defScen.getNumber();
                                }
                            } else if (dim.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                                currNumber = this.getBgFormInfo().getBgVersion().getNumber();
                            }
                            if (currNumber != null) {
                                for (int m = 0; m < dim.getMember().size(); ++m) {
                                    if (!currNumber.equals(((BgDimensionMember)dim.getMember().get(m)).getNumber())) continue;
                                    member = dim.getMember().get(m);
                                    break;
                                }
                            }
                            dim.getMember().clear();
                            dim.getMember().add(member);
                        }
                    }
                    ((List)dimensionManagers.get(((FullOrgUnitInfo)this.orgUnitMap.get(orgNum)).getId().toString())).add(dimensionManager);
                }
            }
            this.proMutilOrgDimesionManagersForQuery(sheetIndex, dimensionManagers);
        }
        return dimensionManagers;
    }

    public Set<String> getOrgIdSetByCurManager() {
        HashSet<String> orgIdSet = new HashSet<String>();
        if (this.getCurMbgViewManager() != null) {
            IMbgSheetManager sheetManger = null;
            Map<String, String> orgIdAndNumMap = null;
            for (int sheetIndex = 0; sheetIndex < ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().size(); ++sheetIndex) {
                sheetManger = ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex);
                orgIdAndNumMap = this.getOrgIdAndNumMap(sheetManger.getDimensionManager().getDimension());
                orgIdSet.addAll(orgIdAndNumMap.keySet());
            }
        }
        return orgIdSet;
    }

    public Set<String> getOrgIdSetByCurSheet() {
        HashSet<String> orgIdSet = new HashSet<String>();
        if (this.getCurMbgViewManager() != null) {
            IMbgSheetManager sheetManger = null;
            Map<String, String> orgIdAndNumMap = null;
            sheetManger = ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(((IMbgSheetManager)this.getCurMbgSheetManager()).getSheetIndex());
            orgIdAndNumMap = this.getOrgIdAndNumMap(sheetManger.getDimensionManager().getDimension());
            orgIdSet.addAll(orgIdAndNumMap.keySet());
        }
        return orgIdSet;
    }

    protected Map<String, String> getOrgIdAndNumMap(List<BgDimensionInfo> dimensions) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        BgDimensionMember member = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(i).getNumber())) continue;
            for (int j = 0; j < dimensions.get(i).getMember().size(); ++j) {
                member = (BgDimensionMember)dimensions.get(i).getMember().get(j);
                if (member.getAttribute().startsWith("F")) continue;
                returnMap.put(member.getAttribute(), member.getNumber());
            }
        }
        return returnMap;
    }

    @Override
    protected void dealCalculateColFormula(Sheet sheet) throws Exception {
        long ct = System.currentTimeMillis();
        if (sheet == null) {
            return;
        }
        Column column = null;
        BgCalcuteColumn bgCalcuteColumn = null;
        Row row = null;
        List _rowObj = null;
        Cell cell = null;
        List viewMembers = BgViewHelper.getCurrPageMember(this.getViewF7List(sheet.getSheetIndex()), this.getDimensionDataForCurSheet(sheet).getDimensionManager().getDimension());
        List pageMembers = BgViewHelper.getCurrPageMember(this.getPageF7List(sheet.getSheetIndex()), this.getDimensionDataForCurSheet(sheet).getDimensionManager().getDimension());
        String orgNumber = null;
        String orgId = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (!MBgTemplateHelper.isCalColumn(column) || StringUtils.isEmpty((String)(bgCalcuteColumn = MBgTemplateHelper.getCalColumn(column)).getFormula())) continue;
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                row = sheet.getRow(rowIndex, false);
                if (row == null || row.getUserObjectValue("DIMENSION") == null) continue;
                _rowObj = (List)row.getUserObjectValue("DIMENSION");
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null) continue;
                orgNumber = null;
                if (_rowObj == null || _rowObj.isEmpty()) continue;
                for (int i = 0; i < _rowObj.size(); ++i) {
                    if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionMember)_rowObj.get(i)).getType())) continue;
                    orgNumber = ((BgDimensionMember)_rowObj.get(i)).getNumber();
                    orgId = ((BgDimensionMember)_rowObj.get(i)).getAttribute();
                    idSet.add(orgId);
                }
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        IFullOrgUnit biz = null;
        biz = this.getCtx() == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)this.getCtx());
        OrgUnitCollection orgUnitCollection = biz.getOrgUnitCollection(viewInfo);
        HashMap<String, OrgUnitInfo> _orgMap = new HashMap<String, OrgUnitInfo>();
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            _orgMap.put(orgUnitCollection.get(i).getId().toString(), orgUnitCollection.get(i));
        }
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
            column = sheet.getColumn(colIndex, false);
            if (!MBgTemplateHelper.isCalColumn(column)) continue;
            bgCalcuteColumn = MBgTemplateHelper.getCalColumn(column);
            if (!StringUtils.isEmpty((String)bgCalcuteColumn.getFormula())) {
                for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                    String obj;
                    String funcionName;
                    row = sheet.getRow(rowIndex, false);
                    if (row == null || row.getUserObjectValue("DIMENSION") == null) continue;
                    _rowObj = (List)row.getUserObjectValue("DIMENSION");
                    if (_rowObj != null) {
                        if (viewMembers != null) {
                            _rowObj.addAll(viewMembers);
                        }
                        if (pageMembers != null) {
                            _rowObj.addAll(pageMembers);
                        }
                    }
                    String itemCombine = this.getItemCombine(_rowObj);
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    long cc = System.currentTimeMillis();
                    orgNumber = null;
                    if (_rowObj != null && !_rowObj.isEmpty()) {
                        for (int i = 0; i < _rowObj.size(); ++i) {
                            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionMember)_rowObj.get(i)).getType())) continue;
                            orgNumber = ((BgDimensionMember)_rowObj.get(i)).getNumber();
                            orgId = ((BgDimensionMember)_rowObj.get(i)).getAttribute();
                            break;
                        }
                    }
                    parameters.add(new Object[]{cell.getRow(), cell.getCol(), BgNFSHelper.getExpression(cell), null, orgNumber, itemCombine, _rowObj, null, _orgMap.get(orgId)});
                    String function = BgNFSHelper.getExpression(cell);
                    if (StringUtils.isEmpty((String)function)) continue;
                    Expression parse = ExcelFormulaPaserHelper.parse((String)function);
                    if (cell == null || !(parse instanceof FunctionExpr) || !"RPTDATE".equalsIgnoreCase(funcionName = ((FunctionExpr)parse).funcionName) && !"MbgRptDate".equalsIgnoreCase(funcionName) && !"MbgCreateDate".equalsIgnoreCase(funcionName) && !"MbgGetOrgNum".equalsIgnoreCase(funcionName) || (obj = cell.getStyle().getNumberFormat()) != null && "@".equals(obj)) continue;
                    BgNFSHelper.setNumberFormat(cell, "@");
                }
            }
            Map resultExpress = this.getExpressionInterface().getExpressionMap(parameters, (IMbgSheetBase)this.getCurMbgSheetManager(), this.model, false);
            Cell itemCell = null;
            String _expression = null;
            String[] splitRowCol = null;
            for (String item : resultExpress.keySet()) {
                splitRowCol = item.split(BgBaseConstants.SEP_FOUR_STR);
                itemCell = sheet.getCell(Integer.valueOf(splitRowCol[0]).intValue(), Integer.valueOf(splitRowCol[1]).intValue(), false);
                _expression = (String)resultExpress.get(item);
                if (_expression == null || _expression.indexOf(DimensionConstants.DEF_INDEX_SRCNUMBER + ":") < 0 && _expression.toUpperCase().indexOf("MbgAggregate".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("Mbgadjust".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgAdjustDate".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgActualDay".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgBgAvlBal".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgRefBgTem".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgRefBgForm".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("ACCT".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("CSREF".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("MbgCorUnit".toUpperCase()) < 0 && _expression.toUpperCase().indexOf("ElimData".toUpperCase()) < 0) continue;
                itemCell.setFormula(_expression);
                itemCell.setValue(itemCell.getValue());
            }
        }
        logger.info((Object)("dealCalculateColFormula:" + (System.currentTimeMillis() - ct) + "(ms)"));
    }
}

