/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.form;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MBGFormExportProvider
extends MBGFormProvider {
    private static final Logger logger = CoreUIObject.getLogger(MBGFormExportProvider.class);
    private boolean isMoveDimension = true;
    private CoreUIObject ownerUI = null;
    private Map<String, BgFormInfo> bgFormInfoMap = null;
    private Map<String, Book> bookMap = new HashMap<String, Book>();
    private Map<String, String> pageViewNumbers = null;
    private BgFormInfo currentBgFormInfo = null;

    public boolean isMoveDimension() {
        return this.isMoveDimension;
    }

    @Override
    public BgFormInfo getBgFormInfo() {
        return this.currentBgFormInfo;
    }

    public void setBgFormInfo(BgFormInfo info) {
        this.currentBgFormInfo = info;
    }

    public MBGFormExportProvider(Map<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI) {
        this.bgFormInfoMap = bgFormInfoMap;
        this.ownerUI = ownerUI;
        this.init();
    }

    public MBGFormExportProvider(Map<String, BgFormInfo> bgFormInfoMap, CoreUIObject ownerUI, Boolean isMoveDimension, Map<String, String> pageViewNumbers) {
        this.bgFormInfoMap = bgFormInfoMap;
        this.ownerUI = ownerUI;
        this.isMoveDimension = isMoveDimension;
        this.pageViewNumbers = pageViewNumbers;
        this.init();
    }

    public Map<String, Book> getBookMap() {
        return this.bookMap;
    }

    private void init() {
        BgFormInfo bgFormInfo;
        HashSet<String> formIds = new HashSet<String>();
        for (String formId : this.bgFormInfoMap.keySet()) {
            bgFormInfo = this.bgFormInfoMap.get(formId);
            if (bgFormInfo.getBgTemplate().getFormType().getValue() != 4) continue;
            formIds.add(formId);
        }
        if (formIds.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getViewlistSelectors());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", formIds, CompareType.INCLUDE));
        try {
            BgFormCollection colls = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
            for (int index = 0; index < colls.size(); ++index) {
                String formId;
                bgFormInfo = colls.get(index);
                formId = bgFormInfo.getId().toString();
                this.setBgFormInfo(bgFormInfo);
                this.setEditValue((IObjectValue)bgFormInfo);
                this.setOrgUnitInfo(bgFormInfo.getOrgUnit());
                this.setOwner(this.ownerUI);
                long ct = System.currentTimeMillis();
                logger.info((Object)("start initBook : " + ct));
                Book book = this.initBook();
                logger.info((Object)("end initBook : " + (System.currentTimeMillis() - ct) + "ms"));
                this.bookMap.put(formId, book);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.ownerUI.handUIException((Throwable)e);
        }
    }

    private Book initBook() throws Exception {
        Book _book = (Book)this.load();
        this.fillData(_book);
        this.calcBook(_book, this.getReportAdapter());
        return _book;
    }

    protected IReportPropertyAdapter getReportAdapter() {
        BgRptReportPropertyAdapter adapter = new BgRptReportPropertyAdapter(this.getBgFormInfo());
        adapter.setOrgUnit(this.getOrgUnitInfo());
        return adapter;
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        if (this.isMoveDimension()) {
            BgViewHelper.movePageDimensionsToRow((IMbgViewManager)this.curMbgViewManager, true);
        } else {
            MBGViewListFormCommonHelper.filterCurPageView(this.curMbgViewManager, this.getBgFormInfo().getId().toString(), this.pageViewNumbers);
        }
    }

    private SelectorItemCollection getViewlistSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("bgTemplate.bgScheme.id");
        return sic;
    }

    @Override
    protected int getDataType() {
        if (this.getBgFormInfo() != null && DimensionCommonHelper.isDecompose(this.getBgFormInfo().getProcessType())) {
            return this.getBgFormInfo().getDataType();
        }
        return super.getDataType();
    }
}

