/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.provider.viewListForm;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class MbgViewlistMeasureUnitHelper {
    private int defaultPrecision = 2;
    private Map<String, Integer> accountDataTypeMap = null;
    private Map<String, BgElementInfo> elementObjMap = null;
    private TemplateStyleInfo templateStyle = null;

    public Map<String, BgElementInfo> getElementObjMap() {
        return this.elementObjMap;
    }

    public Map<String, Integer> getAccountDataTypeMap() {
        return this.accountDataTypeMap;
    }

    public TemplateStyleInfo getTemplateStyle() {
        return this.templateStyle;
    }

    public MbgViewlistMeasureUnitHelper(Map<String, Integer> accountDataTypeMap, TemplateStyleInfo templateStyle, Map<String, BgElementInfo> elementObjMap) {
        this.accountDataTypeMap = accountDataTypeMap;
        this.templateStyle = templateStyle;
        this.elementObjMap = elementObjMap;
    }

    public Map<String, Integer> getMeasureUnitMap() {
        HashMap<String, Integer> measureUnitMap = new HashMap<String, Integer>();
        measureUnitMap.put("currency", MBGViewListFormCommonHelper.transMeasureUnit(this.getTemplateStyle().getCurrencyMeasureUnit()));
        measureUnitMap.put("noCurrency", MBGViewListFormCommonHelper.transMeasureUnit(this.getTemplateStyle().getNoCurrencyMeasureUnit()));
        measureUnitMap.put("rate", MBGViewListFormCommonHelper.transMeasureUnit(this.getTemplateStyle().getRateMeasureUnit()));
        return measureUnitMap;
    }

    public String getDataNumberFormate(String bgAccountNumber, Boolean isRateElement, String eleNumber) {
        if (StringUtils.isEmpty((String)bgAccountNumber) && !this.getAccountDataTypeMap().containsKey(bgAccountNumber)) {
            return null;
        }
        return this.getDataNumberFormate(this.getAccountDataTypeMap().get(bgAccountNumber), isRateElement, eleNumber);
    }

    public String getDataNumberFormate(Integer accountType, Boolean isRateElement, String eleNumber) {
        String numberFormat = ViewListStyleHelper.convertStyle(this.getTemplateStyle().getDataStyleAttributes()).getNumberFormat();
        if (this.templateStyle.isDataTYpe()) {
            if (accountType == 10) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getCurrencyNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getCurrencyDecNums(), this.templateStyle.isCurrencyHasGroupSep(), isRateElement != false ? this.templateStyle.isCurrencyShowPercent() : false);
            } else if (accountType == 20) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getNoCurrencyNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getNoCurrencyDecNums(), this.templateStyle.isNoCurrencyGroupSep(), isRateElement != false ? this.templateStyle.isNoCurrencyShowPercent() : false);
            } else if (accountType == 30) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getRateNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getRateDecNums(), this.templateStyle.isRateHasGroupSep(), this.templateStyle.isRateShowPercent());
            }
        } else if (eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
            Object[] object = this.templateStyle.getEleMap().get(eleNumber);
            this.templateStyle.setDataNegativeIndex((Integer)object[2]);
            numberFormat = this.templateStyle.toNumberPatternNoColor((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
        }
        return numberFormat;
    }

    public BigDecimal getCoef(String _bgAccountNumber, String eleNumber) {
        BigDecimal defaultValue = new BigDecimal(this.getMeasureUnitMap().get("currency"));
        if (this.templateStyle.isDataTYpe()) {
            if (this.getAccountDataTypeMap() == null || !this.getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
                return defaultValue;
            }
            if (this.getAccountDataTypeMap().get(_bgAccountNumber) != null && this.getAccountDataTypeMap().get(_bgAccountNumber) instanceof Integer) {
                if (10 == this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal(this.getMeasureUnitMap().get("currency"));
                }
                if (20 == this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal(this.getMeasureUnitMap().get("noCurrency"));
                }
                if (30 == this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal(this.getMeasureUnitMap().get("rate"));
                }
            }
        } else if (eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
            Object[] object = this.templateStyle.getEleMap().get(eleNumber);
            if ((Integer)object[3] == 0) {
                return this.templateStyle.getCof();
            }
            return new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit((Integer)object[3] - 1));
        }
        return defaultValue;
    }

    public BigDecimal getBigDecimalValue(Object obj, BigDecimal coefficient, int precision, String numberFormat) {
        if (BgNFSHelper.checkHasPercentage(numberFormat)) {
            precision += 2;
        }
        return new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
    }

    public String getDisplayValue(Object obj, BigDecimal coefficient, int precision, String numberFormat) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            precision = this.checkHasPercent(precision, numberFormat);
            _value = this.getBigDecimalValue(obj, coefficient, precision, numberFormat);
            if (numberFormat != null) {
                _decFormat = new DecimalFormat(numberFormat);
                if (_value.compareTo(BigDecimal.ZERO) < 0 && !numberFormat.contains(";-") && !numberFormat.contains(";(")) {
                    _value = _value.multiply(new BigDecimal(-1));
                }
                _decFormat = precision != 0 ? new DecimalFormat(numberFormat) : new DecimalFormat("#,##0");
            } else {
                _decFormat = precision != 0 ? new DecimalFormat(numberFormat) : new DecimalFormat("#,##0");
            }
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected int checkHasPercent(int precision, String numberFormat) {
        if (!StringUtils.isEmpty((String)numberFormat) && (numberFormat.endsWith("%") || numberFormat.endsWith("%)"))) {
            precision += 2;
        }
        return precision;
    }

    public int getPrecision(Cell cell) {
        return BgNFSHelper.getDigitOfNumber(cell, this.defaultPrecision);
    }

    public String getCalcDisplayValue(Cell cell, Object obj) {
        ViewListCalculatorDataStyleInfo calcDataStyle = ViewListHelper.getCalculatorDataStyle(cell);
        int _precision = BgNFSHelper.getDigitOfNumber(cell, this.defaultPrecision);
        BigDecimal _coefficient = new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit(calcDataStyle.getMeasureUnit()));
        String numberFormat = this.getCalcNumberFormate(calcDataStyle);
        return this.getDisplayValue(obj, _coefficient, _precision, numberFormat);
    }

    private String getCalcNumberFormate(ViewListCalculatorDataStyleInfo calcDataStyle) {
        if (calcDataStyle == null) {
            return null;
        }
        this.getTemplateStyle().setDataNegativeIndex(calcDataStyle.getNegativeIndex());
        String numberFormat = this.getTemplateStyle().toNumberPatternNoColor(calcDataStyle.getDecNums(), calcDataStyle.isHasGroupSep(), calcDataStyle.isShowPercent());
        return numberFormat;
    }
}

