/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.roll;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentHandleFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.IBgScenario;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.BgRollSettingsCollection;
import com.kingdee.eas.ma.mbg.BgRollSettingsFactory;
import com.kingdee.eas.ma.mbg.BgRollSettingsInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgRollSettings;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgFormRollSHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.roll.BgRollParameter;
import com.kingdee.eas.ma.mbg.roll.BgRollStrategyFactory;
import com.kingdee.eas.ma.mbg.roll.IBgRollRuleStrategy;
import com.kingdee.eas.ma.mbg.utils.BgMergeSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BgRollContext {
    private BgFormCollection bgFormInfos;
    private Context ctx;
    private Map<BOSUuid, Map<String, BgScenarioInfo>> scenMappings = new HashMap<BOSUuid, Map<String, BgScenarioInfo>>();
    private String bgSchemeId;
    private BgSchemeDimensionHelper schemeHelper;
    private Map<String, BgPeriodInfo> schemePeriodRange = new HashMap<String, BgPeriodInfo>();
    private Map<String, BgScenarioInfo> scenarios = new HashMap<String, BgScenarioInfo>();
    BgCodeNumberHelper numberCodeHelper;
    BgCodeNumberHelper nameCodeHelper;
    public static final int INITIAL_INDEX = 0;
    public static final int ROLL_INDEX = 1;
    private Map result = new HashMap();
    public static final String RESOURCE_DECOMPOSE = "com.kingdee.eas.ma.mbg.MbgRollFormResource";
    private FilterInfo filter;

    private BgRollContext(Context ctx, BgFormCollection bgFormInfos) {
        this.ctx = ctx;
        this.bgFormInfos = bgFormInfos;
        this.bgSchemeId = bgFormInfos.get(0).getBgScheme().getId().toString();
        this.numberCodeHelper = new BgCodeNumberHelper(ctx, null, "sourceType");
        this.nameCodeHelper = new BgCodeNumberHelper(ctx, "name", "sourceType");
    }

    public static BgRollContext newInstance(Context ctx, BgFormInfo info) {
        BgFormCollection bgFormInfos = new BgFormCollection();
        bgFormInfos.add(info);
        return BgRollContext.newInstance(ctx, bgFormInfos);
    }

    public static BgRollContext newInstance(Context ctx, BgFormCollection bgFormInfos) {
        return new BgRollContext(ctx, bgFormInfos);
    }

    private void initBaseData() throws BOSException, EASBizException {
        this.getRollScenMapping();
        this.doSchemePeriodRange();
        this.doSchemeScenario();
    }

    private void doSchemeScenario() throws EASBizException, BOSException {
        Set<String> typeIds = this.getBgSchemeDimensionHelper().getMemberSet(DimensionBaseConstants.DEF_SCENARIO_NUMBER, false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", typeIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IBgScenario instance = this.ctx != null ? BgScenarioFactory.getLocalInstance((Context)this.ctx) : BgScenarioFactory.getRemoteInstance();
        BgScenarioCollection col = instance.getBgScenarioCollection(view);
        if (col != null && !col.isEmpty()) {
            int in = col.size();
            for (int i = 0; i < in; ++i) {
                this.scenarios.put(col.get(i).getNumber(), col.get(i));
            }
        }
    }

    private BgSchemeDimensionHelper getBgSchemeDimensionHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.bgSchemeId);
        }
        return this.schemeHelper;
    }

    public Map rollBgForm() throws Exception {
        this.initBaseData();
        boolean checkEditPeriod = false;
        CoreBaseCollection colls = new CoreBaseCollection();
        CoreBaseCollection traceCols = new CoreBaseCollection();
        HashSet<String> orgIdFail = new HashSet<String>();
        Iterator iter = this.bgFormInfos.iterator();
        while (iter.hasNext()) {
            BgFormInfo bgFormInfo = (BgFormInfo)iter.next();
            try {
                IBgRollRuleStrategy rollStrategy = BgRollStrategyFactory.newInstance(bgFormInfo.getBgRollRule().getRollPart());
                rollStrategy.setBgRollParameter(this.getBgRollParameter(bgFormInfo));
                BgFormInfo rollInfo = rollStrategy.rollBgForm();
                BgFormCollection traceBgRollForm = this.traceBgRollForm(this.ctx, rollInfo);
                String rollFormName = this.checkNumberRuleAndApplyNumber(rollInfo, orgIdFail, rollStrategy);
                rollInfo.setName(rollFormName);
                this.copyAttachment(rollInfo, bgFormInfo);
                this.addDataRef(this.ctx, bgFormInfo.getId().toString(), rollInfo.getId().toString());
                this.copyEditNotes(this.ctx, bgFormInfo.getId().toString(), rollInfo.getId().toString());
                List<Set<String>> canEditPeriodNumbers = rollStrategy.getCanEditPeriodNumbers(bgFormInfo, rollInfo);
                checkEditPeriod = this.checkEditPeriod(canEditPeriodNumbers.get(0), canEditPeriodNumbers.get(1));
                BgFormInfo generateHistoryForm = null;
                if (checkEditPeriod) {
                    generateHistoryForm = this.generateHistoryForm(this.ctx, bgFormInfo);
                    this.copyEditNotes(this.ctx, bgFormInfo.getId().toString(), generateHistoryForm.getId().toString());
                    this.copyAttachment(generateHistoryForm, bgFormInfo);
                }
                if (!this.result.containsKey("rollSuccess")) {
                    this.result.put("rollSuccess", colls);
                }
                ((CoreBaseCollection)this.result.get("rollSuccess")).add((CoreBaseInfo)rollInfo);
                if (!this.result.containsKey("histroyForm")) {
                    this.result.put("histroyForm", new ArrayList(this.bgFormInfos.size()));
                }
                if (generateHistoryForm != null) {
                    ((List)this.result.get("histroyForm")).add(generateHistoryForm);
                }
                if (!this.result.containsKey("traceBgForms")) {
                    this.result.put("traceBgForms", traceCols);
                }
                ((CoreBaseCollection)this.result.get("traceBgForms")).addObjectCollection((IObjectCollection)traceBgRollForm);
            }
            catch (Exception e) {
                if (e instanceof BgRollException || e instanceof BgFormException) {
                    if (!this.result.containsKey("rollFailed")) {
                        this.result.put("rollFailed", new HashMap());
                    }
                    ((Map)this.result.get("rollFailed")).put(bgFormInfo.getId().toString(), e.getMessage());
                    continue;
                }
                throw new BOSException((Throwable)e);
            }
        }
        return this.result;
    }

    private BgFormCollection traceBgRollForm(Context ctx, BgFormInfo rollInfo) throws BOSException {
        String bgSchemeId = rollInfo.getBgScheme().getId().toString();
        String orgUnitId = rollInfo.getOrgUnit().getId().toString();
        String bgVersionId = rollInfo.getBgVersion().getId().toString();
        String bgTemplateId = rollInfo.getBgTemplate().getId().toString();
        String bgPeriodNumber = rollInfo.getBgPeriod().getNumber();
        String currencyId = rollInfo.getCurrency().getId().toString();
        BgProcessEnum processType = rollInfo.getProcessType();
        BgPeriodEnum periodType = rollInfo.getBgPeriod().getPeriodType();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("traceRollId");
        view.getSelector().add("isRolled");
        view.getSelector().add("bgSpecialItems.*");
        view.getSelector().add("bgTemplate.id");
        view.getSelector().add("bgTemplate.formType");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgVersionId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)bgTemplateId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("processType", (Object)processType.getValue(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgPeriod.number", (Object)bgPeriodNumber, CompareType.LESS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", (Object)periodType.getValue(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgRollPeriod", null, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("rollSourceId", null, CompareType.EQUALS));
        view.setFilter(filterInfo);
        BgFormCollection bgFormCollection = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
        for (int i = 0; i < bgFormCollection.size(); ++i) {
            BgFormInfo info = bgFormCollection.get(i);
            if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)rollInfo.getFormType()) && !StringUtils.isEmpty((String)rollInfo.getSpecialItemNumber()) && !rollInfo.getSpecialItemNumber().equals(info.getSpecialItemNumber())) continue;
            info.setIsRolled(true);
            info.setRollSourceId(rollInfo.getId().toString());
        }
        return bgFormCollection;
    }

    private void copyAttachment(BgFormInfo rollInfo, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        String[] attachmentIDsByBoID = new String[]{bgFormInfo.getId().toString()};
        IAttachmentHandleFacade iAttachmentHandleFacade = AttachmentHandleFacadeFactory.getLocalInstance((Context)this.ctx);
        IAttachment localInstance = AttachmentFactory.getLocalInstance((Context)this.ctx);
        List attachmentID = iAttachmentHandleFacade.getAttachmentID(attachmentIDsByBoID);
        if (attachmentID == null || attachmentID.isEmpty()) {
            return;
        }
        HashSet ids = new HashSet(attachmentID);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        AttachmentCollection attachmentCollection = localInstance.getAttachmentCollection(view);
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < attachmentCollection.size(); ++i) {
            AttachmentInfo attachmentInfo = attachmentCollection.get(i);
            attachmentInfo.setId(BOSUuid.create((String)"F4AF4F03"));
            for (int j = 0; j < attachmentInfo.getBoAttchAsso().size(); ++j) {
                attachmentInfo.getBoAttchAsso().get(j).setId(BOSUuid.create((String)"172F3A47"));
                attachmentInfo.getBoAttchAsso().get(j).setBoID(rollInfo.getId().toString());
                attachmentInfo.getBoAttchAsso().get(j).setAttachment(attachmentInfo);
            }
            colls.addObject((IObjectValue)attachmentInfo);
        }
        localInstance.addnewBatchData(colls);
    }

    private void copyEditNotes(Context ctx, String sourceFormId, String targetFormId) throws SQLException {
        MbgSqlHelper.execute((Context)ctx, (String)"insert into T_MBG_MbgViewListEditNote(Fid,FBgFormID,FBgTemplateID,FValue,FSheetIndex) select newbosid('9D8BE7F3'),?, FBgTemplateID,FValue,FSheetIndex from T_MBG_MbgViewListEditNote where fbgFormId = ? ", (Object[])new Object[]{targetFormId, sourceFormId});
    }

    private void addDataRef(Context ctx, String sourceFormId, String targetFormId) throws EASBizException, BOSException, SQLException {
        BgSchemeInfo rootBgScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, BOSUuid.read((String)this.bgSchemeId));
        if (rootBgScheme == null) {
            return;
        }
        String bgDataTable = rootBgScheme.getRefCube();
        String cubeEntryName = BgCubeUtils.getCubeEntryName(bgDataTable, 1);
        BgDimensionInfo dimension = this.schemeHelper.getDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER);
        HashSet<String> bgScenarioNumbers = new HashSet<String>();
        BgDimensionMember dimensionMember = null;
        for (int i = 0; i < dimension.getMember().size(); ++i) {
            dimensionMember = (BgDimensionMember)dimension.getMember().get(i);
            bgScenarioNumbers.add(dimensionMember.getNumber());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(cubeEntryName).append("(fdataId,FFormId) select fid ,? from ").append(bgDataTable).append(" where fstate >= 9 and fscenario in( SELECT fscenarioId FROM T_mbg_bgscenario where ftype = 0)  and fid in( select fdataid from ").append(cubeEntryName).append(" where fformId = ?)");
        MbgSqlHelper.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetFormId, sourceFormId});
    }

    private BgFormInfo generateHistoryForm(Context ctx, BgFormInfo bgFormInfo) throws Exception {
        BgFormInfo historyRollForm = null;
        String versionNumber = bgFormInfo.getBgVersion().getNumber() + "-" + bgFormInfo.getBgPeriod().getNumber();
        String versionName = bgFormInfo.getBgVersion().getName() + "-" + bgFormInfo.getBgPeriod().getName();
        boolean isRepeatNumber = BgVersionFactory.getLocalInstance((Context)ctx).isExistRepeatNum(versionNumber);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgDimSettings.*");
        sic.add("bgDimSettings.members.*");
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgScheme().getId()), sic);
        BgDimSettingsCollection settings = bgSchemeInfo.getBgDimSettings();
        BgVersionInfo bgVersionInfo = null;
        if (!isRepeatNumber) {
            bgVersionInfo = new BgVersionInfo();
            bgVersionInfo.setId(BOSUuid.create((BOSObjectType)bgVersionInfo.getBOSType()));
            bgVersionInfo.setOrgUnit(bgFormInfo.getOrgUnit());
            bgVersionInfo.setNumber(versionNumber);
            bgVersionInfo.setName(versionName);
            bgVersionInfo.setIsRollVersion(true);
            bgVersionInfo.setDescription(EASResource.getString((String)RESOURCE_DECOMPOSE, (String)"historyRollBgVersionDes", (Locale)ctx.getLocale()));
            BgVersionFactory.getLocalInstance((Context)ctx).addnew(bgVersionInfo);
        } else {
            bgVersionInfo = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionInfo("select id,name,number,orgunit.id,versionId where number ='" + versionNumber + "'");
        }
        BgSchemeInfo bgScheme = bgFormInfo.getBgScheme();
        boolean isRepeatVersionNumber = false;
        BgDimSettingsInfo bgDimSettingsInfo = null;
        int seq = -1;
        for (int i = 0; i < settings.size(); ++i) {
            bgDimSettingsInfo = settings.get(i);
            if (bgDimSettingsInfo.getDimNumber().equalsIgnoreCase(DimensionConstants.DEF_VERSION_NUMBER)) {
                seq = bgDimSettingsInfo.getMembers().size();
                for (int n = 0; n < seq; ++n) {
                    if (!bgDimSettingsInfo.getMembers().get(n).getNumber().equals(versionNumber)) continue;
                    isRepeatVersionNumber = true;
                    break;
                }
                if (!isRepeatVersionNumber) {
                    BgDimSettingsMemberInfo member = new BgDimSettingsMemberInfo();
                    member.setMemberID(bgVersionInfo.getId());
                    member.setNumber(bgVersionInfo.getNumber());
                    member.setName(bgVersionInfo.getName());
                    member.setType(MemberTypeEnum.member);
                    member.setId(bgVersionInfo.getId());
                    member.setSeq(seq + 1);
                    member.setBgDimSettings(bgDimSettingsInfo);
                    bgDimSettingsInfo.getMembers().add(member);
                }
            }
            bgScheme.getBgDimSettings().add(bgDimSettingsInfo);
        }
        BgMergeSchemeHelper.filterOrgViewByType(bgScheme.getBgDimSettings(), MemberTypeEnum.budget);
        if (!isRepeatVersionNumber) {
            BgSchemeFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bgScheme);
        }
        historyRollForm = bgFormInfo.deepclone();
        historyRollForm.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
        historyRollForm.getAdjust().setId(historyRollForm.getId());
        historyRollForm.setAdjust(historyRollForm);
        historyRollForm.setBgVersion(bgVersionInfo);
        historyRollForm.setIsRolled(true);
        historyRollForm.setAuditOrgUnit(bgFormInfo.getAuditOrgUnit());
        for (int j = 0; j < bgFormInfo.getBgSpecialItems().size(); ++j) {
            BgSpecialItemsInfo specialItem = (BgSpecialItemsInfo)bgFormInfo.getBgSpecialItems().get(j).clone();
            historyRollForm.getBgSpecialItems().set(j, specialItem);
            specialItem.setId(BOSUuid.create((BOSObjectType)specialItem.getBOSType()));
            for (int g = 0; g < specialItem.getDimRelaGroupRef().size(); ++g) {
                BgSpecialDimRelaGroupRefInfo refInfo = (BgSpecialDimRelaGroupRefInfo)specialItem.getDimRelaGroupRef().get(g).clone();
                specialItem.getDimRelaGroupRef().set(j, refInfo);
                refInfo.setId(BOSUuid.create((BOSObjectType)refInfo.getBOSType()));
                refInfo.setBgSpecialItems(specialItem);
            }
            specialItem.setBgForm(historyRollForm);
        }
        this.dealExistHistoryForm(ctx, historyRollForm);
        MbgFormRollSHelper.generateHistroyRollForm(ctx, bgFormInfo.getId().toString(), historyRollForm);
        return historyRollForm;
    }

    private BgRollParameter getBgRollParameter(BgFormInfo bgFormInfo) {
        BgRollParameter parameter = new BgRollParameter();
        parameter.setBgFormInfo(bgFormInfo);
        parameter.setRollInfo(bgFormInfo.getBgRollRule());
        parameter.setScenMappings(this.scenMappings.get(bgFormInfo.getBgRollRule().getId()));
        parameter.setSchemePeriodRange(this.schemePeriodRange);
        parameter.setScenarios(this.scenarios);
        parameter.setCtx(this.ctx);
        return parameter;
    }

    private boolean checkEditPeriod(Set oldEditPeriods, Set newEditPeriods) throws BgRollException {
        if (oldEditPeriods == null || newEditPeriods == null) {
            return false;
        }
        oldEditPeriods.retainAll(newEditPeriods);
        return !oldEditPeriods.isEmpty();
    }

    private void getRollScenMapping() throws BOSException {
        if (this.bgFormInfos == null || this.bgFormInfos.isEmpty()) {
            return;
        }
        HashSet<String> rollIds = new HashSet<String>();
        int in = this.bgFormInfos.size();
        for (int i = 0; i < in; ++i) {
            rollIds.add(this.bgFormInfos.get(i).getBgRollRule().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("bgRollRule.id");
        view.getSelector().add("bgScenario.number");
        view.getSelector().add("actScenario.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgRollRule.id", rollIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IBgRollSettings instance = this.ctx != null ? BgRollSettingsFactory.getLocalInstance(this.ctx) : BgRollSettingsFactory.getRemoteInstance();
        BgRollSettingsCollection bgRollSettings = instance.getBgRollSettingsCollection(view);
        if (bgRollSettings == null || bgRollSettings.isEmpty()) {
            return;
        }
        int in2 = bgRollSettings.size();
        for (int i = 0; i < in2; ++i) {
            BgRollSettingsInfo bgRollSettingsInfo = bgRollSettings.get(i);
            if (!this.scenMappings.containsKey(bgRollSettingsInfo.getBgRollRule().getId())) {
                this.scenMappings.put(bgRollSettingsInfo.getBgRollRule().getId(), new HashMap());
            }
            this.scenMappings.get(bgRollSettingsInfo.getBgRollRule().getId()).put(bgRollSettingsInfo.getBgScenario().getNumber(), bgRollSettingsInfo.getActScenario());
        }
    }

    protected void doSchemePeriodRange() throws BOSException, EASBizException {
        if (this.bgFormInfos == null || this.bgFormInfos.isEmpty()) {
            return;
        }
        Date from = BgNPeriodHelper.getDayBegin((Date)this.bgFormInfos.get(0).getBgScheme().getDateFrom());
        Date end = BgNPeriodHelper.getDayEnd((Date)this.bgFormInfos.get(0).getBgScheme().getDateTo());
        IBgPeriodDisp instance = this.ctx != null ? BgPeriodDispFactory.getLocalInstance((Context)this.ctx) : BgPeriodDispFactory.getRemoteInstance();
        Set<String> typeIds = this.getBgSchemeDimensionHelper().getMemberSet(DimensionBaseConstants.DEF_PERIOD_NUMBER, false);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("periodType");
        view.getSelector().add("number");
        view.getSelector().add("bgPeriod.id");
        view.getSelector().add("bgPeriod.number");
        view.getSelector().add("bgPeriod.name");
        view.getSelector().add("bgPeriod.isLeaf");
        view.getSelector().add("bgPeriod.level");
        view.getSelector().add("bgPeriod.longNumber");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)from, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)end, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.selfDefined", (Object)false, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.id", typeIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BgPeriodDispCollection periods = instance.getBgPeriodDispCollection(view);
        int in = periods.size();
        for (int i = 0; i < in; ++i) {
            BgPeriodDispInfo info = periods.get(i);
            this.schemePeriodRange.put(info.getNumber(), info.getBgPeriod());
        }
    }

    public Set<String> getCanEditPeriodNumbers() throws Exception {
        this.initBaseData();
        BgFormInfo bgFormInfo = this.bgFormInfos.get(0);
        IBgRollRuleStrategy rollStrategy = BgRollStrategyFactory.newInstance(bgFormInfo.getBgRollRule().getRollPart());
        rollStrategy.setBgRollParameter(this.getBgRollParameter(bgFormInfo));
        return rollStrategy.getCanEditPeriodNumbers(bgFormInfo, null).get(0);
    }

    public String checkNumberRuleAndApplyNumber(BgFormInfo info, Set<String> orgIdFail, IBgRollRuleStrategy rollStrategy) throws EASBizException, BOSException {
        Object otherKey = null;
        String orgId = null;
        String defFormName = null;
        defFormName = info.getBgPeriod().getName() + "-" + info.getBgTemplate().getName() + "-" + info.getBgVersion().getName();
        orgId = info.getOrgUnit().getId().toString();
        if (orgIdFail.contains(orgId)) {
            throw new BgRollException(BgRollException.CODENUMBERROLLFAIL, new Object[]{info.getOrgUnit().getName() + "(" + info.getOrgUnit().getNumber() + ")"});
        }
        this.numberCodeHelper.init((IObjectValue)info, orgId);
        this.nameCodeHelper.init((IObjectValue)info, orgId);
        if (!this.numberCodeHelper.isHasCodeNumber()) {
            orgIdFail.add(orgId);
            throw new BgRollException(BgRollException.CODENUMBERROLLFAIL, new Object[]{info.getOrgUnit().getName() + "(" + info.getOrgUnit().getNumber() + ")"});
        }
        this.numberCodeHelper.applyNumber((IObjectValue)info, orgId, "rollForm", true);
        if (this.nameCodeHelper.isHasCodeNumber()) {
            this.nameCodeHelper.applyNumber((IObjectValue)info, orgId, defFormName, true);
            defFormName = info.getName();
        }
        return defFormName;
    }

    private void dealExistHistoryForm(Context ctx, BgFormInfo baseInfo) throws BOSException, EASBizException {
        Set<String> hasFormId = MbgFormRollSHelper.getHasFormId(ctx, baseInfo);
        if (hasFormId != null) {
            for (String temp : hasFormId) {
                BOSUuid read = BOSUuid.read((String)temp);
                BgFormFactory.getLocalInstance(ctx).deleteRollHistoryForm(read);
            }
        }
    }
}

