/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.roll.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgRollTypeEnum;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.app.utils.MbgFormRollSHelper;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.roll.BgRollParameter;
import com.kingdee.eas.ma.mbg.roll.IBgRollRuleStrategy;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class AbstractBgRollRuleStrategy
implements IBgRollRuleStrategy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.roll.Impl.AbstractBgRollRuleStrategy");
    protected Context ctx;
    protected BgRollRuleInfo rollInfo;
    protected BgFormInfo bgFormInfo;
    protected Map<String, BgScenarioInfo> scenMappings;
    protected Map<String, BgPeriodInfo> schemePeriodRanges;
    protected Set<String> leafPeriods = new HashSet<String>();
    private Map<String, BgScenarioInfo> scenarios;
    protected static final String ACTUAL_SIGN = "ACTUAL_SIGN";
    private static final String ADD_SPECIAL_FIRGROUP_SIGN = "ADD_SPECIAL_FIRGROUP_SIGN";
    protected static final String MAX_SOURCE_PERIOD_SIGN = "MAX_SOURCE_PERIOD_SIGN";
    protected static final String MIN_TARGET_PERIOD_SIGN = "MIN_TARGET_PERIOD_SIGN";
    private static final int HIS_INDEX = 0;

    @Override
    public void checkBgRoll(IMbgViewBase bgFormView) throws BOSException, EASBizException {
        this.checkState();
        this.checkTemplateEnable();
        this.checkPeriod(bgFormView);
        this.checkForm();
    }

    private void checkTemplateEnable() throws EASBizException, BOSException {
        BgTemplateStatusEnum templateStatus = this.bgFormInfo.getBgTemplate().getTemplateStatus();
        if (templateStatus.getValue() != 0) {
            throw new BgRollException(BgRollException.ROLLTEMPLATEENABLE, this.getExceptionParam());
        }
    }

    private void checkForm() {
    }

    protected void checkDimension(IMbgViewBase bgFormView) throws BgRollException, BOSException {
        BgTemFormTypeEnum formType = this.bgFormInfo.getBgTemplate().getFormType();
        String currPeriodNum = this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength());
        if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
            this.verifyFixForm(currPeriodNum);
        } else {
            this.verifyViewListForm(bgFormView, currPeriodNum);
        }
    }

    private void verifyFixForm(String currPeriodNum) throws BgRollException, BOSException {
        boolean verify = true;
        try {
            List formulas = BgNFSHelper.getFormulaListOfBook(this.bgFormInfo.getBook());
            int in = formulas.size();
            for (int i = 0; i < in; ++i) {
                String formula = (String)formulas.get(i);
                if (StringUtils.isEmpty((String)formula)) continue;
                String bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1];
                String bgScenarioNumber = BgNFSHelper.parseFormulaPara(formula)[3];
                if (!this.isProcessPeriod(bgPeriodNumber) || !BgScenarioType.BudgetData.equals((Object)this.scenarios.get(bgScenarioNumber).getType()) || bgPeriodNumber.compareTo(currPeriodNum) < 0) continue;
                verify = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (verify) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
        }
    }

    private void verifyViewListForm(IMbgViewBase bgFormView, String currPeriodNum) throws BgRollException {
        boolean flag = true;
        int in = bgFormView.getSheetManagers().size();
        for (int i = 0; i < in; ++i) {
            MbgViewListDimensionManager dimManager = (MbgViewListDimensionManager)bgFormView.getSheetManagers().get(i).getDimensionManager();
            List<IMbgViewListObject> columns = dimManager.getColumns();
            for (IMbgViewListObject obj : columns) {
                if (!(obj instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol rowCol = (MbgViewListRowCol)obj;
                BgDimensionBaseInfo dimensionInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
                if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
                List members = dimensionInfo.getMember();
                for (BgDimensionMember member : members) {
                    if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessPeriod(member.getNumber()) || member.getNumber().compareTo(currPeriodNum) < 0) continue;
                    flag = false;
                }
            }
        }
        if (flag) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
        }
    }

    protected Object[] getExceptionParam() {
        return this.getExceptionParam(this.bgFormInfo);
    }

    protected Object[] getExceptionParam(BgFormInfo info) {
        Object[] params = new Object[7];
        String specialDimName = info.getBgSpecialItems() != null && !info.getBgSpecialItems().isEmpty() ? info.getBgSpecialItems().get(0).getMemberDisplayName() : null;
        params[0] = info.getOrgUnit().getName();
        params[1] = info.getBgTemplate().getName();
        params[2] = info.getBgPeriod().getName();
        params[3] = info.getBgVersion().getName();
        params[4] = info.getCurrency().getName();
        params[5] = specialDimName == null ? "" : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"specialKey", (Locale)this.ctx.getLocale(), (Object[])new Object[]{specialDimName});
        params[6] = info.getProcessType().getAlias();
        return params;
    }

    @Override
    public BgFormInfo rollBgForm() throws Exception {
        IMbgViewBase bgFormView = this.bgFormInfo.getView(this.ctx, this.bgFormInfo.getBgScheme());
        BgFormInfo clone = this.bgFormInfo.deepclone();
        this.checkBgRoll(bgFormView);
        this.resetBgFormMsg(clone);
        BgTemFormTypeEnum formType = this.bgFormInfo.getBgTemplate().getFormType();
        if (BgRollTypeEnum.limitLengthRoll.equals((Object)this.rollInfo.getRollType())) {
            if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
                this.resetBook(clone, true);
            } else {
                this.resetViewListManager((MbgViewListManager)bgFormView, clone, true);
            }
        } else if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)formType) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType)) {
            this.resetBook(clone, false);
        } else {
            this.resetViewListManager((MbgViewListManager)bgFormView, clone, false);
        }
        return clone;
    }

    private void resetViewListManager(MbgViewListManager bgFormView, BgFormInfo clone, boolean isLimitLength) throws BgRollException, EASBizException {
        List sheetManagers = bgFormView.getSheetManagers();
        String offNumber = this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength());
        for (MbgViewListSheetManager sheetManager : sheetManagers) {
            this.resetViewListSheetManager(sheetManager, offNumber, isLimitLength);
        }
        if (clone.getEntries() != null && !clone.getEntries().isEmpty()) {
            clone.getEntries().get(0).setDimensionData(new MbgViewListXMLParser(this.ctx).unParse(bgFormView));
        }
    }

    protected void reConfigVistListForm(List<IMbgViewListObject> columns, Map<String, Object> compareResult, String offNumber) throws BgRollException {
        String minTarPeriod = (String)compareResult.get(MIN_TARGET_PERIOD_SIGN);
        String maxSouPeriod = (String)compareResult.get(MAX_SOURCE_PERIOD_SIGN);
        Set actPeriods = (Set)compareResult.get(ACTUAL_SIGN);
        Set specialFirGroupPeriods = (Set)compareResult.get(ADD_SPECIAL_FIRGROUP_SIGN);
        this.rollMemberRolCol(columns, maxSouPeriod, offNumber);
        this.createHisRowCol(columns, actPeriods, minTarPeriod);
        this.fillSpecialRowCol(columns, specialFirGroupPeriods, minTarPeriod);
    }

    protected void rollMemberRolCol(List<IMbgViewListObject> columns, String maxSouPeriod, String bgPeriodNumber) throws BgRollException {
        Iterator<IMbgViewListObject> iter = columns.iterator();
        while (iter.hasNext()) {
            MbgViewListRowCol rowCol;
            IMbgViewListObject viewListObj = iter.next();
            if (!(viewListObj instanceof MbgViewListRowCol) || (rowCol = (MbgViewListRowCol)viewListObj).isAddFromRoll()) continue;
            BgDimensionBaseInfo dimInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = dimInfo.getMember();
            boolean containBudgetScenario = this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()));
            Iterator iterMember = members.iterator();
            while (iterMember.hasNext()) {
                BgDimensionMember member = (BgDimensionMember)iterMember.next();
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessPeriod(member.getNumber())) continue;
                String offsetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                if (offsetNumber.compareTo(bgPeriodNumber) < 0 && containBudgetScenario) {
                    iterMember.remove();
                    continue;
                }
                if (maxSouPeriod != null && offsetNumber.compareTo(maxSouPeriod) > 0 || !this.schemePeriodRanges.containsKey(offsetNumber)) {
                    iterMember.remove();
                    continue;
                }
                BgPeriodInfo bgPeriodInfo = this.schemePeriodRanges.get(offsetNumber);
                member.setAlias(bgPeriodInfo.getName());
                member.setNumber(bgPeriodInfo.getNumber());
                member.setSortValue((Comparable)((Object)bgPeriodInfo.getLongNumber()));
                member.setName(bgPeriodInfo.getName());
            }
            if (members.isEmpty()) {
                iter.remove();
            }
            Iterator selIter = dimInfo.getSelectMembers().iterator();
            while (selIter.hasNext()) {
                BgPeriodInfo bgPeriodInfo;
                String offsetNumber;
                Object next = selIter.next();
                if (next instanceof BgDimensionMember) {
                    BgDimensionMember selectMember = (BgDimensionMember)next;
                    if (!this.checkLeafPeriod(selectMember.getNumber()) || !this.isProcessPeriod(selectMember.getNumber())) continue;
                    offsetNumber = this.getOffsetBgPeriodNumber(selectMember.getNumber(), this.rollInfo.getLength());
                    if (offsetNumber.compareTo(bgPeriodNumber) < 0 && containBudgetScenario) {
                        selIter.remove();
                        continue;
                    }
                    if (maxSouPeriod != null && offsetNumber.compareTo(maxSouPeriod) > 0 || !this.schemePeriodRanges.containsKey(offsetNumber)) {
                        selIter.remove();
                        continue;
                    }
                    bgPeriodInfo = this.schemePeriodRanges.get(offsetNumber);
                    selectMember.setAlias(bgPeriodInfo.getName());
                    selectMember.setNumber(bgPeriodInfo.getNumber());
                    selectMember.setSortValue((Comparable)((Object)bgPeriodInfo.getLongNumber()));
                    selectMember.setName(bgPeriodInfo.getName());
                    continue;
                }
                BgPeriodInfo info = (BgPeriodInfo)next;
                if (!this.checkLeafPeriod(info.getNumber()) || !this.isProcessPeriod(info.getNumber())) continue;
                offsetNumber = this.getOffsetBgPeriodNumber(info.getNumber(), this.rollInfo.getLength());
                if (offsetNumber.compareTo(bgPeriodNumber) < 0 && containBudgetScenario) {
                    selIter.remove();
                    continue;
                }
                if (maxSouPeriod != null && offsetNumber.compareTo(maxSouPeriod) > 0 || !this.schemePeriodRanges.containsKey(offsetNumber)) {
                    selIter.remove();
                    continue;
                }
                bgPeriodInfo = this.schemePeriodRanges.get(offsetNumber);
                info.setNumber(bgPeriodInfo.getNumber());
                info.setName(bgPeriodInfo.getName());
                info.setId(bgPeriodInfo.getId());
            }
        }
    }

    private void fillSpecialRowCol(List<IMbgViewListObject> columns, Set<String> specialFirGroupPeriods, String minPeriod) {
        if (specialFirGroupPeriods == null || specialFirGroupPeriods.isEmpty()) {
            return;
        }
        Iterator<IMbgViewListObject> iter = columns.iterator();
        while (iter.hasNext()) {
            boolean isAddMember = false;
            IMbgViewListObject obj = iter.next();
            if (!(obj instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)obj;
            MbgViewListDimensionInfo dimensionInfo = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimensionInfo.getMember();
            for (BgDimensionMember member : members) {
                if (!member.getNumber().equals(minPeriod)) continue;
                isAddMember = true;
            }
            if (!isAddMember) continue;
            for (String number : specialFirGroupPeriods) {
                dimensionInfo.getMember().add(this.newViewListDimensionMember(number));
                dimensionInfo.getSelectMembers().add(this.newViewListDimensionMember(number));
            }
            Collections.sort((List)dimensionInfo.getMember(), (Comparator)new DimenisonMemberComparator());
            Collections.sort((List)dimensionInfo.getSelectMembers(), (Comparator)new DimenisonMemberComparator());
        }
    }

    protected void createHisRowCol(List<IMbgViewListObject> columns, Set<String> actPeriods, String minTarPeriod) throws BgRollException {
        if (actPeriods == null || actPeriods.isEmpty()) {
            return;
        }
        Map<String, MbgViewListDimensionInfo> prepareDims = this.prepareDimension(columns, actPeriods, minTarPeriod);
        if (prepareDims.isEmpty()) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT3, this.getExceptionParam());
        }
        this.replacePeriodAndScenario(prepareDims, actPeriods);
        this.createHisRowCol(columns, prepareDims);
    }

    protected void createHisRowCol(List<IMbgViewListObject> columns, Map<String, MbgViewListDimensionInfo> prepareDims) {
        IMbgViewListObject viewListObj = columns.get(0);
        if (viewListObj instanceof MbgViewListRowCol) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            if (!rowCol.isAddFromRoll()) {
                this.createHisRowCol(columns, prepareDims, false);
            } else {
                this.createHisRowCol(columns, prepareDims, true);
            }
        } else {
            this.createHisRowCol(columns, prepareDims, false);
        }
    }

    protected void replacePeriodAndScenario(Map<String, MbgViewListDimensionInfo> prepareDims, Set<String> actPeriods) {
        MbgViewListDimensionInfo viewListDimInfo = prepareDims.get(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        viewListDimInfo.getMember().clear();
        viewListDimInfo.getSelectMembers().clear();
        for (String number : actPeriods) {
            if (!this.schemePeriodRanges.containsKey(number)) continue;
            viewListDimInfo.getMember().add(this.newViewListDimensionMember(number));
            viewListDimInfo.getSelectMembers().add(this.newViewListDimensionMember(number));
        }
        this.replaceScenario(prepareDims.get(DimensionBaseConstants.DEF_SCENARIO_NUMBER).getMember());
        this.replaceScenario(prepareDims.get(DimensionBaseConstants.DEF_SCENARIO_NUMBER).getSelectMembers());
    }

    private void replaceScenario(List<BgDimensionMember> members) {
        for (BgDimensionMember member : members) {
            String number = member.getNumber();
            if (!this.scenMappings.containsKey(number) || !this.scenarios.containsKey(this.scenMappings.get(number).getNumber())) continue;
            BgScenarioInfo bgScenarioInfo = this.scenarios.get(this.scenMappings.get(number).getNumber());
            member.setNumber(bgScenarioInfo.getNumber());
            member.setName(bgScenarioInfo.getName());
            member.setAlias(bgScenarioInfo.getName());
        }
        HashSet<BgDimensionMember> tmpSet = new HashSet<BgDimensionMember>(members);
        members.clear();
        members.addAll(tmpSet);
    }

    protected MbgViewListDimensionMember newViewListDimensionMember(String number) {
        BgPeriodInfo bgPeriodInfo = this.schemePeriodRanges.get(number);
        MbgViewListDimensionMember member = new MbgViewListDimensionMember(DimensionBaseConstants.DEF_PERIOD_NUMBER, "F-1", bgPeriodInfo.getName(), bgPeriodInfo.getNumber());
        member.setAlias(bgPeriodInfo.getName());
        member.setLeaf(bgPeriodInfo.isIsLeaf());
        member.setLevel(bgPeriodInfo.getLevel());
        member.setSortValue((Comparable)((Object)bgPeriodInfo.getLongNumber()));
        member.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
        return member;
    }

    protected Map<String, MbgViewListDimensionInfo> prepareDimension(List<IMbgViewListObject> columns, Set<String> actPeriods, String minTarPeriod) throws BgRollException {
        LinkedHashMap<String, MbgViewListDimensionInfo> createDimensions = new LinkedHashMap<String, MbgViewListDimensionInfo>();
        for (IMbgViewListObject obj : columns) {
            MbgViewListRowCol rowCol;
            boolean isContainAct = false;
            if (!(obj instanceof MbgViewListRowCol) || !(isContainAct = this.checkIsContainActPeriods(actPeriods, isContainAct, rowCol = (MbgViewListRowCol)obj, minTarPeriod))) continue;
            for (MbgViewListDimensionInfo dimensionInfo : rowCol.getDimensions()) {
                MbgViewListDimensionInfo clone = dimensionInfo.clone();
                if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(clone.getNumber())) {
                    if (createDimensions.containsKey(DimensionBaseConstants.DEF_PERIOD_NUMBER)) continue;
                    createDimensions.put(DimensionBaseConstants.DEF_PERIOD_NUMBER, clone);
                    continue;
                }
                if (createDimensions.containsKey(clone.getNumber())) {
                    MbgViewListDimensionInfo source = (MbgViewListDimensionInfo)createDimensions.get(clone.getNumber());
                    ArrayList tmp = new ArrayList(clone.getMember());
                    tmp.removeAll(source.getMember());
                    source.getMember().addAll(tmp);
                    ArrayList tmpSelectMember = new ArrayList(clone.getSelectMembers());
                    tmpSelectMember.removeAll(source.getSelectMembers());
                    source.getSelectMembers().addAll(tmpSelectMember);
                    continue;
                }
                createDimensions.put(clone.getNumber(), clone.clone());
            }
        }
        return createDimensions;
    }

    protected boolean checkIsContainActPeriods(Set<String> actPeriods, boolean isContainAct, MbgViewListRowCol rowCol, String minTarPeriod) throws BgRollException {
        if (this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) {
            MbgViewListDimensionInfo d = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = d.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessPeriod(member.getNumber()) || !minTarPeriod.equals(member.getNumber())) continue;
                isContainAct = true;
            }
        }
        return isContainAct;
    }

    protected boolean checkIsContainMinPeriod(String minPeriodNum, boolean isContainAct, MbgViewListRowCol rowCol) throws BgRollException {
        if (this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) {
            MbgViewListDimensionInfo d = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = d.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessPeriod(member.getNumber()) || !minPeriodNum.equals(member.getNumber())) continue;
                isContainAct = true;
            }
        }
        return isContainAct;
    }

    private void createHisRowCol(List<IMbgViewListObject> columns, Map<String, MbgViewListDimensionInfo> prepareDims, boolean isExists) {
        if (isExists) {
            MbgViewListRowCol remove = (MbgViewListRowCol)columns.remove(0);
            if (BgRollTypeEnum.limitLengthRoll.equals((Object)this.rollInfo.getRollType())) {
                for (MbgViewListDimensionInfo dimensionInfo : remove.getDimensions()) {
                    if (prepareDims.containsKey(dimensionInfo.getNumber())) {
                        MbgViewListDimensionInfo source = prepareDims.get(dimensionInfo.getNumber());
                        ArrayList tmp = new ArrayList(dimensionInfo.getMember());
                        tmp.removeAll(source.getMember());
                        source.getMember().addAll(tmp);
                        ArrayList tmpSelectMember = new ArrayList(dimensionInfo.getSelectMembers());
                        tmpSelectMember.removeAll(source.getSelectMembers());
                        source.getSelectMembers().addAll(tmpSelectMember);
                        Collections.sort((List)source.getMember(), (Comparator)new DimenisonMemberComparator());
                        Collections.sort((List)source.getSelectMembers(), (Comparator)new DimenisonMemberComparator());
                        continue;
                    }
                    prepareDims.put(dimensionInfo.getNumber(), dimensionInfo);
                }
            }
        }
        MbgViewListRowCol rowCol = new MbgViewListRowCol();
        rowCol.setAddFromRoll(true);
        Iterator<MbgViewListDimensionInfo> iter = prepareDims.values().iterator();
        while (iter.hasNext()) {
            rowCol.getDimensions().add(iter.next());
        }
        columns.add(0, rowCol);
        int i = 0;
        int index = 0;
        int in = columns.size();
        while (i < in) {
            if (columns.get(i) instanceof AbstractMbgViewListObject) {
                AbstractMbgViewListObject iMbgViewListObject = (AbstractMbgViewListObject)columns.get(i);
                iMbgViewListObject.setIndex(i);
                iMbgViewListObject.setInitIndex(index);
            }
            ++i;
            ++index;
        }
    }

    private Map<String, Object> compareChangePeriod(List<Set<String>> rollPeriodMembers, String offNumber) {
        LinkedHashMap<String, Object> groupPeriods = new LinkedHashMap<String, Object>(4);
        LinkedHashSet<String> actuals = new LinkedHashSet<String>();
        LinkedHashSet<String> specialFirBudgetGroups = new LinkedHashSet<String>();
        Set<String> rollMembers = rollPeriodMembers.get(1);
        Set<String> initialMemebrs = rollPeriodMembers.get(0);
        this.fillMinMaxPeriodOfLimitLength(rollMembers, initialMemebrs, groupPeriods, offNumber);
        for (String periodMember : initialMemebrs) {
            if (periodMember.compareTo(offNumber) >= 0) continue;
            actuals.add(periodMember);
        }
        LinkedHashSet<String> tmpMembers = new LinkedHashSet<String>(initialMemebrs);
        tmpMembers.removeAll(rollMembers);
        for (String periodMember : tmpMembers) {
            if (periodMember.compareTo(offNumber) < 0) continue;
            specialFirBudgetGroups.add(periodMember);
        }
        groupPeriods.put(ACTUAL_SIGN, actuals);
        groupPeriods.put(ADD_SPECIAL_FIRGROUP_SIGN, specialFirBudgetGroups);
        return groupPeriods;
    }

    private void fillMinMaxPeriodOfLimitLength(Set<String> rollMembers, Set<String> initialMemebrs, Map<String, Object> groupPeriods, String offNumber) {
        String minPeriodNumber = null;
        String maxPeriodNumber = null;
        for (String number : rollMembers) {
            if (number.compareTo(offNumber) < 0) continue;
            if (minPeriodNumber == null) {
                minPeriodNumber = number;
                continue;
            }
            if (number.compareTo(minPeriodNumber) >= 0) continue;
            minPeriodNumber = number;
        }
        groupPeriods.put(MIN_TARGET_PERIOD_SIGN, minPeriodNumber);
        for (String number : initialMemebrs) {
            if (maxPeriodNumber == null) {
                maxPeriodNumber = number;
                continue;
            }
            if (number.compareTo(maxPeriodNumber) <= 0) continue;
            maxPeriodNumber = number;
        }
        groupPeriods.put(MAX_SOURCE_PERIOD_SIGN, maxPeriodNumber);
    }

    protected void resetViewListSheetManager(MbgViewListSheetManager sheetManager, String offNumber, boolean isLimitLength) throws BgRollException {
        List<IMbgViewListObject> columns = sheetManager.getDimensionManager().getColumns();
        if (isLimitLength) {
            List<Set<String>> rollPeriodMembers = this.getRollPeriodMembers(columns);
            Map<String, Object> compareResult = this.compareChangePeriod(rollPeriodMembers, offNumber);
            this.reConfigVistListForm(columns, compareResult, offNumber);
        } else {
            Map<String, Object> compareResult = this.getHisActPeriodMembersOfContinuous(columns, offNumber);
            this.rollMemberRolCol(columns, null, offNumber);
            Set actuals = (Set)compareResult.get(ACTUAL_SIGN);
            if (actuals.isEmpty()) {
                return;
            }
            Map<String, MbgViewListDimensionInfo> prepareDims = this.prepareDimensionOfContinuous(columns, (String)compareResult.get(MIN_TARGET_PERIOD_SIGN));
            this.replacePeriodAndScenario(prepareDims, actuals);
            this.createHisRowCol(columns, prepareDims);
        }
        this.deleteOtherOrgGroup(sheetManager);
    }

    private void deleteOtherOrgGroup(MbgViewListSheetManager sheetManager) {
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(sheetManager.getDimensionManager());
        if (isorgOnPageOrView) {
            return;
        }
        boolean isOrgOnRow = MBGViewListFormCommonHelper.isOrgOnRow(sheetManager.getDimensionManager());
        String number = this.bgFormInfo.getOrgUnit().getNumber();
        List<IMbgViewListObject> rowCol = isOrgOnRow ? sheetManager.getDimensionManager().getRows() : sheetManager.getDimensionManager().getColumns();
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        boolean isOtherOrg = false;
        Iterator<IMbgViewListObject> ite = rowCol.iterator();
        while (ite.hasNext()) {
            isOtherOrg = false;
            IMbgViewListObject temp = ite.next();
            if (temp instanceof MbgViewListRowCol) {
                dimensions.addAll(((MbgViewListRowCol)temp).getDimensions());
            }
            for (int i = 0; i < dimensions.size(); ++i) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)dimensions.get(i)).getNumber())) continue;
                for (int j = 0; j < ((BgDimensionBaseInfo)dimensions.get(i)).getMember().size(); ++j) {
                    if (((BgDimensionMember)((BgDimensionBaseInfo)dimensions.get(i)).getMember().get(j)).getNumber().equals(number)) continue;
                    isOtherOrg = true;
                }
            }
            if (isOtherOrg) {
                ite.remove();
            }
            dimensions.clear();
        }
    }

    protected Map<String, MbgViewListDimensionInfo> prepareDimensionOfContinuous(List<IMbgViewListObject> columns, String minPeriodNum) throws BgRollException {
        LinkedHashMap<String, MbgViewListDimensionInfo> createDimensions = new LinkedHashMap<String, MbgViewListDimensionInfo>();
        for (IMbgViewListObject obj : columns) {
            MbgViewListRowCol rowCol;
            boolean isContainAct = false;
            if (!(obj instanceof MbgViewListRowCol) || !(isContainAct = this.checkIsContainMinPeriod(minPeriodNum, isContainAct, rowCol = (MbgViewListRowCol)obj))) continue;
            for (MbgViewListDimensionInfo dimensionInfo : rowCol.getDimensions()) {
                MbgViewListDimensionInfo clone = dimensionInfo.clone();
                if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(clone.getNumber())) {
                    if (createDimensions.containsKey(DimensionBaseConstants.DEF_PERIOD_NUMBER)) continue;
                    createDimensions.put(DimensionBaseConstants.DEF_PERIOD_NUMBER, clone);
                    continue;
                }
                if (createDimensions.containsKey(clone.getNumber())) {
                    MbgViewListDimensionInfo source = (MbgViewListDimensionInfo)createDimensions.get(clone.getNumber());
                    ArrayList tmp = new ArrayList(clone.getMember());
                    tmp.removeAll(source.getMember());
                    source.getMember().addAll(tmp);
                    ArrayList tmpSelectMember = new ArrayList(clone.getSelectMembers());
                    tmpSelectMember.removeAll(source.getSelectMembers());
                    source.getSelectMembers().addAll(tmpSelectMember);
                    continue;
                }
                createDimensions.put(clone.getNumber(), clone.clone());
            }
        }
        return createDimensions;
    }

    protected Map<String, Object> getHisActPeriodMembersOfContinuous(List<IMbgViewListObject> columns, String offNumber) throws BgRollException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String minPeriodNumber = null;
        LinkedHashSet<String> rollMembers = new LinkedHashSet<String>();
        for (IMbgViewListObject viewListObj : columns) {
            if (!(viewListObj instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimPerInfo.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessPeriod(member.getNumber())) continue;
                String targetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                if (targetNumber.compareTo(offNumber) >= 0) {
                    if (minPeriodNumber == null) {
                        minPeriodNumber = targetNumber;
                    } else if (targetNumber.compareTo(minPeriodNumber) < 0) {
                        minPeriodNumber = targetNumber;
                    }
                }
                rollMembers.add(targetNumber);
            }
        }
        HashSet<String> tmpSet = new HashSet<String>(this.leafPeriods);
        tmpSet.retainAll(rollMembers);
        if (tmpSet.isEmpty()) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT3, this.getExceptionParam());
        }
        Set<String> actuals = this.getActPeriodMembersOfContinuous(offNumber);
        result.put(ACTUAL_SIGN, actuals);
        result.put(MIN_TARGET_PERIOD_SIGN, minPeriodNumber);
        return result;
    }

    protected Set<String> getActPeriodMembersOfContinuous(String offNumber) throws BgRollException {
        TreeSet<String> actuals = new TreeSet<String>();
        for (int i = 1; i <= this.rollInfo.getHisPeriodLength(); ++i) {
            String offsetBgPeriodNumber = this.getOffsetBgPeriodNumber(offNumber, -i);
            if (!this.leafPeriods.contains(offsetBgPeriodNumber)) continue;
            actuals.add(offsetBgPeriodNumber);
        }
        return actuals;
    }

    private void fillMaxPeriodOfContinuous(Map<String, Object> groupPeriods) {
        String maxPeriodNumber = null;
        String bgFormPeriodNumber = this.bgFormInfo.getBgPeriod().getNumber();
        String type = bgFormPeriodNumber.substring(bgFormPeriodNumber.indexOf("."));
        for (String number : this.leafPeriods) {
            if (!type.equals(number.substring(bgFormPeriodNumber.indexOf(".")))) continue;
            if (maxPeriodNumber == null) {
                maxPeriodNumber = number;
                continue;
            }
            if (number.compareTo(maxPeriodNumber) <= 0) continue;
            maxPeriodNumber = number;
        }
        groupPeriods.put(MAX_SOURCE_PERIOD_SIGN, maxPeriodNumber);
    }

    protected List<Set<String>> getRollPeriodMembers(List<IMbgViewListObject> columns) throws BgRollException {
        LinkedHashSet<String> rollMembers = new LinkedHashSet<String>();
        LinkedHashSet<String> initialMemebrs = new LinkedHashSet<String>();
        for (IMbgViewListObject viewListObj : columns) {
            if (!(viewListObj instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimPerInfo.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessPeriod(member.getNumber())) continue;
                initialMemebrs.add(member.getNumber());
                String targetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                rollMembers.add(targetNumber);
            }
        }
        ArrayList<Set<String>> values = new ArrayList<Set<String>>();
        values.add(0, initialMemebrs);
        values.add(1, rollMembers);
        return values;
    }

    protected void initData() throws BOSException {
    }

    private void resetBgFormMsg(BgFormInfo info) throws EASBizException, BOSException {
        BOSUuid formId = BOSUuid.create((BOSObjectType)this.bgFormInfo.getBOSType());
        info.setId(formId);
        info.setAdjust(info);
        info.setCreator(null);
        info.setCreateTime(null);
        info.setAuditor(null);
        info.setAuditTime(null);
        for (int j = 0; j < this.bgFormInfo.getBgSpecialItems().size(); ++j) {
            BgSpecialItemsInfo specialItem = (BgSpecialItemsInfo)this.bgFormInfo.getBgSpecialItems().get(j).clone();
            info.getBgSpecialItems().set(j, specialItem);
            specialItem.setId(BOSUuid.create((BOSObjectType)specialItem.getBOSType()));
            for (int g = 0; g < specialItem.getDimRelaGroupRef().size(); ++g) {
                BgSpecialDimRelaGroupRefInfo refInfo = (BgSpecialDimRelaGroupRefInfo)specialItem.getDimRelaGroupRef().get(g).clone();
                specialItem.getDimRelaGroupRef().set(j, refInfo);
                refInfo.setId(BOSUuid.create((BOSObjectType)refInfo.getBOSType()));
                refInfo.setBgSpecialItems(specialItem);
            }
            specialItem.setBgForm(info);
        }
        String offsetBgPeriodNumber = this.getOffsetBgPeriodNumber(info.getBgPeriod().getNumber(), info.getBgRollRule().getLength());
        try {
            BgPeriodInfo bgPeriodInfo = BgPeriodFactory.getLocalInstance((Context)this.ctx).getBgPeriodInfo("where number = '" + offsetBgPeriodNumber + "'");
            info.setBgPeriod(bgPeriodInfo);
            info.setBgRollPeriod(bgPeriodInfo);
        }
        catch (Exception e) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam(info));
        }
        info.setState(BgFormStateEnum.RollEdited);
        info.setIsRolled(true);
        if (MbgFormRollSHelper.getHasFormId(this.ctx, info) != null) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT5, this.getExceptionParam(info));
        }
    }

    private void resetBook(BgFormInfo clone, boolean isLimitLength) throws Exception, BOSException, IOException {
        Book book = this.bgFormInfo.getBook();
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            if (book == null) continue;
            Cell cell = null;
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        this.updateItemFormula(cell, isLimitLength);
                    }
                    this.updateCellValue(cell, isLimitLength);
                }
            }
        }
        clone.setBook(book);
        if (clone.getEntries() != null && !clone.getEntries().isEmpty()) {
            HashSet<String> versionNumbers = new HashSet<String>();
            versionNumbers.add(clone.getBgVersion().getNumber());
            clone.getEntries().get(0).setDimensionData(MbgXMLParser.unParse(DimensionFormulaHelper.buildViewMamager(this.ctx, BgNFSHelper.getFormulaListOfBook(book), versionNumbers)));
        }
    }

    protected void updateCellValue(Cell cell, boolean isLimitLength) throws BgRollException {
        if (cell == null || cell.getUserObject("CELL_DATA") == null) {
            return;
        }
        Object value = cell.getUserObject("CELL_DATA").getValue();
        if (value != null && value instanceof Map) {
            Map map = (Map)value;
            Object type = map.get("bgFillType");
            if ("bgFillValueType_period".equals(type)) {
                String rollPeriodNumber;
                if (isLimitLength) {
                    return;
                }
                String bgPeriodNumber = (String)map.get("bgFillValue");
                if (!this.checkLeafPeriod(bgPeriodNumber)) {
                    return;
                }
                if (this.isProcessPeriod(bgPeriodNumber) && this.schemePeriodRanges.containsKey(rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength()))) {
                    BgNFSHelper.setValue(cell, this.schemePeriodRanges.get(rollPeriodNumber).getName());
                    map.put("bgFillValue", rollPeriodNumber);
                }
            } else if ("bgFillValueType_scenario".equals(type)) {
                String scenarioNumber = (String)map.get("bgFillValue");
                Sheet sheet = cell.getSheet();
                int in = sheet.getMaxRowIndex();
                for (int i = cell.getRow(); i < in; ++i) {
                    BgScenarioInfo bgScenarioInfo;
                    String rollPeriodNumber;
                    String bgPeriodNumber;
                    String formula;
                    Cell swap = sheet.getCell(i, cell.getCol(), false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(swap) || StringUtils.isEmpty((String)(formula = BgNFSHelper.getFormulaOfCell(swap))) || !this.checkLeafPeriod(bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1]) || !this.isProcessPeriod(bgPeriodNumber) || !this.isConvertActualPeriod(rollPeriodNumber = isLimitLength ? bgPeriodNumber : this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength()), this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength())) || (bgScenarioInfo = this.scenMappings.get(scenarioNumber)) == null || !this.scenarios.containsKey(bgScenarioInfo.getNumber())) continue;
                    BgNFSHelper.setValue(cell, bgScenarioInfo.getName());
                    map.put("bgFillValue", bgScenarioInfo.getNumber());
                    break;
                }
            } else {
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateItemFormula(Cell cell, boolean isLimitLength) throws BOSException, EASBizException {
        String rollPeriodNumber = null;
        String formula = BgNFSHelper.getFormulaOfCell(cell);
        if (StringUtils.isEmpty((String)formula)) return;
        String bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1];
        String bgScenarioNumber = BgNFSHelper.parseFormulaPara(formula)[3];
        if (!this.checkLeafPeriod(bgPeriodNumber)) {
            return;
        }
        if (!isLimitLength && this.isProcessPeriod(bgPeriodNumber)) {
            rollPeriodNumber = this.getOffsetBgPeriodNumber(bgPeriodNumber, this.rollInfo.getLength());
            if (!this.checkLeafPeriod(bgPeriodNumber) || !this.leafPeriods.contains(rollPeriodNumber)) throw new BgRollException(BgRollException.ROLLPERIODLIMIT1, this.getExceptionParam());
            formula = this.reSetPeriod(formula, rollPeriodNumber);
        } else {
            rollPeriodNumber = bgPeriodNumber;
        }
        if (this.isConvertActualPeriod(rollPeriodNumber, this.getOffsetBgPeriodNumber(this.bgFormInfo.getBgPeriod().getNumber(), this.rollInfo.getLength()))) {
            BgScenarioInfo bgScenarioInfo = this.scenMappings.get(bgScenarioNumber);
            if (bgScenarioInfo != null && this.scenarios.containsKey(bgScenarioInfo.getNumber())) {
                formula = this.reSetScenario(formula, bgScenarioInfo.getNumber());
                if (BgNConstants.EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell))) {
                    BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
                }
            }
            if (BgNFSHelper.checkHasExpression(cell)) {
                BgNFSHelper.clearExpression(cell);
            }
        }
        BgNFSHelper.setFormulaOfCell(cell, formula);
    }

    protected boolean checkLeafPeriod(String bgPeriodNumber) {
        return this.leafPeriods.contains(bgPeriodNumber);
    }

    protected String reSetPeriod(String formula, String periodNumber) {
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        formulaParam[1] = periodNumber;
        return BgNFSHelper.getFormulaFromParam(formulaParam);
    }

    protected String reSetScenario(String formula, String scenarioNumber) {
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        if (scenarioNumber == null) {
            return formula;
        }
        formulaParam[3] = scenarioNumber;
        return BgNFSHelper.getFormulaFromParam(formulaParam);
    }

    private void checkPeriod(IMbgViewBase bgFormView) throws EASBizException, BOSException {
        if (BgRollTypeEnum.limitLengthRoll.equals((Object)this.rollInfo.getRollType())) {
            this.checkDimension(bgFormView);
        }
    }

    private void checkState() throws BgRollException {
        BgFormStateEnum state = this.bgFormInfo.getState();
        if (state.getValue() != 2 && state.getValue() != 50 && state.getValue() != 51) {
            throw new BgRollException(BgRollException.ROLLSTATELIMIT, new Object[]{this.bgFormInfo.getOrgUnit().getName() + "(" + this.bgFormInfo.getOrgUnit().getNumber() + ")", this.bgFormInfo.getName() + "(" + this.bgFormInfo.getNumber() + ")"});
        }
    }

    @Override
    public void setBgRollParameter(BgRollParameter parameter) throws BOSException {
        this.ctx = parameter.getCtx();
        this.rollInfo = parameter.getRollInfo();
        this.bgFormInfo = parameter.getBgFormInfo();
        this.scenMappings = parameter.getScenMappings();
        this.schemePeriodRanges = parameter.getSchemePeriodRange();
        this.leafPeriods = this.schemePeriodRanges.keySet();
        this.scenarios = parameter.getScenarios();
        this.initData();
    }

    @Override
    public abstract boolean isProcessPeriod(String var1);

    protected boolean isContainBudgetScenario(BgDimensionBaseInfo dimScenInfo) {
        boolean isContain = false;
        List members = dimScenInfo.getMember();
        if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimScenInfo.getNumber()) || members.isEmpty()) {
            return isContain;
        }
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            if (!BgScenarioType.BudgetData.equals((Object)this.scenarios.get(member.getNumber()).getType())) continue;
            isContain = true;
        }
        return isContain;
    }

    @Override
    public String getOffsetBgPeriodNumber(String sourcePeriodNumber, int offset) throws BgRollException {
        return BgNPeriodHelper.getOffsetBgPeriodNumber((String)sourcePeriodNumber, (int)offset);
    }

    @Override
    public boolean isConvertActualPeriod(String bgPeriodNumber, String currRollPeriod) {
        if (currRollPeriod == null) {
            return false;
        }
        if (this.isProcessPeriod(bgPeriodNumber)) {
            return bgPeriodNumber.compareTo(currRollPeriod) < 0;
        }
        return false;
    }

    @Override
    public List<Set<String>> getCanEditPeriodNumbers(BgFormInfo sourceInfo, BgFormInfo rollInfo) throws Exception {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        result.add(0, null);
        result.add(1, null);
        if (sourceInfo != null) {
            this.getCanEditPeriodNumbers(sourceInfo, result, false);
        }
        if (rollInfo != null) {
            this.getCanEditPeriodNumbers(rollInfo, result, true);
        }
        return result;
    }

    private void getCanEditPeriodNumbers(BgFormInfo info, List<Set<String>> result, boolean isRolled) throws Exception {
        boolean checkrollPeriodIsNotNull;
        HashSet<String> numbers = new HashSet<String>();
        BgTemFormTypeEnum formType = info.getBgTemplate().getFormType();
        boolean bl = checkrollPeriodIsNotNull = info.getBgRollPeriod() != null;
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formType)) {
            IMbgViewBase viewBase;
            if (isRolled) {
                byte[] dimensionData = info.getEntries().get(0).getDimensionData();
                viewBase = new MbgViewListXMLParser(this.ctx).parse(dimensionData);
                ViewListMemberParserServerHelper parser2 = new ViewListMemberParserServerHelper(this.ctx, new BgSchemeDimensionHelper(this.ctx, info.getBgScheme().getId().toString()), info.getOrgUnit().getId().toString());
                parser2.parseMember((MbgViewListManager)viewBase);
            } else {
                viewBase = info.getView(this.ctx, info.getBgScheme());
            }
            MbgViewListManager manager = (MbgViewListManager)viewBase;
            List sheetManagers = manager.getSheetManagers();
            for (MbgViewListSheetManager sheetManager : sheetManagers) {
                List<IMbgViewListObject> columns = sheetManager.getDimensionManager().getColumns();
                for (IMbgViewListObject iRowCol : columns) {
                    if (!(iRowCol instanceof MbgViewListRowCol)) continue;
                    MbgViewListRowCol rowCol = (MbgViewListRowCol)iRowCol;
                    List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                    if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
                    BgDimensionBaseInfo dimInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
                    List members = dimInfo.getMember();
                    for (BgDimensionMember member : members) {
                        this.putEditPeriodNumber(member.getNumber(), info.getBgPeriod().getNumber(), isRolled || checkrollPeriodIsNotNull, numbers);
                    }
                }
            }
        } else {
            List formulas = BgNFSHelper.getFormulaListOfBook(info.getBook());
            int in = formulas.size();
            for (int i = 0; i < in; ++i) {
                String formula = (String)formulas.get(i);
                if (StringUtils.isEmpty((String)formula)) continue;
                String bgPeriodNumber = BgNFSHelper.parseFormulaPara(formula)[1];
                String bgScenarioNumber = BgNFSHelper.parseFormulaPara(formula)[3];
                if (!BgScenarioType.BudgetData.equals((Object)this.scenarios.get(bgScenarioNumber).getType())) continue;
                this.putEditPeriodNumber(bgPeriodNumber, info.getBgPeriod().getNumber(), isRolled || checkrollPeriodIsNotNull, numbers);
            }
        }
        if (isRolled) {
            result.add(1, numbers);
        } else {
            result.add(0, numbers);
        }
    }

    protected void putEditPeriodNumber(String bgPeriodNumber, String bgFormPeriodNumber, boolean isRolled, Set<String> numbers) throws BgRollException {
        if (this.checkLeafPeriod(bgPeriodNumber)) {
            if (isRolled) {
                if (this.isProcessPeriod(bgPeriodNumber)) {
                    if (bgPeriodNumber.compareTo(bgFormPeriodNumber) >= 0) {
                        numbers.add(bgPeriodNumber);
                    }
                } else {
                    numbers.add(bgPeriodNumber);
                }
            } else {
                numbers.add(bgPeriodNumber);
            }
        }
    }

    class DimenisonMemberComparator
    implements Comparator {
        DimenisonMemberComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof BgDimensionMember && o2 instanceof BgDimensionMember) {
                BgDimensionMember m1 = (BgDimensionMember)o1;
                BgDimensionMember m2 = (BgDimensionMember)o2;
                return m1.getNumber().compareTo(m2.getNumber());
            }
            if (o1 instanceof BgPeriodInfo && o2 instanceof BgPeriodInfo) {
                BgPeriodInfo p1 = (BgPeriodInfo)o1;
                BgPeriodInfo p2 = (BgPeriodInfo)o2;
                return p1.getNumber().compareTo(p2.getNumber());
            }
            return 0;
        }
    }
}

