/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.roll.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.roll.impl.AbstractBgRollRuleStrategy;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MWeekMonthRollStrategy
extends AbstractBgRollRuleStrategy {
    private String typeNumber;
    private Map<String, List<String>> periodMappings = new LinkedHashMap<String, List<String>>();

    @Override
    public boolean isProcessPeriod(String bgPeriodNumber) {
        return 4 == (this.ctx != null ? BgPeriodHelper.getPeriodType((Context)this.ctx, (String)bgPeriodNumber) : BgPeriodHelper.getPeriodType((String)bgPeriodNumber));
    }

    public boolean isProcessChildPeriod(String bgPeriodNumber) {
        return 6 == (this.ctx != null ? BgPeriodHelper.getPeriodType((Context)this.ctx, (String)bgPeriodNumber) : BgPeriodHelper.getPeriodType((String)bgPeriodNumber));
    }

    @Override
    protected void initData() throws BOSException {
        this.initOffsetPeriod();
    }

    private void initOffsetPeriod() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)6, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type.selfDefined", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        IBgPeriodDisp instance = this.ctx != null ? BgPeriodDispFactory.getLocalInstance((Context)this.ctx) : BgPeriodDispFactory.getRemoteInstance();
        BgPeriodDispCollection col = instance.getBgPeriodDispCollection(view);
        List<Object> monthWeeks = null;
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            String longNumber = col.get(i).getLongNumber();
            String number = col.get(i).getNumber();
            this.typeNumber = number.substring(0, number.indexOf("."));
            String[] tmpStrs = longNumber.split("!");
            int jn = tmpStrs.length - 1;
            for (int j = 0; j < jn; ++j) {
                if (!this.periodMappings.containsKey(tmpStrs[j])) {
                    monthWeeks = new ArrayList();
                    this.periodMappings.put(tmpStrs[j], monthWeeks);
                }
                if (!this.periodMappings.containsKey(tmpStrs[j]) || (monthWeeks = this.periodMappings.get(tmpStrs[j])).contains(tmpStrs[j + 1])) continue;
                monthWeeks.add(tmpStrs[j + 1]);
            }
        }
    }

    @Override
    protected Map<String, Object> getHisActPeriodMembersOfContinuous(List<IMbgViewListObject> columns, String offNumber) throws BgRollException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String minPeriodNumber = null;
        LinkedHashSet<String> rollMembers = new LinkedHashSet<String>();
        for (IMbgViewListObject viewListObj : columns) {
            if (!(viewListObj instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowCol = (MbgViewListRowCol)viewListObj;
            BgDimensionBaseInfo dimPerInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            if (!this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) continue;
            List members = dimPerInfo.getMember();
            for (BgDimensionMember member : members) {
                String covtOffNumber;
                if (!this.checkLeafPeriod(member.getNumber())) continue;
                if (this.isProcessPeriod(member.getNumber())) {
                    String targetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                    rollMembers.add(targetNumber);
                    continue;
                }
                if (!this.isProcessChildPeriod(member.getNumber())) continue;
                String number = member.getNumber();
                String monthNumber = number.substring(0, number.lastIndexOf("."));
                String monthWeekNumber = number.substring(number.lastIndexOf("."), number.length());
                String targetNumber = this.getOffsetBgPeriodNumber(monthNumber, this.rollInfo.getLength());
                if ((targetNumber = targetNumber.concat(monthWeekNumber)).compareTo(covtOffNumber = this.periodMappings.get(offNumber.replaceAll("MONT", this.typeNumber)).get(0)) >= 0) {
                    if (minPeriodNumber == null) {
                        minPeriodNumber = targetNumber;
                    } else if (targetNumber.compareTo(minPeriodNumber) < 0) {
                        minPeriodNumber = targetNumber;
                    }
                }
                rollMembers.add(targetNumber);
            }
        }
        HashSet tmpSet = new HashSet(this.leafPeriods);
        tmpSet.retainAll(rollMembers);
        if (tmpSet.isEmpty()) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT3, this.getExceptionParam());
        }
        if (minPeriodNumber == null) {
            throw new BgRollException(BgRollException.ROLLPERIODLIMIT3, this.getExceptionParam());
        }
        Set<String> actuals = this.getActPeriodMembersOfContinuous(offNumber);
        result.put("ACTUAL_SIGN", actuals);
        result.put("MIN_TARGET_PERIOD_SIGN", minPeriodNumber);
        return result;
    }

    @Override
    protected boolean checkIsContainMinPeriod(String minPeriodNum, boolean isContainAct, MbgViewListRowCol rowCol) throws BgRollException {
        if (this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()))) {
            MbgViewListDimensionInfo d = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            List members = d.getMember();
            for (BgDimensionMember member : members) {
                if (!this.checkLeafPeriod(member.getNumber()) || !this.isProcessChildPeriod(member.getNumber()) || !minPeriodNum.equals(member.getNumber())) continue;
                isContainAct = true;
            }
        }
        return isContainAct;
    }

    @Override
    protected void rollMemberRolCol(List<IMbgViewListObject> columns, String maxSouPeriod, String bgPeriodNumber) throws BgRollException {
        for (IMbgViewListObject viewListObj : columns) {
            MbgViewListRowCol rowCol;
            if (!(viewListObj instanceof MbgViewListRowCol) || (rowCol = (MbgViewListRowCol)viewListObj).isAddFromRoll()) continue;
            BgDimensionBaseInfo dimInfo = DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_PERIOD_NUMBER, rowCol.getDimensions());
            boolean containBudgetScenario = this.isContainBudgetScenario(DimensionCommonHelper.searchDimension(DimensionBaseConstants.DEF_SCENARIO_NUMBER, rowCol.getDimensions()));
            List members = dimInfo.getMember();
            HashSet<String> signNumbers = new HashSet<String>();
            ArrayList<BgDimensionMember> tempMembers = new ArrayList<BgDimensionMember>();
            Iterator iterMember = members.iterator();
            while (iterMember.hasNext()) {
                BgDimensionMember member = (BgDimensionMember)iterMember.next();
                if (this.checkLeafPeriod(member.getNumber())) {
                    if (this.isProcessPeriod(member.getNumber())) {
                        String offsetNumber = this.getOffsetBgPeriodNumber(member.getNumber(), this.rollInfo.getLength());
                        this.replacePeriodMember(tempMembers, member, offsetNumber, bgPeriodNumber, containBudgetScenario);
                        continue;
                    }
                    if (this.isProcessChildPeriod(member.getNumber())) {
                        this.replaceMonthWeekPeriodMember(tempMembers, signNumbers, member, bgPeriodNumber, containBudgetScenario);
                        continue;
                    }
                    tempMembers.add((BgDimensionMember)iterMember.next());
                    continue;
                }
                tempMembers.add((BgDimensionMember)iterMember.next());
            }
            dimInfo.getMember().clear();
            dimInfo.getMember().addAll(tempMembers);
            signNumbers.clear();
            tempMembers.clear();
            for (Object next : dimInfo.getSelectMembers()) {
                String offsetNumber;
                if (next instanceof BgDimensionMember) {
                    BgDimensionMember selectMember = (BgDimensionMember)next;
                    if (this.checkLeafPeriod(selectMember.getNumber())) {
                        if (this.isProcessPeriod(selectMember.getNumber())) {
                            offsetNumber = this.getOffsetBgPeriodNumber(selectMember.getNumber(), this.rollInfo.getLength());
                            this.replacePeriodMember(tempMembers, selectMember, offsetNumber, bgPeriodNumber, containBudgetScenario);
                            continue;
                        }
                        if (this.isProcessChildPeriod(selectMember.getNumber())) {
                            this.replaceMonthWeekPeriodMember(tempMembers, signNumbers, selectMember, bgPeriodNumber, containBudgetScenario);
                            continue;
                        }
                        tempMembers.add(selectMember);
                        continue;
                    }
                    tempMembers.add(selectMember);
                    continue;
                }
                BgPeriodInfo info = (BgPeriodInfo)next;
                if (this.checkLeafPeriod(info.getNumber())) {
                    if (this.isProcessPeriod(info.getNumber())) {
                        offsetNumber = this.getOffsetBgPeriodNumber(info.getNumber(), this.rollInfo.getLength());
                        this.replacePeriodInfo(tempMembers, info, offsetNumber, bgPeriodNumber, containBudgetScenario);
                        continue;
                    }
                    if (this.isProcessChildPeriod(info.getNumber())) {
                        this.replaceMonthWeekPeriodInfo(tempMembers, signNumbers, info, bgPeriodNumber, containBudgetScenario);
                        continue;
                    }
                    tempMembers.add((BgDimensionMember)info);
                    continue;
                }
                tempMembers.add((BgDimensionMember)info);
            }
            dimInfo.getSelectMembers().clear();
            dimInfo.getSelectMembers().addAll(tempMembers);
        }
    }

    private void replaceMonthWeekPeriodMember(List<BgDimensionMember> tempMembers, Set signNumbers, BgDimensionMember member, String bgPeriodNumber, boolean containBudgetScenario) throws BgRollException {
        TreeSet<MbgViewListDimensionMember> monthWeekMembers = new TreeSet<MbgViewListDimensionMember>(new AbstractBgRollRuleStrategy.DimenisonMemberComparator());
        String number = member.getNumber();
        String monthNumber = number.substring(0, number.lastIndexOf("."));
        String offsetNumber = this.getOffsetBgPeriodNumber(monthNumber, this.rollInfo.getLength());
        if (signNumbers.contains(offsetNumber)) {
            return;
        }
        String replaceOffsetNumber = offsetNumber.replaceAll(this.typeNumber, "MONT");
        if (replaceOffsetNumber.compareTo(bgPeriodNumber) >= 0 && containBudgetScenario) {
            signNumbers.add(offsetNumber);
            if (this.periodMappings.containsKey(offsetNumber)) {
                List<String> list = this.periodMappings.get(offsetNumber);
                for (String n : list) {
                    monthWeekMembers.add(this.newViewListDimensionMember(n));
                }
            }
        }
        if (!monthWeekMembers.isEmpty()) {
            tempMembers.addAll(monthWeekMembers);
        }
    }

    private void replaceMonthWeekPeriodInfo(List tempMembers, Set<String> signNumbers, BgPeriodInfo info, String bgPeriodNumber, boolean containBudgetScenario) throws BgRollException {
        TreeSet monthWeekMembers = new TreeSet(new AbstractBgRollRuleStrategy.DimenisonMemberComparator());
        String number = info.getNumber();
        String monthNumber = number.substring(0, number.lastIndexOf("."));
        String offsetNumber = this.getOffsetBgPeriodNumber(monthNumber, this.rollInfo.getLength());
        if (signNumbers.contains(offsetNumber)) {
            return;
        }
        String replaceOffsetNumber = offsetNumber.replaceAll(this.typeNumber, "MONT");
        if (replaceOffsetNumber.compareTo(bgPeriodNumber) >= 0 && containBudgetScenario) {
            signNumbers.add(offsetNumber);
            if (this.periodMappings.containsKey(offsetNumber)) {
                List<String> list = this.periodMappings.get(offsetNumber);
                for (String n : list) {
                    tempMembers.add(((BgPeriodInfo)this.schemePeriodRanges.get(n)).clone());
                }
            }
        }
        if (!monthWeekMembers.isEmpty()) {
            tempMembers.addAll(monthWeekMembers);
        }
    }

    private void replacePeriodInfo(List tempMembers, BgPeriodInfo info, String offsetNumber, String bgPeriodNumber, boolean containBudgetScenario) {
        if (!this.schemePeriodRanges.containsKey(offsetNumber) || offsetNumber.compareTo(bgPeriodNumber) < 0 && containBudgetScenario) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.schemePeriodRanges.get(offsetNumber);
        info.setNumber(bgPeriodInfo.getNumber());
        info.setName(bgPeriodInfo.getName());
        info.setId(bgPeriodInfo.getId());
        tempMembers.add(info);
    }

    private void replacePeriodMember(List<BgDimensionMember> tempMembers, BgDimensionMember member, String offsetNumber, String bgPeriodNumber, boolean containBudgetScenario) {
        if (!this.schemePeriodRanges.containsKey(offsetNumber) || offsetNumber.compareTo(bgPeriodNumber) < 0 && containBudgetScenario) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.schemePeriodRanges.get(offsetNumber);
        member.setAlias(bgPeriodInfo.getName());
        member.setNumber(bgPeriodInfo.getNumber());
        member.setSortValue((Comparable)((Object)bgPeriodInfo.getLongNumber()));
        member.setName(bgPeriodInfo.getName());
        tempMembers.add(member);
    }

    @Override
    protected Set<String> getActPeriodMembersOfContinuous(String offNumber) throws BgRollException {
        TreeSet<String> actuals = new TreeSet<String>();
        for (int i = 1; i <= this.rollInfo.getHisPeriodLength(); ++i) {
            String offsetBgPeriodNumber = this.getOffsetBgPeriodNumber(offNumber, -i);
            if (!this.periodMappings.containsKey(offsetBgPeriodNumber = offsetBgPeriodNumber.replaceAll("MONT", this.typeNumber))) continue;
            List<String> leafMonthPeriods = this.periodMappings.get(offsetBgPeriodNumber);
            actuals.addAll(leafMonthPeriods);
        }
        return actuals;
    }

    @Override
    protected void putEditPeriodNumber(String bgPeriodNumber, String bgFormPeriodNumber, boolean isRolled, Set<String> numbers) throws BgRollException {
        if (this.checkLeafPeriod(bgPeriodNumber)) {
            if (isRolled) {
                if (this.isProcessPeriod(bgPeriodNumber)) {
                    if (bgPeriodNumber.compareTo(bgFormPeriodNumber) >= 0) {
                        numbers.add(bgPeriodNumber);
                    }
                } else if (this.isProcessChildPeriod(bgPeriodNumber)) {
                    String monthPeriod = this.periodMappings.get(bgFormPeriodNumber = bgFormPeriodNumber.replaceAll("MONT", this.typeNumber)).get(0);
                    if (bgPeriodNumber.compareTo(monthPeriod) >= 0) {
                        numbers.add(bgPeriodNumber);
                    }
                } else {
                    numbers.add(bgPeriodNumber);
                }
            } else {
                numbers.add(bgPeriodNumber);
            }
        }
    }
}

