/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.roll.olap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.MbgDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class KDOlapRollService {
    private static Logger logger = Logger.getLogger(KDOlapRollService.class);
    private Context ctx;
    private IDimensionParameter parameter;
    private Map<String, Set<String>> filterDimDataKeys = new HashMap<String, Set<String>>();
    private Map<String, BgVersionInfo> versionCols;
    private List<BgVersionInfo> rollVerisonNumbers;
    private BgSchemeDimensionHelper schemeHelper = null;
    private int valueType = 1;
    private UserInfo user = null;
    private String cubeName = null;
    private String cubeEntryName = null;
    private BgSchemeAccIntHelper accIntHelper = null;
    private TempTablePool pool = null;

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null) {
            try {
                this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.parameter.getBgSchemeId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)"create SchemeHelper error:", (Throwable)ex);
                SysUtil.abort();
            }
        }
        return this.schemeHelper;
    }

    private BgSchemeInfo getBgScheme() {
        return this.parameter.getDataManager().getBgScheme();
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public int getValueType() {
        return this.valueType;
    }

    protected UserInfo getCurrUser() {
        if (this.user == null) {
            this.user = ContextUtil.getCurrentUserInfo((Context)this.ctx);
            if (this.user == null) {
                this.user = new UserInfo();
                this.user.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            }
        }
        return this.user;
    }

    public String getCube() {
        if (this.cubeName == null) {
            this.cubeName = BgCubeUtils.getCubeName(this.getBgScheme().getRefCube(), this.getValueType());
        }
        return this.cubeName;
    }

    public String getCubeEntryName() {
        if (this.cubeEntryName == null) {
            this.cubeEntryName = BgCubeUtils.getCubeEntryName(this.getBgScheme().getRefCube(), this.getValueType());
        }
        return this.cubeEntryName;
    }

    public BgSchemeAccIntHelper getAccIntHelper() {
        if (this.accIntHelper == null) {
            this.accIntHelper = new BgSchemeAccIntHelper(this.ctx, this.getSchemeHelper(), this.getCube());
        }
        return this.accIntHelper;
    }

    protected TempTablePool getPool() {
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.ctx);
        }
        return this.pool;
    }

    public KDOlapRollService(Context ctx, IDimensionParameter parameter) {
        this.ctx = ctx;
        this.parameter = parameter;
    }

    public static KDOlapRollService newInstance(Context ctx, IDimensionParameter parameter) {
        return new KDOlapRollService(ctx, parameter);
    }

    public void handle() throws BOSException {
        if (!this.verifyAndAddVersion()) {
            return;
        }
        try {
            this.versionDataHandle();
        }
        catch (Exception e) {
            logger.error((Object)"KDOlapRollService handle error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public Set<String> getFormulaSet(Collection<ICalcData> values) {
        HashSet<String> formulaSet = new HashSet<String>();
        if (formulaSet.isEmpty()) {
            for (ICalcData calcData : values) {
                formulaSet.add(calcData.getFormula());
            }
        }
        return formulaSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertRollData(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        logger.debug((Object)("Rolling version data start to be inserted into DB,calcMap capacity:" + calcMap.size()));
        if (calcMap == null) return;
        if (calcMap.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        Connection conn = BgDBUtils.getConnection((Context)this.ctx);
        ICalcData calcData2222 = null;
        HashSet<String> bgPeriod = new HashSet<String>();
        HashSet<String> bgElement = new HashSet<String>();
        HashSet<String> currency = new HashSet<String>();
        for (ICalcData calcData2222 : calcMap.values()) {
            bgPeriod.add(calcData2222.getBgPeriodNumber());
            bgElement.add(calcData2222.getBgElementNumber());
            currency.add(calcData2222.getCurrencyNumber());
        }
        List<String> refFields = this.getBgScheme().getRefFields(conn, this.getValueType());
        int batchIndex = 0;
        int fixParam = 19;
        String tableName = null;
        String entryName = null;
        String tmpId = null;
        String field = null;
        String srcNumber = null;
        String[] tmpStrs = null;
        BgScenarioInfo scenario = null;
        BgVersionInfo version = null;
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        String _orgUnitId = this.parameter.getOrgUnitId().toString();
        String _userId = this.getCurrUser() != null ? this.getCurrUser().getId().toString() : null;
        int state = 1;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Map<String, String> srcFields = DimUtils.getDimSourceMap(conn, this.ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
        int in = refFields.size();
        for (int i = 0; i < in; ++i) {
            sql.append(refFields.get(i) + " NVARCHAR(80) DEFAULT '' NOT NULL, ");
        }
        sql.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 1 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 0 NOT NULL,FDataSource NUMERIC(21,8)");
        sql.append(",FExists INT Default 0 NOT NULL");
        sql.append(")");
        PreparedStatement pstmt = null;
        PreparedStatement psten = null;
        TempTablePool pool = this.getPool();
        try {
            int i;
            Map<String, String> bgPeriodMap = MbgDataHelper.getBgPeriodMap(conn, bgPeriod);
            Map<String, String> bgElementMap = MbgDataHelper.getBgElementMap(conn, bgElement);
            Map<String, String> currencyMap = MbgDataHelper.getCurrencyMap(conn, currency);
            Map<String, BgScenarioInfo> bgScenarioMap = MbgDataHelper.getBgScenarioMap(conn, this.ctx.getLocale());
            Map<String, BgVersionInfo> bgVersionMap = MbgDataHelper.getBgVersionMap(conn, this.ctx.getLocale());
            tableName = pool.createTempTable(sql.toString());
            entryName = pool.createTempTable("Create Table TMP_Table_Name1(FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)");
            sql = new StringBuffer();
            sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate,FDataSource");
            int in2 = refFields.size();
            for (i = 0; i < in2; ++i) {
                sql.append(", " + refFields.get(i));
            }
            sql.append(") Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
            in2 = refFields.size();
            for (i = 0; i < in2; ++i) {
                sql.append(",?");
            }
            sql.append(")");
            pstmt = conn.prepareStatement(sql.toString());
            if (!StringUtils.isEmpty((String)entryName)) {
                psten = conn.prepareStatement("Insert Into " + entryName + " (FFormID, FDataID) Values (?,?)");
            }
            Map<String, Map<String, ICalcData>> splitCalcMap = this.getAccIntHelper().splitBgDatas(conn, calcMap, this.getFormulaSet(calcMap.values()));
            for (String bgDataTable : splitCalcMap.keySet()) {
                int i22;
                int in32;
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tableName));
                for (ICalcData calcData2222 : splitCalcMap.get(bgDataTable).values()) {
                    if (calcData2222.getValue() == null) continue;
                    valueMap.clear();
                    tmpStrs = calcData2222.getDimNumber().split(",");
                    if (tmpStrs != null) {
                        in32 = tmpStrs.length;
                        for (i22 = 0; i22 < in32; ++i22) {
                            srcNumber = DimUtils.getSrcNumber(tmpStrs[i22]);
                            if (!srcFields.containsKey(srcNumber)) continue;
                            valueMap.put(srcFields.get(srcNumber), tmpStrs[i22]);
                        }
                    }
                    pstmt.setString(1, calcData2222.createId());
                    pstmt.setString(2, _userId);
                    pstmt.setTimestamp(3, _time);
                    pstmt.setString(4, _userId);
                    pstmt.setTimestamp(5, _time);
                    this.getAccIntHelper().setParam(pstmt, 6, calcData2222.getOrgUnitId() != null ? calcData2222.getOrgUnitId() : _orgUnitId, DimensionConstants.DEF_ORGUNIT_FIELD);
                    pstmt.setString(7, calcData2222.getFormula());
                    pstmt.setBigDecimal(8, calcData2222.getValue().setScale(8, 4));
                    pstmt.setBigDecimal(9, calcData2222.getValue().setScale(8, 4));
                    pstmt.setString(10, calcData2222.getDimNumber());
                    tmpId = bgPeriodMap.get(calcData2222.getBgPeriodNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("bgPeriod number error:" + calcData2222.getBgPeriodNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{calcData2222.getBgPeriodNumber()});
                    }
                    this.getAccIntHelper().setParam(pstmt, 11, tmpId, DimensionConstants.DEF_PERIOD_FIELD);
                    tmpId = bgElementMap.get(calcData2222.getBgElementNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("bgElement number error:" + calcData2222.getBgElementNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{calcData2222.getBgElementNumber()});
                    }
                    this.getAccIntHelper().setParam(pstmt, 12, tmpId, DimensionConstants.DEF_ELEMENT_FIELD);
                    tmpId = currencyMap.get(calcData2222.getCurrencyNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("currency number error:" + calcData2222.getCurrencyNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{calcData2222.getCurrencyNumber()});
                    }
                    pstmt.setString(13, tmpId);
                    scenario = bgScenarioMap.get(calcData2222.getBgScenarioNumber());
                    if (scenario == null) {
                        logger.debug((Object)("scenario number error:" + calcData2222.getBgScenarioNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOBGSCENARIO, new String[]{calcData2222.getBgScenarioNumber()});
                    }
                    pstmt.setInt(14, scenario.getScenarioId());
                    version = bgVersionMap.get(calcData2222.getBgVersionNumber());
                    if (version == null) {
                        logger.debug((Object)("version number error:" + calcData2222.getBgVersionNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOBGVERSION, new String[]{calcData2222.getBgVersionNumber()});
                    }
                    pstmt.setInt(15, version.getVersionId());
                    pstmt.setInt(16, state);
                    pstmt.setInt(17, 1);
                    pstmt.setInt(18, calcData2222.getBgDataSource());
                    in32 = refFields.size();
                    for (i22 = 0; i22 < in32; ++i22) {
                        field = refFields.get(i22);
                        if (valueMap.containsKey(field)) {
                            this.getAccIntHelper().setParam(pstmt, fixParam + i22, (String)valueMap.get(field), field);
                            continue;
                        }
                        pstmt.setString(fixParam + i22, null);
                    }
                    pstmt.addBatch();
                    if (psten != null && calcData2222.getOrgUnitId().equals(this.parameter.getOrgUnitId().toString())) {
                        psten.setString(1, this.parameter.getBillId().toString());
                        psten.setString(2, calcData2222.getDataId());
                        psten.addBatch();
                    }
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                }
                StringBuffer fields = new StringBuffer();
                fields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate,FDataSource");
                in32 = refFields.size();
                for (i22 = 0; i22 < in32; ++i22) {
                    fields.append(", " + refFields.get(i22));
                }
                String insertAudit = "";
                String selectAudit = "";
                if (1 == this.getValueType() && (state == 9 || state == 11 || state == 13)) {
                    insertAudit = ",FAudOrgUnitID, FAudUserID, FDetail,FAudFormId";
                    selectAudit = ",FOrgUnitID, FLastUpdateUserID, 1,'" + this.parameter.getBillId() + "'";
                    if (state == 11 || state == 13) {
                        insertAudit = insertAudit + ",FReportOrgUnitID";
                        selectAudit = selectAudit + ",FOrgUnitID";
                    }
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tableName + " t0 Set FExists = 1 Where exists (select FID from " + bgDataTable + " where FOrgUnitID = t0.FOrgUnitID and FFormula = t0.FFormula and FVersion = t0.FVersion)"));
                sql = new StringBuffer("Insert Into " + bgDataTable + "(" + fields + insertAudit + ") Select " + fields + selectAudit + " from " + tableName + " where FExists = 0");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                if (entryName == null) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + this.getCubeEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + entryName));
            }
            logger.debug((Object)("the rollVersionData into the DB is complete,cost time:" + (System.currentTimeMillis() - time) + ".ms"));
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"addNewData error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(psten);
                SQLUtils.cleanup((Connection)conn);
                if (pool == null) throw throwable;
                if (!StringUtils.isEmpty(entryName)) {
                    pool.releaseTable(entryName);
                }
                if (StringUtils.isEmpty(tableName)) throw throwable;
                pool.releaseTable(tableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)psten);
        SQLUtils.cleanup((Connection)conn);
        if (pool == null) return;
        if (!StringUtils.isEmpty((String)entryName)) {
            pool.releaseTable(entryName);
        }
        if (StringUtils.isEmpty((String)tableName)) return;
        pool.releaseTable(tableName);
    }

    public Set<String> getCubeName(Set<String> accNumbers) throws BOSException, EASBizException {
        boolean isUseAccInt = this.getAccIntHelper().isUseAccInt();
        return BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, this.getCube(), accNumbers, this.getAccIntHelper().getSplitMap());
    }

    protected Map<String, ICalcData> queryData(Connection conn, TempTablePool pool, Set<String> versionIds) throws BOSException, EASBizException {
        Set<String> queryOrgIds;
        HashMap<String, ICalcData> dataMap = new HashMap<String, ICalcData>();
        if (this.parameter.getBillId() == null) {
            return dataMap;
        }
        String keyStr = null;
        BizCalcData calcData = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuilder query = new StringBuilder();
        if (null != this.parameter.getQueryOrgIds() && !this.parameter.getQueryOrgIds().isEmpty()) {
            queryOrgIds = this.parameter.getQueryOrgIds();
        } else {
            queryOrgIds = new HashSet<String>(1);
            queryOrgIds.add(this.parameter.getOrgUnitId().toString());
        }
        String tmpOrgTable = null;
        String tmpVersionTable = null;
        try {
            tmpOrgTable = pool.createTempTable("Create Table TEML_KSQL_11(FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert into " + tmpOrgTable + " (FID) Values (?)"), queryOrgIds);
            tmpVersionTable = pool.createTempTable("Create Table TEML_KSQL_12(FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert into " + tmpVersionTable + " (FID) Values (?)"), versionIds);
            query.append("select t.FID, t.FOrgUnitId, t.FFormula, t.FVersion, t.FValue, t.FState from " + DimensionConstants.CUBE_NAME + " t where forgUnitId in (select FID from " + tmpOrgTable + ") and FVersion in (select FID from " + tmpVersionTable + ")");
            Set<String> cubes = this.getCubeName(null);
            for (String cubeName : cubes) {
                pstmt = conn.prepareStatement(query.toString().replace(DimensionConstants.CUBE_NAME, cubeName));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    calcData = new BizCalcData();
                    calcData.setDataId(rst.getString("FID"));
                    calcData.setOrgUnitId(this.getAccIntHelper().convertStringForOrg(rst.getString("FOrgUnitId")));
                    calcData.setFormula(rst.getString("FFormula"));
                    calcData.setBgVersion(rst.getInt("FVersion"));
                    calcData.setValue(rst.getBigDecimal("FValue"));
                    calcData.setState(rst.getInt("FState"));
                    keyStr = calcData.getDimDataKey();
                    dataMap.put(keyStr, (ICalcData)calcData);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"queryData error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                if (null != tmpOrgTable) {
                    pool.releaseTable(tmpOrgTable);
                }
                if (null != tmpVersionTable) {
                    pool.releaseTable(tmpVersionTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, pstmt);
        if (null != tmpOrgTable) {
            pool.releaseTable(tmpOrgTable);
        }
        if (null != tmpVersionTable) {
            pool.releaseTable(tmpVersionTable);
        }
        return dataMap;
    }

    public void removeRollDatas(Map bgDataMap) throws BOSException, EASBizException {
        Set<Object> queryOrgIds;
        Map<String, Set<String>> filterDimDataKeys = this.parameter.getFilterDimDataKeys();
        HashMap<String, ICalcData> deleteDatas = new HashMap<String, ICalcData>();
        HashSet<String> versionIds = new HashSet<String>();
        if (null != this.parameter.getQueryOrgIds() && !this.parameter.getQueryOrgIds().isEmpty()) {
            queryOrgIds = this.parameter.getQueryOrgIds();
        } else {
            queryOrgIds = new HashSet<String>(1);
            queryOrgIds.add(this.parameter.getOrgUnitId().toString());
        }
        for (String string : queryOrgIds) {
            if (filterDimDataKeys == null || !filterDimDataKeys.containsKey(string)) continue;
            Set<String> filterDataKeys = filterDimDataKeys.get(string);
            Object obj = bgDataMap.get(string);
            if (obj == null || !(obj instanceof Map) || filterDataKeys == null) continue;
            Map DataMap = (Map)obj;
            for (String filterKey : filterDataKeys) {
                if (!DataMap.containsKey(filterKey)) continue;
                IBgNData bgNData = (IBgNData)DataMap.get(filterKey);
                ICalcData calcData = bgNData.toCalcData(this.parameter.getDataManager().getBgScenarioMap(), this.parameter.getDataManager().getBgVersionMap(), this.parameter.getValueType());
                if (calcData != null) {
                    calcData.setOrgUnitId(string);
                    deleteDatas.put(calcData.getDimDataKey(), calcData);
                }
                versionIds.add(String.valueOf(calcData.getBgVersion()));
                DataMap.remove(filterKey);
            }
        }
        this.removeRollData(deleteDatas, versionIds);
    }

    public void removeRollData(Map<String, ICalcData> calcMap, Set<String> versionIds) throws BOSException, EASBizException {
        logger.debug((Object)("Rolling version data start to be delete into DB,calcMap capacity:" + calcMap.size()));
        if (calcMap == null || calcMap.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        Connection conn = BgDBUtils.getConnection((Context)this.ctx);
        this.getAccIntHelper().isUseAccInt();
        Map<String, Map<String, ICalcData>> splitCalcMap = this.getAccIntHelper().splitBgDatas(conn, calcMap, this.getFormulaSet(calcMap.values()));
        TempTablePool pool = this.getPool();
        Map<String, ICalcData> dataMap = this.queryData(conn, pool, versionIds);
        for (ICalcData calcData : calcMap.values()) {
            ICalcData oldData;
            String dimDataKey = calcData.getDimDataKey();
            if (!dataMap.containsKey(dimDataKey) || (oldData = dataMap.get(dimDataKey)) == null) continue;
            calcData.setDataId(oldData.getDataId());
        }
        ICalcData calcData2 = null;
        ArrayList<String> dataIds = new ArrayList<String>();
        String tableName = null;
        Object pstmt = null;
        try {
            tableName = pool.createTempTable("Create Table TEML_KSQL_0(FID VARCHAR(44))");
            if (!StringUtils.isEmpty((String)tableName)) {
                for (String bgDataTable : splitCalcMap.keySet()) {
                    MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tableName));
                    dataIds.clear();
                    for (ICalcData calcData2 : splitCalcMap.get(bgDataTable).values()) {
                        dataIds.add(calcData2.getDataId());
                    }
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert into " + tableName + " (FID) Values (?)"), dataIds);
                    BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + this.getCubeEntryName() + " where exists (select FID from " + tableName + " where FID = " + this.getCubeEntryName() + ".FDataId)"));
                    BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + bgDataTable + " where exists (select FID from " + tableName + " where FID = " + bgDataTable + ".FID) "));
                }
            }
            logger.debug((Object)("the rollVersionData delete from DB is complete,cost time:" + (System.currentTimeMillis() - time) + ".ms"));
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"deleteData error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            if (pool != null && tableName != null) {
                pool.releaseTable(tableName);
            }
        }
    }

    public Map<String, Set<String>> acquireFilterDimDataKeys() {
        return this.filterDimDataKeys;
    }

    private void versionDataHandle() throws Exception {
        HashSet<String> queryOrgIds;
        Map<String, IDimension> dimensionMap = this.parameter.getDimensionMap();
        HashSet<String> periodNumbers = new HashSet<String>();
        IDimension periodDim = dimensionMap.get(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        if (null != periodDim && !periodDim.getDimensionMember().isEmpty()) {
            for (IMember member : periodDim.getDimensionMember()) {
                periodNumbers.add(member.getNumber());
            }
        }
        HashSet<String> elementNumbers = new HashSet<String>();
        IDimension elementDim = dimensionMap.get(DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        if (null != elementDim && !elementDim.getDimensionMember().isEmpty()) {
            for (IMember member : elementDim.getDimensionMember()) {
                elementNumbers.add(member.getNumber());
            }
        } else {
            elementNumbers.add(this.parameter.getDataManager().getDefElement()[0]);
        }
        HashSet<String> scenarioNumbers = new HashSet<String>();
        IDimension scenarioDim = dimensionMap.get(DimensionBaseConstants.DEF_SCENARIO_NUMBER);
        if (null != scenarioDim && !scenarioDim.getDimensionMember().isEmpty()) {
            for (IMember member : scenarioDim.getDimensionMember()) {
                scenarioNumbers.add(member.getNumber());
            }
        } else {
            scenarioNumbers.add(this.parameter.getDataManager().getDefScenario()[0]);
        }
        HashSet<String> currencyNumbers = new HashSet<String>();
        IDimension currencyDim = dimensionMap.get(DimensionBaseConstants.DEF_CURRENCY_NUMBER);
        if (null != currencyDim && !currencyDim.getDimensionMember().isEmpty()) {
            for (IMember member : currencyDim.getDimensionMember()) {
                currencyNumbers.add(member.getNumber());
            }
        } else {
            currencyNumbers.add(this.parameter.getDataManager().getDefCurrency()[0]);
        }
        HashSet<String> accountNumbers = new HashSet<String>();
        IDimension accountDim = dimensionMap.get(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
        if (null != accountDim && !accountDim.getDimensionMember().isEmpty()) {
            for (IMember member : accountDim.getDimensionMember()) {
                accountNumbers.add(member.getSrcNumber() + ":" + member.getNumber());
            }
        }
        this.queryAccSubMember(accountNumbers);
        if (null != this.parameter.getQueryOrgIds() && !this.parameter.getQueryOrgIds().isEmpty()) {
            queryOrgIds = this.parameter.getQueryOrgIds();
        } else {
            queryOrgIds = new HashSet<String>(1);
            queryOrgIds.add(this.parameter.getOrgUnitId().toString());
        }
        Map<String, Map<String, IBgNData>> oRollDataMap = MbgDataUtils.querySchemeData(this.ctx, this.parameter.getDataManager().getBgScheme(), queryOrgIds, this.rollVerisonNumbers, periodNumbers, elementNumbers, currencyNumbers, scenarioNumbers, accountNumbers, 1, null);
        HashMap<String, BgVersionInfo> initialVersions = new HashMap<String, BgVersionInfo>(this.rollVerisonNumbers.size());
        ArrayList<String[]> versionMappings = new ArrayList<String[]>(this.rollVerisonNumbers.size());
        for (BgVersionInfo info : this.rollVerisonNumbers) {
            BgVersionInfo initialVersionInfo = this.versionCols.get(info.getNumber().split("-")[0]);
            initialVersions.put(initialVersionInfo.getNumber(), initialVersionInfo);
            versionMappings.add(new String[]{info.getNumber(), initialVersionInfo.getNumber()});
        }
        Map<String, Map<String, IBgNData>> oInitialDataMap = MbgDataUtils.querySchemeData(this.ctx, this.parameter.getDataManager().getBgScheme(), queryOrgIds, new ArrayList<BgVersionInfo>(initialVersions.values()), periodNumbers, elementNumbers, currencyNumbers, scenarioNumbers, accountNumbers, 1, null);
        HashMap<String, Map<String, IBgNData>> allSwapDatas = new HashMap<String, Map<String, IBgNData>>();
        for (Map.Entry<String, Map<String, IBgNData>> entry : oInitialDataMap.entrySet()) {
            String orgUnitId = entry.getKey();
            Map<String, IBgNData> initialDataMap = entry.getValue();
            if (initialDataMap.isEmpty()) continue;
            HashMap<String, IBgNData> swapDatas = new HashMap<String, IBgNData>();
            for (String[] mapping : versionMappings) {
                swapDatas.putAll(this.compareAndSwapVersionData(oRollDataMap.get(orgUnitId), initialDataMap, mapping[0], mapping[1]));
            }
            allSwapDatas.put(orgUnitId, swapDatas);
            this.filterDimDataKeys.put(orgUnitId, swapDatas.keySet());
        }
        this.insertSwapDatasToDB(allSwapDatas);
    }

    private void queryAccSubMember(Set<String> accountNumbers) throws BOSException {
        BOSUuid viewId = this.parameter.getDataManager().getBgScheme().getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
        if (null == viewId || accountNumbers.isEmpty()) {
            return;
        }
        Connection conn = null;
        String tempTable = null;
        IRowSet rst = null;
        ArrayList<String> sqlParams = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        try {
            int i;
            conn = BgDBUtils.getConnection((Context)this.ctx);
            tempTable = this.getPool().createTempTable("create table TEMP_TABLE_KSQL_0(FNUMBER Varchar(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("insert into " + tempTable + " (FNumber) values(?)"), accountNumbers);
            String factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FLongNumber from " + factTable + " where exists (select FNumber from " + tempTable + " where FNumber = " + factTable + ".FDimNumber)"));
            while (rst.next()) {
                sqlParams.add(rst.getString(1) + "!%");
            }
            sql.append("select FDimLongNumber from " + factTable + " where FLongNumber like ? ");
            for (i = 1; i < 100; ++i) {
                sql.append(" OR FLongNumber like ? ");
            }
            List rsts = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams, (int)100);
            int in = rsts.size();
            for (i = 0; i < in; ++i) {
                String[] numbers;
                Object[] objs = (Object[])rsts.get(i);
                String longNumber = (String)objs[0];
                if (longNumber == null || (numbers = longNumber.split("!")) == null) continue;
                for (int j = 0; j < numbers.length; ++j) {
                    if (accountNumbers.contains(numbers[j])) continue;
                    accountNumbers.add(numbers[j]);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                this.pool.releaseTable(tempTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        this.pool.releaseTable(tempTable);
    }

    private void insertSwapDatasToDB(Map<String, Map<String, IBgNData>> allSwapDatas) throws BOSException, EASBizException {
        if (allSwapDatas.isEmpty()) {
            return;
        }
        ArrayList<ICalcData> calcDatas = new ArrayList<ICalcData>();
        for (Map.Entry<String, Map<String, IBgNData>> entry : allSwapDatas.entrySet()) {
            String orgUnitId = entry.getKey();
            Map<String, IBgNData> swapDatas = entry.getValue();
            for (IBgNData bgNData : swapDatas.values()) {
                ICalcData calcData = bgNData.toCalcData(this.parameter.getDataManager().getBgScenarioMap(), this.parameter.getDataManager().getBgVersionMap(), this.parameter.getValueType());
                calcData.setOrgUnitId(orgUnitId);
                calcDatas.add(calcData);
            }
        }
        BizCalcImpl impl = new BizCalcImpl(this.ctx);
        impl.setDimParam(this.parameter);
        impl.setSaveDatas(calcDatas);
        impl.run();
    }

    private Map<String, IBgNData> compareAndSwapVersionData(Map<String, IBgNData> rollDataMap, Map<String, IBgNData> initialDataMap, String rollVersionNumber, String initialVersionNumber) {
        HashMap<String, IBgNData> swap = new HashMap<String, IBgNData>();
        if (initialDataMap.isEmpty()) {
            return swap;
        }
        if (null == rollDataMap || rollDataMap.isEmpty()) {
            for (Map.Entry<String, IBgNData> dataEntry : initialDataMap.entrySet()) {
                String key = dataEntry.getKey();
                IBgNData value = dataEntry.getValue();
                String rollKey = key.substring(0, key.lastIndexOf("_") + 1).concat(rollVersionNumber);
                swap.put(rollKey, value);
            }
        } else {
            Set<String> rollFormulaKeys = this.removeVersionOfDimDataKey(rollDataMap.keySet());
            Set<String> initialFormulaKeys = this.removeVersionOfDimDataKey(initialDataMap.keySet());
            rollFormulaKeys.retainAll(initialFormulaKeys);
            initialFormulaKeys.removeAll(rollFormulaKeys);
            for (String initialFormulaKey : initialFormulaKeys) {
                swap.put(this.addVersionOfDimDataKey(initialFormulaKey, rollVersionNumber), initialDataMap.get(this.addVersionOfDimDataKey(initialFormulaKey, initialVersionNumber)));
            }
        }
        this.swapVersionOfBgData(swap, rollVersionNumber);
        return swap;
    }

    private void swapVersionOfBgData(Map<String, IBgNData> swap, String rollVersionNumber) {
        for (IBgNData bgNData : swap.values()) {
            bgNData.setBgVersion(rollVersionNumber);
        }
    }

    private Set<String> removeVersionOfDimDataKey(Set<String> dimDataKeys) {
        HashSet<String> keys = new HashSet<String>(dimDataKeys.size());
        for (String dimDataKey : dimDataKeys) {
            keys.add(dimDataKey.substring(0, dimDataKey.lastIndexOf("_")));
        }
        return keys;
    }

    private String addVersionOfDimDataKey(String dimDataKey, String versionNumber) {
        return dimDataKey + "_" + versionNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyAndAddVersion() throws BOSException {
        boolean isContainRollVersion = false;
        List bgVersionInfos = BgVersionHelper.getAllVersion((Context)this.ctx);
        this.versionCols = new HashMap<String, BgVersionInfo>(bgVersionInfos.size());
        for (BgVersionInfo info : bgVersionInfos) {
            this.versionCols.put(info.getNumber(), info);
        }
        IDimension dimension = this.parameter.getDimensionMap().get(DimensionBaseConstants.DEF_VERSION_NUMBER);
        Set<String> versionNumbers = this.versionCols.keySet();
        if (null != dimension && !dimension.getDimensionMember().isEmpty()) {
            List<IMember> members = dimension.getDimensionMember();
            this.rollVerisonNumbers = new ArrayList<BgVersionInfo>(members.size());
            Iterator<IMember> iterator = members.iterator();
            while (iterator.hasNext()) {
                IMember member = iterator.next();
                if (!versionNumbers.contains(member.getNumber()) || !this.versionCols.get(member.getNumber()).isIsRollVersion()) continue;
                isContainRollVersion = true;
                this.rollVerisonNumbers.add(this.versionCols.get(member.getNumber()));
            }
            return isContainRollVersion;
        }
        this.rollVerisonNumbers = new ArrayList<BgVersionInfo>(1);
        IDimDataQuery dimDataQuery = this.parameter.getDataManager().getDimDataQuery();
        if (null != dimDataQuery) {
            BgVersionInfo bizVersion = this.parameter.getDataManager().getDimDataQuery().getBizVersion();
            if (bizVersion == null) return isContainRollVersion;
            if (!bizVersion.isIsRollVersion()) return isContainRollVersion;
            this.rollVerisonNumbers.add(bizVersion);
            return true;
        }
        String[] defVersion = this.parameter.getDataManager().getDefVersion();
        if (null == defVersion) return false;
        if (!this.versionCols.get(defVersion[0]).isIsRollVersion()) return false;
        isContainRollVersion = true;
        this.rollVerisonNumbers.add(this.versionCols.get(defVersion[0]));
        return isContainRollVersion;
    }
}

