/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBADatabase;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.config.Config_CN;
import com.kingdee.eas.ma.mbg.streamwork.cuba.config.Config_EN;
import com.kingdee.eas.ma.mbg.streamwork.cuba.config.Config_TW;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.TableManager;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.SchemaDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.SchemaParser;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.BuildContext;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CubaBuilder;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.SchemaImpl;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class CUBAEngine {
    private static Hashtable resources = new Hashtable();

    public static CUBADatabase build(SchemaDef schemaDef, Map params, CUBAConfig config) throws CUBAException, SQLException {
        TableManager tableManager = CubaBuilder.getTableManager(schemaDef, params, config);
        BuildContext buildContext = new BuildContext(tableManager, config);
        SchemaImpl schema = CubaBuilder.buildSchema(buildContext, schemaDef, (List)params.get("OLAP_KEY_MEASURE_VISIBLES"), true);
        CUBADatabase database = CubaBuilder.buildDatabase(buildContext, schema, schemaDef, config);
        tableManager.clear();
        return database;
    }

    public static CUBADatabase buildWithoutCheck(SchemaDef schemaDef, Map params, CUBAConfig config) throws CUBAException, SQLException {
        TableManager tableManager = CubaBuilder.getTableManager(schemaDef, params, config);
        BuildContext buildContext = new BuildContext(tableManager, config);
        SchemaImpl schema = CubaBuilder.buildSchema(buildContext, schemaDef, (List)params.get("OLAP_KEY_MEASURE_VISIBLES"), false);
        CUBADatabase database = CubaBuilder.buildDatabase(buildContext, schema, schemaDef, config);
        tableManager.clear();
        return database;
    }

    public static CUBADatabase build(Document schema, Map parameters, CUBAConfig config) throws CUBAException, SQLException, JDOMException {
        return CUBAEngine.build(SchemaParser.parse(schema), parameters, config);
    }

    public static CUBADatabase build(SchemaDef schema, CUBAConfig config) throws CUBAException, SQLException {
        return CUBAEngine.build(schema, new HashMap(), config);
    }

    public static CUBADatabase build(Document schema, CUBAConfig config) throws CUBAException, SQLException {
        return CUBAEngine.build(SchemaParser.parse(schema), config);
    }

    public static void setLocalResource(Locale locale, Properties props) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = new Properties();
            resources.put(locale, res);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            res.setProperty(name, value);
        }
    }

    public static String getResource(String name) {
        return CUBAEngine.getResource(Locale.getDefault(), name);
    }

    public static String getResource(Locale locale, String name) {
        return CUBAEngine.getResource(locale, name, null);
    }

    public static void setResource(Locale locale, String name, String value) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = new Properties();
            resources.put(locale, res);
        }
        res.put(name, value);
    }

    public static String getResource(Locale locale, String name, String defaultValue) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = (Properties)resources.get(Locale.US);
        }
        return res.getProperty(name, defaultValue);
    }

    public static Properties getResources(Locale locale) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = (Properties)resources.get(Locale.US);
        }
        return res;
    }

    static {
        Config_CN cn = new Config_CN();
        Config_TW tw = new Config_TW();
        Config_EN en = new Config_EN();
        CUBAEngine.setLocalResource(Locale.CHINA, cn);
        CUBAEngine.setLocalResource(Locale.CHINESE, cn);
        CUBAEngine.setLocalResource(Locale.SIMPLIFIED_CHINESE, cn);
        CUBAEngine.setLocalResource(Locale.TRADITIONAL_CHINESE, tw);
        CUBAEngine.setLocalResource(Locale.TAIWAN, tw);
        CUBAEngine.setLocalResource(Locale.US, en);
        CUBAEngine.setLocalResource(Locale.UK, en);
        CUBAEngine.setLocalResource(Locale.CANADA, en);
        CUBAEngine.setLocalResource(Locale.ENGLISH, en);
    }
}

