/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DimensionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberImpl;

public class Point {
    private Member[] members;
    private int key = 0;

    public static int calcKey(Member[] ms) {
        int key = 0;
        for (int i = ms.length - 1; i > -1; --i) {
            DimensionImpl dim = (DimensionImpl)ms[i].getDimension();
            int memberCount = dim.getMemberCount();
            key = ((MemberImpl)ms[i]).getGlobalOrder() + key * memberCount;
        }
        return key;
    }

    public Point(Member[] ms) {
        this.members = (Member[])ms.clone();
        this.key = Point.calcKey(ms);
    }

    public Point(Cube cube, int key) throws CUBAException {
        this.key = key;
        Dimension[] dims = cube.getDimensions();
        this.members = new Member[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            int memberCount = ((DimensionImpl)dims[i]).getMemberCount();
            int globalOrder = key % memberCount;
            key /= memberCount;
            this.members[i] = ((DimensionImpl)dims[i]).getMember(globalOrder);
        }
    }

    public boolean equals(Object x) {
        return this.key == ((Point)x).key;
    }

    public int hashCode() {
        return this.key;
    }

    public int getKey() {
        return this.key;
    }

    public Member[] getMembers() {
        return this.members;
    }
}

