/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.dbsource.Table;
import com.kingdee.eas.ma.mbg.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DimensionBuildResult;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DimensionFetch;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DimensionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.Key;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemberImpl;
import java.math.BigDecimal;

class DimensionUsageFetch
implements DimensionFetch {
    private static final String SCENARIO = "scenario";
    private static final String VERSION = "version";
    Key foreignKey = null;
    String foreignKeyName;
    DimensionBuildResult dbr;
    DimensionImpl dim;
    MemberImpl[] values;
    int hieCount;
    CUBAConfig config;

    DimensionUsageFetch(DimensionBuildResult dbr, DimensionImpl dim, DimensionUsageDef def, CUBAConfig config) {
        this.dim = dim;
        this.hieCount = dim.hies.length;
        this.foreignKeyName = def.foreignKey;
        this.dbr = dbr;
        this.config = config;
        this.values = new MemberImpl[this.hieCount];
    }

    @Override
    public MemberImpl[] fetch(Table table) throws CUBAException {
        if (this.foreignKey == null) {
            this.foreignKey = new Key(table, this.foreignKeyName);
        }
        Object keyValue = this.foreignKey.getCurrentValue();
        for (int i = 0; i < this.hieCount; ++i) {
            if (keyValue == null) {
                if (this.config.BUILD_FACT_IGNORENULLOTHER) {
                    return this.values;
                }
                this.values[i] = (MemberImpl)this.dim.hies[i].getInnerNullMember();
                continue;
            }
            if ((SCENARIO.equals(this.dim.getName()) || VERSION.equals(this.dim.getName())) && keyValue instanceof Integer && this.dbr.getHierarchyBuildResult(i).get(keyValue) == null) {
                Integer integer = (Integer)keyValue;
                BigDecimal big = new BigDecimal(integer);
                keyValue = big;
            }
            this.values[i] = this.dbr.getHierarchyBuildResult(i).get(keyValue);
            if (this.values[i] != null) continue;
            if (this.config.BUILD_FACT_IGNORENULLOTHER) {
                return this.values;
            }
            this.values[i] = (MemberImpl)this.dim.hies[i].getInnerOtherMember();
        }
        return this.values;
    }

    @Override
    public void finish() {
    }
}

