/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.Aggregator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.BlockIndex;
import java.util.Map;

public class IndexedCubeData
extends CubeData {
    private BlockIndex blockIndex;
    private CUBAConfig config;
    private int records = 0;
    private static Object NULL = new Object();

    public IndexedCubeData(Cube _cube, int indexLen, CUBAConfig config) throws CUBAException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        if (_cube.getDimensions().length < indexLen + 1) {
            indexLen = _cube.getDimensions().length - 1;
        }
        if (indexLen < 0) {
            indexLen = 0;
        }
        this.blockIndex = new BlockIndex(null, _cube, 0, indexLen, this.aggs);
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws CUBAException {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            return;
        }
        ++this.records;
        this.blockIndex.addRecord(members, values);
    }

    @Override
    public void buildBB(Member[] members) {
    }

    @Override
    public Object[] getData(Member[] point) throws CUBAException {
        return this.getData(point, null);
    }

    @Override
    public Object[] getData(Member[] members, Map pinCache) throws CUBAException {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].hasData()) continue;
            return null;
        }
        return this.blockIndex.getData(members);
    }

    public Object[] appendAggregator(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws CUBAException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new CUBAException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void release() {
    }

    @Override
    public void finishBuildData() throws CUBAException {
        System.out.println("IndexedCubaData size:" + this.blockIndex.getDataSize());
    }

    @Override
    public void printStatistics() {
    }
}

