/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.ICubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MemCubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.OlapThreadPool;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.BitSetFactory;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.IntBitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class PartitionCubeData
implements ICubeData {
    private static final Logger logger = Logger.getLogger(MemCubeData.class);
    private Cube cube;
    private Dimension partitionDimension;
    private int partitionOrdinal;
    private HashMap cubeDataMap = new HashMap();
    private IntBitSet bitSet;
    private final CUBAConfig config;
    private static int configThreads = Integer.parseInt(System.getProperty("olapThreads", "16"));
    private static OlapThreadPool threadPool = new OlapThreadPool(configThreads);

    public PartitionCubeData(Cube cube, CUBAConfig config, Dimension partitionDimension) throws CUBAException {
        this.cube = cube;
        this.config = config;
        this.partitionDimension = partitionDimension;
        this.partitionOrdinal = partitionDimension.getOrdinal(cube);
        this.bitSet = BitSetFactory.createIntBitSet();
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    @Override
    public Member[] getMeasures() {
        return this.cube.getMeasures();
    }

    @Override
    public void addRecord(Member[] point, Object[] values) throws CUBAException {
        Member pm = point[this.partitionOrdinal];
        ICubeData cubeData = (ICubeData)this.cubeDataMap.get(pm);
        if (cubeData == null) {
            cubeData = new MemCubeData(this.cube, this.config);
            this.cubeDataMap.put(pm, cubeData);
            this.bitSet.set(this.partitionOrdinal);
        }
        cubeData.addRecord(point, values);
    }

    @Override
    public void buildBB(Member[] members) {
    }

    @Override
    public void finishAddRecord() throws CUBAException {
        int count = this.cubeDataMap.size();
        if (count == 0) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(count);
        final AtomicReference error = new AtomicReference();
        for (final ICubeData cubeData : this.cubeDataMap.values()) {
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        cubeData.finishAddRecord();
                    }
                    catch (CUBAException e) {
                        error.set(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (error.get() != null) {
            throw (CUBAException)error.get();
        }
    }

    @Override
    public Object[] getData(Member[] point) throws CUBAException {
        return this.getData(point, null);
    }

    @Override
    public Object[] getData(Member[] point, Map pinCache) throws CUBAException {
        if (!this.bitSet.get(this.partitionOrdinal)) {
            return null;
        }
        Member pm = point[this.partitionOrdinal];
        ICubeData cubeData = (ICubeData)this.cubeDataMap.get(pm);
        return cubeData.getData(point, pinCache);
    }

    @Override
    public void release() {
        Iterator iter = this.cubeDataMap.values().iterator();
        while (iter.hasNext()) {
            ((ICubeData)iter.next()).release();
        }
    }

    @Override
    public void finishBuildData() throws CUBAException {
        String message = "After finish build data by  partition dimension " + this.partitionDimension.getName() + ", total " + this.bitSet.cardinate() + " partitions, is:";
        System.out.println(message);
        logger.info((Object)message);
    }

    @Override
    public void printStatistics() {
        int detailCubeDataSize = 0;
        int detailCubeCacheSize = 0;
        int selfDataSize = 0;
        int selfDataRollupSize = 0;
        for (MemCubeData cubeData : this.cubeDataMap.values()) {
            detailCubeDataSize += cubeData.detailCubeData.size();
            detailCubeCacheSize += cubeData.detailCubeCache.size();
            selfDataSize += cubeData.selfData.size();
            selfDataRollupSize += cubeData.selfDataRollup.size();
        }
        this.printStatistics_(detailCubeDataSize, detailCubeCacheSize, selfDataSize, selfDataRollupSize);
    }

    public void printStatistics_(int detailCubeDataSize, int detailCubeCacheSize, int selfDataSize, int selfDataRollupSize) {
        String message = "All Cuba Data size:" + (detailCubeDataSize + detailCubeCacheSize + selfDataSize + selfDataRollupSize);
        this.println(message);
        message = "    --detail data size:" + detailCubeDataSize;
        this.println(message);
        message = " detail rollup cache size:" + detailCubeCacheSize;
        this.println(message);
        message = "    --not detail data size:" + selfDataSize;
        this.println(message);
        message = "    --not detail data rollup size:" + selfDataRollupSize;
        this.println(message);
    }

    private void println(String message) {
        logger.info((Object)message);
        System.out.println(message);
    }
}

