/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.impl;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cell;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Formatter;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.AxisImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CellImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CellKey;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CellReaderImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CellTupleReaderImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CellValues;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.ConnectionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CubeImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.EvaluatorImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.MdxResultBase;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.PositionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CellReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CellTupleReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.QueryAxis;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class StreamWorkMdxResult
extends MdxResultBase {
    private final CellValues cellValues;
    private transient CellKey point;
    private transient IList[] lists;
    private int[] timeCount = new int[]{0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamWorkMdxResult(MdxQuery query) throws CUBAException {
        super(query, new AxisImpl[2]);
        this.point = new CellKey(new int[2]);
        CubeImpl cube = (CubeImpl)query.getCube();
        ConnectionImpl cn = (ConnectionImpl)query.getConnection();
        CellReaderImpl cellReader = new CellReaderImpl(cn.database.getCubeData(cube));
        CellTupleReaderImpl cellTupleReader = new CellTupleReaderImpl(cn.database.getCubeData(cube));
        EvaluatorImpl evaluator = new EvaluatorImpl(cn, query, cube, cellReader);
        evaluator.setPinCache(new HashMap());
        this.cellValues = new CellValues();
        try {
            this.lists = new IList[2];
            QueryAxis measureAxis = query.getAxes()[1];
            Calc calc = query.getAxisCalcs()[1];
            this.lists[1] = this.executeMeasureAxis(cellReader, evaluator.push(), measureAxis, calc);
            QueryAxis rowAxis = query.getAxes()[0];
            calc = query.getAxisCalcs()[0];
            this.lists[0] = this.executeRowAxis(evaluator.push(), rowAxis, calc);
            long begin = System.currentTimeMillis();
            this.executeBody(cellTupleReader, query);
            System.out.println("executeBody cost " + (System.currentTimeMillis() - begin) + "ms.");
            for (int i = -1; i < this.axes.length; ++i) {
                AxisImpl mdxAxis;
                QueryAxis axis;
                if (i == -1) {
                    axis = null;
                    PositionImpl[] positions = new PositionImpl[]{};
                    this.slicerAxis = new AxisImpl("", query.getMdxHierarchiesOnAxis(i), positions);
                    continue;
                }
                axis = query.getAxes()[i];
                IList list = this.lists[i];
                int returnCount = list.size();
                PositionImpl[] positions = new PositionImpl[returnCount];
                Iterator iter = list.iterator();
                for (int index = 0; iter.hasNext() && index < returnCount; ++index) {
                    positions[index] = new PositionImpl(this.toMemberArray(iter.next()));
                }
                Hierarchy[] hierarchies = query.getMdxHierarchiesOnAxis(i);
                this.axes[i] = mdxAxis = new AxisImpl(axis.getName(), hierarchies, positions);
            }
        }
        finally {
            evaluator.clearExpResultCache(true);
            this.lists = null;
        }
    }

    private Member[] toMemberArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Member[]) {
            return (Member[])o;
        }
        if (o instanceof Member) {
            return new Member[]{(Member)o};
        }
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            Member[] ms = new Member[os.length];
            System.arraycopy(os, 0, ms, 0, os.length);
            return ms;
        }
        throw new ClassCastException();
    }

    private IList executeMeasureAxis(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc) throws CUBAException {
        Object value = calc.evaluate(evaluator);
        IList list = (IList)value;
        return list;
    }

    private IList executeRowAxis(Evaluator evaluator, QueryAxis axis, Calc calc) throws CUBAException {
        Object value = calc.evaluate(evaluator);
        if (value == null) {
            value = Collections.EMPTY_LIST;
        }
        IList list = (IList)value;
        return list;
    }

    private void executeBody(CellTupleReader cellTupleReader, MdxQuery query) throws CUBAException {
        this.cellValues.clear();
        Object[] measures = new Member[this.lists[1].size()];
        this.lists[1].toArray(measures);
        IList positions = this.lists[0];
        HashMap<String, Formatter> mapFormatter = new HashMap<String, Formatter>();
        int index = 0;
        IList positions2 = query.getListFactory().createArrayList();
        int lastSize = 0;
        Iterator iter = positions.iterator();
        while (iter.hasNext()) {
            Object[] values;
            int calStart;
            Member[] members = this.toMemberArray(iter.next());
            if (positions2.size() - lastSize >= 1000) {
                IList positions3 = query.getListFactory().createArrayList();
                positions2 = query.getListFactory().createUnionList(positions2, positions3);
                lastSize = positions2.size();
            }
            if ((calStart = this.hasCalculated(members)) > -1) {
                Member[] members2 = new Member[calStart];
                System.arraycopy(members, 0, members2, 0, calStart);
                long start = System.currentTimeMillis();
                values = cellTupleReader.get(members2, null);
                this.timeCount[0] = (int)((long)this.timeCount[0] + (System.currentTimeMillis() - start));
            } else {
                long start = System.currentTimeMillis();
                values = cellTupleReader.get(members, null);
                this.timeCount[0] = (int)((long)this.timeCount[0] + (System.currentTimeMillis() - start));
            }
            if (values == null) continue;
            boolean allNull = true;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                allNull = false;
            }
            if (allNull) continue;
            this.point.ordinals[0] = index++;
            for (int j = 0; j < measures.length; ++j) {
                this.point.ordinals[1] = j;
                CellKey key = this.point.copy();
                Member[] context = this.addOne(members, (Member)measures[j]);
                String fmtStr = (String)measures[j].getProperty("formatString");
                Formatter formatter = (Formatter)mapFormatter.get(fmtStr);
                if (formatter == null) {
                    formatter = new Formatter(fmtStr);
                    mapFormatter.put(fmtStr, formatter);
                }
                CellImpl cell = new CellImpl(context, values[j], formatter);
                this.cellValues.put(key, cell);
            }
            positions2.add(members);
        }
        this.lists[0] = positions2;
    }

    private int hasCalculated(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isCalculated()) continue;
            return i;
        }
        return -1;
    }

    private Member[] addOne(Member[] members, Member measure) {
        Member[] members2 = new Member[members.length + 1];
        System.arraycopy(members, 0, members2, 0, members.length);
        members2[members.length] = measure;
        return members2;
    }

    @Override
    public Cell getCell(int[] pos) {
        int[] pos2 = (int[])pos.clone();
        Object value = this.cellValues.get(new CellKey(pos2));
        if (value == null) {
            return new CellImpl(this.getMembers(pos));
        }
        return (Cell)value;
    }
}

