/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunCall;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDef;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunFactory;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FuncResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunctionException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.SimpleFuncResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Syntax;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func.BaseFunFactory;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.IntHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class FunTable {
    public static FunTable instance = new FunTable();
    private final List resolvers = new ArrayList();
    private final HashSet reservedWords = new HashSet();
    private final HashSet propertyWords = new HashSet();
    private HashMap mapNameToResolvers = new HashMap();
    private final FuncResolver[] emptyResolvers = new FuncResolver[0];
    private FunFactory[] funFactorys = new FunFactory[]{new BaseFunFactory(this)};

    private FunTable() {
        this.init();
    }

    private void init() {
        this.defineReserved("NULL");
        for (int i = 0; i < this.funFactorys.length; ++i) {
            this.funFactorys[i].defineFunctions();
        }
        this.initNameMap();
    }

    public void initNameMap() {
        this.mapNameToResolvers = new HashMap();
        int n = this.resolvers.size();
        for (int i = 0; i < n; ++i) {
            FuncResolver resolver = (FuncResolver)this.resolvers.get(i);
            String key = FunTable.makeResolverKey(resolver.getName(), resolver.getSyntax());
            ArrayList<FuncResolver> v2 = (ArrayList<FuncResolver>)this.mapNameToResolvers.get(key);
            if (v2 == null) {
                v2 = new ArrayList<FuncResolver>();
                this.mapNameToResolvers.put(key, v2);
            }
            v2.add(resolver);
        }
        for (String key : this.mapNameToResolvers.keySet()) {
            List v2 = (List)this.mapNameToResolvers.get(key);
            this.mapNameToResolvers.put(key, v2.toArray(this.emptyResolvers));
        }
    }

    public void define(FunDef funDef) {
        this.define(new SimpleFuncResolver(funDef));
    }

    public void define(FuncResolver resolver) {
        if (resolver.getSyntax() == Syntax.Property) {
            this.defineProperty(resolver.getName());
        }
        this.resolvers.add(resolver);
        String[] reservedWords = resolver.getReservedWords();
        for (int i = 0; i < reservedWords.length; ++i) {
            String reservedWord = reservedWords[i];
            this.defineReserved(reservedWord);
        }
    }

    public boolean isReserved(String s) {
        return this.reservedWords.contains(s.toUpperCase());
    }

    protected void defineReserved(String s) {
        this.reservedWords.add(s.toUpperCase());
    }

    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    protected void defineProperty(String s) {
        this.propertyWords.add(s.toUpperCase());
    }

    private static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + syntax;
    }

    public FunDef getDef(FunCall call) throws CUBAException {
        String key = FunTable.makeResolverKey(call.getFunction(), call.getSyntax());
        FuncResolver[] resolvers = (FuncResolver[])this.mapNameToResolvers.get(key);
        if (resolvers == null) {
            resolvers = this.emptyResolvers;
        }
        IntHolder conversionCount = new IntHolder(0);
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (int i = 0; i < resolvers.length; ++i) {
            conversionCount.value = 0;
            FunDef def = resolvers[i].resolve(call.getArgs(), conversionCount);
            if (def == null) continue;
            int conversions = conversionCount.value;
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                throw new FunctionException("\u51fd\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u51fd\u6570\u540d\u4e0d\u5b58\u5728\u6216\u8005\u53c2\u6570\u7c7b\u578b\u9519\u8bef:\n" + call.toMdx());
            }
            case 1: {
                return matchDef;
            }
        }
        throw new FunctionException("\u53c2\u6570\u7c7b\u578b\u4e0d\u660e\u786e\uff0c\u5bfc\u81f4\u591a\u4e2a\u51fd\u6570\u5339\u914d:\n" + call.toMdx());
    }
}

