/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAElement;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CalculatedMember;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Connection;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Cube;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Dimension;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.ICubeData;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.SlicerCompoundMember;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.DefaultListFactory;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IList;
import com.kingdee.eas.ma.mbg.streamwork.cuba.collection.IListFactory;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.BBFilterIndex;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CellReaderImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.ConnectionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.CubeImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.DimensionImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.impl.EvaluatorImpl;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CacheType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.CellReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.DelegatingSchemaReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.DimensionProperty;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Formula;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Literal;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.MemberProperty;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.QueryAxis;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.QueryObject;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Set;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.StackExpResolver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.BooleanCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.ListCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.BetterScalarExpCompiler;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.SetType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.TupleType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.Type;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.RoaringLongBitSet;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.UniqueNameUtil;
import com.kingdee.eas.ma.mbg.streamwork.cuba.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MdxQuery
extends QueryObject
implements Serializable {
    static Logger logger = Logger.getLogger(MdxQuery.class);
    List formulas = new ArrayList();
    ArrayList axisDef = null;
    String cubeName;
    transient Connection connection;
    List cellProps = new ArrayList();
    Exp slicer = null;
    private QueryAxis[] axes = null;
    private Calc[] axisCalcs = null;
    private Calc slicerCalc = null;
    public long useTime = 0L;
    private List<CellCalculationInfo> cellCalculations = null;
    CCFilters ccFilters;
    private HashMap slicerCompoundMembers;
    QuerySchemaReader schemaReader = null;
    IListFactory listFactory = null;

    public void afterParse(Connection cn) throws CUBAException {
        if (this.axisDef != null) {
            this.axes = this.axisDef.toArray(new QueryAxis[0]);
            this.axisDef = null;
        }
        this.connection = cn;
        this.resolve();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ExpResolver createExpResolver() throws CUBAException {
        Cube cube = this.connection.getSchemaReader().getCube(this.cubeName);
        if (cube == null) {
            throw new CUBAException("Cube named " + this.cubeName + " not found.");
        }
        StackExpResolver resolver = new StackExpResolver(this);
        return resolver;
    }

    private ExpCompiler createCompiler(ExpResolver resolver) {
        BetterScalarExpCompiler compiler = new BetterScalarExpCompiler(resolver);
        return compiler;
    }

    public void resolve() throws CUBAException {
        ExpResolver resolver = this.createExpResolver();
        this.resolve(resolver);
        ExpCompiler compiler = this.createCompiler(resolver);
        this.compile(compiler);
    }

    public void resolve(ExpResolver resolver) throws CUBAException {
        Cube cube;
        if (this.formulas != null) {
            Formula formula;
            int i;
            for (i = 0; i < this.formulas.size(); ++i) {
                formula = (Formula)this.formulas.get(i);
                formula.createElement(resolver.getQuery());
            }
            for (i = 0; i < this.formulas.size(); ++i) {
                formula = (Formula)this.formulas.get(i);
                resolver.resolve(formula);
            }
        }
        if ((cube = this.getCube()).getCalculatedMembers() != null) {
            CalculatedMember[] members = cube.getCalculatedMembers();
            for (int i = 0; i < members.length; ++i) {
                resolver.resolve(members[i].getFormula());
            }
        }
        if (this.axes != null) {
            for (int i = 0; i < this.axes.length; ++i) {
                resolver.resolve(this.axes[i]);
            }
        }
        if (this.slicer != null) {
            this.slicer = this.slicer.resolve(resolver);
        }
    }

    public Calc compileExpression(Exp exp, boolean scalar) throws CUBAException {
        ExpResolver resolver = this.createExpResolver();
        ExpCompiler compiler = this.createCompiler(resolver);
        Calc calc = scalar ? compiler.compileScalar(exp, false) : exp.compile(compiler);
        return calc;
    }

    private int getDimensionIndexInCube(Dimension dim) {
        Cube cube = this.connection.getSchemaReader().getCubes()[0];
        Dimension[] dims = cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (!dims[i].equals(dim)) continue;
            return i;
        }
        return -1;
    }

    private Evaluator createEvaluator(MdxQuery query) throws CUBAException {
        CubeImpl cube = (CubeImpl)query.getCube();
        ConnectionImpl cn = (ConnectionImpl)query.getConnection();
        ICubeData cubeData = cn.getDatabase().getCubeData(cube);
        CellReaderImpl cellReader = new CellReaderImpl(cubeData);
        return new EvaluatorImpl(cn, query, cube, cellReader);
    }

    public java.util.Set getCellCalculationMemberSet(Evaluator evaluator) throws CUBAException {
        if (this.cellCalculations == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Member> set = new HashSet<Member>();
        for (int i = this.cellCalculations.size() - 1; i >= 0; --i) {
            CellCalculationInfo info = this.cellCalculations.get(i);
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            Iterator iter = info.list.iterator();
            while (iter.hasNext()) {
                Member[] members = Util.toMemberArray(iter.next());
                for (int j = 0; j < members.length; ++j) {
                    set.add(members[j]);
                }
            }
        }
        return set;
    }

    public Calc getCellCalculation(Evaluator evaluator) throws CUBAException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        if (this.ccFilters == null) {
            this.ccFilters = new CCFilters();
        }
        long st = System.currentTimeMillis();
        Calc calc = this.ccFilters.getCellCalculationInfo(evaluator);
        this.useTime = this.useTime + System.currentTimeMillis() - st;
        return calc;
    }

    public Calc getCellCalculation0(Evaluator evaluator) throws CUBAException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        Member[] context = evaluator.getCurrentMembers();
        for (int i = this.cellCalculations.size() - 1; i >= 0; --i) {
            CellCalculationInfo info = this.cellCalculations.get(i);
            if (info.forAll) {
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            Iterator iter = info.list.iterator();
            while (iter.hasNext()) {
                Member[] members = Util.toMemberArray(iter.next());
                if (!Util.tupleContains(context, members)) continue;
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
        }
        return null;
    }

    private void compile(ExpCompiler compiler) throws CUBAException {
        if (this.formulas != null && !this.formulas.isEmpty()) {
            for (Formula formula : this.formulas) {
                if (!formula.isCellCalculation()) continue;
                boolean forAll = false;
                ListCalc listCalc = null;
                BooleanCalc conditionCalc = null;
                if (formula.scope instanceof Literal && "all".equalsIgnoreCase(((Literal)formula.scope).toString())) {
                    forAll = true;
                } else {
                    listCalc = compiler.compileList(formula.scope);
                }
                Calc calc = compiler.compileScalar(formula.exp, true);
                Exp condition = formula.getCondition();
                if (condition != null) {
                    try {
                        conditionCalc = compiler.compileBoolean(condition);
                    }
                    catch (ClassCastException e) {
                        throw new CUBAException("Cell Calculation Condition must be Boolean,but " + condition.toMdx() + " is not.");
                    }
                }
                if (this.cellCalculations == null) {
                    this.cellCalculations = new ArrayList<CellCalculationInfo>();
                }
                this.cellCalculations.add(new CellCalculationInfo(forAll, listCalc, calc, conditionCalc));
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axisCalcs[i] = this.axes[i].compile(compiler);
            }
        }
        if (this.slicer != null) {
            this.slicerCalc = compiler.compile(this.slicer);
        }
    }

    public SlicerCompoundMember getSlicerCompoundMember(String uniqueName) {
        if (this.slicerCompoundMembers == null) {
            return null;
        }
        return (SlicerCompoundMember)this.slicerCompoundMembers.get(uniqueName);
    }

    public SlicerCompoundMember addSlicerCompoundMember(Hierarchy hier, Member[] members) {
        if (this.slicerCompoundMembers == null) {
            this.slicerCompoundMembers = new HashMap(5);
        }
        SlicerCompoundMember m = (SlicerCompoundMember)hier.createSlicerCompoundMember(this.slicerCompoundMembers.size(), members);
        this.slicerCompoundMembers.put(m.getUniqueName(), m);
        return m;
    }

    public SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = new QuerySchemaReader(this.connection.getSchemaReader());
        }
        return this.schemaReader;
    }

    List getDefinedMembers() {
        ArrayList<CUBAElement> definedMembers = new ArrayList<CUBAElement>();
        for (int i = 0; i < this.formulas.size(); ++i) {
            Formula formula = (Formula)this.formulas.get(i);
            if (!formula.isMember() || formula.getElement() == null) continue;
            definedMembers.add(formula.getElement());
        }
        return definedMembers;
    }

    public Member lookupMemberFromDefined(String s) {
        for (Member mdxMember : this.getDefinedMembers()) {
            if (!mdxMember.getUniqueName().equalsIgnoreCase(s)) continue;
            return mdxMember;
        }
        return null;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public QueryAxis getAxis(String name) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (!name.equalsIgnoreCase(this.axes[i].getName())) continue;
            return this.axes[i];
        }
        return null;
    }

    public Calc getAxisCalc(String name) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (!name.equalsIgnoreCase(this.axes[i].getName())) continue;
            return this.axisCalcs[i];
        }
        return null;
    }

    public void setAxes(QueryAxis[] axes) {
        this.axes = axes;
    }

    public Cube getCube() {
        return this.connection.getSchemaReader().getCube(this.cubeName);
    }

    public String getCubeName() {
        if (this.cubeName.charAt(0) == '[' && this.cubeName.charAt(this.cubeName.length() - 1) == ']') {
            return this.cubeName.substring(1, this.cubeName.length() - 1);
        }
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public Formula[] getFormulas() {
        return this.formulas.toArray(new Formula[0]);
    }

    public boolean hasFormulas() {
        return this.formulas.size() > 0;
    }

    public String toString() {
        try {
            this.resolve();
        }
        catch (CUBAException cUBAException) {
            // empty catch block
        }
        return this.toMdx();
    }

    @Override
    public String toMdx() {
        StringBuffer mdx = new StringBuffer();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = (Formula)iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cubeName);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        return mdx.toString();
    }

    public Object clone() {
        MdxQuery cloned = new MdxQuery();
        if (this.formulas.size() > 0) {
            ArrayList<Object> clonedFormulas = new ArrayList<Object>();
            for (Formula form : this.formulas) {
                clonedFormulas.add(form.clone());
            }
            cloned.formulas = clonedFormulas;
        }
        if (this.axes.length > 0) {
            QueryAxis[] clonedAxes = new QueryAxis[this.axes.length];
            for (int i = 0; i < clonedAxes.length; ++i) {
                clonedAxes[i] = (QueryAxis)this.axes[i].clone();
            }
            cloned.setAxes(clonedAxes);
        }
        if (this.slicer != null) {
            cloned.slicer = (Exp)this.slicer.clone();
        }
        cloned.setCubeName("[" + this.getCubeName() + "]");
        return cloned;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    public Formula addFormula(String[] names, Exp exp, MemberProperty[] memberProperties, CacheType cacheType) {
        Formula newFormula = new Formula(names, exp, memberProperties, cacheType);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public void removeFormula(Formula formula) {
        this.formulas.remove(formula);
    }

    public Formula addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public Formula addFormula(String[] names, Exp scope, Exp exp, MemberProperty[] memberProperties) {
        Formula formula = new Formula(names, scope, exp, memberProperties);
        this.formulas.add(formula);
        return formula;
    }

    public void removeFormula(String uniqueName) {
        Iterator iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = (Formula)iter.next();
            if (!uniqueName.equals(formula.getUniqeName())) continue;
            iter.remove();
        }
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getExp();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            DimensionProperty[] dimProps0 = this.axes[0].getResolvedProps();
            DimensionProperty[] dimProps1 = this.axes[1].getResolvedProps();
            Exp e1 = this.axes[1].getExp();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setExp(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[1].setResolvedProps(dimProps0);
            this.axes[0].setExp(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
            this.axes[0].setResolvedProps(dimProps1);
        }
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(int axis) {
        if (axis == -1 && this.slicer == null) {
            return null;
        }
        return this.collectHierarchies(axis == -1 ? this.slicer : this.axes[axis].getExp());
    }

    public Hierarchy[] collectHierarchies(Exp queryPart) {
        Type type = queryPart.getType();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        if (type instanceof TupleType) {
            Type[] types = ((TupleType)type).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < types.length; ++i) {
                Hierarchy hierarchy = types[i].getHierarchy();
                hierarchyList.add(hierarchy);
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{type.getHierarchy()};
    }

    public Evaluator createEvalutor(MdxQuery query) throws CUBAException {
        CubeImpl cube = (CubeImpl)query.getCube();
        ConnectionImpl cn = (ConnectionImpl)query.getConnection();
        CellReader cellReader = cn.getCellReader(cube);
        EvaluatorImpl evaluator = new EvaluatorImpl(cn, query, cube, cellReader);
        return evaluator;
    }

    public Calc[] getAxisCalcs() {
        return this.axisCalcs;
    }

    public Calc getSlicerCalc() {
        return this.slicerCalc;
    }

    public void setAxisCalcs(Calc[] axisCalcs) {
        this.axisCalcs = axisCalcs;
    }

    public void setSlicerCalc(Calc slicerCalc) {
        this.slicerCalc = slicerCalc;
    }

    public Member[] getCalculatedMembers() throws CUBAException {
        if (this.schemaReader == null) {
            this.getSchemaReader();
        }
        return this.schemaReader.getCalculatedMembers(this.schemaReader.getCube(this.cubeName));
    }

    public Member[] getCalculatedMembersInQueryAxis(QueryAxis queryAxis) {
        List definedMembers;
        if (this.schemaReader == null) {
            this.getSchemaReader();
        }
        if ((definedMembers = this.getDefinedMembers()).size() == 0) {
            return null;
        }
        String mdx = queryAxis.getExp().toMdx();
        Hierarchy[] hiers = this.collectHierarchies(queryAxis.getExp());
        ArrayList<Member> list = new ArrayList<Member>();
        for (int i = 0; i < hiers.length; ++i) {
            Member[] members = this.schemaReader.getCalculatedMembers(this.schemaReader.getCube(this.cubeName), hiers[i]);
            for (int j = 0; j < members.length; ++j) {
                if (mdx.indexOf(members[j].getUniqueName()) <= -1) continue;
                list.add(members[j]);
            }
        }
        return list.toArray(new Member[0]);
    }

    public IListFactory getListFactory() {
        if (this.listFactory == null) {
            this.listFactory = DefaultListFactory.instance;
        }
        return this.listFactory;
    }

    public synchronized void release() {
        if (this.listFactory != null) {
            this.listFactory.release();
            this.listFactory = null;
        }
    }

    private class CellCalculationInfo {
        boolean forAll;
        ListCalc listCalc;
        Calc calc;
        BooleanCalc conditionCalc;
        IList list;

        public CellCalculationInfo(boolean forAll, ListCalc listCalc, Calc calc, BooleanCalc conditionCalc) {
            this.forAll = forAll;
            this.listCalc = listCalc;
            this.calc = calc;
            this.conditionCalc = conditionCalc;
        }
    }

    private class CCFilter {
        int dimCount;
        RoaringLongBitSet[] bitSets;
        HashMap<Dimension, RoaringLongBitSet> bitSetMap = new HashMap();
        BBFilterIndex filterIndex;
        private boolean empty;
        private final CellCalculationInfo info;

        CCFilter(CellCalculationInfo info, Evaluator evaluator) throws CUBAException {
            Iterator iter;
            this.info = info;
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            if (!(iter = info.list.iterator()).hasNext()) {
                this.empty = true;
                return;
            }
            Object o = iter.next();
            if (o instanceof Member) {
                this.init((Member)o, iter);
            } else {
                this.init((Member[])o, iter);
            }
        }

        private void init(Member[] ms, Iterator iter) {
            int i;
            this.dimCount = ms.length;
            this.bitSets = new RoaringLongBitSet[this.dimCount];
            int[] indexes = new int[this.dimCount];
            int[] cards = new int[this.dimCount];
            for (i = 0; i < this.dimCount; ++i) {
                DimensionImpl dim = (DimensionImpl)ms[i].getDimension();
                this.bitSets[i] = new RoaringLongBitSet();
                this.bitSetMap.put(dim, this.bitSets[i]);
                indexes[i] = MdxQuery.this.getDimensionIndexInCube(dim);
                cards[i] = dim.getMemberCount();
            }
            this.filterIndex = new BBFilterIndex(cards, indexes);
            while (true) {
                for (i = 0; i < this.dimCount; ++i) {
                    this.bitSets[i].set(ms[i].getGlobalOrder());
                }
                this.filterIndex.addNarrow(ms);
                if (!iter.hasNext()) break;
                ms = (Member[])iter.next();
            }
        }

        private void init(Member m, Iterator iter) {
            DimensionImpl dim = (DimensionImpl)m.getDimension();
            this.dimCount = 1;
            this.bitSets = new RoaringLongBitSet[1];
            this.bitSets[0] = new RoaringLongBitSet();
            this.bitSetMap.put(dim, this.bitSets[0]);
            int[] indexes = new int[]{MdxQuery.this.getDimensionIndexInCube(m.getDimension())};
            int[] cards = new int[]{dim.getMemberCount()};
            this.filterIndex = new BBFilterIndex(cards, indexes);
            while (true) {
                this.bitSets[0].set(m.getGlobalOrder());
                this.filterIndex.addNarrow(m);
                if (!iter.hasNext()) break;
                m = (Member)iter.next();
            }
        }

        boolean hasMemberContext(Member[] members) {
            if (this.empty) {
                return false;
            }
            return this.filterIndex.get(members);
        }
    }

    private class CCFilters {
        CCFilter[] filters;
        HashMap<Dimension, RoaringLongBitSet> dimensionBitSetMap = new HashMap();

        public CCFilters() throws CUBAException {
            if (MdxQuery.this.cellCalculations == null) {
                return;
            }
            this.filters = new CCFilter[MdxQuery.this.cellCalculations.size()];
            for (int i = 0; i < this.filters.length; ++i) {
                CCFilter filter;
                Evaluator evaluator = MdxQuery.this.createEvaluator(MdxQuery.this);
                this.filters[i] = filter = new CCFilter((CellCalculationInfo)MdxQuery.this.cellCalculations.get(i), evaluator);
                for (Map.Entry<Dimension, RoaringLongBitSet> entry : filter.bitSetMap.entrySet()) {
                    Dimension dim = entry.getKey();
                    RoaringLongBitSet bs = this.dimensionBitSetMap.get(dim);
                    if (bs != null) {
                        bs.or(entry.getValue());
                        continue;
                    }
                    this.dimensionBitSetMap.put(dim, entry.getValue());
                }
            }
        }

        Calc getCellCalculationInfo(Evaluator evaluator) throws CUBAException {
            Member[] members = evaluator.getCurrentMembers();
            for (int i = this.filters.length - 1; i >= 0; --i) {
                if (!this.filters[i].hasMemberContext(members)) continue;
                CellCalculationInfo info = this.filters[i].info;
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
            return null;
        }
    }

    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader schemaReader) {
            super(schemaReader);
        }

        @Override
        public Member getMemberByUniqueName(Cube cube, String uniqueName) throws CUBAException {
            Member member = this.getCalculatedMember(cube, uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member getCalculatedMember(Cube cube, String uniqueName) {
            Member member = MdxQuery.this.lookupMemberFromDefined(uniqueName);
            if (member == null) {
                member = this.schemaReader.getCalculatedMember(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
            List definedMembers = MdxQuery.this.getDefinedMembers();
            ArrayList<Member> result = new ArrayList<Member>();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < definedMembers.size(); ++i) {
                Member member = (Member)definedMembers.get(i);
                if (!member.getHierarchy().equals(hierarchy)) continue;
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube, hierarchy);
            if (cMemberInSchema != null) {
                for (int i = 0; i < cMemberInSchema.length; ++i) {
                    if (set.contains(cMemberInSchema[i].getUniqueName())) continue;
                    result.add(cMemberInSchema[i]);
                }
            }
            return result.toArray(new Member[0]);
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube) throws CUBAException {
            List definedMembers = MdxQuery.this.getDefinedMembers();
            ArrayList<Member> result = new ArrayList<Member>();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < definedMembers.size(); ++i) {
                Member member = (Member)definedMembers.get(i);
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube);
            if (cMemberInSchema != null) {
                for (int i = 0; i < cMemberInSchema.length; ++i) {
                    if (set.contains(cMemberInSchema[i].getUniqueName())) continue;
                    result.add(cMemberInSchema[i]);
                }
            }
            return result.toArray(new Member[0]);
        }

        public Set getSet(String name) {
            for (int i = 0; i < MdxQuery.this.formulas.size(); ++i) {
                Formula formula = (Formula)MdxQuery.this.formulas.get(i);
                if (!formula.isSet() || !formula.getFirstName().equalsIgnoreCase(name)) continue;
                return formula.getSet();
            }
            return null;
        }

        @Override
        public CUBAElement getElementChild(CUBAElement parent, String s) throws CUBAException {
            CUBAElement mdxElement = this.schemaReader.getElementChild(parent, s);
            if (mdxElement != null) {
                return mdxElement;
            }
            for (int i = 0; i < MdxQuery.this.formulas.size(); ++i) {
                Formula formula = (Formula)MdxQuery.this.formulas.get(i);
                if (!formula.isSet() || !formula.getFirstName().equalsIgnoreCase(s)) continue;
                return formula.getSet();
            }
            return mdxElement;
        }

        @Override
        public CUBAElement lookupCompound(CUBAElement parent, String[] names, int category) throws CUBAException {
            switch (category) {
                case 0: 
                case 6: {
                    Set set;
                    if (parent != this.getCube(MdxQuery.this.cubeName)) break;
                    String uniqueName = UniqueNameUtil.createUniqueName(names);
                    Member calculatedMember = this.getCalculatedMember(this.getCube(MdxQuery.this.cubeName), uniqueName);
                    if (calculatedMember != null) {
                        return calculatedMember;
                    }
                    if (names.length != 1 || (set = this.getSet(names[0])) == null) break;
                    return set;
                }
            }
            CUBAElement olapElement = super.lookupCompound(parent, names, category);
            return olapElement;
        }
    }
}

