/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.func;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Level;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Exp;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunctionException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.HierarchyCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.IntegerCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.AbstractLevelCalc;

public class LevelsCalc
extends AbstractLevelCalc {
    HierarchyCalc hierarchyCalc;
    IntegerCalc ordinalCalc;

    public LevelsCalc(Exp exp, HierarchyCalc hierarchyCalc, IntegerCalc ordinalCalc) {
        super(exp, new Calc[]{hierarchyCalc, ordinalCalc});
        this.hierarchyCalc = hierarchyCalc;
        this.ordinalCalc = ordinalCalc;
    }

    @Override
    public Level evaluateLevel(Evaluator evaluator) throws CUBAException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        int n = this.ordinalCalc.evaluateInteger(evaluator);
        if (hierarchy.getDimension().isParentChildrenDimension()) {
            Level level;
            for (level = hierarchy.getLevels()[0]; level != null && n > level.getDepth(); level = level.getChildLevel()) {
            }
            if (level == null) {
                throw new FunctionException("Levels Index '" + n + "' out of bounds");
            }
            return level;
        }
        Level[] levels = hierarchy.getLevels();
        if (n >= levels.length || n < 0) {
            throw new FunctionException("Levels Index '" + n + "' out of bounds");
        }
        return levels[n];
    }
}

