/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.func;

import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Hierarchy;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunCall;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.IntegerCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.TupleCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.AbstractMemberCalc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.TupleType;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.type.Type;

class TupleItemFunDef
extends FunDefBase {
    static final TupleItemFunDef instance = new TupleItemFunDef();

    private TupleItemFunDef() {
        super("Item", "<Tuple>.Item(<Index>)", "Returns a member from the tuple specified in <Tuple>. The member to be returned is specified by the zero-based position of the member in the set in <Index>.", "mmtn");
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
        Type type = call.getArg(0).getType();
        if (type instanceof MemberType) {
            final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
            final IntegerCalc indexCalc = compiler.compileInteger(call.getArg(1));
            return new AbstractMemberCalc(call, new Calc[]{memberCalc, indexCalc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                    Member member = memberCalc.evaluateMember(evaluator);
                    int index = indexCalc.evaluateInteger(evaluator);
                    if (index != 0) {
                        return null;
                    }
                    return member;
                }
            };
        }
        final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
        final IntegerCalc indexCalc = compiler.compileInteger(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{tupleCalc, indexCalc}){
            final Member[] nullTupleMembers;
            {
                super(exp, calcs);
                this.nullTupleMembers = TupleItemFunDef.this.makeNullTuple((TupleType)tupleCalc.getType());
            }

            @Override
            public Member evaluateMember(Evaluator evaluator) throws CUBAException {
                Member[] members = tupleCalc.evaluateTuple(evaluator);
                assert (members == null || members.length == this.nullTupleMembers.length);
                int index = indexCalc.evaluateInteger(evaluator);
                if (members == null) {
                    return this.nullTupleMembers[index];
                }
                if (index >= members.length || index < 0) {
                    return null;
                }
                return members[index];
            }
        };
    }

    public Member[] makeNullTuple(TupleType tupleType) {
        Member[] members = new Member[tupleType.elementTypes.length];
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            MemberType type = (MemberType)tupleType.elementTypes[i];
            members[i] = this.makeNullMember(type);
        }
        return members;
    }

    Member makeNullMember(MemberType memberType) {
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getNullMember();
    }
}

