/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.q;

import com.kingdee.eas.ma.mbg.streamwork.cuba.q.Bitmap;
import java.util.ArrayList;
import java.util.BitSet;

public class BitmapImpl
implements Bitmap {
    private int top;
    private int left;
    private int rowCount;
    private int columnCount;
    private ArrayList<BitSet> rowBitSets = new ArrayList();
    private ArrayList<BitSet> columnBitSets = new ArrayList();

    public BitmapImpl(int top, int left, int rowCount, int columnCount) {
        int i;
        this.top = top;
        this.left = left;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        for (i = 0; i < rowCount; ++i) {
            this.rowBitSets.add(new BitSet());
        }
        for (i = 0; i < columnCount; ++i) {
            this.columnBitSets.add(new BitSet());
        }
    }

    @Override
    public int top() {
        return this.top;
    }

    @Override
    public int left() {
        return this.left;
    }

    @Override
    public void set(int row, int column) {
        this.rowBitSets.get(row).set(column);
        this.columnBitSets.get(column).set(row);
    }

    @Override
    public boolean get(int row, int column) {
        return this.rowBitSets.get(row).get(column);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public BitSet getRowBitSet(int row) {
        return this.rowBitSets.get(row);
    }

    @Override
    public BitSet getColumnBitSet(int column) {
        return this.columnBitSets.get(column);
    }

    @Override
    public BitSet xOr() {
        BitSet result = new BitSet();
        BitSet set = this.columnBitSets.get(0);
        result.or(set);
        for (int i = 1; i < this.columnBitSets.size(); ++i) {
            result.or(this.columnBitSets.get(i));
        }
        return result;
    }

    @Override
    public BitSet yOr() {
        BitSet result = new BitSet();
        BitSet set = this.rowBitSets.get(0);
        result.or(set);
        for (int i = 1; i < this.rowBitSets.size(); ++i) {
            result.or(this.rowBitSets.get(i));
        }
        return result;
    }

    @Override
    public BitSet xOr(Bitmap bm) {
        BitSet result = this.xOr();
        result.or(bm.xOr());
        return result;
    }

    @Override
    public BitSet yOr(Bitmap bm) {
        BitSet result = this.yOr();
        result.or(bm.yOr());
        return result;
    }

    @Override
    public int rowCardinality() {
        return this.xOr().cardinality();
    }

    @Override
    public int columnCardinality() {
        return this.yOr().cardinality();
    }
}

