/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.streamwork.cuba.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SqlParamSet
implements Serializable {
    private static final DecimalFormat df = new DecimalFormat("0.##########");
    private static final int TYPE_OBJECT = 0;
    private static final int TYPE_STRING = 1;
    private static final int TYPE_INT = 2;
    private static final int TYPE_BIGDECIMAL = 3;
    private static final int TYPE_DATE = 4;
    private static final int TYPE_TIMESTAMP = 5;
    private static final int TYPE_DATETIME = 6;
    private static final int TYPE_BYTES = 7;
    private Set params = new HashSet();
    DateFormat f = new SimpleDateFormat("yyyy-M-d H:mm:ss");

    public SqlParamSet() {
    }

    public SqlParamSet(Object[] params) {
        this.setParams(params);
    }

    public Object[] getParams() {
        Entity[] es = new Entity[this.params.size()];
        this.params.toArray(es);
        ArrayList<Object> list = new ArrayList<Object>(es.length);
        int n = es.length;
        for (int i = 0; i < n; ++i) {
            list.add(null);
        }
        for (Entity e : es) {
            list.set(e.position - 1, e.value);
        }
        return list.toArray();
    }

    public SqlParamSet setParams(Object[] params) {
        this.clear();
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            this.addObject(params[i]);
        }
        return this;
    }

    public void putToStatement(PreparedStatement ps) throws SQLException {
        block7: for (Entity e : this.params) {
            switch (e.type) {
                case 1: {
                    ps.setString(e.position, (String)e.value);
                    continue block7;
                }
                case 2: {
                    ps.setInt(e.position, (Integer)e.value);
                    continue block7;
                }
                case 7: {
                    ps.setBytes(e.position, (byte[])e.value);
                    continue block7;
                }
                case 5: {
                    ps.setTimestamp(e.position, (Timestamp)e.value);
                    continue block7;
                }
                case 4: 
                case 6: {
                    ps.setDate(e.position, (java.sql.Date)e.value);
                    continue block7;
                }
            }
            if (e.value == null) {
                ps.setNull(e.position, 0);
                continue;
            }
            ps.setObject(e.position, e.value);
        }
    }

    public String sql(Object sql) throws SQLException {
        return this.getSqlWithParams(sql.toString());
    }

    public String getSqlWithParams(String sql) throws SQLException {
        StringBuffer sb = new StringBuffer();
        char[] chs = sql.toCharArray();
        int quoteCount = 0;
        int position = 0;
        block4: for (int i = 0; i < chs.length; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '\'': {
                    ++quoteCount;
                    sb.append(ch);
                    continue block4;
                }
                case '?': {
                    if (quoteCount % 2 == 0) {
                        ++position;
                        Iterator iter = this.params.iterator();
                        boolean hasValue = false;
                        while (iter.hasNext()) {
                            Entity e = (Entity)iter.next();
                            if (e.position != position) continue;
                            sb.append(this.getFormatedValue(e.value));
                            hasValue = true;
                            break;
                        }
                        if (hasValue) continue block4;
                        throw new SQLException("Not set parameter value yet @" + position + " with sql: " + sql);
                    }
                    sb.append(ch);
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (quoteCount % 2 != 0) {
            throw new SQLException("Statement not close the quote:" + sql);
        }
        return sb.toString();
    }

    private String getFormatedValue(Object obj) {
        if (obj == null) {
            return "Null";
        }
        if (obj instanceof String) {
            return "'" + obj.toString() + "'";
        }
        if (obj instanceof Date) {
            StringBuffer sb = new StringBuffer("to_date('");
            sb.append(this.f.format((Date)obj));
            sb.append("')");
            return sb.toString();
        }
        if (obj instanceof Double) {
            return df.format((Double)obj);
        }
        if (obj instanceof Float) {
            return df.format(((Float)obj).floatValue());
        }
        return obj.toString();
    }

    public void clear() {
        this.params.clear();
    }

    private SqlParamSet setValue(int type, int index, Object value) {
        for (Entity e : this.params) {
            if (e.position != index) continue;
            e.type = type;
            e.value = value;
            return this;
        }
        this.params.add(new Entity(type, index, value));
        return this;
    }

    public SqlParamSet setObject(int index, Object value) {
        return this.setValue(0, index, value);
    }

    public SqlParamSet setBytes(int index, byte[] value) {
        return this.setValue(7, index, value);
    }

    public SqlParamSet setString(int index, String value) {
        return this.setValue(1, index, value);
    }

    public SqlParamSet setInt(int index, int value) {
        return this.setValue(2, index, new Integer(value));
    }

    public SqlParamSet setBigDecimal(int index, BigDecimal value) {
        return this.setValue(3, index, value);
    }

    public SqlParamSet setDate(int index, java.sql.Date value) {
        return this.setValue(4, index, value);
    }

    public SqlParamSet setDateTime(int index, java.sql.Date value) {
        return this.setValue(6, index, value);
    }

    public SqlParamSet setTimestamp(int index, Timestamp value) {
        return this.setValue(5, index, value);
    }

    public SqlParamSet addParams(SqlParamSet sqlParams) {
        int baseIndex = this.size();
        for (Entity e : sqlParams.params) {
            this.setValue(e.type, baseIndex + e.position, e.value);
        }
        return this;
    }

    private SqlParamSet addValue(int type, Object value) {
        this.params.add(new Entity(type, this.params.size() + 1, value));
        return this;
    }

    public SqlParamSet addObject(Object value) {
        return this.addValue(0, value);
    }

    public SqlParamSet addBytes(byte[] value) {
        return this.addValue(7, value);
    }

    public SqlParamSet addString(String value) {
        return this.addValue(1, value);
    }

    public SqlParamSet addInt(int value) {
        return this.addValue(2, new Integer(value));
    }

    public SqlParamSet addBigDecimal(BigDecimal value) {
        return this.addValue(3, value);
    }

    public SqlParamSet addDate(java.sql.Date value) {
        return this.addValue(4, value);
    }

    public SqlParamSet addDateTime(java.sql.Date value) {
        return this.addValue(6, value);
    }

    public SqlParamSet addTimestamp(Timestamp value) {
        return this.addValue(5, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.params.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("\n");
        }
        return sb.toString();
    }

    public int size() {
        return this.params.size();
    }

    class Entity
    implements Serializable {
        int type;
        int position;
        Object value;

        Entity(int position, Object value) {
            this(0, position, value);
        }

        Entity(int type, int position, Object value) {
            this.type = type;
            this.position = position;
            this.value = value;
        }

        public boolean equals(Object o) {
            return o instanceof Entity && ((Entity)o).position == this.position;
        }

        public String toString() {
            return this.position + "=" + this.value;
        }
    }
}

