/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgTemplateUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgDataOrgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgDataUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodIdProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgViewManagerProcessor;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import java.sql.Connection;
import java.util.Map;

public class MbgActualUpdate
extends MbgTemplateUpdate {
    @Override
    public void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        super.innerUpdate(result);
    }

    @Override
    protected void otherUpdate(Connection conn) throws Exception {
        this.updateBgActualForm(conn);
        this.updateActualData(conn);
    }

    @Override
    protected String getBgScenarioNumber() {
        return this.getCacheHelper().getBgActualScenario().getNumber();
    }

    private void updateActualData(Connection conn) throws Exception {
        Map<String, String> cubeMap = this.getBgDataCubeMap();
        MbgDataUpdateProcessor processor = new MbgDataUpdateProcessor(conn, this.getCacheHelper(), this.getCacheHelper().getExeVersion(), this.getCacheHelper().getBgActualScenario());
        for (Map.Entry<String, String> entry : cubeMap.entrySet()) {
            String bgSchemeRootId = entry.getKey();
            String refCube = entry.getValue();
            processor.setBgSchemeRootId(bgSchemeRootId);
            processor.setCubeName(BgCubeUtils.getDailyActualCubeName(refCube));
            processor.startProcess();
            processor.setCubeName(BgCubeUtils.getActualCubeName1(refCube));
            processor.startProcess();
        }
        MbgDataOrgUpdateProcessor processor1 = new MbgDataOrgUpdateProcessor(conn, this.getCacheHelper(), 16);
        processor1.startProcess();
    }

    private Map<String, String> getBgDataCubeMap() {
        return this.getCacheHelper().getBgDataCubeMap();
    }

    private void updateBgActualForm(Connection conn) throws Exception {
        String querySql = "Select bgActual.FID m_id, bgActual.FBgPeriodId bp_id, bgForm.FBgSchemeId bs_id FROM T_Mbg_BgActualRecord bgActual, T_Mbg_BgForm bgForm Where bgActual.FBgFormId = bgForm.FID";
        String updateSql = "Update T_Mbg_BgActualRecord Set FBgPeriodId = ? Where FID = ?";
        MbgPeriodIdProcessor processor = new MbgPeriodIdProcessor(conn, this.getCacheHelper(), querySql, updateSql);
        processor.startProcess();
    }

    @Override
    protected String getBookQuerySql() {
        return "Select bgActual.FID " + MbgViewManagerProcessor.idField + ", bgActual.FData " + MbgViewManagerProcessor.dataField + ", temp.FRootId " + MbgViewManagerProcessor.templateRootIdField + " From T_Mbg_BgActualRecord bgActual, T_Mbg_BgForm bgForm, T_Mbg_BgTemplate temp Where bgActual.FBgFormID = bgForm.FID AND bgForm.FBgTemplateId = temp.FID AND bgActual.FData IS NOT NULL";
    }

    @Override
    protected String getBookUpdateSql() {
        return "Update T_Mbg_BgActualRecord Set FData = ? Where FID = ?";
    }

    @Override
    protected String getViewQuerySql() {
        return "Select bgActual.FID " + MbgViewManagerProcessor.idField + ", bgActual.FDimensionData " + MbgViewManagerProcessor.dataField + ", temp.FRootId " + MbgViewManagerProcessor.templateRootIdField + " FROM T_Mbg_BgActualRecord bgActual, T_Mbg_BgForm bgForm, T_Mbg_BgTemplate temp Where bgActual.FBgFormID = bgForm.FID AND bgForm.FBgTemplateId = temp.FID AND bgActual.FDimensionData IS NOT NULL";
    }

    @Override
    public String getViewUpdateSql() {
        return "Update T_Mbg_BgActualRecord Set FDimensionData = ? Where FID = ?";
    }
}

