/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgBgPeriodTypeUtils;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodUpdateUtils;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgAdjustBillUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgAdjustBillUpdate.class);
    HashMap<String, HashMap<String, String>> orgUnitMap = new HashMap();

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        this.startUpdateAdjustBill();
    }

    private void startUpdateAdjustBill() throws BOSException {
        DbUtil.execute((Context)this.getContext(), (String)"Update T_MBG_BgAdjustBill Set FType = 2 Where FType >= 10");
        this.addNewDimension();
        this.dealDetailOrgs();
        this.dealBgTmpDataTable();
        this.dealPastRecord();
        this.dealRollTemplate();
    }

    private void addNewDimension() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            HashMap<String, String> updateMap = new HashMap<String, String>();
            String selectSql = "select b.fid, s.FPeriod from t_mbg_bgadjustbill b left join t_mbg_bgscheme s on s.fid = b.FBgScheme ";
            pstmt = conn.prepareStatement(selectSql);
            rst = pstmt.executeQuery();
            String adjustbillId = null;
            Integer period = null;
            while (rst.next()) {
                adjustbillId = rst.getString(1);
                period = rst.getInt(2);
                updateMap.put(adjustbillId, MbgBgPeriodTypeUtils.getBgPeriodTypeByPeriod(this.getContext(), period).getId().toString());
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!updateMap.isEmpty()) {
                String updateSql = "update T_MBG_BgAdjustBill set FBgPeriodTypeID = ?, FBgScenarioID = ?, FBgVersionID = ?  where fid = ? ";
                pstmt = conn.prepareStatement(updateSql);
                int index = 0;
                String adjustBillId2 = null;
                for (String adjustBillId2 : updateMap.keySet()) {
                    pstmt.setString(1, (String)updateMap.get(adjustBillId2));
                    pstmt.setString(2, this.getCacheHelper().getBgDataScenario().getId().toString());
                    pstmt.setString(3, this.getCacheHelper().getExeVersion().getId().toString());
                    pstmt.setString(4, adjustBillId2);
                    pstmt.addBatch();
                    if (++index < 50) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"MbgAdjustBillUpdate.addNewDimension() error!", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealDetailOrgs() throws BOSException {
        HashMap<String, HashMap<String, String>> schemeOrgMap = this.getSchemeOrgMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            StringBuffer querySql = new StringBuffer();
            querySql.append("select b.FId adjustId, b.FType adjustType, b.FOrgUnit adjustOrgUnit, b.FBgScheme adjustScheme, b.FPeriodYear adjustPeriodYear, ").append("e.FId entryId, e.FOrgUnit entryOrgUnit, e.FPeriod entryPeriod, e.FFormula formula, ").append("s.FRootId schemeRootId ,  s.FPeriod schemePeriod ").append("from T_MBG_BgAdjustBill b ").append("left join T_MBG_BgScheme s on s.FID = b.FBgScheme ").append("left join T_MBG_BgAdjustBillEntry e on e.FBgAdjustBill = b.fid ");
            pstmt = conn.prepareStatement(querySql.toString());
            rst = pstmt.executeQuery();
            ArrayList<String[]> dataLst = new ArrayList<String[]>();
            String[] updateArr = null;
            while (rst.next()) {
                updateArr = new String[]{rst.getString("entryId"), rst.getString("entryOrgUnit"), rst.getString("entryPeriod"), rst.getString("formula"), rst.getString("adjustId"), String.valueOf(rst.getInt("adjustType")), rst.getString("adjustOrgUnit"), rst.getString("adjustPeriodYear"), rst.getString("adjustScheme"), rst.getString("schemeRootId"), rst.getString("schemePeriod")};
                dataLst.add(updateArr);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            ArrayList<String[]> updateLst1 = new ArrayList<String[]>();
            ArrayList<String[]> updateLst2 = new ArrayList<String[]>();
            ArrayList<String[]> updateLst3 = new ArrayList<String[]>();
            HashSet<String> tmpSet = new HashSet<String>();
            String[] updateArr1 = null;
            String[] updateArr2 = null;
            String[] updateArr3 = null;
            if (!dataLst.isEmpty()) {
                String entryId = null;
                String entryOrgUnit = null;
                String entryPeriod = null;
                String formula = null;
                String adjustId = null;
                String adjustType = null;
                String adjustOrgUnit = null;
                String adjustPeriodYear = null;
                String adjustScheme = null;
                String schemeRootId = null;
                String schemePeriod = null;
                int size = dataLst.size();
                for (int i = 0; i < size; ++i) {
                    entryId = ((String[])dataLst.get(i))[0];
                    entryOrgUnit = ((String[])dataLst.get(i))[1];
                    entryPeriod = ((String[])dataLst.get(i))[2];
                    formula = ((String[])dataLst.get(i))[3];
                    adjustId = ((String[])dataLst.get(i))[4];
                    adjustType = ((String[])dataLst.get(i))[5];
                    adjustOrgUnit = ((String[])dataLst.get(i))[6];
                    adjustPeriodYear = ((String[])dataLst.get(i))[7];
                    adjustScheme = ((String[])dataLst.get(i))[8];
                    schemeRootId = ((String[])dataLst.get(i))[9];
                    schemePeriod = ((String[])dataLst.get(i))[10];
                    updateArr1 = new String[4];
                    updateArr2 = new String[3];
                    updateArr3 = new String[4];
                    if (!tmpSet.contains(adjustId)) {
                        if (adjustType.equalsIgnoreCase(String.valueOf(1)) || adjustType.equalsIgnoreCase(String.valueOf(3))) {
                            updateArr1[0] = schemeRootId;
                            updateArr1[1] = this.getNewPeriodIdByOldPeriodId(adjustPeriodYear, schemePeriod);
                            updateArr1[2] = schemeOrgMap.containsKey(adjustScheme) ? (schemeOrgMap.get(adjustScheme).containsKey(adjustOrgUnit) ? schemeOrgMap.get(adjustScheme).get(adjustOrgUnit) : adjustOrgUnit) : adjustOrgUnit;
                            updateArr1[3] = adjustId;
                            tmpSet.add(adjustId);
                            updateLst1.add(updateArr1);
                        }
                        if (adjustType.equalsIgnoreCase(String.valueOf(0)) || adjustType.equalsIgnoreCase(String.valueOf(2))) {
                            updateArr2[0] = schemeRootId;
                            updateArr2[1] = this.getNewPeriodIdByOldPeriodId(adjustPeriodYear, schemePeriod);
                            updateArr2[2] = adjustId;
                            tmpSet.add(adjustId);
                            updateLst2.add(updateArr2);
                        }
                    }
                    updateArr3[0] = this.getNewPeriodIdByOldPeriodId(entryPeriod, schemePeriod);
                    updateArr3[1] = this.getFormula(schemePeriod, formula);
                    updateArr3[2] = schemeOrgMap.containsKey(adjustScheme) ? (schemeOrgMap.get(adjustScheme).containsKey(entryOrgUnit) ? schemeOrgMap.get(adjustScheme).get(entryOrgUnit) : entryOrgUnit) : entryOrgUnit;
                    updateArr3[2] = this.getNewOrgUnitMap().get(schemeRootId).get(updateArr3[2]);
                    updateArr3[3] = entryId;
                    updateLst3.add(updateArr3);
                }
                this.updateadjustEntry(conn, updateLst3);
                this.updateInnerAdjust(conn, updateLst1);
                this.updateOuterAdjust(conn, updateLst2);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"MbgAdjustBillUpdate.addNewDimension() error!", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealBgTmpDataTable() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection();
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select d.FID Id, d.FBgSchemeRootId schemeRootId, d.FOrgUnitId orgUnitId, d.FFormula formula, d.FBgPeriodId periodId, s.FPeriod periodType from t_mbg_bgtmpdata d left join t_mbg_bgscheme s on s.fId = d.FBgSchemeRootId ");
            String[] updateArr = null;
            ArrayList<String[]> updateLst = new ArrayList<String[]>();
            while (rst.next()) {
                updateArr = new String[]{rst.getString("Id"), this.getTargeOrgId(rst.getString("schemeRootId")) != null ? this.getTargeOrgId(rst.getString("schemeRootId")) : rst.getString("orgUnitId"), this.getFormula(String.valueOf(rst.getInt("periodType")), rst.getString("formula")), this.getNewPeriodIdByOldPeriodId(rst.getString("periodId"), String.valueOf(rst.getInt("periodType")))};
                updateLst.add(updateArr);
            }
            SQLUtils.cleanup((ResultSet)rst);
            int index = 0;
            pstmt = conn.prepareStatement("update t_mbg_bgtmpdata set FOrgUnitId = ? , FFormula = ? , FBgPeriodId = ? where FID = ?");
            int in = updateLst.size();
            for (int i = 0; i < in; ++i) {
                updateArr = (String[])updateLst.get(i);
                pstmt.setString(1, updateArr[1]);
                pstmt.setString(2, updateArr[2]);
                pstmt.setString(3, updateArr[3]);
                pstmt.setString(4, updateArr[0]);
                pstmt.addBatch();
                if (++index < 50) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"MbgAdjustBillUpdate.dealBgTmpDataTable() error!", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void dealPastRecord() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmtUpdate = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            int index = 0;
            pstmt = conn.prepareStatement("select d.fid dId, d.FFormula dFormula, s.FPeriod sPeriod from T_MBG_BgPastData d left join T_MBG_BgPastRecord r on r.fid = d.FPastRecordID left join T_MBG_BgForm f on f.fId = r.FBgFormID left join t_mbg_bgscheme s on s.fid = f.FBgSchemeID ");
            pstmtUpdate = conn.prepareStatement("Update T_MBG_BgPastData Set FFormula = ? Where FId = ?");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                pstmtUpdate.setString(1, this.getFormula(String.valueOf(rst.getInt("sPeriod")), rst.getString("dFormula")));
                pstmtUpdate.setString(2, rst.getString("dId"));
                pstmtUpdate.addBatch();
                if (++index < 50) continue;
                pstmtUpdate.executeBatch();
                pstmtUpdate.clearBatch();
                index = 0;
            }
            if (index != 0) {
                pstmtUpdate.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmtUpdate);
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"MbgAdjustBillUpdate.dealPastRecord() error!", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void updateInnerAdjust(Connection conn, ArrayList<String[]> updateLst) throws BOSException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update T_MBG_BgAdjustBill set FBgScheme = ? , FPeriodYear = ? , FOrgUnit = ? where FID = ?");
            String[] updateArr = null;
            int index = 0;
            int in = updateLst.size();
            for (int i = 0; i < in; ++i) {
                updateArr = updateLst.get(i);
                pstmt.setString(1, updateArr[0]);
                pstmt.setString(2, updateArr[1]);
                pstmt.setString(3, updateArr[2]);
                pstmt.setString(4, updateArr[3]);
                pstmt.addBatch();
                if (++index < 50) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"MbgAdjustBillUpdate error!", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private void updateOuterAdjust(Connection conn, ArrayList<String[]> updateLst) throws BOSException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update T_MBG_BgAdjustBill set FBgScheme = ? , FPeriodYear = ? where FID = ?");
            String[] updateArr = null;
            int index = 0;
            int in = updateLst.size();
            for (int i = 0; i < in; ++i) {
                updateArr = updateLst.get(i);
                pstmt.setString(1, updateArr[0]);
                pstmt.setString(2, updateArr[1]);
                pstmt.setString(3, updateArr[2]);
                pstmt.addBatch();
                if (++index < 50) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"MbgAdjustBillUpdate error!", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private void updateadjustEntry(Connection conn, ArrayList<String[]> updateLst) throws BOSException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update T_MBG_BgAdjustBillEntry set FPeriod = ? , FFormula = ? , FOrgUnit = ? where FID = ?");
            String[] updateArr = null;
            int index = 0;
            int in = updateLst.size();
            for (int i = 0; i < in; ++i) {
                updateArr = updateLst.get(i);
                pstmt.setString(1, updateArr[0]);
                pstmt.setString(2, updateArr[1]);
                pstmt.setString(3, updateArr[2]);
                pstmt.setString(4, updateArr[3]);
                pstmt.addBatch();
                if (++index < 50) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"MbgAdjustBillUpdate error!", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private String getTargeOrgId(String bgSchemeRootId) {
        MbgUpdateOrgInfo config = this.getCacheHelper().getUpdateInfoByBgSchemeId(bgSchemeRootId);
        if (config == null || config.getTargetOrg() == null) {
            return null;
        }
        return config.getTargetOrg().getId().toString();
    }

    private String getFormula(String periodType, String oldFormula) {
        String periodTypeNum = MbgPeriodUpdateUtils.getBgPeriodType(Integer.valueOf(periodType));
        String[] params = BgNFSHelper.parseFormulaPara(oldFormula);
        params[1] = MbgPeriodUpdateUtils.convertPeriod(params[1], periodTypeNum);
        return BgNFSHelper.getFormulaFromParam(params);
    }

    private String getNewPeriodIdByOldPeriodId(String oldPeriodId, String periodType) throws BOSException {
        if (StringUtils.isEmpty((String)oldPeriodId) || StringUtils.isEmpty((String)periodType)) {
            return null;
        }
        String oldBgPeriodNumber = this.getCacheHelper().getOldPeriodMap().get(oldPeriodId);
        String bgPeriodTypeNumber = MbgPeriodUpdateUtils.getBgPeriodType(Integer.valueOf(periodType));
        String newBgPeriodNumber = MbgPeriodUpdateUtils.convertPeriod(oldBgPeriodNumber, bgPeriodTypeNumber);
        String newPeriod = this.getCacheHelper().getBgPeriodMap().get(newBgPeriodNumber).getId().toString();
        return newPeriod;
    }

    private HashMap<String, HashMap<String, String>> getSchemeOrgMap() {
        Map<String, MbgUpdateOrgInfo> orgConfig = this.getCacheHelper().getUpdateConfig().getOrgConfig();
        MbgUpdateOrgInfo config2 = null;
        HashMap<String, HashMap<String, String>> schemeOrgMap = new HashMap<String, HashMap<String, String>>();
        String schemeId = null;
        String sourceOrgId = null;
        String targeOrgId = null;
        for (MbgUpdateOrgInfo config2 : orgConfig.values()) {
            if (config2.getBgScheme() == null || config2.getBgScheme().getId() == null) continue;
            schemeId = config2.getBgScheme().getId().toString();
            sourceOrgId = config2.getSourceOrg().getId().toString();
            if (config2.getTargetOrg() == null) continue;
            targeOrgId = config2.getTargetOrg().getId().toString();
            if (!schemeOrgMap.containsKey(schemeId)) {
                schemeOrgMap.put(schemeId, new HashMap());
            }
            schemeOrgMap.get(schemeId).put(sourceOrgId, targeOrgId);
        }
        return schemeOrgMap;
    }

    private HashMap<String, HashMap<String, String>> getNewOrgUnitMap() throws BOSException {
        if (!this.orgUnitMap.isEmpty()) {
            return this.orgUnitMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            HashMap schemeViewMap = new HashMap();
            String schemeId2 = null;
            String orgUnitId = null;
            String bgOrgUnitid = null;
            String orgViewId = null;
            pstmt = conn.prepareStatement("Select FRootID, FBgOrgViewId FROM T_MBG_BgScheme Where FID = FRootId");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgViewId = rst.getString("FBgOrgViewId");
                schemeId2 = rst.getString("FRootID");
                if (!schemeViewMap.containsKey(orgViewId)) {
                    schemeViewMap.put(orgViewId, new HashSet());
                }
                ((Set)schemeViewMap.get(orgViewId)).add(schemeId2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("select u.fid bgOrgUnitid, u.FOrgUnitID orgUnitId, u.FViewId orgViewId from t_mbg_bgOrgUnit u");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgViewId = rst.getString("orgViewId");
                orgUnitId = rst.getString("orgUnitId");
                bgOrgUnitid = rst.getString("bgOrgUnitid");
                if (!schemeViewMap.containsKey(orgViewId)) continue;
                for (String schemeId2 : (Set)schemeViewMap.get(orgViewId)) {
                    if (!this.orgUnitMap.containsKey(schemeId2)) {
                        this.orgUnitMap.put(schemeId2, new HashMap());
                    }
                    this.orgUnitMap.get(schemeId2).put(orgUnitId, bgOrgUnitid);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return this.orgUnitMap;
    }

    private void dealRollTemplate() throws BOSException {
        Connection conn = this.getConnection();
        if (BgDBUtils.existColumn((Connection)conn, (String)"T_MBG_RollTemplate", (String)"FBgScenarioID") == BgDBUtils.YES) {
            MbgSqlHelper.execute((Connection)conn, (String)("update T_MBG_RollTemplate set FBgScenarioID = '" + this.getCacheHelper().getBgActualScenario().getId().toString() + "'  where FBgScenarioID is null or FBgScenarioID = '' "));
        }
        SQLUtils.cleanup((Connection)conn);
    }
}

