/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.app.impl.BizCalcRuleInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateCalculateInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MbgCalcRuleUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgCalcRuleUpdate.class);
    private static final String FindStr = "\\[BGP@[A-Z0-9.!+-]+\\]";

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        String _billId = null;
        Connection conn = null;
        IRowSet rst = null;
        BizCalcRuleInfo rule = null;
        BgSchemeInfo scheme = null;
        HashMap<String, String> bizFormulaMap = new HashMap<String, String>();
        HashMap<String, List<BizCalcRuleInfo>> bizRuleMap = new HashMap<String, List<BizCalcRuleInfo>>();
        HashMap<String, BgSchemeInfo> schemeMap = new HashMap<String, BgSchemeInfo>();
        ArrayList<BizCalcRuleInfo> ruleCol = null;
        try {
            conn = this.getConnection();
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FId, t.FFormula, r.FID AS RID, r.FExpression, r.FBgPeriodNum from T_MBG_BizCalc t left join T_MBG_BizCalcRule r on t.FID = r.FBizSchemeId where r.FBgPeriodNum is not null");
            while (rst.next()) {
                _billId = rst.getString("FID");
                if (bizFormulaMap.containsKey(_billId)) {
                    ruleCol = (ArrayList<BizCalcRuleInfo>)bizRuleMap.get(_billId);
                } else {
                    bizFormulaMap.put(_billId, rst.getString("FFormula"));
                    ruleCol = new ArrayList<BizCalcRuleInfo>();
                    bizRuleMap.put(_billId, ruleCol);
                }
                rule = new BizCalcRuleInfo();
                rule.setId(BOSUuid.read((String)rst.getString("RID")));
                rule.setExpression(rst.getString("FExpression"));
                rule.setBgPeriodNum(rst.getString("FBgPeriodNum"));
                if (StringUtils.isEmpty((String)rule.getBgPeriodNum())) continue;
                ruleCol.add(rule);
            }
            SQLUtils.cleanup((ResultSet)rst);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FBizCalcId, t.FBgSchemeId, s.FPeriod from T_MBG_BizCalcSchemeRelation t left join T_MBG_BgScheme s on t.FBgSchemeId = s.FID");
            while (rst.next()) {
                scheme = new BgSchemeInfo();
                scheme.setId(BOSUuid.read((String)rst.getString("FBgSchemeId")));
                scheme.setPeriod(BgPeriodEnum.getEnum((int)rst.getInt("FPeriod")));
                schemeMap.put(rst.getString("FBizCalcId"), scheme);
            }
            SQLUtils.cleanup((ResultSet)rst);
            Set<String> bizCalcIds = this.parseBizCalc(conn, bizFormulaMap, bizRuleMap, schemeMap);
            this.updateBizCalc(conn, bizCalcIds, bizFormulaMap, bizRuleMap);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"biz calc innerUpdate sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    private Set<String> parseBizCalc(Connection conn, Map<String, String> bizFormulaMap, Map<String, List<BizCalcRuleInfo>> bizRuleMap, Map<String, BgSchemeInfo> schemeMap) {
        HashSet<String> upCalcs = new HashSet<String>();
        if (conn == null || bizFormulaMap == null || bizFormulaMap.isEmpty()) {
            return upCalcs;
        }
        String bizCalcId = null;
        BOSUuid bosId = null;
        BizCalcRuleInfo rule = null;
        BgSchemeInfo scheme = null;
        int periodType = 0;
        String srcStr = null;
        String distStr = null;
        String expresStr = null;
        Pattern pattern = Pattern.compile(FindStr);
        Matcher matcher = null;
        Object var16_16 = null;
        Map.Entry entry122 = null;
        HashMap<Integer, Map<String, String>> bgPeriodTypeMap = new HashMap<Integer, Map<String, String>>();
        Map<String, String> bgPeriodSrcMap = null;
        HashMap<Integer, Map<String, String>> bgPeriodNumMap = new HashMap<Integer, Map<String, String>>();
        Map<String, String> bgPeriodMap = null;
        MbgUpdateCalculateInfo upBizCalc22 = null;
        HashMap<BOSUuid, MbgUpdateCalculateInfo> updates = new HashMap<BOSUuid, MbgUpdateCalculateInfo>();
        for (MbgUpdateCalculateInfo upBizCalc22 : this.getCacheHelper().getUpdateConfig().getBizCalcs().values()) {
            updates.put(upBizCalc22.getBizCalc().getId(), upBizCalc22);
        }
        List<BizCalcRuleInfo> ruleCol = null;
        for (Map.Entry<String, String> entry : bizFormulaMap.entrySet()) {
            bizCalcId = entry.getKey();
            bosId = BOSUuid.read((String)bizCalcId);
            scheme = schemeMap.get(bizCalcId);
            if (scheme == null) {
                if (!updates.containsKey(bosId)) continue;
                upBizCalc22 = (MbgUpdateCalculateInfo)updates.get(bosId);
                periodType = upBizCalc22.getPeriodType().getValue();
            } else {
                periodType = scheme.getPeriod().getValue();
            }
            if (bgPeriodTypeMap.containsKey(periodType)) {
                bgPeriodSrcMap = (Map)bgPeriodTypeMap.get(periodType);
            } else {
                bgPeriodSrcMap = new HashMap();
                bgPeriodTypeMap.put(periodType, bgPeriodSrcMap);
            }
            if (bgPeriodNumMap.containsKey(periodType)) {
                bgPeriodMap = (Map)bgPeriodNumMap.get(periodType);
            } else {
                bgPeriodMap = new HashMap();
                bgPeriodNumMap.put(periodType, bgPeriodMap);
            }
            matcher = pattern.matcher(entry.getValue());
            while (matcher.find()) {
                srcStr = matcher.group();
                if (bgPeriodSrcMap.containsKey(srcStr) || srcStr.equals(distStr = this.parseBgPeriodNumStr(srcStr, periodType)) || bgPeriodSrcMap.containsKey(srcStr)) continue;
                bgPeriodSrcMap.put(srcStr, distStr);
            }
            expresStr = entry.getValue();
            for (Map.Entry entry122 : bgPeriodSrcMap.entrySet()) {
                expresStr = StringUtils.replace((String)expresStr, (String)((String)entry122.getKey()), (String)((String)entry122.getValue()));
            }
            if (expresStr.equals(entry.getValue())) continue;
            entry.setValue(expresStr);
            upCalcs.add(entry.getKey());
            ruleCol = bizRuleMap.get(entry.getKey());
            if (ruleCol == null || ruleCol.isEmpty()) continue;
            int jn = ruleCol.size();
            for (int j = 0; j < jn; ++j) {
                rule = ruleCol.get(j);
                expresStr = rule.getExpression();
                for (Map.Entry entry2 : bgPeriodSrcMap.entrySet()) {
                    expresStr = StringUtils.replace((String)expresStr, (String)((String)entry2.getKey()), (String)((String)entry2.getValue()));
                }
                if (!expresStr.equals(rule.getExpression())) {
                    rule.setExpression(expresStr);
                }
                if (!bgPeriodMap.containsKey(rule.getBgPeriodNum())) {
                    distStr = this.parseBgPeriodNum(rule.getBgPeriodNum(), periodType);
                    bgPeriodMap.put(rule.getBgPeriodNum(), distStr);
                } else {
                    distStr = (String)bgPeriodMap.get(rule.getBgPeriodNum());
                }
                rule.setBgPeriodNum(distStr);
            }
        }
        return upCalcs;
    }

    private String parseBgPeriodNumStr(String bgPeriodNum, int periodType) {
        if (bgPeriodNum == null) {
            return bgPeriodNum;
        }
        String[] tmpStrs = bgPeriodNum.substring(1, bgPeriodNum.length() - 1).split("@");
        if (tmpStrs != null && tmpStrs.length == 2) {
            String tmpStr = this.parseBgPeriodNum(tmpStrs[1], periodType);
            bgPeriodNum = "[" + tmpStrs[0] + "@" + tmpStr + "]";
        }
        return bgPeriodNum;
    }

    private String parseBgPeriodNum(String bgPeriodNum, int periodType) {
        if (bgPeriodNum == null) {
            return bgPeriodNum;
        }
        String tmpStr = bgPeriodNum;
        String[] seps = tmpStr.split("\\.");
        if (BgPeriodHelper.ALL_BGPERIOD_NUMBER.contains(seps[0])) {
            return bgPeriodNum;
        }
        if (1 == periodType) {
            tmpStr = "YEAR." + tmpStr;
        } else if (2 == periodType) {
            tmpStr = "HALF." + tmpStr;
        } else if (3 == periodType) {
            tmpStr = "QUAR." + tmpStr;
        } else if (4 == periodType) {
            tmpStr = "MONT." + tmpStr;
        } else if (7 == periodType) {
            tmpStr = "MDAY." + tmpStr;
        } else if (5 == periodType) {
            tmpStr = "YWEE." + tmpStr;
        } else if (6 == periodType) {
            tmpStr = "MWEE." + tmpStr;
        } else if (9 == periodType) {
            tmpStr = "PERI." + tmpStr;
        }
        return tmpStr;
    }

    private void updateBizCalc(Connection conn, Set<String> bizCalcIds, Map<String, String> bizFormulaMap, Map<String, List<BizCalcRuleInfo>> bizRuleMap) throws EASBizException {
        if (conn == null || bizCalcIds == null || bizCalcIds.isEmpty()) {
            return;
        }
        int index = 0;
        BizCalcRuleInfo rule = null;
        List<BizCalcRuleInfo> ruleCol = null;
        PreparedStatement pstmt = null;
        PreparedStatement psRule = null;
        try {
            pstmt = conn.prepareStatement("update T_MBG_BizCalc set FFormula = ? where FID = ?");
            psRule = conn.prepareStatement("update T_MBG_BizCalcRule set FExpression = ?, FBgPeriodNum = ? where FID = ?");
            for (String bizCalcId : bizCalcIds) {
                pstmt.setString(1, bizFormulaMap.get(bizCalcId));
                pstmt.setString(2, bizCalcId);
                pstmt.addBatch();
                ruleCol = bizRuleMap.get(bizCalcId);
                if (ruleCol != null && !ruleCol.isEmpty()) {
                    int in = ruleCol.size();
                    for (int i = 0; i < in; ++i) {
                        rule = ruleCol.get(i);
                        psRule.setString(1, rule.getExpression());
                        psRule.setString(2, rule.getBgPeriodNum());
                        psRule.setString(3, rule.getId().toString());
                        psRule.addBatch();
                    }
                }
                if (++index < 50) continue;
                pstmt.executeBatch();
                psRule.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
                psRule.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"updateBizCalc sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psRule);
                SQLUtils.cleanup((Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psRule);
        SQLUtils.cleanup((Statement)pstmt);
    }
}

