/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgBgPeriodTypeUtils;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;

public class MbgControlSchemelUpdate
extends AbstractMbgUpdate {
    private HashMap<String, String> entrustMap = new HashMap();

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        this.startUpdateControlScheme();
    }

    private void startUpdateControlScheme() throws BOSException {
        HashMap<String, Object[]> ruleMap;
        String[] twoIds;
        Object[] queryArr;
        IRowSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block10: {
            conn = null;
            pstmt = null;
            rst = null;
            conn = this.getConnection();
            StringBuffer querySql = new StringBuffer();
            querySql.append("select r.fid ruleId, s.FBizSystem, r.FBgSchemeTypeId, ").append("s.fid cSchemeId, s.forgunitid cSchemeOrgUnitId, s.FBeginDate cSchemeBeginDate, s.FEndDate cSchemeEndDate ").append("from t_mbg_bgcontrolrule r ").append("left join t_mbg_bgcontrolscheme s on s.fid = r.FSchemeID ").append("where s.FIsSysDefault = 0 ");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)querySql.toString());
            queryArr = null;
            twoIds = null;
            ruleMap = new HashMap<String, Object[]>();
            String orgUnitId = null;
            while (rst.next()) {
                queryArr = new Object[5];
                orgUnitId = rst.getString("cSchemeOrgUnitId");
                if (this.getOrgEntrust().containsKey(orgUnitId)) {
                    orgUnitId = this.getOrgEntrust().get(orgUnitId);
                }
                queryArr[0] = orgUnitId;
                queryArr[1] = rst.getDate("cSchemeBeginDate");
                queryArr[2] = rst.getDate("cSchemeEndDate");
                queryArr[3] = rst.getString("FBizSystem");
                queryArr[4] = rst.getString("FBgSchemeTypeId");
                ruleMap.put(rst.getString("ruleId"), queryArr);
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!ruleMap.isEmpty()) break block10;
            SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
            return;
        }
        try {
            int index = 0;
            pstmt = conn.prepareStatement("update t_mbg_bgcontrolrule set FBgSchemeTypeId = ? , FBgPeriodTypeID = ?, FScenarioNumber = ?  where FID = ? ");
            String ruleId2 = null;
            for (String ruleId2 : ruleMap.keySet()) {
                queryArr = (Object[])ruleMap.get(ruleId2);
                twoIds = this.getBgSchemeTypeIdAndBgPeriodTypeId((String)queryArr[0], (Date)queryArr[1], (Date)queryArr[2], (String)queryArr[3]);
                if (twoIds == null) continue;
                if (queryArr[4] != null) {
                    twoIds[0] = (String)queryArr[4];
                }
                pstmt.setString(1, twoIds[0] == null || twoIds[0].equalsIgnoreCase("") ? "" : twoIds[0]);
                pstmt.setString(2, twoIds[1]);
                pstmt.setString(3, "BgData");
                pstmt.setString(4, ruleId2);
                pstmt.addBatch();
                if (++index < 50) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private String[] getBgSchemeTypeIdAndBgPeriodTypeId(String orgUnitId, Date beginDate, Date endDate, String bizSystem) throws BOSException {
        String[] twoIds = null;
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)beginDate.toString()) || StringUtils.isEmpty((String)endDate.toString())) {
            return twoIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID, t.FPeriod, t.FBgOrgViewId from T_MBG_BgScheme t join T_MBG_BgOrgUnit u on t.FBgOrgViewId = u.FViewId where u.FOrgUnitId = ?  and ((t.FDateFrom >= ? and t.FDateTo <= ?) or (t.FDateFrom >= ? and t.FDateTo <= ?) or (t.FDateFrom >= ? and t.FDateFrom <= ?) or (t.FDateTo >= ? and t.FDateTo <= ?)) and t.FIsFormal = 1");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId);
            pstmt.setTimestamp(2, new Timestamp(BgNPeriodHelper.getDayBegin((java.util.Date)beginDate).getTime()));
            pstmt.setTimestamp(3, new Timestamp(BgNPeriodHelper.getDayBegin((java.util.Date)beginDate).getTime()));
            pstmt.setTimestamp(4, new Timestamp(BgNPeriodHelper.getDayEnd((java.util.Date)endDate).getTime()));
            pstmt.setTimestamp(5, new Timestamp(BgNPeriodHelper.getDayEnd((java.util.Date)endDate).getTime()));
            pstmt.setTimestamp(6, new Timestamp(BgNPeriodHelper.getDayBegin((java.util.Date)beginDate).getTime()));
            pstmt.setTimestamp(7, new Timestamp(BgNPeriodHelper.getDayEnd((java.util.Date)endDate).getTime()));
            pstmt.setTimestamp(8, new Timestamp(BgNPeriodHelper.getDayBegin((java.util.Date)beginDate).getTime()));
            pstmt.setTimestamp(9, new Timestamp(BgNPeriodHelper.getDayEnd((java.util.Date)endDate).getTime()));
            rst = pstmt.executeQuery();
            HashSet<String> schemeSet = new HashSet<String>();
            HashMap<String, String> schemeAndType = MbgBgPeriodTypeUtils.buildBgPeriodTypeMap(conn, false);
            while (rst.next()) {
                twoIds = new String[2];
                schemeSet.add(rst.getString("FID"));
                twoIds[0] = schemeAndType.get(rst.getString("FID"));
                twoIds[1] = MbgBgPeriodTypeUtils.getBgPeriodTypeByPeriod(this.getContext(), rst.getInt("FPeriod")).getId().toString();
                if ("lVIAAAAuzHqQxGui".equals(twoIds[0]) || "lVIAAABXGOSQxGui".equals(twoIds[0])) break;
                if ("lVIAAAAuzHiQxGui".equals(twoIds[0])) {
                    if (bizSystem.startsWith("com.kingdee.eas.fi.cas") || bizSystem.startsWith("com.kingdee.eas.fm.")) continue;
                    twoIds = null;
                    continue;
                }
                if (!"lVIAAAAuzHmQxGui".equals(twoIds[0]) || bizSystem.equals("com.kingdee.eas.cp.bc") || bizSystem.equals("com.kingdee.eas.fi.gl")) continue;
                twoIds = null;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return twoIds;
    }

    private HashMap<String, String> getOrgEntrust() throws BOSException {
        if (!this.entrustMap.isEmpty() && this.entrustMap.size() > 0) {
            return this.entrustMap;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection();
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FBgOrgUnitID, FBgEntrustOrgUnitID from T_MBG_BgControlOrgEntrust ");
            while (rst.next()) {
                this.entrustMap.put(rst.getString("FBgOrgUnitID"), rst.getString("FBgEntrustOrgUnitID"));
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return this.entrustMap;
    }
}

