/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgDataUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgControlUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgControlUpdate.class);

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Connection conn = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection();
            Map<String, String> cubeMap = this.getBgDataCubeMap();
            MbgDataUpdateProcessor processor = new MbgDataUpdateProcessor(conn, this.getCacheHelper(), this.getCacheHelper().getExeVersion(), this.getCacheHelper().getBgActualScenario());
            for (Map.Entry<String, String> entry : cubeMap.entrySet()) {
                String bgSchemeRootId = entry.getKey();
                String refCube = entry.getValue();
                processor.setBgSchemeRootId(bgSchemeRootId);
                processor.setCubeName(BgCubeUtils.getControlCubeName(refCube));
                processor.startProcess();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"biz Actual Data innerUpdate sql error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
    }

    private Map<String, String> getBgDataCubeMap() {
        return this.getCacheHelper().getBgDataCubeMap();
    }
}

