/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgItemAllocationParameter;
import com.kingdee.eas.ma.base.BgItemFactory;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.BgItemRelationInfo;
import com.kingdee.eas.ma.base.IBgItem;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgDimensionUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgDimensionUpdate.class);

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Map<String, MbgUpdateOrgInfo> orgConfig = this.getCacheHelper().getUpdateConfig().getOrgConfig();
        if (orgConfig.isEmpty()) {
            return;
        }
        this.startUpdateBgItems(orgConfig, result);
    }

    private void startUpdateBgItems(Map<String, MbgUpdateOrgInfo> orgConfigs, MbgUpdateResultInfo result) throws BOSException {
        if (orgConfigs == null || orgConfigs.isEmpty()) {
            return;
        }
        MbgUpdateOrgInfo upOrgInfo2 = null;
        String soucreOrgUntiID2 = null;
        OrgUnitInfo sourceOrg = null;
        OrgUnitInfo targeOrg = null;
        ArrayList<String> sourceOrgIDs = new ArrayList<String>();
        HashMap targeOrgs = new HashMap();
        for (MbgUpdateOrgInfo upOrgInfo2 : orgConfigs.values()) {
            sourceOrg = upOrgInfo2.getSourceOrg();
            soucreOrgUntiID2 = sourceOrg.getId().toString();
            if (!sourceOrgIDs.contains(soucreOrgUntiID2)) {
                sourceOrgIDs.add(soucreOrgUntiID2);
            }
            targeOrg = upOrgInfo2.getTargetOrg();
            if (!targeOrgs.containsKey(soucreOrgUntiID2)) {
                targeOrgs.put(soucreOrgUntiID2, new ArrayList());
            }
            ((ArrayList)targeOrgs.get(soucreOrgUntiID2)).add(targeOrg);
        }
        HashMap<String, HashSet<BgItemInfo>> exitMap = this.buildExistItemsMap(sourceOrgIDs, result);
        for (String soucreOrgUntiID2 : exitMap.keySet()) {
            ItemAllocationThread thread = new ItemAllocationThread();
            thread.setItemInfos(exitMap.get(soucreOrgUntiID2));
            thread.setOrgUnits((ArrayList)targeOrgs.get(soucreOrgUntiID2));
            thread.start();
        }
    }

    private HashMap<String, HashSet<BgItemInfo>> buildExistItemsMap(ArrayList<String> sourceOrgIds, MbgUpdateResultInfo result) throws BOSException {
        if (sourceOrgIds.isEmpty()) {
            return null;
        }
        HashMap<String, HashSet<BgItemInfo>> existMap = new HashMap<String, HashSet<BgItemInfo>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int index;
            conn = this.getConnection();
            int batchSize = 50;
            int size = sourceOrgIds.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            StringBuffer sql = new StringBuffer("SELECT item.FID , relation.FORGUNITID, relation.FIsEffective, relation.FParentID, relation.FRootID ,item.Fname_").append(this.getContext().getLocale()).append(" FROM t_mbg_bgitem item ").append(" join t_mbg_bgitemgroup grou on grou.fid = item.FBGITEMGROUPID ").append(" join t_mbg_bgitemrelation relation on item.fid = relation.FBGITEMID ").append(" where grou.FIsGlobal = 0 and relation.FORGUNITID in ( ");
            for (index = 1; index < batchSize; ++index) {
                sql.append("?,");
            }
            sql.append("?)");
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, sourceOrgIds.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
            }
            rst = pstmt.executeQuery();
            BgItemInfo itemInfo = null;
            BgItemRelationInfo relationInfo = null;
            String sOrgUntiId = null;
            String id = null;
            while (rst.next()) {
                itemInfo = new BgItemInfo();
                relationInfo = new BgItemRelationInfo();
                itemInfo.setId(BOSUuid.read((String)rst.getString(1)));
                sOrgUntiId = rst.getString(2);
                relationInfo.setOrgUnitID(BOSUuid.read((String)sOrgUntiId));
                relationInfo.setIsEffective(rst.getBoolean(3));
                id = rst.getString(4);
                if (id != null) {
                    relationInfo.setParentId(BOSUuid.read((String)id));
                }
                if ((id = rst.getString(5)) != null) {
                    relationInfo.setRootId(BOSUuid.read((String)id));
                }
                itemInfo.setName(rst.getString(6));
                relationInfo.setBgItem(itemInfo);
                itemInfo.getRelation().add(relationInfo);
                if (existMap.containsKey(sOrgUntiId)) {
                    existMap.get(sOrgUntiId).add(itemInfo);
                    continue;
                }
                existMap.put(sOrgUntiId, new HashSet());
                existMap.get(sOrgUntiId).add(itemInfo);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"MbgDimensionUpdate error!", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return existMap;
    }

    protected IBgItem getItemInterface() throws BOSException {
        return BgItemFactory.getLocalInstance((Context)this.getContext());
    }

    class ItemAllocationThread
    extends Thread {
        private int DELAY = 100;
        private HashSet<BgItemInfo> itemInfos = null;
        private ArrayList<OrgUnitInfo> orgUnits = null;

        public void setItemInfos(HashSet<BgItemInfo> itemInfos) {
            this.itemInfos = itemInfos;
        }

        public HashSet<BgItemInfo> getItemInfos() {
            return this.itemInfos;
        }

        public void setOrgUnits(ArrayList<OrgUnitInfo> orgUnits) {
            this.orgUnits = orgUnits;
        }

        public ArrayList<OrgUnitInfo> getOrgUnits() {
            return this.orgUnits;
        }

        @Override
        public synchronized void start() {
            super.start();
            LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
            BgItemInfo itemInfo2 = null;
            BgItemAllocationParameter parameter = new BgItemAllocationParameter();
            ArrayList<BOSUuid> orgUnitIds = new ArrayList<BOSUuid>();
            if (this.getOrgUnits() != null) {
                int size = this.getOrgUnits().size();
                for (int i = 0; i < size; ++i) {
                    if (this.getOrgUnits().get(i) == null || orgUnitIds.contains(this.getOrgUnits().get(i).getId())) continue;
                    orgUnitIds.add(this.getOrgUnits().get(i).getId());
                }
            }
            if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                for (BgItemInfo itemInfo2 : this.getItemInfos()) {
                    parameter.setItemInfo(itemInfo2);
                    parameter.setOrgUnits(orgUnitIds);
                    try {
                        List list = (List)MbgDimensionUpdate.this.getItemInterface().allocation((Object)parameter);
                        if (list != null && !list.isEmpty()) {
                            result.put(itemInfo2.getName(), list);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("bgItem " + itemInfo2.getNumber() + "MbgDimensionUpdate error!"), (Throwable)ex);
                    }
                    try {
                        Thread.sleep(this.DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

