/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.update.app.impl.MbgTemplateUpdate;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgDataOrgUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgDataUpdateProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgOrgUnitProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgPeriodIdProcessor;
import com.kingdee.eas.ma.mbg.update.app.utils.MbgViewManagerProcessor;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class MbgFormUpdate
extends MbgTemplateUpdate {
    @Override
    public void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        super.innerUpdate(result);
    }

    @Override
    protected void otherUpdate(Connection conn) throws Exception {
        this.updateBgForm(conn);
        this.updateBgData(conn);
        this.updateRef(conn);
        this.updateBgDataAssist(conn);
    }

    private void updateBgDataAssist(Connection conn) throws SQLException, BOSException {
        String rootId = null;
        ArrayList<String[]> list = new ArrayList<String[]>();
        HashSet<String> keys = new HashSet<String>();
        for (MbgUpdateOrgInfo config : this.getCacheHelper().getUpdateConfig().getOrgConfig().values()) {
            if (config.getBgScheme() == null || config.getBgScheme().getId() == null || config.getTargetOrg() == null || config.getTargetOrg().getId().equals((Object)config.getSourceOrg().getId())) continue;
            rootId = this.getCacheHelper().getBgSchemeRootMap().get(config.getBgScheme().getId().toString());
            if (rootId == null) {
                throw new NullPointerException("rootId is null: " + config.getBgScheme().getId());
            }
            String key = rootId + "_" + config.getTargetOrg().getId() + "_" + config.getSourceOrg().getId();
            if (keys.contains(key)) continue;
            keys.add(key);
            list.add(new String[]{config.getTargetOrg().getId().toString(), config.getSourceOrg().getId().toString(), rootId});
        }
        if (!list.isEmpty()) {
            MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_Mbg_BgDataAssist set FOrgUnitId = ? Where FOrgUnitId = ? AND FBgRootSchemeId = ?", list);
        }
        MbgSqlHelper.execute((Connection)conn, (String)"Update T_Mbg_BgDataAssist set FBgSchemeId = FBgRootSchemeId Where FBgSchemeId <> FBgRootSchemeId");
    }

    private void updateRef(Connection conn) throws Exception {
        String querySql = "Select r.FID m_id ,r.FBgPeriodId bp_id, bgForm.FBgSchemeId bs_id FROM T_MBg_BgRefBgPeriod r, T_Mbg_BgForm bgForm Where r.FBgFormID = bgForm.FID";
        String updateSql = "Update T_MBg_BgRefBgPeriod Set FBgPeriodID = ? Where FID = ?";
        MbgPeriodIdProcessor processor = new MbgPeriodIdProcessor(conn, this.getCacheHelper(), querySql, updateSql);
        processor.startProcess();
    }

    protected void updateBgData(Connection conn) throws Exception {
        Map<String, String> cubeMap = this.getBgDataCubeMap();
        MbgDataUpdateProcessor processor = new MbgDataUpdateProcessor(conn, this.getCacheHelper(), this.getCacheHelper().getExeVersion(), this.getCacheHelper().getBgDataScenario());
        for (Map.Entry<String, String> entry : cubeMap.entrySet()) {
            String bgSchemeRootId = entry.getKey();
            String refCube = entry.getValue();
            processor.setBgSchemeRootId(bgSchemeRootId);
            processor.setCubeName(refCube);
            processor.startProcess();
        }
        MbgDataOrgUpdateProcessor processor1 = new MbgDataOrgUpdateProcessor(conn, this.getCacheHelper(), 1);
        processor1.startProcess();
    }

    private Map<String, String> getBgDataCubeMap() {
        return this.getCacheHelper().getBgDataCubeMap();
    }

    protected void updateBgForm(Connection conn) throws BOSException, Exception {
        String querySql = "Select FID m_id, FBgPeriodId bp_id, FBgSchemeId bs_id FROM T_Mbg_BgForm";
        String updateSql = "Update T_Mbg_BgForm Set FBgPeriodId = ? Where FID = ?";
        MbgPeriodIdProcessor processor = new MbgPeriodIdProcessor(conn, this.getCacheHelper(), querySql, updateSql);
        processor.startProcess();
        MbgSqlHelper.execute((Connection)conn, (String)("Update T_Mbg_BgForm Set FBgVersionID = '" + this.getCacheHelper().getExeVersion().getId().toString() + "' Where FBgVersionID IS NULL"));
        String fromOrgUpdateSql = "Update T_Mbg_BgForm Set FOrgUnitId = ?, FBgTemplateRootId = '" + BgBaseConstants.nullID + "' Where FBgSchemeId = ? AND FBgTemplateId = ?";
        String[] formOrgUpdateKeys = new String[]{"bgScheme.id", "bgTemplate.id"};
        MbgOrgUnitProcessor orgProcessor = new MbgOrgUnitProcessor(conn, this.getCacheHelper(), fromOrgUpdateSql, formOrgUpdateKeys);
        orgProcessor.startProcess();
        MbgSqlHelper.execute((Connection)conn, (String)"Update T_Mbg_BgForm bgForm Set FBgTemplateRootId = (Select FRootId FROM T_Mbg_BgTemplate bgTemplate Where bgTemplate.FID = bgForm.FBgTemplateId) Where FBgTemplateRootId IS NOT NULL");
        MbgSqlHelper.execute((Connection)conn, (String)"Update T_Mbg_BgForm bgForm Set FBgTemplateId = (Select FID FROM T_Mbg_BgTemplate bgTemplate Where bgTemplate.FRootID = bgForm.FBgTemplateRootId AND bgTemplate.FOrgUnitId = bgForm.FOrgUnitId) Where FBgTemplateRootId IS NOT NULL");
        MbgSqlHelper.execute((Connection)conn, (String)"Update T_MBG_BGFORM bgForm Set FBgSchemeId = (Select FRootID FROM T_Mbg_BgScheme bgScheme Where bgScheme.FID = bgForm.FBgSchemeId)");
    }

    @Override
    protected String getBookQuerySql() {
        return "Select bgForm.FID " + MbgViewManagerProcessor.idField + ", bgForm.FData " + MbgViewManagerProcessor.dataField + ", temp.FRootId " + MbgViewManagerProcessor.templateRootIdField + " From T_Mbg_BgForm bgForm, T_Mbg_BgTemplate temp Where temp.FID = bgForm.FBgTemplateId AND bgForm.FData IS NOT NULL Order By temp.FRootId";
    }

    @Override
    protected String getBookUpdateSql() {
        return "Update T_Mbg_BgForm Set FData = ? Where FID = ?";
    }

    @Override
    protected String getViewQuerySql() {
        return "Select bgFormEntry.FBgFormId " + MbgViewManagerProcessor.idField + ", bgFormEntry.FDimensionData " + MbgViewManagerProcessor.dataField + ", temp.FRootId " + MbgViewManagerProcessor.templateRootIdField + " FROM T_Mbg_BgFormEntry bgFormEntry, T_Mbg_BgForm bgForm, T_Mbg_BgTemplate temp Where bgFormEntry.FBgFormId = bgForm.FID AND bgForm.FBgTemplateId = temp.FID AND bgFormEntry.FDimensionData IS NOT NULL";
    }

    @Override
    public String getViewUpdateSql() {
        return "Update T_Mbg_BgFormEntry Set FDimensionData = ? Where FBgFormId = ?";
    }
}

