/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MbgOrgUnitUpdate
extends AbstractMbgUpdate {
    private static final String SCHEME_ID = "schemeID";
    private static final String SCHEME_NUMBER = "schemeNumber";
    private static final String ORG_ID = "orgID";
    private static final String ORG_NUMBER = "orgNumber";
    private static final String ORG_NAME = "orgName";
    private static final String LONG_NUMBER = "longNumber";
    private static final String ORG_LEVEL = "orgLevle";
    private static final String ISTARGET = "isTargetOrg";
    private static final String ORG_DESCRIPTION = "orgDescription";
    private static final String ORG_SIMPLENAME = "orgSimpleName";
    private static final String ORG_CODE = "orgCode";

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        HashMap<String, String> orgView;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map<String, MbgUpdateOrgInfo> orgInfos = this.getCacheHelper().getUpdateConfig().getOrgConfig();
        HashMap tarOrgMap = new HashMap();
        for (String orgKey : orgInfos.keySet()) {
            String schemeNumber = orgInfos.get(orgKey).getBgScheme().getNumber();
            if (orgInfos.get(orgKey).getTargetOrg() == null) continue;
            if (!tarOrgMap.containsKey(schemeNumber)) {
                tarOrgMap.put(schemeNumber, new HashSet());
            }
            orgView = new HashMap<String, String>();
            orgView.put(SCHEME_ID, orgInfos.get(orgKey).getBgScheme().getId().toString());
            orgView.put(SCHEME_NUMBER, orgInfos.get(orgKey).getBgScheme().getNumber());
            orgView.put(ORG_ID, orgInfos.get(orgKey).getTargetOrg().getId().toString());
            orgView.put(ORG_NUMBER, orgInfos.get(orgKey).getTargetOrg().getNumber());
            orgView.put(LONG_NUMBER, orgInfos.get(orgKey).getTargetOrg().getLongNumber());
            orgView.put(ORG_NAME, orgInfos.get(orgKey).getTargetOrg().getName());
            orgView.put(ORG_DESCRIPTION, orgInfos.get(orgKey).getTargetOrg().getDescription());
            orgView.put(ORG_SIMPLENAME, orgInfos.get(orgKey).getTargetOrg().getSimpleName());
            orgView.put(ORG_CODE, orgInfos.get(orgKey).getTargetOrg().getCode());
            orgView.put(ISTARGET, Boolean.TRUE.toString());
            ((Set)tarOrgMap.get(schemeNumber)).add(orgView);
        }
        Locale local = this.getContext().getLocale();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select s.FID as FSCHEMEID, s.FNUMBER as FSCHEMENUMBER , s.FROOTID , ").append(" o.FID as FORGID, o.FNUMBER as FORGNUMBER ,o.FLONGNUMBER ,o.FNAME_" + local + " as FORGNAME, o.FLEVEL, ").append(" o.FDescription_" + local + " as FDESCRIPTION, o.FSimpleName as FSIMPLENAME, o.FCode as FCODE ").append(" from t_mbg_bgscheme s ").append(" inner join t_org_costcenter o on s.FORGUNITID = o.FID ").append(" order by s.FROOTID");
        HashMap orgMap = new HashMap();
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sqlBuf.toString());
            rst = pstmt.executeQuery();
            orgView = null;
            while (rst.next()) {
                if (!orgMap.containsKey(rst.getString("FROOTID"))) {
                    orgMap.put(rst.getString("FROOTID"), new HashSet());
                    Set tarOrgSet = (Set)tarOrgMap.get(rst.getString("FSCHEMENUMBER"));
                    if (tarOrgSet != null) {
                        for (Map org : tarOrgSet) {
                            ((Set)orgMap.get(rst.getString("FROOTID"))).add(org);
                        }
                    }
                }
                orgView = new HashMap();
                orgView.put(SCHEME_ID, rst.getString("FSCHEMEID"));
                orgView.put(SCHEME_NUMBER, rst.getString("FSCHEMENUMBER"));
                orgView.put(ORG_ID, rst.getString("FORGID"));
                orgView.put(ORG_NUMBER, rst.getString("FORGNUMBER"));
                orgView.put(LONG_NUMBER, rst.getString("FLONGNUMBER"));
                orgView.put(ORG_NAME, rst.getString("FORGNAME"));
                orgView.put(ORG_LEVEL, rst.getString("FLEVEL"));
                orgView.put(ORG_DESCRIPTION, rst.getString("FDESCRIPTION"));
                orgView.put(ORG_SIMPLENAME, rst.getString("FSIMPLENAME"));
                orgView.put(ORG_CODE, rst.getString("FCODE"));
                ((Set)orgMap.get(rst.getString("FROOTID"))).add(orgView);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        HashMap leafOrgMap = new HashMap();
        HashSet<Map> removeSet = new HashSet<Map>();
        HashSet leafSet = null;
        String rootLongNumber = null;
        HashMap longNumberMap = new HashMap();
        HashSet<String> allLongNumber = new HashSet<String>();
        HashMap<Object, String> rootLongNumberMap = new HashMap<Object, String>();
        HashMap schemeMsgMap = new HashMap();
        for (Object rootID : orgMap.keySet()) {
            leafSet = new HashSet((Collection)orgMap.get(rootID));
            removeSet.clear();
            block13: for (Map org : (Set)orgMap.get(rootID)) {
                if (org.get(ISTARGET) == null && ((String)org.get(SCHEME_ID)).equals(rootID)) {
                    rootLongNumber = (String)org.get(LONG_NUMBER);
                    HashMap schemeMsg = new HashMap();
                    schemeMsg.put(SCHEME_NUMBER, org.get(SCHEME_NUMBER));
                    schemeMsg.put(ORG_ID, org.get(ORG_ID));
                    schemeMsg.put(ORG_NUMBER, org.get(ORG_NUMBER));
                    schemeMsg.put(ORG_NAME, org.get(ORG_NAME));
                    schemeMsgMap.put(rootID, schemeMsg);
                }
                String parentLongNumber = (String)org.get(LONG_NUMBER);
                for (Map leafOrg : leafSet) {
                    String longNumber = (String)leafOrg.get(LONG_NUMBER);
                    if (longNumber.split("!").length <= parentLongNumber.split("!").length || longNumber.indexOf(parentLongNumber) != 0 || longNumber == parentLongNumber) continue;
                    removeSet.add(org);
                    continue block13;
                }
            }
            leafSet.removeAll(removeSet);
            leafOrgMap.put(rootID, leafSet);
            if (rootLongNumber == null) continue;
            String[] rootNumArr = rootLongNumber.split("!");
            HashSet<String> longNumberSet = new HashSet<String>();
            for (Map org : leafSet) {
                String ln = (String)org.get(LONG_NUMBER);
                String[] numArr = ln.split("!");
                for (int i = numArr.length; i > rootNumArr.length; --i) {
                    StringBuffer longNumberBuf = new StringBuffer();
                    for (int j = 0; j < i; ++j) {
                        longNumberBuf = longNumberBuf.append(numArr[j]).append("!");
                    }
                    String longNumber = longNumberBuf.toString().substring(0, longNumberBuf.length() - 1);
                    longNumberSet.add(longNumber);
                    allLongNumber.add(longNumber);
                }
            }
            longNumberSet.add(rootLongNumber);
            allLongNumber.add(rootLongNumber);
            rootLongNumberMap.put(rootID, rootLongNumber);
            longNumberMap.put(rootID, longNumberSet);
        }
        HashSet sourceOrgSet = new HashSet();
        for (String rooID : schemeMsgMap.keySet()) {
            sourceOrgSet.add(((Map)schemeMsgMap.get(rooID)).get(ORG_ID));
        }
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("id", sourceOrgSet, CompareType.INCLUDE));
        view1.setFilter(filter1);
        CoreBaseCollection colls1 = FullOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCollection(view1);
        HashMap<String, OrgUnitInfo> sourceOrgMap = new HashMap<String, OrgUnitInfo>();
        block19: for (int i = 0; i < colls1.size(); ++i) {
            for (String rooID : schemeMsgMap.keySet()) {
                if (!((String)((Map)schemeMsgMap.get(rooID)).get(ORG_ID)).equals(colls1.get(i).getId().toString())) continue;
                sourceOrgMap.put(rooID, (OrgUnitInfo)colls1.get(i));
                continue block19;
            }
        }
        EntityViewInfo view2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo(LONG_NUMBER, allLongNumber, CompareType.INCLUDE));
        view2.setFilter(filter2);
        CoreBaseCollection colls2 = CostCenterOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCollection(view2);
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        for (int i = 0; i < colls2.size(); ++i) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)colls2.get(i);
            orgUnitMap.put(orgUnitInfo.getLongNumber(), orgUnitInfo);
        }
        String CUID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        CostCenterOrgUnitInfo cu = CostCenterOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(CUID));
        HashMap<String, BgOrgViewInfo> bgOrgViewMap = new HashMap<String, BgOrgViewInfo>();
        int snap = 1000;
        for (String rootID : longNumberMap.keySet()) {
            BgOrgViewInfo bgOrgViewInfo = new BgOrgViewInfo();
            BOSUuid uuid = BOSUuid.create((BOSObjectType)bgOrgViewInfo.getBOSType());
            bgOrgViewInfo.setSnapShotVar(String.valueOf(++snap));
            bgOrgViewInfo.setId(uuid);
            bgOrgViewInfo.setIsLeaf(true);
            String number = (String)((Map)schemeMsgMap.get(rootID)).get(SCHEME_NUMBER) + (String)((Map)schemeMsgMap.get(rootID)).get(ORG_NUMBER);
            if (number.length() > 80) {
                number = number.substring(0, 80);
            }
            String name = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"orgUpdateOrgName", (Object[])new String[]{(String)((Map)schemeMsgMap.get(rootID)).get(SCHEME_NUMBER)});
            bgOrgViewInfo.setNumber(number);
            bgOrgViewInfo.setLongNumber(number);
            bgOrgViewInfo.setName(name);
            bgOrgViewInfo.setOrgUnit(cu);
            bgOrgViewMap.put(rootID, bgOrgViewInfo);
            BgOrgViewFactory.getLocalInstance(this.getContext()).addnew(bgOrgViewInfo);
            OrgUnitInfo rootOrgUnit = (OrgUnitInfo)orgUnitMap.get(rootLongNumberMap.get(rootID));
            HashMap<String, BgOrgUnitInfo> tempMap = new HashMap<String, BgOrgUnitInfo>();
            for (String longNumber : (Set)longNumberMap.get(rootID)) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgUnitMap.get(longNumber);
                BgOrgUnitInfo bgOrgUnitInfo = new BgOrgUnitInfo();
                bgOrgUnitInfo.setId(BOSUuid.create((BOSObjectType)bgOrgUnitInfo.getBOSType()));
                bgOrgUnitInfo.setViewID(uuid.toString());
                bgOrgUnitInfo.setOrgUnitID(orgUnitInfo.getId().toString());
                bgOrgUnitInfo.setNumber(orgUnitInfo.getNumber());
                bgOrgUnitInfo.setName(orgUnitInfo.getName());
                bgOrgUnitInfo.setLongNumber(orgUnitInfo.getLongNumber());
                bgOrgUnitInfo.setLevel(orgUnitInfo.getLevel() - rootOrgUnit.getLevel() + 1);
                bgOrgUnitInfo.setIsLeaf(false);
                bgOrgUnitInfo.setIsOUSealUp(orgUnitInfo.isIsOUSealUp());
                bgOrgUnitInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bgOrgUnitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                bgOrgUnitInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                bgOrgUnitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.getContext()));
                bgOrgUnitInfo.setDescription(orgUnitInfo.getDescription());
                bgOrgUnitInfo.setCode(orgUnitInfo.getCode());
                bgOrgUnitInfo.setSimpleName(orgUnitInfo.getSimpleName());
                tempMap.put(longNumber, bgOrgUnitInfo);
            }
            for (Map orgView2 : (Set)leafOrgMap.get(rootID)) {
                ((BgOrgUnitInfo)tempMap.get(orgView2.get(LONG_NUMBER))).setIsLeaf(true);
            }
            for (String longNumber : tempMap.keySet()) {
                String parentLongNumber = longNumber.contains("!") ? longNumber.substring(0, longNumber.lastIndexOf("!")) : "";
                ((BgOrgUnitInfo)tempMap.get(longNumber)).setParent((BgOrgUnitInfo)tempMap.get(parentLongNumber));
            }
            ArrayList addNewInfoCol = new ArrayList();
            for (String longNumber : tempMap.keySet()) {
                addNewInfoCol.add(tempMap.get(longNumber));
            }
            BgOrgUnitFactory.getLocalInstance(this.getContext()).persistData(uuid, addNewInfoCol, new ArrayList(), new ArrayList());
        }
        String sql = "update t_mbg_bgscheme set FbgOrgViewID = ? where FRootID = ? ";
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            int index = 0;
            for (String rootID : bgOrgViewMap.keySet()) {
                pstmt.setString(1, ((BgOrgViewInfo)bgOrgViewMap.get(rootID)).getId().toString());
                pstmt.setString(2, rootID);
                pstmt.addBatch();
                if (++index < 50) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
    }
}

