/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MbgPeriodUpdate
extends AbstractMbgUpdate {
    protected Locale sLocale = new Locale("l2");
    protected Locale tLocale = new Locale("l3");
    protected final String START_YEAR = "startYear";
    protected final String END_YEAR = "endYear";
    protected final String BGPERIOD_PREFIX = "QJFL";
    protected final String BGPERIOD_DISP_PREFIX = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateRootDisp");
    protected BgPeriodTypeInfo rootPeriodTypeInfo = null;
    protected List<BgPeriodEnum> bgPeriods = null;
    protected List<Integer> years = null;
    protected List<Map<String, Integer>> yearRanges = null;
    protected List<String> oldPeriodIDs = null;

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        this.beforeUpdate();
        BgPeriodTypeInfo bgPeriodTypeInfo = null;
        String bgPeriodTypeNumber = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        for (BgPeriodEnum bgPeriodType : this.bgPeriods) {
            if (bgPeriodType.equals((Object)BgPeriodEnum.YWEEK) || bgPeriodType.equals((Object)BgPeriodEnum.MWEEK) || bgPeriodType.equals((Object)BgPeriodEnum.DAY) || bgPeriodType.equals((Object)BgPeriodEnum.TENDAYS)) {
                this.addBgPeriodType(bgPeriodType);
            }
            bgPeriodTypeNumber = BgPeriodHelper.getBgPeriodNumberByEnum((BgPeriodEnum)bgPeriodType);
            BgCommHelper.replaceFilterItemsWithoutMask((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("number", (Object)bgPeriodTypeNumber, CompareType.EQUALS));
            view.setFilter(filter);
            bgPeriodTypeInfo = BgPeriodTypeFactory.getLocalInstance((Context)this.getContext()).getBgPeriodTypeCollection(view).get(0);
            try {
                for (Map<String, Integer> yearRange : this.yearRanges) {
                    BgPeriodDispFactory.getLocalInstance((Context)this.getContext()).addBgPeriodByPeriodType((IObjectValue)bgPeriodTypeInfo, yearRange.get("startYear").intValue(), yearRange.get("endYear").intValue(), null, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.afterUpdate();
    }

    protected void initBgPeriod() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<BgPeriodEnum> bgPeriods = new ArrayList<BgPeriodEnum>();
        String sql = " select distinct FPERIOD  from t_mbg_bgscheme ";
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgPeriods.add(BgPeriodEnum.getEnum((int)rst.getInt("FPERIOD")));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        this.setBgPeriods(bgPeriods);
    }

    protected void initYear() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<Integer> years = new ArrayList<Integer>();
        String sql = " select distinct FYEAR  from t_mbg_bgperiod ";
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                years.add(rst.getInt("FYEAR"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        this.setYears(years);
        this.processYear();
    }

    protected void processYear() {
        ArrayList<Map<String, Integer>> yearRanges = new ArrayList<Map<String, Integer>>();
        HashMap<String, Integer> yearRange = null;
        Integer start = null;
        Integer end = null;
        int i = 0;
        while (i < this.getYears().size()) {
            start = this.getYears().get(i);
            end = this.getYears().get(i);
            while (++i < this.getYears().size() && this.getYears().get(i) == end + 1) {
                end = end + 1;
            }
            yearRange = new HashMap<String, Integer>();
            yearRange.put("startYear", start);
            yearRange.put("endYear", end);
            yearRanges.add(yearRange);
        }
        this.yearRanges = yearRanges;
    }

    protected void addBgPeriodType(BgPeriodEnum bgPeriodType) throws BOSException, EASBizException {
        BgPeriodTypeInfo bgPeriodTypeInfo = null;
        String bgPeriodNumber = BgPeriodHelper.getBgPeriodNumberByEnum((BgPeriodEnum)bgPeriodType);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgPeriodNumber, CompareType.EQUALS));
        view.setFilter(filter);
        if (BgPeriodTypeFactory.getLocalInstance((Context)this.getContext()).getCollection(view).size() > 0) {
            return;
        }
        bgPeriodTypeInfo = new BgPeriodTypeInfo();
        bgPeriodTypeInfo.setFiscalYear(FiscalYearEnum.STANDARDYEAR);
        bgPeriodTypeInfo.setParent(this.getRootBgPeriodType());
        bgPeriodTypeInfo.setLevel(2);
        bgPeriodTypeInfo.setNumber(bgPeriodNumber);
        bgPeriodTypeInfo.setLongNumber("QJFL!" + bgPeriodNumber);
        if (bgPeriodType.equals((Object)BgPeriodEnum.DAY)) {
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateMDAY"), this.sLocale);
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateMDAY"), this.tLocale);
            bgPeriodTypeInfo.setDisplayName(this.BGPERIOD_DISP_PREFIX + "_" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateMDAY"), this.sLocale);
            bgPeriodTypeInfo.setYear(true);
            bgPeriodTypeInfo.setHalfYear(true);
            bgPeriodTypeInfo.setQuarter(true);
            bgPeriodTypeInfo.setMonth(true);
            bgPeriodTypeInfo.setDay(true);
        } else if (bgPeriodType.equals((Object)BgPeriodEnum.YWEEK)) {
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateYWEE"), this.sLocale);
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateYWEE"), this.tLocale);
            bgPeriodTypeInfo.setDisplayName(this.BGPERIOD_DISP_PREFIX + "_" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateYWEE"), this.sLocale);
            bgPeriodTypeInfo.setYear(true);
            bgPeriodTypeInfo.setYearWeek(true);
        } else if (bgPeriodType.equals((Object)BgPeriodEnum.MWEEK)) {
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateMWEE"), this.sLocale);
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateMWEE"), this.tLocale);
            bgPeriodTypeInfo.setDisplayName(this.BGPERIOD_DISP_PREFIX + "_" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdateMWEE"), this.sLocale);
            bgPeriodTypeInfo.setYear(true);
            bgPeriodTypeInfo.setHalfYear(true);
            bgPeriodTypeInfo.setQuarter(true);
            bgPeriodTypeInfo.setMonth(true);
            bgPeriodTypeInfo.setMothWeek(true);
        } else if (bgPeriodType.equals((Object)BgPeriodEnum.TENDAYS)) {
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdatePERI"), this.sLocale);
            bgPeriodTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdatePERI"), this.tLocale);
            bgPeriodTypeInfo.setDisplayName(this.BGPERIOD_DISP_PREFIX + "_" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdateResultResource", (String)"periodUpdatePERI"), this.sLocale);
            bgPeriodTypeInfo.setYear(true);
            bgPeriodTypeInfo.setHalfYear(true);
            bgPeriodTypeInfo.setQuarter(true);
            bgPeriodTypeInfo.setMonth(true);
            bgPeriodTypeInfo.setTenday(true);
        }
        BgPeriodTypeFactory.getLocalInstance((Context)this.getContext()).addnew(bgPeriodTypeInfo);
    }

    protected void initRootBgPeriodType() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"QJFL", CompareType.EQUALS));
        view.setFilter(filter);
        this.rootPeriodTypeInfo = BgPeriodTypeFactory.getLocalInstance((Context)this.getContext()).getBgPeriodTypeCollection(view).get(0);
    }

    protected void checkOldPeriod() throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Set allPeriodNumber = BgPeriodHelper.ALL_BGPERIOD_NUMBER;
        this.oldPeriodIDs = new ArrayList<String>();
        String sql = " select FID, FNUMBER from t_mbg_bgperiod ";
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String periodNumber;
                String periodID = rst.getString("FID");
                if (allPeriodNumber.contains(periodNumber.substring(0, (periodNumber = rst.getString("FNUMBER")).indexOf(".") == -1 ? 0 : periodNumber.indexOf(".")))) continue;
                this.oldPeriodIDs.add(periodID);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected void removeOldPeriod() throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sqlBuf = new StringBuffer(" DELETE FROM  t_mbg_bgperiod  where fid in (");
        for (int i = 1; i < 50; ++i) {
            sqlBuf.append("?,");
        }
        sqlBuf.append("?)");
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sqlBuf.toString());
            int index = 0;
            for (int i = 0; i < this.oldPeriodIDs.size(); ++i) {
                pstmt.setString(index + 1, this.oldPeriodIDs.get(i));
                if (++index < 50) continue;
                pstmt.addBatch();
                index = 0;
            }
            if (index != 0) {
                while (index < 50) {
                    pstmt.setString(index + 1, "#");
                    ++index;
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected void beforeUpdate() throws BOSException {
        this.initBgPeriod();
        this.initYear();
        this.initRootBgPeriodType();
        this.checkOldPeriod();
    }

    protected void afterUpdate() throws BOSException, EASBizException {
        this.removeOldPeriod();
    }

    protected BgPeriodTypeInfo getRootBgPeriodType() {
        return this.rootPeriodTypeInfo;
    }

    public List<Integer> getYears() {
        return this.years;
    }

    public void setYears(List<Integer> years) {
        Collections.sort(years);
        this.years = years;
    }

    public List<BgPeriodEnum> getBgPeriods() {
        return this.bgPeriods;
    }

    public void setBgPeriods(List<BgPeriodEnum> bgPeriods) {
        this.bgPeriods = bgPeriods;
    }
}

