/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.update.app.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.IDimensionRelationship;
import com.kingdee.eas.ma.mbg.update.app.face.AbstractMbgUpdate;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateOrgInfo;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateResultInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgRelationUpdate
extends AbstractMbgUpdate {
    private static final Logger logger = Logger.getLogger(MbgRelationUpdate.class);

    @Override
    protected void innerUpdate(MbgUpdateResultInfo result) throws BOSException, EASBizException {
        Map<String, MbgUpdateOrgInfo> orgConfig = this.getCacheHelper().getUpdateConfig().getOrgConfig();
        if (orgConfig.isEmpty()) {
            return;
        }
        this.startUpdateRelation(orgConfig, result);
    }

    private void startUpdateRelation(Map<String, MbgUpdateOrgInfo> orgConfigs, MbgUpdateResultInfo result) throws BOSException, EASBizException {
        if (orgConfigs == null || orgConfigs.isEmpty()) {
            return;
        }
        MbgUpdateOrgInfo upOrgInfo2 = null;
        String soucreOrgUntiID = null;
        OrgUnitInfo sourceOrg = null;
        OrgUnitInfo targeOrg = null;
        ArrayList<String> sourceOrgIDs = new ArrayList<String>();
        HashMap<String, ArrayList<OrgUnitInfo>> targeOrgs = new HashMap<String, ArrayList<OrgUnitInfo>>();
        HashSet<String> targeOrgIDS = new HashSet<String>();
        for (MbgUpdateOrgInfo upOrgInfo2 : orgConfigs.values()) {
            sourceOrg = upOrgInfo2.getSourceOrg();
            soucreOrgUntiID = sourceOrg.getId().toString();
            if (!sourceOrgIDs.contains(soucreOrgUntiID)) {
                sourceOrgIDs.add(soucreOrgUntiID);
            }
            if ((targeOrg = upOrgInfo2.getTargetOrg()) == null) continue;
            targeOrgIDS.add(targeOrg.getId().toString());
            if (targeOrgs.containsKey(soucreOrgUntiID)) {
                if (targeOrgs.get(soucreOrgUntiID).contains(targeOrg)) continue;
                targeOrgs.get(soucreOrgUntiID).add(targeOrg);
                continue;
            }
            targeOrgs.put(soucreOrgUntiID, new ArrayList());
            targeOrgs.get(soucreOrgUntiID).add(targeOrg);
        }
        HashMap<String, DimensionRelationshipCollection> existMap = this.buildExistRelationMap(sourceOrgIDs, result);
        HashMap<String, HashSet<String>> tempMap = this.getTargeOrgDims(targeOrgIDS);
        this.updateRelation(targeOrgs, existMap, tempMap);
    }

    private HashMap<String, DimensionRelationshipCollection> buildExistRelationMap(ArrayList<String> sourceOrgIds, MbgUpdateResultInfo result) throws BOSException {
        if (sourceOrgIds.isEmpty()) {
            return null;
        }
        HashMap<String, DimensionRelationshipCollection> existMap = new HashMap<String, DimensionRelationshipCollection>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("costUnit.id", new HashSet<String>(sourceOrgIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("dimensionGroup.isLowerShow", (Object)0, CompareType.EQUALS));
        evi.setFilter(filter);
        CoreBaseCollection coll = this.getBizInterface().getCollection(evi);
        String orgUnitId = null;
        DimensionRelationshipInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = (DimensionRelationshipInfo)coll.get(i);
            orgUnitId = info.getCostUnit().getId().toString();
            if (existMap.containsKey(orgUnitId)) {
                existMap.get(orgUnitId).add(info);
                continue;
            }
            existMap.put(orgUnitId, new DimensionRelationshipCollection());
            existMap.get(orgUnitId).add(info);
        }
        return existMap;
    }

    private HashMap<String, HashSet<String>> getTargeOrgDims(HashSet<String> targeOrgIDS) throws BOSException {
        HashMap<String, HashSet<String>> returnMap = new HashMap<String, HashSet<String>>();
        if (targeOrgIDS.isEmpty()) {
            return returnMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("dimensionNumber");
        evi.getSelector().add("costUnit.id");
        evi.getSelector().add("dimensionGroup.isLowerShow");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("costUnit.id", targeOrgIDS, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("dimensionGroup.isLowerShow", (Object)0, CompareType.EQUALS));
        evi.setFilter(filter);
        CoreBaseCollection coll = this.getBizInterface().getCollection(evi);
        String orgUnitId = null;
        DimensionRelationshipInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = (DimensionRelationshipInfo)coll.get(i);
            orgUnitId = info.getCostUnit().getId().toString();
            if (returnMap.containsKey(orgUnitId)) {
                returnMap.get(orgUnitId).add(info.getDimensionNumber());
                continue;
            }
            returnMap.put(orgUnitId, new HashSet());
            returnMap.get(orgUnitId).add(info.getDimensionNumber());
        }
        return returnMap;
    }

    private void updateRelation(HashMap<String, ArrayList<OrgUnitInfo>> targeOrgs, HashMap<String, DimensionRelationshipCollection> existMap, HashMap<String, HashSet<String>> tempMap) throws EASBizException, BOSException {
        int i;
        if (targeOrgs.isEmpty() || existMap.isEmpty()) {
            return;
        }
        DimensionRelationshipCollection upColl = new DimensionRelationshipCollection();
        DimensionRelationshipCollection existColl = null;
        ArrayList<OrgUnitInfo> targeOrgLst = null;
        OrgUnitInfo targeOrg = null;
        DimensionRelationshipInfo dimInfo = null;
        DimensionRelationshipInfo newInfo = null;
        String sourceOrgId2 = null;
        for (String sourceOrgId2 : existMap.keySet()) {
            existColl = existMap.get(sourceOrgId2);
            targeOrgLst = targeOrgs.get(sourceOrgId2);
            if (targeOrgLst == null) continue;
            int ix = targeOrgLst.size();
            for (i = 0; i < ix; ++i) {
                targeOrg = targeOrgLst.get(i);
                CostCenterOrgUnitInfo ccouinfo = null;
                int jx = existColl.size();
                for (int j = 0; j < jx; ++j) {
                    dimInfo = existColl.get(j);
                    if ((tempMap.isEmpty() || tempMap.get(targeOrg.getId().toString()) == null || tempMap.get(targeOrg.getId().toString()).contains(dimInfo.getDimensionNumber())) && tempMap.containsKey(targeOrg.getId().toString())) continue;
                    newInfo = new DimensionRelationshipInfo();
                    newInfo.setDimensionGroup(dimInfo.getDimensionGroup());
                    newInfo.setDimensionNumber(dimInfo.getDimensionNumber());
                    newInfo.setDimensionName(dimInfo.getDimensionName());
                    newInfo.setCreator(dimInfo.getCreator());
                    newInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    newInfo.setFilterUnit(targeOrg.castToFullOrgUnitInfo());
                    ccouinfo = new CostCenterOrgUnitInfo();
                    ccouinfo.setId(targeOrg.getId());
                    ccouinfo.setNumber(targeOrg.getNumber());
                    ccouinfo.setName(targeOrg.getName());
                    ccouinfo.setLongNumber(targeOrg.getLongNumber());
                    newInfo.setCostUnit(ccouinfo);
                    if (!tempMap.containsKey(targeOrg.getId().toString())) {
                        tempMap.put(targeOrg.getId().toString(), new HashSet());
                    }
                    tempMap.get(targeOrg.getId().toString()).add(newInfo.getDimensionNumber());
                    upColl.add(newInfo);
                }
            }
        }
        if (!upColl.isEmpty()) {
            CoreBaseInfo[] objs = new CoreBaseInfo[upColl.size()];
            for (i = 0; i < upColl.size(); ++i) {
                objs[i] = upColl.get(i);
            }
            this.getBizInterface().addnewPartial(objs);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("dimensionNumber");
        sic.add("dimensionName");
        sic.add("costUnit.id");
        sic.add("filterUnit.id");
        sic.add("isEnabled");
        sic.add("dimensionGroup.id");
        sic.add("dimensionGroup.number");
        sic.add("dimensionGroup.name");
        sic.add("dimensionGroup.longNumber");
        sic.add("dimensionGroup.isLowerShow");
        return sic;
    }

    private IDimensionRelationship getBizInterface() throws BOSException {
        return DimensionRelationshipFactory.getLocalInstance(this.getContext());
    }
}

